/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.core;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XStep;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import net.sf.saxon.s9api.XdmNode;

public class XProcData {
    private Stack<StackFrame> stack = null;
    private XProcRuntime runtime = null;

    public XProcData(XProcRuntime xProcRuntime) {
        this.runtime = xProcRuntime;
        this.stack = new Stack();
    }

    public void openFrame(XStep xStep) {
        int n = 1;
        int n2 = 1;
        if (this.stack.size() > 0) {
            n = this.stack.peek().iterPos;
            n2 = this.stack.peek().iterSize;
        }
        StackFrame stackFrame = new StackFrame();
        stackFrame.iterPos = n;
        stackFrame.iterSize = n2;
        this.stack.push(stackFrame);
        this.stack.peek().step = xStep;
    }

    public void closeFrame() {
        this.stack.pop();
    }

    public int getDepth() {
        return this.stack.size();
    }

    public XStep getStep() {
        if (this.stack.size() == 0) {
            return null;
        }
        return this.stack.peek().step;
    }

    public void setIterationPosition(int n) {
        this.stack.peek().iterPos = n;
    }

    public int getIterationPosition() {
        return this.stack.peek().iterPos;
    }

    public void setIterationSize(int n) {
        this.stack.peek().iterSize = n;
    }

    public int getIterationSize() {
        return this.stack.peek().iterSize;
    }

    private boolean tryGroup(XStep xStep) {
        if (XProcConstants.p_group.equals((Object)xStep.getType())) {
            XdmNode xdmNode = xStep.getNode();
            return XProcConstants.p_try.equals((Object)xdmNode.getParent().getNodeName());
        }
        return false;
    }

    public boolean catchError(XdmNode xdmNode) {
        int n = this.stack.size() - 1;
        if (this.stack.size() > 0 && XProcConstants.p_catch.equals((Object)this.stack.peek().step.getType())) {
            n -= 2;
        }
        while (n >= 0 && !this.tryGroup(((StackFrame)this.stack.get((int)n)).step)) {
            --n;
        }
        if (n >= 0) {
            ((StackFrame)this.stack.get((int)n)).errors.add(xdmNode);
            return true;
        }
        return false;
    }

    public List<XdmNode> errors() {
        int n;
        for (n = this.stack.size() - 1; n >= 0 && !this.tryGroup(((StackFrame)this.stack.get((int)n)).step); --n) {
        }
        if (n >= 0) {
            return ((StackFrame)this.stack.get((int)n)).errors;
        }
        return new Stack<XdmNode>();
    }

    private class StackFrame {
        public XStep step = null;
        public int iterPos = 1;
        public int iterSize = 1;
        public Vector<XdmNode> errors = new Vector();
    }
}

