/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.S9apiUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.xml.sax.InputSource;

public class PrettyPrint
extends DefaultStep {
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private static XdmNode prettyPrint = null;

    public PrettyPrint(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
        if (prettyPrint == null) {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream("/etc/prettyprint.xsl");
                if (inputStream == null) {
                    throw new UnsupportedOperationException("Failed to load prettyprint.xsl stylesheet from resources.");
                }
                XdmNode xdmNode = xProcRuntime.parse(new InputSource(inputStream));
                prettyPrint = S9apiUtils.getDocumentElement(xdmNode);
            }
            catch (Exception exception) {
                throw new XProcException(exception);
            }
        }
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        XsltCompiler xsltCompiler = this.runtime.getProcessor().newXsltCompiler();
        XsltExecutable xsltExecutable = xsltCompiler.compile(prettyPrint.asSource());
        XsltTransformer xsltTransformer = xsltExecutable.load();
        xsltTransformer.setInitialContextNode(this.source.read());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Serializer serializer = new Serializer();
        serializer.setOutputProperty(Serializer.Property.ENCODING, "utf-8");
        serializer.setOutputProperty(Serializer.Property.INDENT, "yes");
        serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
        serializer.setOutputStream((OutputStream)byteArrayOutputStream);
        xsltTransformer.setDestination((Destination)serializer);
        xsltTransformer.transform();
        XdmNode xdmNode = this.runtime.parse(new InputSource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
        this.result.write(xdmNode);
    }
}

