# This file was created by configpm when Perl was built. Any changes
# made to this file will be lost the next time perl is built.

package Config;
use strict;
use warnings;
our %Config;

sub bincompat_options {
    return split ' ', (Internals::V())[0];
}

sub non_bincompat_options {
    return split ' ', (Internals::V())[1];
}

sub compile_date {
    return (Internals::V())[2]
}

sub local_patches {
    my (undef, undef, undef, @patches) = Internals::V();
    return @patches;
}

sub _V {
    die "Perl lib was built for 'linux' but is being run on '$^O'"
        unless "linux" eq $^O;

    my ($bincompat, $non_bincompat, $date, @patches) = Internals::V();

    my @opts = sort split ' ', "$bincompat $non_bincompat";

    print Config::myconfig();
    print "\nCharacteristics of this binary (from libperl): \n";

    print "  Compile-time options:\n";
    print "    $_\n" for @opts;

    if (@patches) {
        print "  Locally applied patches:\n";
        print "    $_\n" foreach @patches;
    }

    print "  Built under linux\n";

    print "  $date\n" if defined $date;

    my @env = map { "$_=\"$ENV{$_}\"" } sort grep {/^PERL/} keys %ENV;

    if (@env) {
        print "  \%ENV:\n";
        print "    $_\n" foreach @env;
    }
    print "  \@INC:\n";
    print "    $_\n" foreach @INC;
}

sub header_files {
    return qw(EXTERN.h INTERN.h XSUB.h av.h config.h cop.h cv.h
              dosish.h embed.h embedvar.h form.h gv.h handy.h hv.h hv_func.h
              intrpvar.h iperlsys.h keywords.h mg.h nostdio.h op.h opcode.h
              pad.h parser.h patchlevel.h perl.h perlio.h perliol.h perlsdio.h
              perlvars.h perly.h pp.h pp_proto.h proto.h regcomp.h regexp.h
              regnodes.h scope.h sv.h thread.h time64.h unixish.h utf8.h
              util.h);
}

##
## This file was produced by running the Configure script. It holds all the
## definitions figured out by Configure. Should you modify one of these values,
## do not forget to propagate your changes by running "Configure -der". You may
## instead choose to run each of the .SH files by yourself, or "Configure -S".
##
#
## Package name      : perl5
## Source directory  : .
## Configuration time: Mon Apr 28 05:59:15 -00 2025
## Configured by     : Gentoo
## Target system     : linux localhost 6.12.23-gentoo-dist #1 smp preempt_dynamic sat apr 12 12:42:20 -00 2025 aarch64 gnulinux 
#
#: Configure command line arguments.
#
#: Variables propagated from previous config.sh file.

our $summary = <<'!END!';
Summary of my $package (revision $revision $version_patchlevel_string) configuration:
  $git_commit_id_title $git_commit_id$git_ancestor_line
  Platform:
    osname=$osname
    osvers=$osvers
    archname=$archname
    uname='$myuname'
    config_args='$config_args'
    hint=$hint
    useposix=$useposix
    d_sigaction=$d_sigaction
    useithreads=$useithreads
    usemultiplicity=$usemultiplicity
    use64bitint=$use64bitint
    use64bitall=$use64bitall
    uselongdouble=$uselongdouble
    usemymalloc=$usemymalloc
    default_inc_excludes_dot=$default_inc_excludes_dot
  Compiler:
    cc='$cc'
    ccflags ='$ccflags'
    optimize='$optimize'
    cppflags='$cppflags'
    ccversion='$ccversion'
    gccversion='$gccversion'
    gccosandvers='$gccosandvers'
    intsize=$intsize
    longsize=$longsize
    ptrsize=$ptrsize
    doublesize=$doublesize
    byteorder=$byteorder
    doublekind=$doublekind
    d_longlong=$d_longlong
    longlongsize=$longlongsize
    d_longdbl=$d_longdbl
    longdblsize=$longdblsize
    longdblkind=$longdblkind
    ivtype='$ivtype'
    ivsize=$ivsize
    nvtype='$nvtype'
    nvsize=$nvsize
    Off_t='$lseektype'
    lseeksize=$lseeksize
    alignbytes=$alignbytes
    prototype=$prototype
  Linker and Libraries:
    ld='$ld'
    ldflags ='$ldflags'
    libpth=$libpth
    libs=$libs
    perllibs=$perllibs
    libc=$libc
    so=$so
    useshrplib=$useshrplib
    libperl=$libperl
    gnulibc_version='$gnulibc_version'
  Dynamic Linking:
    dlsrc=$dlsrc
    dlext=$dlext
    d_dlsymun=$d_dlsymun
    ccdlflags='$ccdlflags'
    cccdlflags='$cccdlflags'
    lddlflags='$lddlflags'

!END!
my $summary_expanded;

sub myconfig {
    return $summary_expanded if $summary_expanded;
    ($summary_expanded = $summary) =~ s{\$(\w+)}
                 {
                        my $c;
                        if ($1 eq 'git_ancestor_line') {
                                if ($Config::Config{git_ancestor}) {
                                        $c= "\n  Ancestor: $Config::Config{git_ancestor}";
                                } else {
                                        $c= "";
                                }
                        } else {
                                $c = $Config::Config{$1};
                        }
                        defined($c) ? $c : 'undef'
                }ge;
    $summary_expanded;
}

local *_ = \my $a;
$_ = <<'!END!';
Author=''
CONFIG='true'
Date=''
Header=''
Id=''
Locker=''
Log=''
PATCHLEVEL='40'
PERL_API_REVISION='5'
PERL_API_SUBVERSION='0'
PERL_API_VERSION='40'
PERL_CONFIG_SH='true'
PERL_PATCHLEVEL=''
PERL_REVISION='5'
PERL_SUBVERSION='2'
PERL_VERSION='40'
RCSfile=''
Revision=''
SUBVERSION='2'
Source=''
State=''
_a='.a'
_exe=''
_o='.o'
afs='false'
afsroot='/afs'
alignbytes='8'
aphostname=''
api_revision='5'
api_subversion='0'
api_version='40'
api_versionstring='5.40.0'
ar='llvm-ar'
archlib='/usr/lib64/perl5/5.40/aarch64-linux'
archlibexp='/usr/lib64/perl5/5.40/aarch64-linux'
archname='aarch64-linux'
archname64=''
archobjs=''
asctime_r_proto='0'
awk='awk'
baserev='5.0'
bash=''
bin='/usr/bin'
bin_ELF='define'
binexp='/usr/bin'
bison='bison'
byacc='byacc'
byteorder='12345678'
c=''
castflags='1'
cat='cat'
cc='clang'
cccdlflags='-fPIC'
ccdlflags='-Wl,-E'
ccflags='-O2 -pipe -fno-strict-aliasing -DNO_PERL_RAND_SEED -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64'
ccflags_uselargefiles='-D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64'
ccname='gcc'
ccsymbols=''
ccversion=''
cf_by='Gentoo'
cf_email='Gentoo@localhost.nonet'
cf_time='Mon Apr 28 05:59:15 -00 2025'
charbits='8'
charsize='1'
chgrp=''
chmod='chmod'
chown=''
clocktype='clock_t'
comm='comm'
compiler_warning='grep -i warning'
compress=''
config_arg0='Configure'
config_arg1='-des'
config_arg10='-Dnoextensions=ODBM_File'
config_arg11='-Duseshrplib'
config_arg12='-Darchname=aarch64-linux'
config_arg13='-Dar=llvm-ar'
config_arg14='-Dcc=clang'
config_arg15='-Dcpp=clang-cpp'
config_arg16='-Dld=clang'
config_arg17='-Dnm=llvm-nm'
config_arg18='-Dranlib=llvm-ranlib'
config_arg19='-Accflags=-O2 -pipe -fno-strict-aliasing -DNO_PERL_RAND_SEED'
config_arg2='-Dinstallprefix=/usr'
config_arg20='-Doptimize=-O2 -pipe -fno-strict-aliasing'
config_arg21='-Dldflags=-Wl,-O1 -Wl,--as-needed -Wl,--as-needed'
config_arg22='-Dprefix=/usr'
config_arg23='-Dsiteprefix=/usr/local'
config_arg24='-Dvendorprefix=/usr'
config_arg25='-Dscriptdir=/usr/bin'
config_arg26='-Dprivlib=/usr/lib64/perl5/5.40'
config_arg27='-Darchlib=/usr/lib64/perl5/5.40/aarch64-linux'
config_arg28='-Dsitelib=/usr/local/lib64/perl5/5.40'
config_arg29='-Dsitearch=/usr/local/lib64/perl5/5.40/aarch64-linux'
config_arg3='-Dinstallusrbinperl=n'
config_arg30='-Dvendorlib=/usr/lib64/perl5/vendor_perl/5.40'
config_arg31='-Dvendorarch=/usr/lib64/perl5/vendor_perl/5.40/aarch64-linux'
config_arg32='-Dman1dir=/usr/share/man/man1'
config_arg33='-Dman3dir=/usr/share/man/man3'
config_arg34='-Dsiteman1dir=/usr/local/man/man1'
config_arg35='-Dsiteman3dir=/usr/local/man/man3'
config_arg36='-Dvendorman1dir=/usr/share/man/man1'
config_arg37='-Dvendorman3dir=/usr/share/man/man3'
config_arg38='-Dman1ext=1'
config_arg39='-Dman3ext=3pm'
config_arg4='-Ui_xlocale'
config_arg40='-Dlibperl=libperl.so.5.40.2'
config_arg41='-Dlocincpth=/usr/include '
config_arg42='-Dglibpth=/lib64 /usr/lib64 '
config_arg43='-Duselargefiles'
config_arg44='-Dd_semctl_semun'
config_arg45='-Dcf_by=Gentoo'
config_arg46='-Dmyhostname=localhost'
config_arg47='-Dperladmin=root@localhost'
config_arg48='-Ud_csh'
config_arg49='-Dsh=/bin/sh'
config_arg5='-Ui_ndbm'
config_arg50='-Dtargetsh=/bin/sh'
config_arg51='-Uusenm'
config_arg6='-Di_gdbm'
config_arg7='-Ui_db'
config_arg8='-DDEBUGGING=none'
config_arg9='-Dlibpth=/usr/local/lib64 /lib64 /usr/lib64'
config_argc='51'
config_args='-des -Dinstallprefix=/usr -Dinstallusrbinperl=n -Ui_xlocale -Ui_ndbm -Di_gdbm -Ui_db -DDEBUGGING=none -Dlibpth=/usr/local/lib64 /lib64 /usr/lib64 -Dnoextensions=ODBM_File -Duseshrplib -Darchname=aarch64-linux -Dar=llvm-ar -Dcc=clang -Dcpp=clang-cpp -Dld=clang -Dnm=llvm-nm -Dranlib=llvm-ranlib -Accflags=-O2 -pipe -fno-strict-aliasing -DNO_PERL_RAND_SEED -Doptimize=-O2 -pipe -fno-strict-aliasing -Dldflags=-Wl,-O1 -Wl,--as-needed -Wl,--as-needed -Dprefix=/usr -Dsiteprefix=/usr/local -Dvendorprefix=/usr -Dscriptdir=/usr/bin -Dprivlib=/usr/lib64/perl5/5.40 -Darchlib=/usr/lib64/perl5/5.40/aarch64-linux -Dsitelib=/usr/local/lib64/perl5/5.40 -Dsitearch=/usr/local/lib64/perl5/5.40/aarch64-linux -Dvendorlib=/usr/lib64/perl5/vendor_perl/5.40 -Dvendorarch=/usr/lib64/perl5/vendor_perl/5.40/aarch64-linux -Dman1dir=/usr/share/man/man1 -Dman3dir=/usr/share/man/man3 -Dsiteman1dir=/usr/local/man/man1 -Dsiteman3dir=/usr/local/man/man3 -Dvendorman1dir=/usr/share/man/man1 -Dvendorman3dir=/usr/share/man/man3 -Dman1ext=1 -Dman3ext=3pm -Dlibperl=libperl.so.5.40.2 -Dlocincpth=/usr/include  -Dglibpth=/lib64 /usr/lib64  -Duselargefiles -Dd_semctl_semun -Dcf_by=Gentoo -Dmyhostname=localhost -Dperladmin=root@localhost -Ud_csh -Dsh=/bin/sh -Dtargetsh=/bin/sh -Uusenm'
contains='grep'
cp='cp'
cpio=''
cpp='clang-cpp'
cpp_stuff='42'
cppccsymbols='__GCC_HAVE_DWARF2_CFI_ASM=1'
cppflags='-O2 -pipe -fno-strict-aliasing -DNO_PERL_RAND_SEED'
cpplast='-'
cppminus='-'
cpprun='clang  -E'
cppstdin='clang  -E'
cppsymbols='_FILE_OFFSET_BITS=64 _FORTIFY_SOURCE=2 _LARGEFILE_SOURCE=1 _LP64=1 _POSIX_C_SOURCE=200809L _POSIX_SOURCE=1 _STDC_PREDEF_H=1 __AARCH64EL__=1 __AARCH64_CMODEL_SMALL__=1 __ARM_64BIT_STATE=1 __ARM_ACLE=200 __ARM_ALIGN_MAX_STACK_PWR=4 __ARM_ARCH=8 __ARM_ARCH_ISA_A64=1 __ARM_ARCH_PROFILE='A' __ARM_FEATURE_CLZ=1 __ARM_FEATURE_DIRECTED_ROUNDING=1 __ARM_FEATURE_DIV=1 __ARM_FEATURE_FMA=1 __ARM_FEATURE_IDIV=1 __ARM_FEATURE_LDREX=0xF __ARM_FEATURE_NUMERIC_MAXMIN=1 __ARM_FEATURE_UNALIGNED=1 __ARM_FP16_ARGS=1 __ARM_FP16_FORMAT_IEEE=1 __ARM_FP=0xE __ARM_NEON=1 __ARM_NEON_FP=0xE __ARM_PCS_AAPCS64=1 __ARM_SIZEOF_MINIMAL_ENUM=4 __ARM_SIZEOF_WCHAR_T=4 __ARM_STATE_ZA=1 __ARM_STATE_ZT0=1 __ATOMIC_ACQUIRE=2 __ATOMIC_ACQ_REL=4 __ATOMIC_CONSUME=1 __ATOMIC_RELAXED=0 __ATOMIC_RELEASE=3 __ATOMIC_SEQ_CST=5 __BIGGEST_ALIGNMENT__=16 __BITINT_MAXWIDTH__=128 __BOOL_WIDTH__=8 __BYTE_ORDER__=1234 __CHAR16_TYPE__=unsigned\ short __CHAR32_TYPE__=unsigned\ int __CHAR_BIT__=8 __CHAR_UNSIGNED__=1 __CLANG_ATOMIC_BOOL_LOCK_FREE=2 __CLANG_ATOMIC_CHAR16_T_LOCK_FREE=2 __CLANG_ATOMIC_CHAR32_T_LOCK_FREE=2 __CLANG_ATOMIC_CHAR_LOCK_FREE=2 __CLANG_ATOMIC_INT_LOCK_FREE=2 __CLANG_ATOMIC_LLONG_LOCK_FREE=2 __CLANG_ATOMIC_LONG_LOCK_FREE=2 __CLANG_ATOMIC_POINTER_LOCK_FREE=2 __CLANG_ATOMIC_SHORT_LOCK_FREE=2 __CLANG_ATOMIC_WCHAR_T_LOCK_FREE=2 __CONSTANT_CFSTRINGS__=1 __DBL_DECIMAL_DIG__=17 __DBL_DENORM_MIN__=4.9406564584124654e-324 __DBL_DIG__=15 __DBL_EPSILON__=2.2204460492503131e-16 __DBL_HAS_DENORM__=1 __DBL_HAS_INFINITY__=1 __DBL_HAS_QUIET_NAN__=1 __DBL_MANT_DIG__=53 __DBL_MAX_10_EXP__=308 __DBL_MAX_EXP__=1024 __DBL_MAX__=1.7976931348623157e+308 __DBL_MIN_10_EXP__=(-307) __DBL_MIN_EXP__=(-1021) __DBL_MIN__=2.2250738585072014e-308 __DBL_NORM_MAX__=1.7976931348623157e+308 __DECIMAL_DIG__=36 __ELF__=1 __FINITE_MATH_ONLY__=0 __FLT16_DECIMAL_DIG__=5 __FLT16_DENORM_MIN__=5.9604644775390625e-8F16 __FLT16_DIG__=3 __FLT16_EPSILON__=9.765625e-4F16 __FLT16_HAS_DENORM__=1 __FLT16_HAS_INFINITY__=1 __FLT16_HAS_QUIET_NAN__=1 __FLT16_MANT_DIG__=11 __FLT16_MAX_10_EXP__=4 __FLT16_MAX_EXP__=16 __FLT16_MAX__=6.5504e+4F16 __FLT16_MIN_10_EXP__=(-4) __FLT16_MIN_EXP__=(-13) __FLT16_MIN__=6.103515625e-5F16 __FLT16_NORM_MAX__=6.5504e+4F16 __FLT_DECIMAL_DIG__=9 __FLT_DENORM_MIN__=1.40129846e-45F __FLT_DIG__=6 __FLT_EPSILON__=1.19209290e-7F __FLT_HAS_DENORM__=1 __FLT_HAS_INFINITY__=1 __FLT_HAS_QUIET_NAN__=1 __FLT_MANT_DIG__=24 __FLT_MAX_10_EXP__=38 __FLT_MAX_EXP__=128 __FLT_MAX__=3.40282347e+38F __FLT_MIN_10_EXP__=(-37) __FLT_MIN_EXP__=(-125) __FLT_MIN__=1.17549435e-38F __FLT_NORM_MAX__=3.40282347e+38F __FLT_RADIX__=2 __FPCLASS_NEGINF=0x0004 __FPCLASS_NEGNORMAL=0x0008 __FPCLASS_NEGSUBNORMAL=0x0010 __FPCLASS_NEGZERO=0x0020 __FPCLASS_POSINF=0x0200 __FPCLASS_POSNORMAL=0x0100 __FPCLASS_POSSUBNORMAL=0x0080 __FPCLASS_POSZERO=0x0040 __FPCLASS_QNAN=0x0002 __FPCLASS_SNAN=0x0001 __FP_FAST_FMA=1 __FP_FAST_FMAF=1 __GCC_ASM_FLAG_OUTPUTS__=1 __GCC_ATOMIC_BOOL_LOCK_FREE=2 __GCC_ATOMIC_CHAR16_T_LOCK_FREE=2 __GCC_ATOMIC_CHAR32_T_LOCK_FREE=2 __GCC_ATOMIC_CHAR_LOCK_FREE=2 __GCC_ATOMIC_INT_LOCK_FREE=2 __GCC_ATOMIC_LLONG_LOCK_FREE=2 __GCC_ATOMIC_LONG_LOCK_FREE=2 __GCC_ATOMIC_POINTER_LOCK_FREE=2 __GCC_ATOMIC_SHORT_LOCK_FREE=2 __GCC_ATOMIC_TEST_AND_SET_TRUEVAL=1 __GCC_ATOMIC_WCHAR_T_LOCK_FREE=2 __GCC_CONSTRUCTIVE_SIZE=64 __GCC_DESTRUCTIVE_SIZE=64 __GCC_HAVE_SYNC_COMPARE_AND_SWAP_16=1 __GCC_HAVE_SYNC_COMPARE_AND_SWAP_1=1 __GCC_HAVE_SYNC_COMPARE_AND_SWAP_2=1 __GCC_HAVE_SYNC_COMPARE_AND_SWAP_4=1 __GCC_HAVE_SYNC_COMPARE_AND_SWAP_8=1 __GLIBC_MINOR__=40 __GLIBC__=2 __GNUC_MINOR__=2 __GNUC_PATCHLEVEL__=1 __GNUC_STDC_INLINE__=1 __GNUC__=4 __GNU_LIBRARY__=6 __GXX_ABI_VERSION=1002 __HAVE_FUNCTION_MULTI_VERSIONING=1 __INT16_C_SUFFIX__= __INT16_FMTd__="hd" __INT16_FMTi__="hi" __INT16_MAX__=32767 __INT16_TYPE__=short __INT32_C_SUFFIX__= __INT32_FMTd__="d" __INT32_FMTi__="i" __INT32_MAX__=2147483647 __INT32_TYPE__=int __INT64_C_SUFFIX__=L __INT64_FMTd__="ld" __INT64_FMTi__="li" __INT64_MAX__=9223372036854775807L __INT64_TYPE__=long\ int __INT8_C_SUFFIX__= __INT8_FMTd__="hhd" __INT8_FMTi__="hhi" __INT8_MAX__=127 __INT8_TYPE__=signed\ char __INTMAX_C_SUFFIX__=L __INTMAX_FMTd__="ld" __INTMAX_FMTi__="li" __INTMAX_MAX__=9223372036854775807L __INTMAX_TYPE__=long\ int __INTMAX_WIDTH__=64 __INTPTR_FMTd__="ld" __INTPTR_FMTi__="li" __INTPTR_MAX__=9223372036854775807L __INTPTR_TYPE__=long\ int __INTPTR_WIDTH__=64 __INT_FAST16_FMTd__="hd" __INT_FAST16_FMTi__="hi" __INT_FAST16_MAX__=32767 __INT_FAST16_TYPE__=short __INT_FAST16_WIDTH__=16 __INT_FAST32_FMTd__="d" __INT_FAST32_FMTi__="i" __INT_FAST32_MAX__=2147483647 __INT_FAST32_TYPE__=int __INT_FAST32_WIDTH__=32 __INT_FAST64_FMTd__="ld" __INT_FAST64_FMTi__="li" __INT_FAST64_MAX__=9223372036854775807L __INT_FAST64_TYPE__=long\ int __INT_FAST64_WIDTH__=64 __INT_FAST8_FMTd__="hhd" __INT_FAST8_FMTi__="hhi" __INT_FAST8_MAX__=127 __INT_FAST8_TYPE__=signed\ char __INT_FAST8_WIDTH__=8 __INT_LEAST16_FMTd__="hd" __INT_LEAST16_FMTi__="hi" __INT_LEAST16_MAX__=32767 __INT_LEAST16_TYPE__=short __INT_LEAST16_WIDTH__=16 __INT_LEAST32_FMTd__="d" __INT_LEAST32_FMTi__="i" __INT_LEAST32_MAX__=2147483647 __INT_LEAST32_TYPE__=int __INT_LEAST32_WIDTH__=32 __INT_LEAST64_FMTd__="ld" __INT_LEAST64_FMTi__="li" __INT_LEAST64_MAX__=9223372036854775807L __INT_LEAST64_TYPE__=long\ int __INT_LEAST64_WIDTH__=64 __INT_LEAST8_FMTd__="hhd" __INT_LEAST8_FMTi__="hhi" __INT_LEAST8_MAX__=127 __INT_LEAST8_TYPE__=signed\ char __INT_LEAST8_WIDTH__=8 __INT_MAX__=2147483647 __INT_WIDTH__=32 __LDBL_DECIMAL_DIG__=36 __LDBL_DENORM_MIN__=6.47517511943802511092443895822764655e-4966L __LDBL_DIG__=33 __LDBL_EPSILON__=1.92592994438723585305597794258492732e-34L __LDBL_HAS_DENORM__=1 __LDBL_HAS_INFINITY__=1 __LDBL_HAS_QUIET_NAN__=1 __LDBL_MANT_DIG__=113 __LDBL_MAX_10_EXP__=4932 __LDBL_MAX_EXP__=16384 __LDBL_MAX__=1.18973149535723176508575932662800702e+4932L __LDBL_MIN_10_EXP__=(-4931) __LDBL_MIN_EXP__=(-16381) __LDBL_MIN__=3.36210314311209350626267781732175260e-4932L __LDBL_NORM_MAX__=1.18973149535723176508575932662800702e+4932L __LITTLE_ENDIAN__=1 __LLONG_WIDTH__=64 __LONG_LONG_MAX__=9223372036854775807LL __LONG_MAX__=9223372036854775807L __LONG_WIDTH__=64 __LP64__=1 __MEMORY_SCOPE_DEVICE=1 __MEMORY_SCOPE_SINGLE=4 __MEMORY_SCOPE_SYSTEM=0 __MEMORY_SCOPE_WRKGRP=2 __MEMORY_SCOPE_WVFRNT=3 __OBJC_BOOL_IS_BOOL=0 __OPENCL_MEMORY_SCOPE_ALL_SVM_DEVICES=3 __OPENCL_MEMORY_SCOPE_DEVICE=2 __OPENCL_MEMORY_SCOPE_SUB_GROUP=4 __OPENCL_MEMORY_SCOPE_WORK_GROUP=1 __OPENCL_MEMORY_SCOPE_WORK_ITEM=0 __ORDER_BIG_ENDIAN__=4321 __ORDER_LITTLE_ENDIAN__=1234 __ORDER_PDP_ENDIAN__=3412 __PIC__=2 __PIE__=2 __POINTER_WIDTH__=64 __PRAGMA_REDEFINE_EXTNAME=1 __PTRDIFF_FMTd__="ld" __PTRDIFF_FMTi__="li" __PTRDIFF_MAX__=9223372036854775807L __PTRDIFF_TYPE__=long\ int __PTRDIFF_WIDTH__=64 __SCHAR_MAX__=127 __SHRT_MAX__=32767 __SHRT_WIDTH__=16 __SIG_ATOMIC_MAX__=2147483647 __SIG_ATOMIC_WIDTH__=32 __SIZEOF_DOUBLE__=8 __SIZEOF_FLOAT__=4 __SIZEOF_INT128__=16 __SIZEOF_INT__=4 __SIZEOF_LONG_DOUBLE__=16 __SIZEOF_LONG_LONG__=8 __SIZEOF_LONG__=8 __SIZEOF_POINTER__=8 __SIZEOF_PTRDIFF_T__=8 __SIZEOF_SHORT__=2 __SIZEOF_SIZE_T__=8 __SIZEOF_WCHAR_T__=4 __SIZEOF_WINT_T__=4 __SIZE_FMTX__="lX" __SIZE_FMTo__="lo" __SIZE_FMTu__="lu" __SIZE_FMTx__="lx" __SIZE_MAX__=18446744073709551615UL __SIZE_TYPE__=long\ unsigned\ int __SIZE_WIDTH__=64 __SSP_STRONG__=2 __STDC_EMBED_EMPTY__=2 __STDC_EMBED_FOUND__=1 __STDC_EMBED_NOT_FOUND__=0 __STDC_HOSTED__=1 __STDC_IEC_559_COMPLEX__=1 __STDC_IEC_559__=1 __STDC_IEC_60559_BFP__=201404L __STDC_IEC_60559_COMPLEX__=201404L __STDC_ISO_10646__=201706L __STDC_UTF_16__=1 __STDC_UTF_32__=1 __STDC_VERSION__=201710L __STDC__=1 __UINT16_C_SUFFIX__= __UINT16_FMTX__="hX" __UINT16_FMTo__="ho" __UINT16_FMTu__="hu" __UINT16_FMTx__="hx" __UINT16_MAX__=65535 __UINT16_TYPE__=unsigned\ short __UINT32_C_SUFFIX__=U __UINT32_FMTX__="X" __UINT32_FMTo__="o" __UINT32_FMTu__="u" __UINT32_FMTx__="x" __UINT32_MAX__=4294967295U __UINT32_TYPE__=unsigned\ int __UINT64_C_SUFFIX__=UL __UINT64_FMTX__="lX" __UINT64_FMTo__="lo" __UINT64_FMTu__="lu" __UINT64_FMTx__="lx" __UINT64_MAX__=18446744073709551615UL __UINT64_TYPE__=long\ unsigned\ int __UINT8_C_SUFFIX__= __UINT8_FMTX__="hhX" __UINT8_FMTo__="hho" __UINT8_FMTu__="hhu" __UINT8_FMTx__="hhx" __UINT8_MAX__=255 __UINT8_TYPE__=unsigned\ char __UINTMAX_C_SUFFIX__=UL __UINTMAX_FMTX__="lX" __UINTMAX_FMTo__="lo" __UINTMAX_FMTu__="lu" __UINTMAX_FMTx__="lx" __UINTMAX_MAX__=18446744073709551615UL __UINTMAX_TYPE__=long\ unsigned\ int __UINTMAX_WIDTH__=64 __UINTPTR_FMTX__="lX" __UINTPTR_FMTo__="lo" __UINTPTR_FMTu__="lu" __UINTPTR_FMTx__="lx" __UINTPTR_MAX__=18446744073709551615UL __UINTPTR_TYPE__=long\ unsigned\ int __UINTPTR_WIDTH__=64 __UINT_FAST16_FMTX__="hX" __UINT_FAST16_FMTo__="ho" __UINT_FAST16_FMTu__="hu" __UINT_FAST16_FMTx__="hx" __UINT_FAST16_MAX__=65535 __UINT_FAST16_TYPE__=unsigned\ short __UINT_FAST32_FMTX__="X" __UINT_FAST32_FMTo__="o" __UINT_FAST32_FMTu__="u" __UINT_FAST32_FMTx__="x" __UINT_FAST32_MAX__=4294967295U __UINT_FAST32_TYPE__=unsigned\ int __UINT_FAST64_FMTX__="lX" __UINT_FAST64_FMTo__="lo" __UINT_FAST64_FMTu__="lu" __UINT_FAST64_FMTx__="lx" __UINT_FAST64_MAX__=18446744073709551615UL __UINT_FAST64_TYPE__=long\ unsigned\ int __UINT_FAST8_FMTX__="hhX" __UINT_FAST8_FMTo__="hho" __UINT_FAST8_FMTu__="hhu" __UINT_FAST8_FMTx__="hhx" __UINT_FAST8_MAX__=255 __UINT_FAST8_TYPE__=unsigned\ char __UINT_LEAST16_FMTX__="hX" __UINT_LEAST16_FMTo__="ho" __UINT_LEAST16_FMTu__="hu" __UINT_LEAST16_FMTx__="hx" __UINT_LEAST16_MAX__=65535 __UINT_LEAST16_TYPE__=unsigned\ short __UINT_LEAST32_FMTX__="X" __UINT_LEAST32_FMTo__="o" __UINT_LEAST32_FMTu__="u" __UINT_LEAST32_FMTx__="x" __UINT_LEAST32_MAX__=4294967295U __UINT_LEAST32_TYPE__=unsigned\ int __UINT_LEAST64_FMTX__="lX" __UINT_LEAST64_FMTo__="lo" __UINT_LEAST64_FMTu__="lu" __UINT_LEAST64_FMTx__="lx" __UINT_LEAST64_MAX__=18446744073709551615UL __UINT_LEAST64_TYPE__=long\ unsigned\ int __UINT_LEAST8_FMTX__="hhX" __UINT_LEAST8_FMTo__="hho" __UINT_LEAST8_FMTu__="hhu" __UINT_LEAST8_FMTx__="hhx" __UINT_LEAST8_MAX__=255 __UINT_LEAST8_TYPE__=unsigned\ char __USER_LABEL_PREFIX__= __USE_FILE_OFFSET64=1 __USE_LARGEFILE=1 __USE_MISC=1 __USE_POSIX199309=1 __USE_POSIX199506=1 __USE_POSIX2=1 __USE_POSIX=1 __VERSION__="Clang\ 19.1.7+libcxx" __WCHAR_MAX__=4294967295U __WCHAR_TYPE__=unsigned\ int __WCHAR_UNSIGNED__=1 __WCHAR_WIDTH__=32 __WINT_MAX__=4294967295U __WINT_TYPE__=unsigned\ int __WINT_UNSIGNED__=1 __WINT_WIDTH__=32 __aarch64__=1 __clang__=1 __clang_literal_encoding__="UTF-8" __clang_major__=19 __clang_minor__=1 __clang_patchlevel__=7 __clang_version__="19.1.7+libcxx\ " __clang_wide_literal_encoding__="UTF-32" __gnu_linux__=1 __linux=1 __linux__=1 __llvm__=1 __pic__=2 __pie__=2 __unix=1 __unix__=1 linux=1 unix=1'
crypt_r_proto='0'
cryptlib=''
csh='csh'
ctermid_r_proto='0'
ctime_r_proto='0'
d_Gconvert='sprintf((b),"%.*g",(n),(x))'
d_PRIEUldbl='define'
d_PRIFUldbl='define'
d_PRIGUldbl='define'
d_PRIXU64='define'
d_PRId64='define'
d_PRIeldbl='define'
d_PRIfldbl='define'
d_PRIgldbl='define'
d_PRIi64='define'
d_PRIo64='define'
d_PRIu64='define'
d_PRIx64='define'
d_SCNfldbl='define'
d__fwalk='undef'
d_accept4='define'
d_access='define'
d_accessx='undef'
d_acosh='define'
d_aintl='undef'
d_alarm='define'
d_archlib='define'
d_asctime64='undef'
d_asctime_r='undef'
d_asinh='define'
d_atanh='define'
d_atolf='undef'
d_atoll='define'
d_attribute_always_inline='define'
d_attribute_deprecated='define'
d_attribute_format='define'
d_attribute_malloc='define'
d_attribute_nonnull='define'
d_attribute_noreturn='define'
d_attribute_pure='define'
d_attribute_unused='define'
d_attribute_visibility='define'
d_attribute_warn_unused_result='define'
d_backtrace='define'
d_bsd='undef'
d_bsdgetpgrp='undef'
d_bsdsetpgrp='undef'
d_builtin_add_overflow='define'
d_builtin_choose_expr='define'
d_builtin_expect='define'
d_builtin_mul_overflow='define'
d_builtin_sub_overflow='define'
d_c99_variadic_macros='define'
d_casti32='define'
d_castneg='undef'
d_cbrt='define'
d_chown='define'
d_chroot='define'
d_chsize='undef'
d_class='undef'
d_clearenv='define'
d_closedir='define'
d_cmsghdr_s='define'
d_copysign='define'
d_copysignl='define'
d_cplusplus='undef'
d_crypt='define'
d_crypt_r='undef'
d_csh='undef'
d_ctermid='define'
d_ctermid_r='undef'
d_ctime64='undef'
d_ctime_r='undef'
d_cuserid='define'
d_dbminitproto='undef'
d_difftime='define'
d_difftime64='undef'
d_dir_dd_fd='undef'
d_dirfd='define'
d_dirnamlen='undef'
d_dladdr='define'
d_dlerror='define'
d_dlopen='define'
d_dlsymun='undef'
d_dosuid='undef'
d_double_has_inf='define'
d_double_has_nan='define'
d_double_has_negative_zero='define'
d_double_has_subnormals='define'
d_double_style_cray='undef'
d_double_style_ibm='undef'
d_double_style_ieee='define'
d_double_style_vax='undef'
d_drand48_r='undef'
d_drand48proto='define'
d_dup2='define'
d_dup3='define'
d_duplocale='define'
d_eaccess='define'
d_endgrent='define'
d_endgrent_r='undef'
d_endhent='define'
d_endhostent_r='undef'
d_endnent='define'
d_endnetent_r='undef'
d_endpent='define'
d_endprotoent_r='undef'
d_endpwent='define'
d_endpwent_r='undef'
d_endsent='define'
d_endservent_r='undef'
d_eofnblk='define'
d_erf='define'
d_erfc='define'
d_eunice='undef'
d_exp2='define'
d_expm1='define'
d_faststdio='undef'
d_fchdir='define'
d_fchmod='define'
d_fchmodat='define'
d_fchown='define'
d_fcntl='define'
d_fcntl_can_lock='define'
d_fd_macros='define'
d_fd_set='define'
d_fdclose='undef'
d_fdim='define'
d_fds_bits='undef'
d_fegetround='define'
d_ffs='define'
d_ffsl='define'
d_fgetpos='define'
d_finite='define'
d_finitel='define'
d_flexfnam='define'
d_flock='define'
d_flockproto='define'
d_fma='define'
d_fmax='define'
d_fmin='define'
d_fork='define'
d_fp_class='undef'
d_fp_classify='undef'
d_fp_classl='undef'
d_fpathconf='define'
d_fpclass='undef'
d_fpclassify='define'
d_fpclassl='undef'
d_fpgetround='undef'
d_fpos64_t='undef'
d_freelocale='define'
d_frexpl='define'
d_fs_data_s='undef'
d_fseeko='define'
d_fsetpos='define'
d_fstatfs='define'
d_fstatvfs='define'
d_fsync='define'
d_ftello='define'
d_ftime='undef'
d_futimes='define'
d_gai_strerror='define'
d_gdbm_ndbm_h_uses_prototypes='undef'
d_gdbmndbm_h_uses_prototypes='define'
d_gentoolibdirs='undef'
d_getaddrinfo='define'
d_getcwd='define'
d_getenv_preserves_other_thread='define'
d_getespwnam='undef'
d_getfsstat='undef'
d_getgrent='define'
d_getgrent_r='undef'
d_getgrgid_r='undef'
d_getgrnam_r='undef'
d_getgrps='define'
d_gethbyaddr='define'
d_gethbyname='define'
d_gethent='define'
d_gethname='define'
d_gethostbyaddr_r='undef'
d_gethostbyname_r='undef'
d_gethostent_r='undef'
d_gethostprotos='define'
d_getitimer='define'
d_getlogin='define'
d_getlogin_r='undef'
d_getmnt='undef'
d_getmntent='define'
d_getnameinfo='define'
d_getnbyaddr='define'
d_getnbyname='define'
d_getnent='define'
d_getnetbyaddr_r='undef'
d_getnetbyname_r='undef'
d_getnetent_r='undef'
d_getnetprotos='define'
d_getpagsz='define'
d_getpbyname='define'
d_getpbynumber='define'
d_getpent='define'
d_getpgid='define'
d_getpgrp='define'
d_getpgrp2='undef'
d_getppid='define'
d_getprior='define'
d_getprotobyname_r='undef'
d_getprotobynumber_r='undef'
d_getprotoent_r='undef'
d_getprotoprotos='define'
d_getprpwnam='undef'
d_getpwent='define'
d_getpwent_r='undef'
d_getpwnam_r='undef'
d_getpwuid_r='undef'
d_getsbyname='define'
d_getsbyport='define'
d_getsent='define'
d_getservbyname_r='undef'
d_getservbyport_r='undef'
d_getservent_r='undef'
d_getservprotos='define'
d_getspnam='define'
d_getspnam_r='undef'
d_gettimeod='define'
d_gmtime64='undef'
d_gmtime_r='undef'
d_gnulibc='define'
d_grpasswd='define'
d_has_C_UTF8='true'
d_hasmntopt='define'
d_htonl='define'
d_hypot='define'
d_ilogb='define'
d_ilogbl='define'
d_inc_version_list='undef'
d_inetaton='define'
d_inetntop='define'
d_inetpton='define'
d_int64_t='define'
d_ip_mreq='define'
d_ip_mreq_source='define'
d_ipv6_mreq='define'
d_ipv6_mreq_source='undef'
d_isascii='define'
d_isblank='define'
d_isfinite='define'
d_isfinitel='undef'
d_isinf='define'
d_isinfl='define'
d_isless='define'
d_isnan='define'
d_isnanl='define'
d_isnormal='define'
d_j0='define'
d_j0l='define'
d_killpg='define'
d_lc_monetary_2008='define'
d_lchown='define'
d_ldbl_dig='define'
d_ldexpl='define'
d_lgamma='define'
d_lgamma_r='define'
d_libm_lib_version='undef'
d_libname_unique='undef'
d_link='define'
d_linkat='define'
d_llrint='define'
d_llrintl='define'
d_llround='define'
d_llroundl='define'
d_localeconv_l='undef'
d_localtime64='undef'
d_localtime_r='undef'
d_localtime_r_needs_tzset='undef'
d_locconv='define'
d_lockf='define'
d_log1p='define'
d_log2='define'
d_logb='define'
d_long_double_style_ieee='define'
d_long_double_style_ieee_doubledouble='undef'
d_long_double_style_ieee_extended='undef'
d_long_double_style_ieee_std='define'
d_long_double_style_vax='undef'
d_longdbl='define'
d_longlong='define'
d_lrint='define'
d_lrintl='define'
d_lround='define'
d_lroundl='define'
d_lseekproto='define'
d_lstat='define'
d_madvise='define'
d_malloc_good_size='undef'
d_malloc_size='undef'
d_malloc_usable_size='define'
d_mblen='define'
d_mbrlen='define'
d_mbrtowc='define'
d_mbstowcs='define'
d_mbtowc='define'
d_memmem='define'
d_memrchr='define'
d_mkdir='define'
d_mkdtemp='define'
d_mkfifo='define'
d_mkostemp='define'
d_mkstemp='define'
d_mkstemps='define'
d_mktime='define'
d_mktime64='undef'
d_mmap='define'
d_modfl='define'
d_modflproto='define'
d_mprotect='define'
d_msg='define'
d_msg_ctrunc='define'
d_msg_dontroute='define'
d_msg_oob='define'
d_msg_peek='define'
d_msg_proxy='define'
d_msgctl='define'
d_msgget='define'
d_msghdr_s='define'
d_msgrcv='define'
d_msgsnd='define'
d_msync='define'
d_munmap='define'
d_mymalloc='undef'
d_nan='define'
d_nanosleep='define'
d_ndbm='define'
d_ndbm_h_uses_prototypes='undef'
d_nearbyint='define'
d_newlocale='define'
d_nextafter='define'
d_nexttoward='define'
d_nice='define'
d_nl_langinfo='define'
d_nl_langinfo_l='define'
d_non_int_bitfields='define'
d_nv_preserves_uv='undef'
d_nv_zero_is_allbits_zero='define'
d_off64_t='undef'
d_old_pthread_create_joinable='undef'
d_oldpthreads='undef'
d_oldsock='undef'
d_open3='define'
d_openat='define'
d_pathconf='define'
d_pause='define'
d_perl_lc_all_category_positions_init='undef'
d_perl_lc_all_separator='undef'
d_perl_lc_all_uses_name_value_pairs='define'
d_perl_otherlibdirs='undef'
d_phostname='undef'
d_pipe='define'
d_pipe2='define'
d_poll='define'
d_portable='define'
d_prctl='define'
d_prctl_set_name='define'
d_printf_format_null='define'
d_procselfexe='define'
d_pseudofork='undef'
d_pthread_atfork='define'
d_pthread_attr_setscope='define'
d_pthread_yield='undef'
d_ptrdiff_t='define'
d_pwage='undef'
d_pwchange='undef'
d_pwclass='undef'
d_pwcomment='undef'
d_pwexpire='undef'
d_pwgecos='define'
d_pwpasswd='define'
d_pwquota='undef'
d_qgcvt='define'
d_quad='define'
d_querylocale='undef'
d_random_r='undef'
d_re_comp='undef'
d_readdir='define'
d_readdir64_r='undef'
d_readdir_r='undef'
d_readlink='define'
d_readv='define'
d_recvmsg='define'
d_regcmp='undef'
d_regcomp='define'
d_remainder='define'
d_remquo='define'
d_rename='define'
d_renameat='define'
d_rewinddir='define'
d_rint='define'
d_rmdir='define'
d_round='define'
d_sbrkproto='define'
d_scalbn='define'
d_scalbnl='define'
d_sched_yield='define'
d_scm_rights='define'
d_seekdir='define'
d_select='define'
d_sem='define'
d_semctl='define'
d_semctl_semid_ds='define'
d_semctl_semun='define'
d_semget='define'
d_semop='define'
d_sendmsg='define'
d_setegid='define'
d_setenv='define'
d_seteuid='define'
d_setgrent='define'
d_setgrent_r='undef'
d_setgrps='define'
d_sethent='define'
d_sethostent_r='undef'
d_setitimer='define'
d_setlinebuf='define'
d_setlocale='define'
d_setlocale_accepts_any_locale_name='undef'
d_setlocale_r='undef'
d_setnent='define'
d_setnetent_r='undef'
d_setpent='define'
d_setpgid='define'
d_setpgrp='define'
d_setpgrp2='undef'
d_setprior='define'
d_setproctitle='undef'
d_setprotoent_r='undef'
d_setpwent='define'
d_setpwent_r='undef'
d_setregid='define'
d_setresgid='define'
d_setresuid='define'
d_setreuid='define'
d_setrgid='undef'
d_setruid='undef'
d_setsent='define'
d_setservent_r='undef'
d_setsid='define'
d_setvbuf='define'
d_shm='define'
d_shmat='define'
d_shmatprototype='define'
d_shmctl='define'
d_shmdt='define'
d_shmget='define'
d_sigaction='define'
d_siginfo_si_addr='define'
d_siginfo_si_band='define'
d_siginfo_si_errno='define'
d_siginfo_si_fd='define'
d_siginfo_si_pid='define'
d_siginfo_si_status='define'
d_siginfo_si_uid='define'
d_siginfo_si_value='define'
d_signbit='define'
d_sigprocmask='define'
d_sigsetjmp='define'
d_sin6_scope_id='define'
d_sitearch='define'
d_snprintf='define'
d_sockaddr_in6='define'
d_sockaddr_sa_len='undef'
d_sockaddr_storage='define'
d_sockatmark='define'
d_sockatmarkproto='define'
d_socket='define'
d_socklen_t='define'
d_sockpair='define'
d_socks5_init='undef'
d_sqrtl='define'
d_srand48_r='undef'
d_srandom_r='undef'
d_sresgproto='undef'
d_sresuproto='undef'
d_stat='define'
d_statblks='define'
d_statfs_f_flags='define'
d_statfs_s='define'
d_static_inline='define'
d_statvfs='define'
d_stdio_cnt_lval='undef'
d_stdio_ptr_lval='undef'
d_stdio_ptr_lval_nochange_cnt='undef'
d_stdio_ptr_lval_sets_cnt='undef'
d_stdio_stream_array='undef'
d_stdiobase='undef'
d_stdstdio='undef'
d_strcoll='define'
d_strerror_l='define'
d_strerror_r='undef'
d_strftime='define'
d_strlcat='define'
d_strlcpy='define'
d_strnlen='define'
d_strtod='define'
d_strtod_l='define'
d_strtol='define'
d_strtold='define'
d_strtold_l='define'
d_strtoll='define'
d_strtoq='define'
d_strtoul='define'
d_strtoull='define'
d_strtouq='define'
d_strxfrm='define'
d_strxfrm_l='define'
d_suidsafe='undef'
d_symlink='define'
d_syscall='define'
d_syscallproto='define'
d_sysconf='define'
d_sysernlst=''
d_syserrlst='undef'
d_system='define'
d_tcgetpgrp='define'
d_tcsetpgrp='define'
d_telldir='define'
d_telldirproto='define'
d_tgamma='define'
d_thread_local='define'
d_time='define'
d_timegm='define'
d_times='define'
d_tm_tm_gmtoff='define'
d_tm_tm_zone='define'
d_tmpnam_r='undef'
d_towlower='define'
d_towupper='define'
d_trunc='define'
d_truncate='define'
d_truncl='define'
d_ttyname_r='undef'
d_tzname='define'
d_u32align='define'
d_ualarm='define'
d_umask='define'
d_uname='define'
d_union_semun='undef'
d_unlinkat='define'
d_unordered='undef'
d_unsetenv='define'
d_uselocale='define'
d_usleep='define'
d_usleepproto='define'
d_ustat='undef'
d_vendorarch='define'
d_vendorbin='define'
d_vendorlib='define'
d_vendorscript='define'
d_vfork='undef'
d_void_closedir='undef'
d_voidsig='define'
d_voidtty=''
d_vsnprintf='define'
d_wait4='define'
d_waitpid='define'
d_wcrtomb='define'
d_wcscmp='define'
d_wcstombs='define'
d_wcsxfrm='define'
d_wctomb='define'
d_writev='define'
d_xenix='undef'
date='date'
db_hashtype='u_int32_t'
db_prefixtype='size_t'
db_version_major=''
db_version_minor=''
db_version_patch=''
default_inc_excludes_dot='define'
direntrytype='struct dirent'
dlext='so'
dlsrc='dl_dlopen.xs'
doubleinfbytes='0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x7f'
doublekind='3'
doublemantbits='52'
doublenanbytes='0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x7f'
doublesize='8'
drand01='Perl_drand48()'
drand48_r_proto='0'
dtrace=''
dtraceobject=''
dtracexnolibs=''
dynamic_ext='B Compress/Raw/Bzip2 Compress/Raw/Zlib Cwd Data/Dumper Devel/PPPort Devel/Peek Digest/MD5 Digest/SHA Encode Fcntl File/DosGlob File/Glob Filter/Util/Call GDBM_File Hash/Util Hash/Util/FieldHash I18N/Langinfo IO IPC/SysV List/Util MIME/Base64 Math/BigInt/FastCalc NDBM_File Opcode POSIX PerlIO/encoding PerlIO/mmap PerlIO/via SDBM_File Socket Storable Sys/Hostname Sys/Syslog Time/HiRes Time/Piece Unicode/Collate Unicode/Normalize XS/APItest XS/Typemap attributes mro re threads threads/shared'
eagain='EAGAIN'
ebcdic='undef'
echo='echo'
egrep='egrep'
emacs=''
endgrent_r_proto='0'
endhostent_r_proto='0'
endnetent_r_proto='0'
endprotoent_r_proto='0'
endpwent_r_proto='0'
endservent_r_proto='0'
eunicefix=':'
exe_ext=''
expr='expr'
extensions='B Compress/Raw/Bzip2 Compress/Raw/Zlib Cwd Data/Dumper Devel/PPPort Devel/Peek Digest/MD5 Digest/SHA Encode Fcntl File/DosGlob File/Glob Filter/Util/Call GDBM_File Hash/Util Hash/Util/FieldHash I18N/Langinfo IO IPC/SysV List/Util MIME/Base64 Math/BigInt/FastCalc NDBM_File Opcode POSIX PerlIO/encoding PerlIO/mmap PerlIO/via SDBM_File Socket Storable Sys/Hostname Sys/Syslog Time/HiRes Time/Piece Unicode/Collate Unicode/Normalize XS/APItest XS/Typemap attributes mro re threads threads/shared Archive/Tar Attribute/Handlers AutoLoader CPAN CPAN/Meta CPAN/Meta/Requirements CPAN/Meta/YAML Carp Config/Perl/V Devel/SelfStubber Digest Dumpvalue Env Errno Exporter ExtUtils/CBuilder ExtUtils/Constant ExtUtils/Install ExtUtils/MakeMaker ExtUtils/Manifest ExtUtils/Miniperl ExtUtils/PL2Bat ExtUtils/ParseXS File/Fetch File/Find File/Path File/Temp FileCache Filter/Simple FindBin Getopt/Long HTTP/Tiny I18N/Collate I18N/LangTags IO/Compress IO/Socket/IP IO/Zlib IPC/Cmd IPC/Open3 JSON/PP Locale/Maketext Locale/Maketext/Simple Math/BigInt Math/Complex Memoize Module/CoreList Module/Load Module/Load/Conditional Module/Loaded Module/Metadata NEXT Net/Ping Params/Check Perl/OSType PerlIO/scalar PerlIO/via/QuotedPrint Pod/Checker Pod/Escapes Pod/Functions Pod/Html Pod/Perldoc Pod/Simple Pod/Usage Safe Search/Dict SelfLoader Term/ANSIColor Term/Cap Term/Complete Term/ReadLine Term/Table Test Test/Harness Test/Simple Test2/Suite Text/Abbrev Text/Balanced Text/ParseWords Text/Tabs Thread/Queue Thread/Semaphore Tie/File Tie/Hash/NamedCapture Tie/Memoize Tie/RefHash Time/Local XSLoader autodie autouse base bignum constant encoding/warnings experimental if lib libnet parent perlfaq podlators version'
extern_C='extern'
extras=''
fflushNULL='define'
fflushall='undef'
find=''
firstmakefile='makefile'
flex=''
fpossize='16'
fpostype='fpos_t'
freetype='void'
from=':'
full_ar='/usr/lib/llvm/19/bin/llvm-ar'
full_csh='csh'
full_sed='/usr/bin/sed'
gccansipedantic=''
gccosandvers=''
gccversion='Clang 19.1.7+libcxx'
gentoolibdirs=' '
getgrent_r_proto='0'
getgrgid_r_proto='0'
getgrnam_r_proto='0'
gethostbyaddr_r_proto='0'
gethostbyname_r_proto='0'
gethostent_r_proto='0'
getlogin_r_proto='0'
getnetbyaddr_r_proto='0'
getnetbyname_r_proto='0'
getnetent_r_proto='0'
getprotobyname_r_proto='0'
getprotobynumber_r_proto='0'
getprotoent_r_proto='0'
getpwent_r_proto='0'
getpwnam_r_proto='0'
getpwuid_r_proto='0'
getservbyname_r_proto='0'
getservbyport_r_proto='0'
getservent_r_proto='0'
getspnam_r_proto='0'
gidformat='"u"'
gidsign='1'
gidsize='4'
gidtype='gid_t'
glibpth='/lib64 /usr/lib64 '
gmake='gmake'
gmtime_r_proto='0'
gnulibc_version='2.40'
grep='grep'
groupcat='cat /etc/group'
groupstype='gid_t'
gzip='gzip'
h_fcntl='false'
h_sysfile='true'
hint='recommended'
hostcat='cat /etc/hosts'
hostgenerate=''
hostosname=''
hostperl=''
html1dir=' '
html1direxp=''
html3dir=' '
html3direxp=''
i16size='2'
i16type='short'
i32dformat='"d"'
i32size='4'
i32type='int'
i64size='8'
i64type='long'
i8size='1'
i8type='signed char'
i_arpainet='define'
i_bfd='undef'
i_bsdioctl=''
i_crypt='define'
i_db='undef'
i_dbm='undef'
i_dirent='define'
i_dlfcn='define'
i_execinfo='define'
i_fcntl='undef'
i_fenv='define'
i_fp='undef'
i_fp_class='undef'
i_gdbm='define'
i_gdbm_ndbm='undef'
i_gdbmndbm='define'
i_grp='define'
i_ieeefp='undef'
i_inttypes='define'
i_langinfo='define'
i_libutil='undef'
i_limits='define'
i_locale='define'
i_machcthr='undef'
i_malloc='define'
i_mallocmalloc='undef'
i_mntent='define'
i_ndbm='undef'
i_netdb='define'
i_neterrno='undef'
i_netinettcp='define'
i_niin='define'
i_poll='define'
i_prot='undef'
i_pthread='define'
i_pwd='define'
i_quadmath='undef'
i_rpcsvcdbm='undef'
i_sgtty='undef'
i_shadow='define'
i_socks='undef'
i_stdbool='define'
i_stdint='define'
i_stdlib='define'
i_string='define'
i_sunmath='undef'
i_sysaccess='undef'
i_sysdir='define'
i_sysfile='define'
i_sysfilio='undef'
i_sysin='undef'
i_sysioctl='define'
i_syslog='define'
i_sysmman='define'
i_sysmode='undef'
i_sysmount='define'
i_sysndir='undef'
i_sysparam='define'
i_syspoll='define'
i_sysresrc='define'
i_syssecrt='undef'
i_sysselct='define'
i_syssockio='undef'
i_sysstat='define'
i_sysstatfs='define'
i_sysstatvfs='define'
i_syssyscall='define'
i_systime='define'
i_systimek='undef'
i_systimes='define'
i_systypes='define'
i_sysuio='define'
i_sysun='define'
i_sysutsname='define'
i_sysvfs='define'
i_syswait='define'
i_termio='undef'
i_termios='define'
i_time='define'
i_unistd='define'
i_ustat='undef'
i_utime='define'
i_vfork='undef'
i_wchar='define'
i_wctype='define'
i_xlocale='undef'
ignore_versioned_solibs='y'
inc_version_list=' '
inc_version_list_init='0'
incpath=''
incpth='/usr/lib/clang/19/include /usr/include'
inews=''
initialinstalllocation='/usr/bin'
installarchlib='/usr/lib64/perl5/5.40/aarch64-linux'
installbin='/usr/bin'
installhtml1dir=''
installhtml3dir=''
installman1dir='/usr/share/man/man1'
installman3dir='/usr/share/man/man3'
installprefix='/usr'
installprefixexp='/usr'
installprivlib='/usr/lib64/perl5/5.40'
installscript='/usr/bin'
installsitearch='/usr/local/lib64/perl5/5.40/aarch64-linux'
installsitebin='/usr/local/bin'
installsitehtml1dir=''
installsitehtml3dir=''
installsitelib='/usr/local/lib64/perl5/5.40'
installsiteman1dir='/usr/local/man/man1'
installsiteman3dir='/usr/local/man/man3'
installsitescript='/usr/local/bin'
installstyle='lib/perl5'
installusrbinperl='undef'
installvendorarch='/usr/lib64/perl5/vendor_perl/5.40/aarch64-linux'
installvendorbin='/usr/bin'
installvendorhtml1dir=''
installvendorhtml3dir=''
installvendorlib='/usr/lib64/perl5/vendor_perl/5.40'
installvendorman1dir='/usr/share/man/man1'
installvendorman3dir='/usr/share/man/man3'
installvendorscript='/usr/bin'
intsize='4'
issymlink='test -h'
ivdformat='"ld"'
ivsize='8'
ivtype='long'
known_extensions='Amiga/ARexx Amiga/Exec Archive/Tar Attribute/Handlers AutoLoader B CPAN CPAN/Meta CPAN/Meta/Requirements CPAN/Meta/YAML Carp Compress/Raw/Bzip2 Compress/Raw/Zlib Config/Perl/V Cwd DB_File Data/Dumper Devel/PPPort Devel/Peek Devel/SelfStubber Digest Digest/MD5 Digest/SHA Dumpvalue Encode Env Errno Exporter ExtUtils/CBuilder ExtUtils/Constant ExtUtils/Install ExtUtils/MakeMaker ExtUtils/Manifest ExtUtils/Miniperl ExtUtils/PL2Bat ExtUtils/ParseXS Fcntl File/DosGlob File/Fetch File/Find File/Glob File/Path File/Temp FileCache Filter/Simple Filter/Util/Call FindBin GDBM_File Getopt/Long HTTP/Tiny Hash/Util Hash/Util/FieldHash I18N/Collate I18N/LangTags I18N/Langinfo IO IO/Compress IO/Socket/IP IO/Zlib IPC/Cmd IPC/Open3 IPC/SysV JSON/PP List/Util Locale/Maketext Locale/Maketext/Simple MIME/Base64 Math/BigInt Math/BigInt/FastCalc Math/Complex Memoize Module/CoreList Module/Load Module/Load/Conditional Module/Loaded Module/Metadata NDBM_File NEXT Net/Ping ODBM_File Opcode POSIX Params/Check Perl/OSType PerlIO/encoding PerlIO/mmap PerlIO/scalar PerlIO/via PerlIO/via/QuotedPrint Pod/Checker Pod/Escapes Pod/Functions Pod/Html Pod/Perldoc Pod/Simple Pod/Usage SDBM_File Safe Search/Dict SelfLoader Socket Storable Sys/Hostname Sys/Syslog Term/ANSIColor Term/Cap Term/Complete Term/ReadLine Term/Table Test Test/Harness Test/Simple Test2/Suite Text/Abbrev Text/Balanced Text/ParseWords Text/Tabs Thread/Queue Thread/Semaphore Tie/File Tie/Hash/NamedCapture Tie/Memoize Tie/RefHash Time/HiRes Time/Local Time/Piece Unicode/Collate Unicode/Normalize VMS/DCLsym VMS/Filespec VMS/Stdio Win32 Win32API/File Win32CORE XS/APItest XS/Typemap XSLoader attributes autodie autouse base bignum constant encoding/warnings experimental if lib libnet mro parent perlfaq podlators re threads threads/shared version '
ksh=''
ld='clang'
ld_can_script='define'
lddlflags='-shared -O2 -pipe -fno-strict-aliasing -Wl,-O1 -Wl,--as-needed -Wl,--as-needed'
ldflags='-Wl,-O1 -Wl,--as-needed -Wl,--as-needed'
ldflags_uselargefiles=''
ldlibpthname='LD_LIBRARY_PATH'
less='less'
lib_ext='.a'
libc='/lib/../lib64/libc.so.6'
libdb_needs_pthread='N'
libperl='libperl.so.5.40.2'
libpth='/usr/local/lib64 /lib64 /usr/lib64 /usr/lib/clang/19/lib /usr/lib'
libs='-lgdbm -ldl -lm -lcrypt -lutil -lc -lgdbm_compat'
libsdirs=' /lib64'
libsfiles=' libgdbm.so libdl.a libm.so libcrypt.so libutil.a libc.so libgdbm_compat.so'
libsfound=' /lib64/libgdbm.so /lib64/libdl.a /lib64/libm.so /lib64/libcrypt.so /lib64/libutil.a /lib64/libc.so /lib64/libgdbm_compat.so'
libspath=' /usr/local/lib64 /lib64 /usr/lib64 /usr/lib/clang/19/lib /usr/lib'
libswanted='socket inet gdbm dbm db malloc dl ld sun m crypt sec util c cposix posix ucb BSD gdbm_compat'
libswanted_uselargefiles=''
line=''
lint=''
lkflags=''
ln='ln'
lns='/usr/bin/ln -s'
localtime_r_proto='0'
locincpth=''
loclibpth=''
longdblinfbytes='0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x7f'
longdblkind='1'
longdblmantbits='112'
longdblnanbytes='0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0x7f'
longdblsize='16'
longlongsize='8'
longsize='8'
lp=''
lpr=''
ls='ls'
lseeksize='8'
lseektype='off_t'
mail=''
mailx=''
make='make'
make_set_make='#'
mallocobj=''
mallocsrc=''
malloctype='void *'
man1dir='/usr/share/man/man1'
man1direxp='/usr/share/man/man1'
man1ext='1'
man3dir='/usr/share/man/man3'
man3direxp='/usr/share/man/man3'
man3ext='3pm'
mips_type=''
mistrustnm=''
mkdir='mkdir'
mmaptype='void *'
modetype='mode_t'
more='more'
multiarch='undef'
mv=''
myarchname='aarch64-linux'
mydomain='.nonet'
myhostname='localhost'
myuname='linux localhost 6.12.23-gentoo-dist #1 smp preempt_dynamic sat apr 12 12:42:20 -00 2025 aarch64 gnulinux '
n='-n'
need_va_copy='undef'
netdb_hlen_type='size_t'
netdb_host_type='char *'
netdb_name_type='const char *'
netdb_net_type='in_addr_t'
nm='llvm-nm'
nm_opt=''
nm_so_opt='--dynamic'
nonxs_ext='Archive/Tar Attribute/Handlers AutoLoader CPAN CPAN/Meta CPAN/Meta/Requirements CPAN/Meta/YAML Carp Config/Perl/V Devel/SelfStubber Digest Dumpvalue Env Errno Exporter ExtUtils/CBuilder ExtUtils/Constant ExtUtils/Install ExtUtils/MakeMaker ExtUtils/Manifest ExtUtils/Miniperl ExtUtils/PL2Bat ExtUtils/ParseXS File/Fetch File/Find File/Path File/Temp FileCache Filter/Simple FindBin Getopt/Long HTTP/Tiny I18N/Collate I18N/LangTags IO/Compress IO/Socket/IP IO/Zlib IPC/Cmd IPC/Open3 JSON/PP Locale/Maketext Locale/Maketext/Simple Math/BigInt Math/Complex Memoize Module/CoreList Module/Load Module/Load/Conditional Module/Loaded Module/Metadata NEXT Net/Ping Params/Check Perl/OSType PerlIO/scalar PerlIO/via/QuotedPrint Pod/Checker Pod/Escapes Pod/Functions Pod/Html Pod/Perldoc Pod/Simple Pod/Usage Safe Search/Dict SelfLoader Term/ANSIColor Term/Cap Term/Complete Term/ReadLine Term/Table Test Test/Harness Test/Simple Test2/Suite Text/Abbrev Text/Balanced Text/ParseWords Text/Tabs Thread/Queue Thread/Semaphore Tie/File Tie/Hash/NamedCapture Tie/Memoize Tie/RefHash Time/Local XSLoader autodie autouse base bignum constant encoding/warnings experimental if lib libnet parent perlfaq podlators version'
nroff='nroff'
nvEUformat='"E"'
nvFUformat='"F"'
nvGUformat='"G"'
nv_overflows_integers_at='256.0*256.0*256.0*256.0*256.0*256.0*2.0*2.0*2.0*2.0*2.0'
nv_preserves_uv_bits='53'
nveformat='"e"'
nvfformat='"f"'
nvgformat='"g"'
nvmantbits='52'
nvsize='8'
nvtype='double'
o_nonblock='O_NONBLOCK'
obj_ext='.o'
old_pthread_create_joinable=''
optimize='-O2 -pipe -fno-strict-aliasing'
orderlib='false'
osname='linux'
osvers='6.12.23-gentoo-dist'
otherlibdirs=' '
package='perl5'
pager='/usr/bin/less -R'
passcat='cat /etc/passwd'
patchlevel='40'
path_sep=':'
perl='perl'
perl5='/usr/bin/perl'
perl_lc_all_category_positions_init=''
perl_lc_all_separator=''
perl_patchlevel=''
perl_static_inline='static __inline__'
perl_thread_local='_Thread_local'
perladmin='root@localhost'
perllibs='-ldl -lm -lcrypt -lutil -lc'
perlpath='/usr/bin/perl'
pg='pg'
phostname=''
pidtype='pid_t'
plibpth='/lib/aarch64-unknown-linux-gnu/14 /lib/../lib64 /usr/lib/aarch64-unknown-linux-gnu/14 /usr/lib/../lib64 /lib /usr/lib'
pmake=''
pr=''
prefix='/usr'
prefixexp='/usr'
privlib='/usr/lib64/perl5/5.40'
privlibexp='/usr/lib64/perl5/5.40'
procselfexe='"/proc/self/exe"'
prototype='define'
ptrsize='8'
quadkind='2'
quadtype='long'
randbits='48'
randfunc='Perl_drand48'
random_r_proto='0'
randseedtype='U32'
ranlib='llvm-ranlib'
rd_nodata='-1'
readdir64_r_proto='0'
readdir_r_proto='0'
revision='5'
rm='rm'
rm_try='/usr/bin/rm -f try try a.out .out try.[cho] try..o core core.try* try.core*'
rmail=''
run=''
runnm='false'
sGMTIME_max='67768036191676799'
sGMTIME_min='-62167219200'
sLOCALTIME_max='67768036191676799'
sLOCALTIME_min='-62167219200'
sPRIEUldbl='"LE"'
sPRIFUldbl='"LF"'
sPRIGUldbl='"LG"'
sPRIXU64='"lX"'
sPRId64='"ld"'
sPRIeldbl='"Le"'
sPRIfldbl='"Lf"'
sPRIgldbl='"Lg"'
sPRIi64='"li"'
sPRIo64='"lo"'
sPRIu64='"lu"'
sPRIx64='"lx"'
sSCNfldbl='"Lf"'
sched_yield='sched_yield()'
scriptdir='/usr/bin'
scriptdirexp='/usr/bin'
sed='sed'
seedfunc='Perl_drand48_init'
selectminbits='64'
selecttype='fd_set *'
sendmail=''
setgrent_r_proto='0'
sethostent_r_proto='0'
setlocale_r_proto='0'
setnetent_r_proto='0'
setprotoent_r_proto='0'
setpwent_r_proto='0'
setservent_r_proto='0'
sh='/bin/sh'
shar=''
sharpbang='#!'
shmattype='void *'
shortsize='2'
shrpenv=''
shsharp='true'
sig_count='65'
sig_name='ZERO HUP INT QUIT ILL TRAP ABRT BUS FPE KILL USR1 SEGV USR2 PIPE ALRM TERM STKFLT CHLD CONT STOP TSTP TTIN TTOU URG XCPU XFSZ VTALRM PROF WINCH IO PWR SYS NUM32 NUM33 RTMIN NUM35 NUM36 NUM37 NUM38 NUM39 NUM40 NUM41 NUM42 NUM43 NUM44 NUM45 NUM46 NUM47 NUM48 NUM49 NUM50 NUM51 NUM52 NUM53 NUM54 NUM55 NUM56 NUM57 NUM58 NUM59 NUM60 NUM61 NUM62 NUM63 RTMAX IOT CLD POLL '
sig_name_init='"ZERO", "HUP", "INT", "QUIT", "ILL", "TRAP", "ABRT", "BUS", "FPE", "KILL", "USR1", "SEGV", "USR2", "PIPE", "ALRM", "TERM", "STKFLT", "CHLD", "CONT", "STOP", "TSTP", "TTIN", "TTOU", "URG", "XCPU", "XFSZ", "VTALRM", "PROF", "WINCH", "IO", "PWR", "SYS", "NUM32", "NUM33", "RTMIN", "NUM35", "NUM36", "NUM37", "NUM38", "NUM39", "NUM40", "NUM41", "NUM42", "NUM43", "NUM44", "NUM45", "NUM46", "NUM47", "NUM48", "NUM49", "NUM50", "NUM51", "NUM52", "NUM53", "NUM54", "NUM55", "NUM56", "NUM57", "NUM58", "NUM59", "NUM60", "NUM61", "NUM62", "NUM63", "RTMAX", "IOT", "CLD", "POLL", 0'
sig_num='0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 6 17 29 '
sig_num_init='0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 6, 17, 29, 0'
sig_size='68'
signal_t='void'
sitearch='/usr/local/lib64/perl5/5.40/aarch64-linux'
sitearchexp='/usr/local/lib64/perl5/5.40/aarch64-linux'
sitebin='/usr/local/bin'
sitebinexp='/usr/local/bin'
sitehtml1dir=''
sitehtml1direxp=''
sitehtml3dir=''
sitehtml3direxp=''
sitelib='/usr/local/lib64/perl5/5.40'
sitelib_stem='/usr/local/lib64/perl5/5.40'
sitelibexp='/usr/local/lib64/perl5/5.40'
siteman1dir='/usr/local/man/man1'
siteman1direxp='/usr/local/man/man1'
siteman3dir='/usr/local/man/man3'
siteman3direxp='/usr/local/man/man3'
siteprefix='/usr/local'
siteprefixexp='/usr/local'
sitescript='/usr/local/bin'
sitescriptexp='/usr/local/bin'
sizesize='8'
sizetype='size_t'
sleep=''
smail=''
so='so'
sockethdr=''
socketlib=''
socksizetype='socklen_t'
sort='sort'
spackage='Perl5'
spitshell='cat'
srand48_r_proto='0'
srandom_r_proto='0'
src='.'
ssizetype='ssize_t'
st_dev_sign='1'
st_dev_size='8'
st_ino_sign='1'
st_ino_size='8'
startperl='#!/usr/bin/perl'
startsh='#!/bin/sh'
static_ext=' '
stdchar='char'
stdio_base='((fp)->_base)'
stdio_bufsiz='((fp)->_cnt + (fp)->_ptr - (fp)->_base)'
stdio_cnt='((fp)->_cnt)'
stdio_filbuf=''
stdio_ptr='((fp)->_ptr)'
stdio_stream_array=''
strerror_r_proto='0'
submit=''
subversion='2'
sysman='/usr/share/man/man1'
sysroot=''
tail=''
taint_disabled=''
taint_support=''
tar=''
targetarch=''
targetdir=''
targetenv=''
targethost=''
targetmkdir=''
targetport=''
targetsh='/bin/sh'
tbl=''
tee=''
test='test'
timeincl='/usr/include/sys/time.h '
timetype='time_t'
tmpnam_r_proto='0'
to=':'
touch='touch'
tr='tr'
trnl='\n'
troff=''
ttyname_r_proto='0'
u16size='2'
u16type='unsigned short'
u32XUformat='"X"'
u32oformat='"o"'
u32size='4'
u32type='unsigned int'
u32uformat='"u"'
u32xformat='"x"'
u64size='8'
u64type='unsigned long'
u8size='1'
u8type='unsigned char'
uidformat='"u"'
uidsign='1'
uidsize='4'
uidtype='uid_t'
uname='uname'
uniq='uniq'
uquadtype='unsigned long'
use64bitall='define'
use64bitint='define'
usecbacktrace='undef'
usecrosscompile='undef'
usedefaultstrict='undef'
usedevel='undef'
usedl='define'
usedtrace='undef'
usefaststdio='undef'
useithreads='undef'
usekernprocpathname='undef'
uselanginfo='true'
uselargefiles='define'
uselongdouble='undef'
usemallocwrap='define'
usemorebits='undef'
usemultiplicity='undef'
usemymalloc='n'
usenm='false'
usensgetexecutablepath='undef'
useopcode='true'
useperlio='define'
useposix='true'
usequadmath='undef'
usereentrant='undef'
userelocatableinc='undef'
useshrplib='true'
usesitecustomize='undef'
usesocks='undef'
usethreads='undef'
usevendorprefix='define'
useversionedarchname='undef'
usevfork='false'
usrinc='/usr/include'
uuname=''
uvXUformat='"lX"'
uvoformat='"lo"'
uvsize='8'
uvtype='unsigned long'
uvuformat='"lu"'
uvxformat='"lx"'
vendorarch='/usr/lib64/perl5/vendor_perl/5.40/aarch64-linux'
vendorarchexp='/usr/lib64/perl5/vendor_perl/5.40/aarch64-linux'
vendorbin='/usr/bin'
vendorbinexp='/usr/bin'
vendorhtml1dir=' '
vendorhtml1direxp=''
vendorhtml3dir=' '
vendorhtml3direxp=''
vendorlib='/usr/lib64/perl5/vendor_perl/5.40'
vendorlib_stem='/usr/lib64/perl5/vendor_perl/5.40'
vendorlibexp='/usr/lib64/perl5/vendor_perl/5.40'
vendorman1dir='/usr/share/man/man1'
vendorman1direxp='/usr/share/man/man1'
vendorman3dir='/usr/share/man/man3'
vendorman3direxp='/usr/share/man/man3'
vendorprefix='/usr'
vendorprefixexp='/usr'
vendorscript='/usr/bin'
vendorscriptexp='/usr/bin'
version='5.40.2'
version_patchlevel_string='version 40 subversion 2'
versiononly='undef'
vi=''
xlibpth='/usr/lib/386 /lib/386'
xlocale_needed='undef'
yacc='yacc'
yaccflags=''
zcat=''
zip='zip'
!END!

my $i = ord(8);
foreach my $c (7,6,5,4,3,2,1) { $i <<= 8; $i |= ord($c); }
our $byteorder = join('', unpack('aaaaaaaa', pack('L!', $i)));
s/(byteorder=)(['"]).*?\2/$1$2$Config::byteorder$2/m;

{
    # We have to set this up late as Win32 does not build miniperl
    # with the same defines and CC flags as it builds perl itself.
    my $defines = join " ", (Internals::V)[0,1];
    if (
        $defines =~ /\b(SILENT_NO_TAINT_SUPPORT)\b/ ||
        $defines =~ /\b(NO_TAINT_SUPPORT)\b/
    ){
        my $which = $1;
        my $taint_disabled = ($which eq "SILENT_NO_TAINT_SUPPORT")
                             ? "silent" : "define";
        s/^(taint_disabled=['"])(["'])/$1$taint_disabled$2/m;
    }
    else {
        my $taint_support = 'define';
        s/^(taint_support=['"])(["'])/$1$taint_support$2/m;
    }
}
my $config_sh_len = length $_;

our $Config_SH_expanded = "\n$_" . << 'EOVIRTUAL';
ccflags_nolargefiles='-O2 -pipe -fno-strict-aliasing -DNO_PERL_RAND_SEED '
ldflags_nolargefiles='-Wl,-O1 -Wl,--as-needed -Wl,--as-needed'
libs_nolargefiles='-lgdbm -ldl -lm -lcrypt -lutil -lc -lgdbm_compat'
libswanted_nolargefiles='socket inet gdbm dbm db malloc dl ld sun m crypt sec util c cposix posix ucb BSD gdbm_compat'
ccwarnflags=' -Wall -Werror=pointer-arith -Werror=vla -Wextra -Wno-long-long -Wno-declaration-after-statement -Wc++-compat -Wwrite-strings'
ccstdflags=' -std=c99'
EOVIRTUAL
eval {
        # do not have hairy conniptions if this isnt available
        require 'Config_git.pl';
        $Config_SH_expanded .= $Config::Git_Data;
        1;
} or warn "Warning: failed to load Config_git.pl, something strange about this perl...\n";

# Search for it in the big string
sub fetch_string {
    my($self, $key) = @_;

    return undef unless $Config_SH_expanded =~ /\n$key=\'(.*?)\'\n/s;
    # So we can say "if $Config{'foo'}".
    $self->{$key} = $1 eq 'undef' ? undef : $1;
}

my $prevpos = 0;

sub FIRSTKEY {
    $prevpos = 0;
    substr($Config_SH_expanded, 1, index($Config_SH_expanded, '=') - 1 );
}

sub NEXTKEY {
    my $pos = index($Config_SH_expanded, qq('\n), $prevpos) + 2;
    my $len = index($Config_SH_expanded, "=", $pos) - $pos;
    $prevpos = $pos;
    $len > 0 ? substr($Config_SH_expanded, $pos, $len) : undef;
}

sub EXISTS {
    return 1 if exists($_[0]->{$_[1]});

    return(index($Config_SH_expanded, "\n$_[1]='") != -1
          );
}

sub STORE  { die "\%Config::Config is read-only\n" }
*DELETE = *CLEAR = \*STORE; # Typeglob aliasing uses less space

sub config_sh {
    substr $Config_SH_expanded, 1, $config_sh_len;
}

sub config_re {
    my $re = shift;
    return map { chomp; $_ } grep eval{ /^(?:$re)=/ }, split /^/,
    $Config_SH_expanded;
}

sub config_vars {
    # implements -V:cfgvar option (see perlrun -V:)
    foreach (@_) {
        # find optional leading, trailing colons; and query-spec
        my ($notag,$qry,$lncont) = m/^(:)?(.*?)(:)?$/;  # flags fore and aft,
        # map colon-flags to print decorations
        my $prfx = $notag ? '': "$qry=";                # tag-prefix for print
        my $lnend = $lncont ? ' ' : ";\n";              # line ending for print

        # all config-vars are by definition \w only, any \W means regex
        if ($qry =~ /\W/) {
            my @matches = config_re($qry);
            print map "$_$lnend", @matches ? @matches : "$qry: not found"               if !$notag;
            print map { s/\w+=//; "$_$lnend" } @matches ? @matches : "$qry: not found"  if  $notag;
        } else {
            my $v = (exists $Config::Config{$qry}) ? $Config::Config{$qry}
                                                   : 'UNKNOWN';
            $v = 'undef' unless defined $v;
            print "${prfx}'${v}'$lnend";
        }
    }
}

# Called by the real AUTOLOAD
sub launcher {
    undef &AUTOLOAD;
    goto \&$Config::AUTOLOAD;
}

1;
