//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `error!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn error() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::error!(ident = 3); // DEBUG:error,-,-,-,-,"ident","3"
    tracing::error!(foo = true, ident = 3); // DEBUG:error,-,-,p,-,"ident","3"
    tracing::error!(ident = 3, qux = 3); // DEBUG:error,-,-,f,-,"ident","3"
    tracing::error!(foo = true, ident = 3, qux = 3); // DEBUG:error,-,-,pf,-,"ident","3"
    tracing::error!(ident = 3, "msg without args"); // DEBUG:error,-,-,-,m,"ident","3"
    tracing::error!(foo = true, ident = 3, "msg without args"); // DEBUG:error,-,-,p,m,"ident","3"
    tracing::error!(ident = 3, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"ident","3"
    tracing::error!(foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"ident","3"
    tracing::error!({ ident = 3 }, "msg without args"); // DEBUG:error,-,{},-,m,"ident","3"
    tracing::error!({ foo = true, ident = 3 }, "msg without args"); // DEBUG:error,-,{},p,m,"ident","3"
    tracing::error!({ ident = 3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"ident","3"
    tracing::error!({ foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"ident","3"
    tracing::error!(ident = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"ident","3"
    tracing::error!(foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"ident","3"
    tracing::error!(ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"ident","3"
    tracing::error!(foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"ident","3"
    tracing::error!({ ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"ident","3"
    tracing::error!({ foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"ident","3"
    tracing::error!({ ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"ident","3"
    tracing::error!({ foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"ident","3"
    tracing::error!(ident = false); // DEBUG:error,-,-,-,-,"ident","false"
    tracing::error!(foo = true, ident = false); // DEBUG:error,-,-,p,-,"ident","false"
    tracing::error!(ident = false, qux = 3); // DEBUG:error,-,-,f,-,"ident","false"
    tracing::error!(foo = true, ident = false, qux = 3); // DEBUG:error,-,-,pf,-,"ident","false"
    tracing::error!(ident = false, "msg without args"); // DEBUG:error,-,-,-,m,"ident","false"
    tracing::error!(foo = true, ident = false, "msg without args"); // DEBUG:error,-,-,p,m,"ident","false"
    tracing::error!(ident = false, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"ident","false"
    tracing::error!(foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"ident","false"
    tracing::error!({ ident = false }, "msg without args"); // DEBUG:error,-,{},-,m,"ident","false"
    tracing::error!({ foo = true, ident = false }, "msg without args"); // DEBUG:error,-,{},p,m,"ident","false"
    tracing::error!({ ident = false, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"ident","false"
    tracing::error!({ foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"ident","false"
    tracing::error!(ident = false, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"ident","false"
    tracing::error!(foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"ident","false"
    tracing::error!(ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"ident","false"
    tracing::error!(foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"ident","false"
    tracing::error!({ ident = false }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"ident","false"
    tracing::error!({ foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"ident","false"
    tracing::error!({ ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"ident","false"
    tracing::error!({ foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"ident","false"
    tracing::error!(ident = ?3); // DEBUG:error,-,-,-,-,"ident","?3"
    tracing::error!(foo = true, ident = ?3); // DEBUG:error,-,-,p,-,"ident","?3"
    tracing::error!(ident = ?3, qux = 3); // DEBUG:error,-,-,f,-,"ident","?3"
    tracing::error!(foo = true, ident = ?3, qux = 3); // DEBUG:error,-,-,pf,-,"ident","?3"
    tracing::error!(ident = ?3, "msg without args"); // DEBUG:error,-,-,-,m,"ident","?3"
    tracing::error!(foo = true, ident = ?3, "msg without args"); // DEBUG:error,-,-,p,m,"ident","?3"
    tracing::error!(ident = ?3, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"ident","?3"
    tracing::error!(foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"ident","?3"
    tracing::error!({ ident = ?3 }, "msg without args"); // DEBUG:error,-,{},-,m,"ident","?3"
    tracing::error!({ foo = true, ident = ?3 }, "msg without args"); // DEBUG:error,-,{},p,m,"ident","?3"
    tracing::error!({ ident = ?3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"ident","?3"
    tracing::error!({ foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"ident","?3"
    tracing::error!(ident = ?3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"ident","?3"
    tracing::error!(foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"ident","?3"
    tracing::error!(ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"ident","?3"
    tracing::error!(foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"ident","?3"
    tracing::error!({ ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"ident","?3"
    tracing::error!({ foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"ident","?3"
    tracing::error!({ ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"ident","?3"
    tracing::error!({ foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"ident","?3"
    tracing::error!(ident = %3); // DEBUG:error,-,-,-,-,"ident","%3"
    tracing::error!(foo = true, ident = %3); // DEBUG:error,-,-,p,-,"ident","%3"
    tracing::error!(ident = %3, qux = 3); // DEBUG:error,-,-,f,-,"ident","%3"
    tracing::error!(foo = true, ident = %3, qux = 3); // DEBUG:error,-,-,pf,-,"ident","%3"
    tracing::error!(ident = %3, "msg without args"); // DEBUG:error,-,-,-,m,"ident","%3"
    tracing::error!(foo = true, ident = %3, "msg without args"); // DEBUG:error,-,-,p,m,"ident","%3"
    tracing::error!(ident = %3, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"ident","%3"
    tracing::error!(foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"ident","%3"
    tracing::error!({ ident = %3 }, "msg without args"); // DEBUG:error,-,{},-,m,"ident","%3"
    tracing::error!({ foo = true, ident = %3 }, "msg without args"); // DEBUG:error,-,{},p,m,"ident","%3"
    tracing::error!({ ident = %3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"ident","%3"
    tracing::error!({ foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"ident","%3"
    tracing::error!(ident = %3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"ident","%3"
    tracing::error!(foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"ident","%3"
    tracing::error!(ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"ident","%3"
    tracing::error!(foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"ident","%3"
    tracing::error!({ ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"ident","%3"
    tracing::error!({ foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"ident","%3"
    tracing::error!({ ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"ident","%3"
    tracing::error!({ foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"ident","%3"
    tracing::error!(ident = ?deb); // DEBUG:error,-,-,-,-,"ident","?deb"
    tracing::error!(foo = true, ident = ?deb); // DEBUG:error,-,-,p,-,"ident","?deb"
    tracing::error!(ident = ?deb, qux = 3); // DEBUG:error,-,-,f,-,"ident","?deb"
    tracing::error!(foo = true, ident = ?deb, qux = 3); // DEBUG:error,-,-,pf,-,"ident","?deb"
    tracing::error!(ident = ?deb, "msg without args"); // DEBUG:error,-,-,-,m,"ident","?deb"
    tracing::error!(foo = true, ident = ?deb, "msg without args"); // DEBUG:error,-,-,p,m,"ident","?deb"
    tracing::error!(ident = ?deb, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"ident","?deb"
    tracing::error!(foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"ident","?deb"
    tracing::error!({ ident = ?deb }, "msg without args"); // DEBUG:error,-,{},-,m,"ident","?deb"
    tracing::error!({ foo = true, ident = ?deb }, "msg without args"); // DEBUG:error,-,{},p,m,"ident","?deb"
    tracing::error!({ ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"ident","?deb"
    tracing::error!({ foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"ident","?deb"
    tracing::error!(ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"ident","?deb"
    tracing::error!(foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"ident","?deb"
    tracing::error!(ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"ident","?deb"
    tracing::error!(foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"ident","?deb"
    tracing::error!({ ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"ident","?deb"
    tracing::error!({ foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"ident","?deb"
    tracing::error!({ ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"ident","?deb"
    tracing::error!({ foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"ident","?deb"
    tracing::error!(ident = %disp); // DEBUG:error,-,-,-,-,"ident","%disp"
    tracing::error!(foo = true, ident = %disp); // DEBUG:error,-,-,p,-,"ident","%disp"
    tracing::error!(ident = %disp, qux = 3); // DEBUG:error,-,-,f,-,"ident","%disp"
    tracing::error!(foo = true, ident = %disp, qux = 3); // DEBUG:error,-,-,pf,-,"ident","%disp"
    tracing::error!(ident = %disp, "msg without args"); // DEBUG:error,-,-,-,m,"ident","%disp"
    tracing::error!(foo = true, ident = %disp, "msg without args"); // DEBUG:error,-,-,p,m,"ident","%disp"
    tracing::error!(ident = %disp, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"ident","%disp"
    tracing::error!(foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"ident","%disp"
    tracing::error!({ ident = %disp }, "msg without args"); // DEBUG:error,-,{},-,m,"ident","%disp"
    tracing::error!({ foo = true, ident = %disp }, "msg without args"); // DEBUG:error,-,{},p,m,"ident","%disp"
    tracing::error!({ ident = %disp, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"ident","%disp"
    tracing::error!({ foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"ident","%disp"
    tracing::error!(ident = %disp, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"ident","%disp"
    tracing::error!(foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"ident","%disp"
    tracing::error!(ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"ident","%disp"
    tracing::error!(foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"ident","%disp"
    tracing::error!({ ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"ident","%disp"
    tracing::error!({ foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"ident","%disp"
    tracing::error!({ ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"ident","%disp"
    tracing::error!({ foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"ident","%disp"
    tracing::error!(ident = ?sub.field); // DEBUG:error,-,-,-,-,"ident","?sub.field"
    tracing::error!(foo = true, ident = ?sub.field); // DEBUG:error,-,-,p,-,"ident","?sub.field"
    tracing::error!(ident = ?sub.field, qux = 3); // DEBUG:error,-,-,f,-,"ident","?sub.field"
    tracing::error!(foo = true, ident = ?sub.field, qux = 3); // DEBUG:error,-,-,pf,-,"ident","?sub.field"
    tracing::error!(ident = ?sub.field, "msg without args"); // DEBUG:error,-,-,-,m,"ident","?sub.field"
    tracing::error!(foo = true, ident = ?sub.field, "msg without args"); // DEBUG:error,-,-,p,m,"ident","?sub.field"
    tracing::error!(ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"ident","?sub.field"
    tracing::error!(foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"ident","?sub.field"
    tracing::error!({ ident = ?sub.field }, "msg without args"); // DEBUG:error,-,{},-,m,"ident","?sub.field"
    tracing::error!({ foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:error,-,{},p,m,"ident","?sub.field"
    tracing::error!({ ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"ident","?sub.field"
    tracing::error!({ foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"ident","?sub.field"
    tracing::error!(ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"ident","?sub.field"
    tracing::error!(foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"ident","?sub.field"
    tracing::error!(ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"ident","?sub.field"
    tracing::error!(foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"ident","?sub.field"
    tracing::error!({ ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"ident","?sub.field"
    tracing::error!({ foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"ident","?sub.field"
    tracing::error!({ ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"ident","?sub.field"
    tracing::error!({ foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"ident","?sub.field"
    tracing::error!(ident = %sub.field); // DEBUG:error,-,-,-,-,"ident","%sub.field"
    tracing::error!(foo = true, ident = %sub.field); // DEBUG:error,-,-,p,-,"ident","%sub.field"
    tracing::error!(ident = %sub.field, qux = 3); // DEBUG:error,-,-,f,-,"ident","%sub.field"
    tracing::error!(foo = true, ident = %sub.field, qux = 3); // DEBUG:error,-,-,pf,-,"ident","%sub.field"
    tracing::error!(ident = %sub.field, "msg without args"); // DEBUG:error,-,-,-,m,"ident","%sub.field"
    tracing::error!(foo = true, ident = %sub.field, "msg without args"); // DEBUG:error,-,-,p,m,"ident","%sub.field"
    tracing::error!(ident = %sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"ident","%sub.field"
    tracing::error!(foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"ident","%sub.field"
    tracing::error!({ ident = %sub.field }, "msg without args"); // DEBUG:error,-,{},-,m,"ident","%sub.field"
    tracing::error!({ foo = true, ident = %sub.field }, "msg without args"); // DEBUG:error,-,{},p,m,"ident","%sub.field"
    tracing::error!({ ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"ident","%sub.field"
    tracing::error!({ foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"ident","%sub.field"
    tracing::error!(ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"ident","%sub.field"
    tracing::error!(foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"ident","%sub.field"
    tracing::error!(ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"ident","%sub.field"
    tracing::error!(foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"ident","%sub.field"
    tracing::error!({ ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"ident","%sub.field"
    tracing::error!({ foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"ident","%sub.field"
    tracing::error!({ ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"ident","%sub.field"
    tracing::error!({ foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"ident","%sub.field"
    tracing::error!(ident = debug(&deb)); // DEBUG:error,-,-,-,-,"ident","debug(&deb)"
    tracing::error!(foo = true, ident = debug(&deb)); // DEBUG:error,-,-,p,-,"ident","debug(&deb)"
    tracing::error!(ident = debug(&deb), qux = 3); // DEBUG:error,-,-,f,-,"ident","debug(&deb)"
    tracing::error!(foo = true, ident = debug(&deb), qux = 3); // DEBUG:error,-,-,pf,-,"ident","debug(&deb)"
    tracing::error!(ident = debug(&deb), "msg without args"); // DEBUG:error,-,-,-,m,"ident","debug(&deb)"
    tracing::error!(foo = true, ident = debug(&deb), "msg without args"); // DEBUG:error,-,-,p,m,"ident","debug(&deb)"
    tracing::error!(ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"ident","debug(&deb)"
    tracing::error!(foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"ident","debug(&deb)"
    tracing::error!({ ident = debug(&deb) }, "msg without args"); // DEBUG:error,-,{},-,m,"ident","debug(&deb)"
    tracing::error!({ foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:error,-,{},p,m,"ident","debug(&deb)"
    tracing::error!({ ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"ident","debug(&deb)"
    tracing::error!({ foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"ident","debug(&deb)"
    tracing::error!(ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"ident","debug(&deb)"
    tracing::error!(foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"ident","debug(&deb)"
    tracing::error!(ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"ident","debug(&deb)"
    tracing::error!(foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"ident","debug(&deb)"
    tracing::error!({ ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"ident","debug(&deb)"
    tracing::error!({ foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"ident","debug(&deb)"
    tracing::error!({ ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"ident","debug(&deb)"
    tracing::error!({ foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"ident","debug(&deb)"
    tracing::error!(ident = display(&disp)); // DEBUG:error,-,-,-,-,"ident","display(&disp)"
    tracing::error!(foo = true, ident = display(&disp)); // DEBUG:error,-,-,p,-,"ident","display(&disp)"
    tracing::error!(ident = display(&disp), qux = 3); // DEBUG:error,-,-,f,-,"ident","display(&disp)"
    tracing::error!(foo = true, ident = display(&disp), qux = 3); // DEBUG:error,-,-,pf,-,"ident","display(&disp)"
    tracing::error!(ident = display(&disp), "msg without args"); // DEBUG:error,-,-,-,m,"ident","display(&disp)"
    tracing::error!(foo = true, ident = display(&disp), "msg without args"); // DEBUG:error,-,-,p,m,"ident","display(&disp)"
    tracing::error!(ident = display(&disp), qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"ident","display(&disp)"
    tracing::error!(foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"ident","display(&disp)"
    tracing::error!({ ident = display(&disp) }, "msg without args"); // DEBUG:error,-,{},-,m,"ident","display(&disp)"
    tracing::error!({ foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:error,-,{},p,m,"ident","display(&disp)"
    tracing::error!({ ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"ident","display(&disp)"
    tracing::error!({ foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"ident","display(&disp)"
    tracing::error!(ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"ident","display(&disp)"
    tracing::error!(foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"ident","display(&disp)"
    tracing::error!(ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"ident","display(&disp)"
    tracing::error!(foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"ident","display(&disp)"
    tracing::error!({ ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"ident","display(&disp)"
    tracing::error!({ foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"ident","display(&disp)"
    tracing::error!({ ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"ident","display(&disp)"
    tracing::error!({ foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"ident","display(&disp)"
    tracing::error!(ident = tracing::field::Empty); // DEBUG:error,-,-,-,-,"ident","tracing::field::Empty"
    tracing::error!(foo = true, ident = tracing::field::Empty); // DEBUG:error,-,-,p,-,"ident","tracing::field::Empty"
    tracing::error!(ident = tracing::field::Empty, qux = 3); // DEBUG:error,-,-,f,-,"ident","tracing::field::Empty"
    tracing::error!(foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:error,-,-,pf,-,"ident","tracing::field::Empty"
    tracing::error!(ident = tracing::field::Empty, "msg without args"); // DEBUG:error,-,-,-,m,"ident","tracing::field::Empty"
    tracing::error!(foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:error,-,-,p,m,"ident","tracing::field::Empty"
    tracing::error!(ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"ident","tracing::field::Empty"
    tracing::error!(foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"ident","tracing::field::Empty"
    tracing::error!({ ident = tracing::field::Empty }, "msg without args"); // DEBUG:error,-,{},-,m,"ident","tracing::field::Empty"
    tracing::error!({ foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:error,-,{},p,m,"ident","tracing::field::Empty"
    tracing::error!({ ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"ident","tracing::field::Empty"
    tracing::error!({ foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"ident","tracing::field::Empty"
    tracing::error!(ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"ident","tracing::field::Empty"
    tracing::error!(foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"ident","tracing::field::Empty"
    tracing::error!(ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"ident","tracing::field::Empty"
    tracing::error!(foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"ident","tracing::field::Empty"
    tracing::error!({ ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"ident","tracing::field::Empty"
    tracing::error!({ foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"ident","tracing::field::Empty"
    tracing::error!({ ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"ident","tracing::field::Empty"
    tracing::error!({ foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"ident","tracing::field::Empty"
    tracing::error!(dotted.ident = 3); // DEBUG:error,-,-,-,-,"dotted.ident","3"
    tracing::error!(foo = true, dotted.ident = 3); // DEBUG:error,-,-,p,-,"dotted.ident","3"
    tracing::error!(dotted.ident = 3, qux = 3); // DEBUG:error,-,-,f,-,"dotted.ident","3"
    tracing::error!(foo = true, dotted.ident = 3, qux = 3); // DEBUG:error,-,-,pf,-,"dotted.ident","3"
    tracing::error!(dotted.ident = 3, "msg without args"); // DEBUG:error,-,-,-,m,"dotted.ident","3"
    tracing::error!(foo = true, dotted.ident = 3, "msg without args"); // DEBUG:error,-,-,p,m,"dotted.ident","3"
    tracing::error!(dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"dotted.ident","3"
    tracing::error!(foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"dotted.ident","3"
    tracing::error!({ dotted.ident = 3 }, "msg without args"); // DEBUG:error,-,{},-,m,"dotted.ident","3"
    tracing::error!({ foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:error,-,{},p,m,"dotted.ident","3"
    tracing::error!({ dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"dotted.ident","3"
    tracing::error!({ foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"dotted.ident","3"
    tracing::error!(dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"dotted.ident","3"
    tracing::error!(foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"dotted.ident","3"
    tracing::error!(dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"dotted.ident","3"
    tracing::error!(foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"dotted.ident","3"
    tracing::error!({ dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"dotted.ident","3"
    tracing::error!({ foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"dotted.ident","3"
    tracing::error!({ dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"dotted.ident","3"
    tracing::error!({ foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"dotted.ident","3"
    tracing::error!(dotted.ident = false); // DEBUG:error,-,-,-,-,"dotted.ident","false"
    tracing::error!(foo = true, dotted.ident = false); // DEBUG:error,-,-,p,-,"dotted.ident","false"
    tracing::error!(dotted.ident = false, qux = 3); // DEBUG:error,-,-,f,-,"dotted.ident","false"
    tracing::error!(foo = true, dotted.ident = false, qux = 3); // DEBUG:error,-,-,pf,-,"dotted.ident","false"
    tracing::error!(dotted.ident = false, "msg without args"); // DEBUG:error,-,-,-,m,"dotted.ident","false"
    tracing::error!(foo = true, dotted.ident = false, "msg without args"); // DEBUG:error,-,-,p,m,"dotted.ident","false"
    tracing::error!(dotted.ident = false, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"dotted.ident","false"
    tracing::error!(foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"dotted.ident","false"
    tracing::error!({ dotted.ident = false }, "msg without args"); // DEBUG:error,-,{},-,m,"dotted.ident","false"
    tracing::error!({ foo = true, dotted.ident = false }, "msg without args"); // DEBUG:error,-,{},p,m,"dotted.ident","false"
    tracing::error!({ dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"dotted.ident","false"
    tracing::error!({ foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"dotted.ident","false"
    tracing::error!(dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"dotted.ident","false"
    tracing::error!(foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"dotted.ident","false"
    tracing::error!(dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"dotted.ident","false"
    tracing::error!(foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"dotted.ident","false"
    tracing::error!({ dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"dotted.ident","false"
    tracing::error!({ foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"dotted.ident","false"
    tracing::error!({ dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"dotted.ident","false"
    tracing::error!({ foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"dotted.ident","false"
    tracing::error!(dotted.ident = ?3); // DEBUG:error,-,-,-,-,"dotted.ident","?3"
    tracing::error!(foo = true, dotted.ident = ?3); // DEBUG:error,-,-,p,-,"dotted.ident","?3"
    tracing::error!(dotted.ident = ?3, qux = 3); // DEBUG:error,-,-,f,-,"dotted.ident","?3"
    tracing::error!(foo = true, dotted.ident = ?3, qux = 3); // DEBUG:error,-,-,pf,-,"dotted.ident","?3"
    tracing::error!(dotted.ident = ?3, "msg without args"); // DEBUG:error,-,-,-,m,"dotted.ident","?3"
    tracing::error!(foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:error,-,-,p,m,"dotted.ident","?3"
    tracing::error!(dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"dotted.ident","?3"
    tracing::error!(foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"dotted.ident","?3"
    tracing::error!({ dotted.ident = ?3 }, "msg without args"); // DEBUG:error,-,{},-,m,"dotted.ident","?3"
    tracing::error!({ foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:error,-,{},p,m,"dotted.ident","?3"
    tracing::error!({ dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"dotted.ident","?3"
    tracing::error!({ foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"dotted.ident","?3"
    tracing::error!(dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"dotted.ident","?3"
    tracing::error!(foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"dotted.ident","?3"
    tracing::error!(dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"dotted.ident","?3"
    tracing::error!(foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"dotted.ident","?3"
    tracing::error!({ dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"dotted.ident","?3"
    tracing::error!({ foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"dotted.ident","?3"
    tracing::error!({ dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"dotted.ident","?3"
    tracing::error!({ foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"dotted.ident","?3"
    tracing::error!(dotted.ident = %3); // DEBUG:error,-,-,-,-,"dotted.ident","%3"
    tracing::error!(foo = true, dotted.ident = %3); // DEBUG:error,-,-,p,-,"dotted.ident","%3"
    tracing::error!(dotted.ident = %3, qux = 3); // DEBUG:error,-,-,f,-,"dotted.ident","%3"
    tracing::error!(foo = true, dotted.ident = %3, qux = 3); // DEBUG:error,-,-,pf,-,"dotted.ident","%3"
    tracing::error!(dotted.ident = %3, "msg without args"); // DEBUG:error,-,-,-,m,"dotted.ident","%3"
    tracing::error!(foo = true, dotted.ident = %3, "msg without args"); // DEBUG:error,-,-,p,m,"dotted.ident","%3"
    tracing::error!(dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"dotted.ident","%3"
    tracing::error!(foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"dotted.ident","%3"
    tracing::error!({ dotted.ident = %3 }, "msg without args"); // DEBUG:error,-,{},-,m,"dotted.ident","%3"
    tracing::error!({ foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:error,-,{},p,m,"dotted.ident","%3"
    tracing::error!({ dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"dotted.ident","%3"
    tracing::error!({ foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"dotted.ident","%3"
    tracing::error!(dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"dotted.ident","%3"
    tracing::error!(foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"dotted.ident","%3"
    tracing::error!(dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"dotted.ident","%3"
    tracing::error!(foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"dotted.ident","%3"
    tracing::error!({ dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"dotted.ident","%3"
    tracing::error!({ foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"dotted.ident","%3"
    tracing::error!({ dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"dotted.ident","%3"
    tracing::error!({ foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"dotted.ident","%3"
    tracing::error!(dotted.ident = ?deb); // DEBUG:error,-,-,-,-,"dotted.ident","?deb"
    tracing::error!(foo = true, dotted.ident = ?deb); // DEBUG:error,-,-,p,-,"dotted.ident","?deb"
    tracing::error!(dotted.ident = ?deb, qux = 3); // DEBUG:error,-,-,f,-,"dotted.ident","?deb"
    tracing::error!(foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:error,-,-,pf,-,"dotted.ident","?deb"
    tracing::error!(dotted.ident = ?deb, "msg without args"); // DEBUG:error,-,-,-,m,"dotted.ident","?deb"
    tracing::error!(foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:error,-,-,p,m,"dotted.ident","?deb"
    tracing::error!(dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"dotted.ident","?deb"
    tracing::error!(foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"dotted.ident","?deb"
    tracing::error!({ dotted.ident = ?deb }, "msg without args"); // DEBUG:error,-,{},-,m,"dotted.ident","?deb"
    tracing::error!({ foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:error,-,{},p,m,"dotted.ident","?deb"
    tracing::error!({ dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"dotted.ident","?deb"
    tracing::error!({ foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"dotted.ident","?deb"
    tracing::error!(dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"dotted.ident","?deb"
    tracing::error!(foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"dotted.ident","?deb"
    tracing::error!(dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"dotted.ident","?deb"
    tracing::error!(foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"dotted.ident","?deb"
    tracing::error!({ dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"dotted.ident","?deb"
    tracing::error!({ foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"dotted.ident","?deb"
    tracing::error!({ dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"dotted.ident","?deb"
    tracing::error!({ foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"dotted.ident","?deb"
    tracing::error!(dotted.ident = %disp); // DEBUG:error,-,-,-,-,"dotted.ident","%disp"
    tracing::error!(foo = true, dotted.ident = %disp); // DEBUG:error,-,-,p,-,"dotted.ident","%disp"
    tracing::error!(dotted.ident = %disp, qux = 3); // DEBUG:error,-,-,f,-,"dotted.ident","%disp"
    tracing::error!(foo = true, dotted.ident = %disp, qux = 3); // DEBUG:error,-,-,pf,-,"dotted.ident","%disp"
    tracing::error!(dotted.ident = %disp, "msg without args"); // DEBUG:error,-,-,-,m,"dotted.ident","%disp"
    tracing::error!(foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:error,-,-,p,m,"dotted.ident","%disp"
    tracing::error!(dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"dotted.ident","%disp"
    tracing::error!(foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"dotted.ident","%disp"
    tracing::error!({ dotted.ident = %disp }, "msg without args"); // DEBUG:error,-,{},-,m,"dotted.ident","%disp"
    tracing::error!({ foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:error,-,{},p,m,"dotted.ident","%disp"
    tracing::error!({ dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"dotted.ident","%disp"
    tracing::error!({ foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"dotted.ident","%disp"
    tracing::error!(dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"dotted.ident","%disp"
    tracing::error!(foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"dotted.ident","%disp"
    tracing::error!(dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"dotted.ident","%disp"
    tracing::error!(foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"dotted.ident","%disp"
    tracing::error!({ dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"dotted.ident","%disp"
    tracing::error!({ foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"dotted.ident","%disp"
    tracing::error!({ dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"dotted.ident","%disp"
    tracing::error!({ foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"dotted.ident","%disp"
    tracing::error!(dotted.ident = ?sub.field); // DEBUG:error,-,-,-,-,"dotted.ident","?sub.field"
    tracing::error!(foo = true, dotted.ident = ?sub.field); // DEBUG:error,-,-,p,-,"dotted.ident","?sub.field"
    tracing::error!(dotted.ident = ?sub.field, qux = 3); // DEBUG:error,-,-,f,-,"dotted.ident","?sub.field"
    tracing::error!(foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:error,-,-,pf,-,"dotted.ident","?sub.field"
    tracing::error!(dotted.ident = ?sub.field, "msg without args"); // DEBUG:error,-,-,-,m,"dotted.ident","?sub.field"
    tracing::error!(foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:error,-,-,p,m,"dotted.ident","?sub.field"
    tracing::error!(dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"dotted.ident","?sub.field"
    tracing::error!(foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"dotted.ident","?sub.field"
    tracing::error!({ dotted.ident = ?sub.field }, "msg without args"); // DEBUG:error,-,{},-,m,"dotted.ident","?sub.field"
    tracing::error!({ foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:error,-,{},p,m,"dotted.ident","?sub.field"
    tracing::error!({ dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"dotted.ident","?sub.field"
    tracing::error!({ foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"dotted.ident","?sub.field"
    tracing::error!(dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"dotted.ident","?sub.field"
    tracing::error!(foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"dotted.ident","?sub.field"
    tracing::error!(dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"dotted.ident","?sub.field"
    tracing::error!(foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"dotted.ident","?sub.field"
    tracing::error!({ dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"dotted.ident","?sub.field"
    tracing::error!({ foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"dotted.ident","?sub.field"
    tracing::error!({ dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"dotted.ident","?sub.field"
    tracing::error!({ foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"dotted.ident","?sub.field"
    tracing::error!(dotted.ident = %sub.field); // DEBUG:error,-,-,-,-,"dotted.ident","%sub.field"
    tracing::error!(foo = true, dotted.ident = %sub.field); // DEBUG:error,-,-,p,-,"dotted.ident","%sub.field"
    tracing::error!(dotted.ident = %sub.field, qux = 3); // DEBUG:error,-,-,f,-,"dotted.ident","%sub.field"
    tracing::error!(foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:error,-,-,pf,-,"dotted.ident","%sub.field"
    tracing::error!(dotted.ident = %sub.field, "msg without args"); // DEBUG:error,-,-,-,m,"dotted.ident","%sub.field"
    tracing::error!(foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:error,-,-,p,m,"dotted.ident","%sub.field"
    tracing::error!(dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"dotted.ident","%sub.field"
    tracing::error!(foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"dotted.ident","%sub.field"
    tracing::error!({ dotted.ident = %sub.field }, "msg without args"); // DEBUG:error,-,{},-,m,"dotted.ident","%sub.field"
    tracing::error!({ foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:error,-,{},p,m,"dotted.ident","%sub.field"
    tracing::error!({ dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"dotted.ident","%sub.field"
    tracing::error!({ foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"dotted.ident","%sub.field"
    tracing::error!(dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"dotted.ident","%sub.field"
    tracing::error!(foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"dotted.ident","%sub.field"
    tracing::error!(dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"dotted.ident","%sub.field"
    tracing::error!(foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"dotted.ident","%sub.field"
    tracing::error!({ dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"dotted.ident","%sub.field"
    tracing::error!({ foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"dotted.ident","%sub.field"
    tracing::error!({ dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"dotted.ident","%sub.field"
    tracing::error!({ foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"dotted.ident","%sub.field"
    tracing::error!(dotted.ident = debug(&deb)); // DEBUG:error,-,-,-,-,"dotted.ident","debug(&deb)"
    tracing::error!(foo = true, dotted.ident = debug(&deb)); // DEBUG:error,-,-,p,-,"dotted.ident","debug(&deb)"
    tracing::error!(dotted.ident = debug(&deb), qux = 3); // DEBUG:error,-,-,f,-,"dotted.ident","debug(&deb)"
    tracing::error!(foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:error,-,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::error!(dotted.ident = debug(&deb), "msg without args"); // DEBUG:error,-,-,-,m,"dotted.ident","debug(&deb)"
    tracing::error!(foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:error,-,-,p,m,"dotted.ident","debug(&deb)"
    tracing::error!(dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"dotted.ident","debug(&deb)"
    tracing::error!(foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::error!({ dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:error,-,{},-,m,"dotted.ident","debug(&deb)"
    tracing::error!({ foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:error,-,{},p,m,"dotted.ident","debug(&deb)"
    tracing::error!({ dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"dotted.ident","debug(&deb)"
    tracing::error!({ foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::error!(dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::error!(foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::error!(dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::error!(foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::error!({ dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::error!({ foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::error!({ dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::error!({ foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::error!(dotted.ident = display(&disp)); // DEBUG:error,-,-,-,-,"dotted.ident","display(&disp)"
    tracing::error!(foo = true, dotted.ident = display(&disp)); // DEBUG:error,-,-,p,-,"dotted.ident","display(&disp)"
    tracing::error!(dotted.ident = display(&disp), qux = 3); // DEBUG:error,-,-,f,-,"dotted.ident","display(&disp)"
    tracing::error!(foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:error,-,-,pf,-,"dotted.ident","display(&disp)"
    tracing::error!(dotted.ident = display(&disp), "msg without args"); // DEBUG:error,-,-,-,m,"dotted.ident","display(&disp)"
    tracing::error!(foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:error,-,-,p,m,"dotted.ident","display(&disp)"
    tracing::error!(dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"dotted.ident","display(&disp)"
    tracing::error!(foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"dotted.ident","display(&disp)"
    tracing::error!({ dotted.ident = display(&disp) }, "msg without args"); // DEBUG:error,-,{},-,m,"dotted.ident","display(&disp)"
    tracing::error!({ foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:error,-,{},p,m,"dotted.ident","display(&disp)"
    tracing::error!({ dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"dotted.ident","display(&disp)"
    tracing::error!({ foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"dotted.ident","display(&disp)"
    tracing::error!(dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"dotted.ident","display(&disp)"
    tracing::error!(foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"dotted.ident","display(&disp)"
    tracing::error!(dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"dotted.ident","display(&disp)"
    tracing::error!(foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::error!({ dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"dotted.ident","display(&disp)"
    tracing::error!({ foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"dotted.ident","display(&disp)"
    tracing::error!({ dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"dotted.ident","display(&disp)"
    tracing::error!({ foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::error!(dotted.ident = tracing::field::Empty); // DEBUG:error,-,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::error!(foo = true, dotted.ident = tracing::field::Empty); // DEBUG:error,-,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::error!(dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:error,-,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::error!(foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:error,-,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::error!(dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:error,-,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::error!(foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:error,-,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::error!(dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::error!(foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::error!({ dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:error,-,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::error!({ foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:error,-,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::error!({ dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::error!({ foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::error!(dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::error!(foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::error!(dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::error!(foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::error!({ dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::error!({ foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::error!({ dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::error!({ foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::error!("literal" = 3); // DEBUG:error,-,-,-,-,"\"literal\"","3"
    tracing::error!(foo = true, "literal" = 3); // DEBUG:error,-,-,p,-,"\"literal\"","3"
    tracing::error!("literal" = 3, qux = 3); // DEBUG:error,-,-,f,-,"\"literal\"","3"
    tracing::error!(foo = true, "literal" = 3, qux = 3); // DEBUG:error,-,-,pf,-,"\"literal\"","3"
    tracing::error!("literal" = 3, "msg without args"); // DEBUG:error,-,-,-,m,"\"literal\"","3"
    tracing::error!(foo = true, "literal" = 3, "msg without args"); // DEBUG:error,-,-,p,m,"\"literal\"","3"
    tracing::error!("literal" = 3, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"\"literal\"","3"
    tracing::error!(foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"\"literal\"","3"
    tracing::error!({ "literal" = 3 }, "msg without args"); // DEBUG:error,-,{},-,m,"\"literal\"","3"
    tracing::error!({ foo = true, "literal" = 3 }, "msg without args"); // DEBUG:error,-,{},p,m,"\"literal\"","3"
    tracing::error!({ "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"\"literal\"","3"
    tracing::error!({ foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"\"literal\"","3"
    tracing::error!("literal" = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"\"literal\"","3"
    tracing::error!(foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"\"literal\"","3"
    tracing::error!("literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"\"literal\"","3"
    tracing::error!(foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"\"literal\"","3"
    tracing::error!({ "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"\"literal\"","3"
    tracing::error!({ foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"\"literal\"","3"
    tracing::error!({ "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"\"literal\"","3"
    tracing::error!({ foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"\"literal\"","3"
    tracing::error!("literal" = false); // DEBUG:error,-,-,-,-,"\"literal\"","false"
    tracing::error!(foo = true, "literal" = false); // DEBUG:error,-,-,p,-,"\"literal\"","false"
    tracing::error!("literal" = false, qux = 3); // DEBUG:error,-,-,f,-,"\"literal\"","false"
    tracing::error!(foo = true, "literal" = false, qux = 3); // DEBUG:error,-,-,pf,-,"\"literal\"","false"
    tracing::error!("literal" = false, "msg without args"); // DEBUG:error,-,-,-,m,"\"literal\"","false"
    tracing::error!(foo = true, "literal" = false, "msg without args"); // DEBUG:error,-,-,p,m,"\"literal\"","false"
    tracing::error!("literal" = false, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"\"literal\"","false"
    tracing::error!(foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"\"literal\"","false"
    tracing::error!({ "literal" = false }, "msg without args"); // DEBUG:error,-,{},-,m,"\"literal\"","false"
    tracing::error!({ foo = true, "literal" = false }, "msg without args"); // DEBUG:error,-,{},p,m,"\"literal\"","false"
    tracing::error!({ "literal" = false, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"\"literal\"","false"
    tracing::error!({ foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"\"literal\"","false"
    tracing::error!("literal" = false, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"\"literal\"","false"
    tracing::error!(foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"\"literal\"","false"
    tracing::error!("literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"\"literal\"","false"
    tracing::error!(foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"\"literal\"","false"
    tracing::error!({ "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"\"literal\"","false"
    tracing::error!({ foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"\"literal\"","false"
    tracing::error!({ "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"\"literal\"","false"
    tracing::error!({ foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"\"literal\"","false"
    tracing::error!("literal" = ?3); // DEBUG:error,-,-,-,-,"\"literal\"","?3"
    tracing::error!(foo = true, "literal" = ?3); // DEBUG:error,-,-,p,-,"\"literal\"","?3"
    tracing::error!("literal" = ?3, qux = 3); // DEBUG:error,-,-,f,-,"\"literal\"","?3"
    tracing::error!(foo = true, "literal" = ?3, qux = 3); // DEBUG:error,-,-,pf,-,"\"literal\"","?3"
    tracing::error!("literal" = ?3, "msg without args"); // DEBUG:error,-,-,-,m,"\"literal\"","?3"
    tracing::error!(foo = true, "literal" = ?3, "msg without args"); // DEBUG:error,-,-,p,m,"\"literal\"","?3"
    tracing::error!("literal" = ?3, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"\"literal\"","?3"
    tracing::error!(foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"\"literal\"","?3"
    tracing::error!({ "literal" = ?3 }, "msg without args"); // DEBUG:error,-,{},-,m,"\"literal\"","?3"
    tracing::error!({ foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:error,-,{},p,m,"\"literal\"","?3"
    tracing::error!({ "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"\"literal\"","?3"
    tracing::error!({ foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"\"literal\"","?3"
    tracing::error!("literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"\"literal\"","?3"
    tracing::error!(foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"\"literal\"","?3"
    tracing::error!("literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"\"literal\"","?3"
    tracing::error!(foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"\"literal\"","?3"
    tracing::error!({ "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"\"literal\"","?3"
    tracing::error!({ foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"\"literal\"","?3"
    tracing::error!({ "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"\"literal\"","?3"
    tracing::error!({ foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"\"literal\"","?3"
    tracing::error!("literal" = %3); // DEBUG:error,-,-,-,-,"\"literal\"","%3"
    tracing::error!(foo = true, "literal" = %3); // DEBUG:error,-,-,p,-,"\"literal\"","%3"
    tracing::error!("literal" = %3, qux = 3); // DEBUG:error,-,-,f,-,"\"literal\"","%3"
    tracing::error!(foo = true, "literal" = %3, qux = 3); // DEBUG:error,-,-,pf,-,"\"literal\"","%3"
    tracing::error!("literal" = %3, "msg without args"); // DEBUG:error,-,-,-,m,"\"literal\"","%3"
    tracing::error!(foo = true, "literal" = %3, "msg without args"); // DEBUG:error,-,-,p,m,"\"literal\"","%3"
    tracing::error!("literal" = %3, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"\"literal\"","%3"
    tracing::error!(foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"\"literal\"","%3"
    tracing::error!({ "literal" = %3 }, "msg without args"); // DEBUG:error,-,{},-,m,"\"literal\"","%3"
    tracing::error!({ foo = true, "literal" = %3 }, "msg without args"); // DEBUG:error,-,{},p,m,"\"literal\"","%3"
    tracing::error!({ "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"\"literal\"","%3"
    tracing::error!({ foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"\"literal\"","%3"
    tracing::error!("literal" = %3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"\"literal\"","%3"
    tracing::error!(foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"\"literal\"","%3"
    tracing::error!("literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"\"literal\"","%3"
    tracing::error!(foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"\"literal\"","%3"
    tracing::error!({ "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"\"literal\"","%3"
    tracing::error!({ foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"\"literal\"","%3"
    tracing::error!({ "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"\"literal\"","%3"
    tracing::error!({ foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"\"literal\"","%3"
    tracing::error!("literal" = ?deb); // DEBUG:error,-,-,-,-,"\"literal\"","?deb"
    tracing::error!(foo = true, "literal" = ?deb); // DEBUG:error,-,-,p,-,"\"literal\"","?deb"
    tracing::error!("literal" = ?deb, qux = 3); // DEBUG:error,-,-,f,-,"\"literal\"","?deb"
    tracing::error!(foo = true, "literal" = ?deb, qux = 3); // DEBUG:error,-,-,pf,-,"\"literal\"","?deb"
    tracing::error!("literal" = ?deb, "msg without args"); // DEBUG:error,-,-,-,m,"\"literal\"","?deb"
    tracing::error!(foo = true, "literal" = ?deb, "msg without args"); // DEBUG:error,-,-,p,m,"\"literal\"","?deb"
    tracing::error!("literal" = ?deb, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"\"literal\"","?deb"
    tracing::error!(foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"\"literal\"","?deb"
    tracing::error!({ "literal" = ?deb }, "msg without args"); // DEBUG:error,-,{},-,m,"\"literal\"","?deb"
    tracing::error!({ foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:error,-,{},p,m,"\"literal\"","?deb"
    tracing::error!({ "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"\"literal\"","?deb"
    tracing::error!({ foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"\"literal\"","?deb"
    tracing::error!("literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"\"literal\"","?deb"
    tracing::error!(foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"\"literal\"","?deb"
    tracing::error!("literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"\"literal\"","?deb"
    tracing::error!(foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"\"literal\"","?deb"
    tracing::error!({ "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"\"literal\"","?deb"
    tracing::error!({ foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"\"literal\"","?deb"
    tracing::error!({ "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"\"literal\"","?deb"
    tracing::error!({ foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"\"literal\"","?deb"
    tracing::error!("literal" = %disp); // DEBUG:error,-,-,-,-,"\"literal\"","%disp"
    tracing::error!(foo = true, "literal" = %disp); // DEBUG:error,-,-,p,-,"\"literal\"","%disp"
    tracing::error!("literal" = %disp, qux = 3); // DEBUG:error,-,-,f,-,"\"literal\"","%disp"
    tracing::error!(foo = true, "literal" = %disp, qux = 3); // DEBUG:error,-,-,pf,-,"\"literal\"","%disp"
    tracing::error!("literal" = %disp, "msg without args"); // DEBUG:error,-,-,-,m,"\"literal\"","%disp"
    tracing::error!(foo = true, "literal" = %disp, "msg without args"); // DEBUG:error,-,-,p,m,"\"literal\"","%disp"
    tracing::error!("literal" = %disp, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"\"literal\"","%disp"
    tracing::error!(foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"\"literal\"","%disp"
    tracing::error!({ "literal" = %disp }, "msg without args"); // DEBUG:error,-,{},-,m,"\"literal\"","%disp"
    tracing::error!({ foo = true, "literal" = %disp }, "msg without args"); // DEBUG:error,-,{},p,m,"\"literal\"","%disp"
    tracing::error!({ "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"\"literal\"","%disp"
    tracing::error!({ foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"\"literal\"","%disp"
    tracing::error!("literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"\"literal\"","%disp"
    tracing::error!(foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"\"literal\"","%disp"
    tracing::error!("literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"\"literal\"","%disp"
    tracing::error!(foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"\"literal\"","%disp"
    tracing::error!({ "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"\"literal\"","%disp"
    tracing::error!({ foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"\"literal\"","%disp"
    tracing::error!({ "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"\"literal\"","%disp"
    tracing::error!({ foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"\"literal\"","%disp"
    tracing::error!("literal" = ?sub.field); // DEBUG:error,-,-,-,-,"\"literal\"","?sub.field"
    tracing::error!(foo = true, "literal" = ?sub.field); // DEBUG:error,-,-,p,-,"\"literal\"","?sub.field"
    tracing::error!("literal" = ?sub.field, qux = 3); // DEBUG:error,-,-,f,-,"\"literal\"","?sub.field"
    tracing::error!(foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:error,-,-,pf,-,"\"literal\"","?sub.field"
    tracing::error!("literal" = ?sub.field, "msg without args"); // DEBUG:error,-,-,-,m,"\"literal\"","?sub.field"
    tracing::error!(foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:error,-,-,p,m,"\"literal\"","?sub.field"
    tracing::error!("literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"\"literal\"","?sub.field"
    tracing::error!(foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"\"literal\"","?sub.field"
    tracing::error!({ "literal" = ?sub.field }, "msg without args"); // DEBUG:error,-,{},-,m,"\"literal\"","?sub.field"
    tracing::error!({ foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:error,-,{},p,m,"\"literal\"","?sub.field"
    tracing::error!({ "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"\"literal\"","?sub.field"
    tracing::error!({ foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"\"literal\"","?sub.field"
    tracing::error!("literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"\"literal\"","?sub.field"
    tracing::error!(foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"\"literal\"","?sub.field"
    tracing::error!("literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"\"literal\"","?sub.field"
    tracing::error!(foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"\"literal\"","?sub.field"
    tracing::error!({ "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"\"literal\"","?sub.field"
    tracing::error!({ foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"\"literal\"","?sub.field"
    tracing::error!({ "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"\"literal\"","?sub.field"
    tracing::error!({ foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"\"literal\"","?sub.field"
    tracing::error!("literal" = %sub.field); // DEBUG:error,-,-,-,-,"\"literal\"","%sub.field"
    tracing::error!(foo = true, "literal" = %sub.field); // DEBUG:error,-,-,p,-,"\"literal\"","%sub.field"
    tracing::error!("literal" = %sub.field, qux = 3); // DEBUG:error,-,-,f,-,"\"literal\"","%sub.field"
    tracing::error!(foo = true, "literal" = %sub.field, qux = 3); // DEBUG:error,-,-,pf,-,"\"literal\"","%sub.field"
    tracing::error!("literal" = %sub.field, "msg without args"); // DEBUG:error,-,-,-,m,"\"literal\"","%sub.field"
    tracing::error!(foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:error,-,-,p,m,"\"literal\"","%sub.field"
    tracing::error!("literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"\"literal\"","%sub.field"
    tracing::error!(foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"\"literal\"","%sub.field"
    tracing::error!({ "literal" = %sub.field }, "msg without args"); // DEBUG:error,-,{},-,m,"\"literal\"","%sub.field"
    tracing::error!({ foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:error,-,{},p,m,"\"literal\"","%sub.field"
    tracing::error!({ "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"\"literal\"","%sub.field"
    tracing::error!({ foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"\"literal\"","%sub.field"
    tracing::error!("literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"\"literal\"","%sub.field"
    tracing::error!(foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"\"literal\"","%sub.field"
    tracing::error!("literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"\"literal\"","%sub.field"
    tracing::error!(foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"\"literal\"","%sub.field"
    tracing::error!({ "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"\"literal\"","%sub.field"
    tracing::error!({ foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"\"literal\"","%sub.field"
    tracing::error!({ "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"\"literal\"","%sub.field"
    tracing::error!({ foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"\"literal\"","%sub.field"
    tracing::error!("literal" = debug(&deb)); // DEBUG:error,-,-,-,-,"\"literal\"","debug(&deb)"
    tracing::error!(foo = true, "literal" = debug(&deb)); // DEBUG:error,-,-,p,-,"\"literal\"","debug(&deb)"
    tracing::error!("literal" = debug(&deb), qux = 3); // DEBUG:error,-,-,f,-,"\"literal\"","debug(&deb)"
    tracing::error!(foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:error,-,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::error!("literal" = debug(&deb), "msg without args"); // DEBUG:error,-,-,-,m,"\"literal\"","debug(&deb)"
    tracing::error!(foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:error,-,-,p,m,"\"literal\"","debug(&deb)"
    tracing::error!("literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"\"literal\"","debug(&deb)"
    tracing::error!(foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::error!({ "literal" = debug(&deb) }, "msg without args"); // DEBUG:error,-,{},-,m,"\"literal\"","debug(&deb)"
    tracing::error!({ foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:error,-,{},p,m,"\"literal\"","debug(&deb)"
    tracing::error!({ "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"\"literal\"","debug(&deb)"
    tracing::error!({ foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::error!("literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::error!(foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::error!("literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::error!(foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::error!({ "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::error!({ foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::error!({ "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::error!({ foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::error!("literal" = display(&disp)); // DEBUG:error,-,-,-,-,"\"literal\"","display(&disp)"
    tracing::error!(foo = true, "literal" = display(&disp)); // DEBUG:error,-,-,p,-,"\"literal\"","display(&disp)"
    tracing::error!("literal" = display(&disp), qux = 3); // DEBUG:error,-,-,f,-,"\"literal\"","display(&disp)"
    tracing::error!(foo = true, "literal" = display(&disp), qux = 3); // DEBUG:error,-,-,pf,-,"\"literal\"","display(&disp)"
    tracing::error!("literal" = display(&disp), "msg without args"); // DEBUG:error,-,-,-,m,"\"literal\"","display(&disp)"
    tracing::error!(foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:error,-,-,p,m,"\"literal\"","display(&disp)"
    tracing::error!("literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"\"literal\"","display(&disp)"
    tracing::error!(foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"\"literal\"","display(&disp)"
    tracing::error!({ "literal" = display(&disp) }, "msg without args"); // DEBUG:error,-,{},-,m,"\"literal\"","display(&disp)"
    tracing::error!({ foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:error,-,{},p,m,"\"literal\"","display(&disp)"
    tracing::error!({ "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"\"literal\"","display(&disp)"
    tracing::error!({ foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"\"literal\"","display(&disp)"
    tracing::error!("literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"\"literal\"","display(&disp)"
    tracing::error!(foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"\"literal\"","display(&disp)"
    tracing::error!("literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"\"literal\"","display(&disp)"
    tracing::error!(foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::error!({ "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"\"literal\"","display(&disp)"
    tracing::error!({ foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"\"literal\"","display(&disp)"
    tracing::error!({ "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"\"literal\"","display(&disp)"
    tracing::error!({ foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::error!("literal" = tracing::field::Empty); // DEBUG:error,-,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::error!(foo = true, "literal" = tracing::field::Empty); // DEBUG:error,-,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::error!("literal" = tracing::field::Empty, qux = 3); // DEBUG:error,-,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::error!(foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:error,-,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::error!("literal" = tracing::field::Empty, "msg without args"); // DEBUG:error,-,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::error!(foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:error,-,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::error!("literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::error!(foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::error!({ "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:error,-,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::error!({ foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:error,-,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::error!({ "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::error!({ foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::error!("literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::error!(foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::error!("literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::error!(foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::error!({ "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::error!({ foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::error!({ "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::error!({ foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::error!({ CONST_VAR } = 3); // DEBUG:error,-,-,-,-,"{ CONST_VAR }","3"
    tracing::error!(foo = true, { CONST_VAR } = 3); // DEBUG:error,-,-,p,-,"{ CONST_VAR }","3"
    tracing::error!({ CONST_VAR } = 3, qux = 3); // DEBUG:error,-,-,f,-,"{ CONST_VAR }","3"
    tracing::error!(foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:error,-,-,pf,-,"{ CONST_VAR }","3"
    tracing::error!({ CONST_VAR } = 3, "msg without args"); // DEBUG:error,-,-,-,m,"{ CONST_VAR }","3"
    tracing::error!(foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:error,-,-,p,m,"{ CONST_VAR }","3"
    tracing::error!({ CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"{ CONST_VAR }","3"
    tracing::error!(foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"{ CONST_VAR }","3"
    tracing::error!({ { CONST_VAR } = 3 }, "msg without args"); // DEBUG:error,-,{},-,m,"{ CONST_VAR }","3"
    tracing::error!({ foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:error,-,{},p,m,"{ CONST_VAR }","3"
    tracing::error!({ { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"{ CONST_VAR }","3"
    tracing::error!({ foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"{ CONST_VAR }","3"
    tracing::error!({ CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"{ CONST_VAR }","3"
    tracing::error!(foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"{ CONST_VAR }","3"
    tracing::error!({ CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"{ CONST_VAR }","3"
    tracing::error!(foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"{ CONST_VAR }","3"
    tracing::error!({ { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"{ CONST_VAR }","3"
    tracing::error!({ foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"{ CONST_VAR }","3"
    tracing::error!({ { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"{ CONST_VAR }","3"
    tracing::error!({ foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"{ CONST_VAR }","3"
    tracing::error!({ CONST_VAR } = false); // DEBUG:error,-,-,-,-,"{ CONST_VAR }","false"
    tracing::error!(foo = true, { CONST_VAR } = false); // DEBUG:error,-,-,p,-,"{ CONST_VAR }","false"
    tracing::error!({ CONST_VAR } = false, qux = 3); // DEBUG:error,-,-,f,-,"{ CONST_VAR }","false"
    tracing::error!(foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:error,-,-,pf,-,"{ CONST_VAR }","false"
    tracing::error!({ CONST_VAR } = false, "msg without args"); // DEBUG:error,-,-,-,m,"{ CONST_VAR }","false"
    tracing::error!(foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:error,-,-,p,m,"{ CONST_VAR }","false"
    tracing::error!({ CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"{ CONST_VAR }","false"
    tracing::error!(foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"{ CONST_VAR }","false"
    tracing::error!({ { CONST_VAR } = false }, "msg without args"); // DEBUG:error,-,{},-,m,"{ CONST_VAR }","false"
    tracing::error!({ foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:error,-,{},p,m,"{ CONST_VAR }","false"
    tracing::error!({ { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"{ CONST_VAR }","false"
    tracing::error!({ foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"{ CONST_VAR }","false"
    tracing::error!({ CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"{ CONST_VAR }","false"
    tracing::error!(foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"{ CONST_VAR }","false"
    tracing::error!({ CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"{ CONST_VAR }","false"
    tracing::error!(foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"{ CONST_VAR }","false"
    tracing::error!({ { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"{ CONST_VAR }","false"
    tracing::error!({ foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"{ CONST_VAR }","false"
    tracing::error!({ { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"{ CONST_VAR }","false"
    tracing::error!({ foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"{ CONST_VAR }","false"
    tracing::error!({ CONST_VAR } = ?3); // DEBUG:error,-,-,-,-,"{ CONST_VAR }","?3"
    tracing::error!(foo = true, { CONST_VAR } = ?3); // DEBUG:error,-,-,p,-,"{ CONST_VAR }","?3"
    tracing::error!({ CONST_VAR } = ?3, qux = 3); // DEBUG:error,-,-,f,-,"{ CONST_VAR }","?3"
    tracing::error!(foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:error,-,-,pf,-,"{ CONST_VAR }","?3"
    tracing::error!({ CONST_VAR } = ?3, "msg without args"); // DEBUG:error,-,-,-,m,"{ CONST_VAR }","?3"
    tracing::error!(foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:error,-,-,p,m,"{ CONST_VAR }","?3"
    tracing::error!({ CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"{ CONST_VAR }","?3"
    tracing::error!(foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"{ CONST_VAR }","?3"
    tracing::error!({ { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:error,-,{},-,m,"{ CONST_VAR }","?3"
    tracing::error!({ foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:error,-,{},p,m,"{ CONST_VAR }","?3"
    tracing::error!({ { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"{ CONST_VAR }","?3"
    tracing::error!({ foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"{ CONST_VAR }","?3"
    tracing::error!({ CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"{ CONST_VAR }","?3"
    tracing::error!(foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"{ CONST_VAR }","?3"
    tracing::error!({ CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"{ CONST_VAR }","?3"
    tracing::error!(foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::error!({ { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"{ CONST_VAR }","?3"
    tracing::error!({ foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"{ CONST_VAR }","?3"
    tracing::error!({ { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"{ CONST_VAR }","?3"
    tracing::error!({ foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::error!({ CONST_VAR } = %3); // DEBUG:error,-,-,-,-,"{ CONST_VAR }","%3"
    tracing::error!(foo = true, { CONST_VAR } = %3); // DEBUG:error,-,-,p,-,"{ CONST_VAR }","%3"
    tracing::error!({ CONST_VAR } = %3, qux = 3); // DEBUG:error,-,-,f,-,"{ CONST_VAR }","%3"
    tracing::error!(foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:error,-,-,pf,-,"{ CONST_VAR }","%3"
    tracing::error!({ CONST_VAR } = %3, "msg without args"); // DEBUG:error,-,-,-,m,"{ CONST_VAR }","%3"
    tracing::error!(foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:error,-,-,p,m,"{ CONST_VAR }","%3"
    tracing::error!({ CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"{ CONST_VAR }","%3"
    tracing::error!(foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"{ CONST_VAR }","%3"
    tracing::error!({ { CONST_VAR } = %3 }, "msg without args"); // DEBUG:error,-,{},-,m,"{ CONST_VAR }","%3"
    tracing::error!({ foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:error,-,{},p,m,"{ CONST_VAR }","%3"
    tracing::error!({ { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"{ CONST_VAR }","%3"
    tracing::error!({ foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"{ CONST_VAR }","%3"
    tracing::error!({ CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"{ CONST_VAR }","%3"
    tracing::error!(foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"{ CONST_VAR }","%3"
    tracing::error!({ CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"{ CONST_VAR }","%3"
    tracing::error!(foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::error!({ { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"{ CONST_VAR }","%3"
    tracing::error!({ foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"{ CONST_VAR }","%3"
    tracing::error!({ { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"{ CONST_VAR }","%3"
    tracing::error!({ foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::error!({ CONST_VAR } = ?deb); // DEBUG:error,-,-,-,-,"{ CONST_VAR }","?deb"
    tracing::error!(foo = true, { CONST_VAR } = ?deb); // DEBUG:error,-,-,p,-,"{ CONST_VAR }","?deb"
    tracing::error!({ CONST_VAR } = ?deb, qux = 3); // DEBUG:error,-,-,f,-,"{ CONST_VAR }","?deb"
    tracing::error!(foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:error,-,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::error!({ CONST_VAR } = ?deb, "msg without args"); // DEBUG:error,-,-,-,m,"{ CONST_VAR }","?deb"
    tracing::error!(foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:error,-,-,p,m,"{ CONST_VAR }","?deb"
    tracing::error!({ CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"{ CONST_VAR }","?deb"
    tracing::error!(foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::error!({ { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:error,-,{},-,m,"{ CONST_VAR }","?deb"
    tracing::error!({ foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:error,-,{},p,m,"{ CONST_VAR }","?deb"
    tracing::error!({ { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"{ CONST_VAR }","?deb"
    tracing::error!({ foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::error!({ CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::error!(foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::error!({ CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::error!(foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::error!({ { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::error!({ foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::error!({ { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::error!({ foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::error!({ CONST_VAR } = %disp); // DEBUG:error,-,-,-,-,"{ CONST_VAR }","%disp"
    tracing::error!(foo = true, { CONST_VAR } = %disp); // DEBUG:error,-,-,p,-,"{ CONST_VAR }","%disp"
    tracing::error!({ CONST_VAR } = %disp, qux = 3); // DEBUG:error,-,-,f,-,"{ CONST_VAR }","%disp"
    tracing::error!(foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:error,-,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::error!({ CONST_VAR } = %disp, "msg without args"); // DEBUG:error,-,-,-,m,"{ CONST_VAR }","%disp"
    tracing::error!(foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:error,-,-,p,m,"{ CONST_VAR }","%disp"
    tracing::error!({ CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"{ CONST_VAR }","%disp"
    tracing::error!(foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::error!({ { CONST_VAR } = %disp }, "msg without args"); // DEBUG:error,-,{},-,m,"{ CONST_VAR }","%disp"
    tracing::error!({ foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:error,-,{},p,m,"{ CONST_VAR }","%disp"
    tracing::error!({ { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"{ CONST_VAR }","%disp"
    tracing::error!({ foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::error!({ CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::error!(foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::error!({ CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::error!(foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::error!({ { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::error!({ foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::error!({ { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::error!({ foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::error!({ CONST_VAR } = ?sub.field); // DEBUG:error,-,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::error!(foo = true, { CONST_VAR } = ?sub.field); // DEBUG:error,-,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::error!({ CONST_VAR } = ?sub.field, qux = 3); // DEBUG:error,-,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::error!(foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:error,-,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::error!({ CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:error,-,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::error!(foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:error,-,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::error!({ CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::error!(foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::error!({ { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:error,-,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::error!({ foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:error,-,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::error!({ { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::error!({ foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::error!({ CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::error!(foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::error!({ CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::error!(foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::error!({ { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::error!({ foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::error!({ { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::error!({ foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::error!({ CONST_VAR } = %sub.field); // DEBUG:error,-,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::error!(foo = true, { CONST_VAR } = %sub.field); // DEBUG:error,-,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::error!({ CONST_VAR } = %sub.field, qux = 3); // DEBUG:error,-,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::error!(foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:error,-,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::error!({ CONST_VAR } = %sub.field, "msg without args"); // DEBUG:error,-,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::error!(foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:error,-,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::error!({ CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::error!(foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::error!({ { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:error,-,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::error!({ foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:error,-,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::error!({ { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::error!({ foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::error!({ CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::error!(foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::error!({ CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::error!(foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::error!({ { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::error!({ foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::error!({ { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::error!({ foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::error!({ CONST_VAR } = debug(&deb)); // DEBUG:error,-,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::error!(foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:error,-,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::error!({ CONST_VAR } = debug(&deb), qux = 3); // DEBUG:error,-,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::error!(foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:error,-,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::error!({ CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:error,-,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::error!(foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:error,-,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::error!({ CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::error!(foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::error!({ { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:error,-,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::error!({ foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:error,-,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::error!({ { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::error!({ foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::error!({ CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::error!(foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::error!({ CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::error!(foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::error!({ { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::error!({ foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::error!({ { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::error!({ foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::error!({ CONST_VAR } = display(&disp)); // DEBUG:error,-,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::error!(foo = true, { CONST_VAR } = display(&disp)); // DEBUG:error,-,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::error!({ CONST_VAR } = display(&disp), qux = 3); // DEBUG:error,-,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::error!(foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:error,-,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::error!({ CONST_VAR } = display(&disp), "msg without args"); // DEBUG:error,-,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::error!(foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:error,-,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::error!({ CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::error!(foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::error!({ { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:error,-,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::error!({ foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:error,-,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::error!({ { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::error!({ foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::error!({ CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::error!(foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::error!({ CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::error!(foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::error!({ { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::error!({ foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::error!({ { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::error!({ foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::error!({ CONST_VAR } = tracing::field::Empty); // DEBUG:error,-,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!(foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:error,-,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!({ CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:error,-,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!(foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:error,-,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!({ CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:error,-,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!(foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:error,-,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!({ CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!(foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!({ { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:error,-,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!({ foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:error,-,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!({ { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!({ foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!({ CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!(foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!({ CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!(foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!({ { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!({ foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!({ { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!({ foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::error!(r#type = 3); // DEBUG:error,-,-,-,-,"r#type","3"
    tracing::error!(foo = true, r#type = 3); // DEBUG:error,-,-,p,-,"r#type","3"
    tracing::error!(r#type = 3, qux = 3); // DEBUG:error,-,-,f,-,"r#type","3"
    tracing::error!(foo = true, r#type = 3, qux = 3); // DEBUG:error,-,-,pf,-,"r#type","3"
    tracing::error!(r#type = 3, "msg without args"); // DEBUG:error,-,-,-,m,"r#type","3"
    tracing::error!(foo = true, r#type = 3, "msg without args"); // DEBUG:error,-,-,p,m,"r#type","3"
    tracing::error!(r#type = 3, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"r#type","3"
    tracing::error!(foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"r#type","3"
    tracing::error!({ r#type = 3 }, "msg without args"); // DEBUG:error,-,{},-,m,"r#type","3"
    tracing::error!({ foo = true, r#type = 3 }, "msg without args"); // DEBUG:error,-,{},p,m,"r#type","3"
    tracing::error!({ r#type = 3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"r#type","3"
    tracing::error!({ foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"r#type","3"
    tracing::error!(r#type = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"r#type","3"
    tracing::error!(foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"r#type","3"
    tracing::error!(r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"r#type","3"
    tracing::error!(foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"r#type","3"
    tracing::error!({ r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"r#type","3"
    tracing::error!({ foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"r#type","3"
    tracing::error!({ r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"r#type","3"
    tracing::error!({ foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"r#type","3"
    tracing::error!(r#type = false); // DEBUG:error,-,-,-,-,"r#type","false"
    tracing::error!(foo = true, r#type = false); // DEBUG:error,-,-,p,-,"r#type","false"
    tracing::error!(r#type = false, qux = 3); // DEBUG:error,-,-,f,-,"r#type","false"
    tracing::error!(foo = true, r#type = false, qux = 3); // DEBUG:error,-,-,pf,-,"r#type","false"
    tracing::error!(r#type = false, "msg without args"); // DEBUG:error,-,-,-,m,"r#type","false"
    tracing::error!(foo = true, r#type = false, "msg without args"); // DEBUG:error,-,-,p,m,"r#type","false"
    tracing::error!(r#type = false, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"r#type","false"
    tracing::error!(foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"r#type","false"
    tracing::error!({ r#type = false }, "msg without args"); // DEBUG:error,-,{},-,m,"r#type","false"
    tracing::error!({ foo = true, r#type = false }, "msg without args"); // DEBUG:error,-,{},p,m,"r#type","false"
    tracing::error!({ r#type = false, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"r#type","false"
    tracing::error!({ foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"r#type","false"
    tracing::error!(r#type = false, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"r#type","false"
    tracing::error!(foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"r#type","false"
    tracing::error!(r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"r#type","false"
    tracing::error!(foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"r#type","false"
    tracing::error!({ r#type = false }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"r#type","false"
    tracing::error!({ foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"r#type","false"
    tracing::error!({ r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"r#type","false"
    tracing::error!({ foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"r#type","false"
    tracing::error!(r#type = ?3); // DEBUG:error,-,-,-,-,"r#type","?3"
    tracing::error!(foo = true, r#type = ?3); // DEBUG:error,-,-,p,-,"r#type","?3"
    tracing::error!(r#type = ?3, qux = 3); // DEBUG:error,-,-,f,-,"r#type","?3"
    tracing::error!(foo = true, r#type = ?3, qux = 3); // DEBUG:error,-,-,pf,-,"r#type","?3"
    tracing::error!(r#type = ?3, "msg without args"); // DEBUG:error,-,-,-,m,"r#type","?3"
    tracing::error!(foo = true, r#type = ?3, "msg without args"); // DEBUG:error,-,-,p,m,"r#type","?3"
    tracing::error!(r#type = ?3, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"r#type","?3"
    tracing::error!(foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"r#type","?3"
    tracing::error!({ r#type = ?3 }, "msg without args"); // DEBUG:error,-,{},-,m,"r#type","?3"
    tracing::error!({ foo = true, r#type = ?3 }, "msg without args"); // DEBUG:error,-,{},p,m,"r#type","?3"
    tracing::error!({ r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"r#type","?3"
    tracing::error!({ foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"r#type","?3"
    tracing::error!(r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"r#type","?3"
    tracing::error!(foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"r#type","?3"
    tracing::error!(r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"r#type","?3"
    tracing::error!(foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"r#type","?3"
    tracing::error!({ r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"r#type","?3"
    tracing::error!({ foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"r#type","?3"
    tracing::error!({ r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"r#type","?3"
    tracing::error!({ foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"r#type","?3"
    tracing::error!(r#type = %3); // DEBUG:error,-,-,-,-,"r#type","%3"
    tracing::error!(foo = true, r#type = %3); // DEBUG:error,-,-,p,-,"r#type","%3"
    tracing::error!(r#type = %3, qux = 3); // DEBUG:error,-,-,f,-,"r#type","%3"
    tracing::error!(foo = true, r#type = %3, qux = 3); // DEBUG:error,-,-,pf,-,"r#type","%3"
    tracing::error!(r#type = %3, "msg without args"); // DEBUG:error,-,-,-,m,"r#type","%3"
    tracing::error!(foo = true, r#type = %3, "msg without args"); // DEBUG:error,-,-,p,m,"r#type","%3"
    tracing::error!(r#type = %3, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"r#type","%3"
    tracing::error!(foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"r#type","%3"
    tracing::error!({ r#type = %3 }, "msg without args"); // DEBUG:error,-,{},-,m,"r#type","%3"
    tracing::error!({ foo = true, r#type = %3 }, "msg without args"); // DEBUG:error,-,{},p,m,"r#type","%3"
    tracing::error!({ r#type = %3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"r#type","%3"
    tracing::error!({ foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"r#type","%3"
    tracing::error!(r#type = %3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"r#type","%3"
    tracing::error!(foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"r#type","%3"
    tracing::error!(r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"r#type","%3"
    tracing::error!(foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"r#type","%3"
    tracing::error!({ r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"r#type","%3"
    tracing::error!({ foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"r#type","%3"
    tracing::error!({ r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"r#type","%3"
    tracing::error!({ foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"r#type","%3"
    tracing::error!(r#type = ?deb); // DEBUG:error,-,-,-,-,"r#type","?deb"
    tracing::error!(foo = true, r#type = ?deb); // DEBUG:error,-,-,p,-,"r#type","?deb"
    tracing::error!(r#type = ?deb, qux = 3); // DEBUG:error,-,-,f,-,"r#type","?deb"
    tracing::error!(foo = true, r#type = ?deb, qux = 3); // DEBUG:error,-,-,pf,-,"r#type","?deb"
    tracing::error!(r#type = ?deb, "msg without args"); // DEBUG:error,-,-,-,m,"r#type","?deb"
    tracing::error!(foo = true, r#type = ?deb, "msg without args"); // DEBUG:error,-,-,p,m,"r#type","?deb"
    tracing::error!(r#type = ?deb, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"r#type","?deb"
    tracing::error!(foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"r#type","?deb"
    tracing::error!({ r#type = ?deb }, "msg without args"); // DEBUG:error,-,{},-,m,"r#type","?deb"
    tracing::error!({ foo = true, r#type = ?deb }, "msg without args"); // DEBUG:error,-,{},p,m,"r#type","?deb"
    tracing::error!({ r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"r#type","?deb"
    tracing::error!({ foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"r#type","?deb"
    tracing::error!(r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"r#type","?deb"
    tracing::error!(foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"r#type","?deb"
    tracing::error!(r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"r#type","?deb"
    tracing::error!(foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"r#type","?deb"
    tracing::error!({ r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"r#type","?deb"
    tracing::error!({ foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"r#type","?deb"
    tracing::error!({ r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"r#type","?deb"
    tracing::error!({ foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"r#type","?deb"
    tracing::error!(r#type = %disp); // DEBUG:error,-,-,-,-,"r#type","%disp"
    tracing::error!(foo = true, r#type = %disp); // DEBUG:error,-,-,p,-,"r#type","%disp"
    tracing::error!(r#type = %disp, qux = 3); // DEBUG:error,-,-,f,-,"r#type","%disp"
    tracing::error!(foo = true, r#type = %disp, qux = 3); // DEBUG:error,-,-,pf,-,"r#type","%disp"
    tracing::error!(r#type = %disp, "msg without args"); // DEBUG:error,-,-,-,m,"r#type","%disp"
    tracing::error!(foo = true, r#type = %disp, "msg without args"); // DEBUG:error,-,-,p,m,"r#type","%disp"
    tracing::error!(r#type = %disp, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"r#type","%disp"
    tracing::error!(foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"r#type","%disp"
    tracing::error!({ r#type = %disp }, "msg without args"); // DEBUG:error,-,{},-,m,"r#type","%disp"
    tracing::error!({ foo = true, r#type = %disp }, "msg without args"); // DEBUG:error,-,{},p,m,"r#type","%disp"
    tracing::error!({ r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"r#type","%disp"
    tracing::error!({ foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"r#type","%disp"
    tracing::error!(r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"r#type","%disp"
    tracing::error!(foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"r#type","%disp"
    tracing::error!(r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"r#type","%disp"
    tracing::error!(foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"r#type","%disp"
    tracing::error!({ r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"r#type","%disp"
    tracing::error!({ foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"r#type","%disp"
    tracing::error!({ r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"r#type","%disp"
    tracing::error!({ foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"r#type","%disp"
    tracing::error!(r#type = ?sub.field); // DEBUG:error,-,-,-,-,"r#type","?sub.field"
    tracing::error!(foo = true, r#type = ?sub.field); // DEBUG:error,-,-,p,-,"r#type","?sub.field"
    tracing::error!(r#type = ?sub.field, qux = 3); // DEBUG:error,-,-,f,-,"r#type","?sub.field"
    tracing::error!(foo = true, r#type = ?sub.field, qux = 3); // DEBUG:error,-,-,pf,-,"r#type","?sub.field"
    tracing::error!(r#type = ?sub.field, "msg without args"); // DEBUG:error,-,-,-,m,"r#type","?sub.field"
    tracing::error!(foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:error,-,-,p,m,"r#type","?sub.field"
    tracing::error!(r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"r#type","?sub.field"
    tracing::error!(foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"r#type","?sub.field"
    tracing::error!({ r#type = ?sub.field }, "msg without args"); // DEBUG:error,-,{},-,m,"r#type","?sub.field"
    tracing::error!({ foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:error,-,{},p,m,"r#type","?sub.field"
    tracing::error!({ r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"r#type","?sub.field"
    tracing::error!({ foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"r#type","?sub.field"
    tracing::error!(r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"r#type","?sub.field"
    tracing::error!(foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"r#type","?sub.field"
    tracing::error!(r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"r#type","?sub.field"
    tracing::error!(foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"r#type","?sub.field"
    tracing::error!({ r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"r#type","?sub.field"
    tracing::error!({ foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"r#type","?sub.field"
    tracing::error!({ r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"r#type","?sub.field"
    tracing::error!({ foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"r#type","?sub.field"
    tracing::error!(r#type = %sub.field); // DEBUG:error,-,-,-,-,"r#type","%sub.field"
    tracing::error!(foo = true, r#type = %sub.field); // DEBUG:error,-,-,p,-,"r#type","%sub.field"
    tracing::error!(r#type = %sub.field, qux = 3); // DEBUG:error,-,-,f,-,"r#type","%sub.field"
    tracing::error!(foo = true, r#type = %sub.field, qux = 3); // DEBUG:error,-,-,pf,-,"r#type","%sub.field"
    tracing::error!(r#type = %sub.field, "msg without args"); // DEBUG:error,-,-,-,m,"r#type","%sub.field"
    tracing::error!(foo = true, r#type = %sub.field, "msg without args"); // DEBUG:error,-,-,p,m,"r#type","%sub.field"
    tracing::error!(r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"r#type","%sub.field"
    tracing::error!(foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"r#type","%sub.field"
    tracing::error!({ r#type = %sub.field }, "msg without args"); // DEBUG:error,-,{},-,m,"r#type","%sub.field"
    tracing::error!({ foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:error,-,{},p,m,"r#type","%sub.field"
    tracing::error!({ r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"r#type","%sub.field"
    tracing::error!({ foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"r#type","%sub.field"
    tracing::error!(r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"r#type","%sub.field"
    tracing::error!(foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"r#type","%sub.field"
    tracing::error!(r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"r#type","%sub.field"
    tracing::error!(foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"r#type","%sub.field"
    tracing::error!({ r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"r#type","%sub.field"
    tracing::error!({ foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"r#type","%sub.field"
    tracing::error!({ r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"r#type","%sub.field"
    tracing::error!({ foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"r#type","%sub.field"
    tracing::error!(r#type = debug(&deb)); // DEBUG:error,-,-,-,-,"r#type","debug(&deb)"
    tracing::error!(foo = true, r#type = debug(&deb)); // DEBUG:error,-,-,p,-,"r#type","debug(&deb)"
    tracing::error!(r#type = debug(&deb), qux = 3); // DEBUG:error,-,-,f,-,"r#type","debug(&deb)"
    tracing::error!(foo = true, r#type = debug(&deb), qux = 3); // DEBUG:error,-,-,pf,-,"r#type","debug(&deb)"
    tracing::error!(r#type = debug(&deb), "msg without args"); // DEBUG:error,-,-,-,m,"r#type","debug(&deb)"
    tracing::error!(foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:error,-,-,p,m,"r#type","debug(&deb)"
    tracing::error!(r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"r#type","debug(&deb)"
    tracing::error!(foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"r#type","debug(&deb)"
    tracing::error!({ r#type = debug(&deb) }, "msg without args"); // DEBUG:error,-,{},-,m,"r#type","debug(&deb)"
    tracing::error!({ foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:error,-,{},p,m,"r#type","debug(&deb)"
    tracing::error!({ r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"r#type","debug(&deb)"
    tracing::error!({ foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"r#type","debug(&deb)"
    tracing::error!(r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"r#type","debug(&deb)"
    tracing::error!(foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"r#type","debug(&deb)"
    tracing::error!(r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"r#type","debug(&deb)"
    tracing::error!(foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"r#type","debug(&deb)"
    tracing::error!({ r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"r#type","debug(&deb)"
    tracing::error!({ foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"r#type","debug(&deb)"
    tracing::error!({ r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"r#type","debug(&deb)"
    tracing::error!({ foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"r#type","debug(&deb)"
    tracing::error!(r#type = display(&disp)); // DEBUG:error,-,-,-,-,"r#type","display(&disp)"
    tracing::error!(foo = true, r#type = display(&disp)); // DEBUG:error,-,-,p,-,"r#type","display(&disp)"
    tracing::error!(r#type = display(&disp), qux = 3); // DEBUG:error,-,-,f,-,"r#type","display(&disp)"
    tracing::error!(foo = true, r#type = display(&disp), qux = 3); // DEBUG:error,-,-,pf,-,"r#type","display(&disp)"
    tracing::error!(r#type = display(&disp), "msg without args"); // DEBUG:error,-,-,-,m,"r#type","display(&disp)"
    tracing::error!(foo = true, r#type = display(&disp), "msg without args"); // DEBUG:error,-,-,p,m,"r#type","display(&disp)"
    tracing::error!(r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"r#type","display(&disp)"
    tracing::error!(foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"r#type","display(&disp)"
    tracing::error!({ r#type = display(&disp) }, "msg without args"); // DEBUG:error,-,{},-,m,"r#type","display(&disp)"
    tracing::error!({ foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:error,-,{},p,m,"r#type","display(&disp)"
    tracing::error!({ r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"r#type","display(&disp)"
    tracing::error!({ foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"r#type","display(&disp)"
    tracing::error!(r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"r#type","display(&disp)"
    tracing::error!(foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"r#type","display(&disp)"
    tracing::error!(r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"r#type","display(&disp)"
    tracing::error!(foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"r#type","display(&disp)"
    tracing::error!({ r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"r#type","display(&disp)"
    tracing::error!({ foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"r#type","display(&disp)"
    tracing::error!({ r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"r#type","display(&disp)"
    tracing::error!({ foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"r#type","display(&disp)"
    tracing::error!(r#type = tracing::field::Empty); // DEBUG:error,-,-,-,-,"r#type","tracing::field::Empty"
    tracing::error!(foo = true, r#type = tracing::field::Empty); // DEBUG:error,-,-,p,-,"r#type","tracing::field::Empty"
    tracing::error!(r#type = tracing::field::Empty, qux = 3); // DEBUG:error,-,-,f,-,"r#type","tracing::field::Empty"
    tracing::error!(foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:error,-,-,pf,-,"r#type","tracing::field::Empty"
    tracing::error!(r#type = tracing::field::Empty, "msg without args"); // DEBUG:error,-,-,-,m,"r#type","tracing::field::Empty"
    tracing::error!(foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:error,-,-,p,m,"r#type","tracing::field::Empty"
    tracing::error!(r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,"r#type","tracing::field::Empty"
    tracing::error!(foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,"r#type","tracing::field::Empty"
    tracing::error!({ r#type = tracing::field::Empty }, "msg without args"); // DEBUG:error,-,{},-,m,"r#type","tracing::field::Empty"
    tracing::error!({ foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:error,-,{},p,m,"r#type","tracing::field::Empty"
    tracing::error!({ r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,"r#type","tracing::field::Empty"
    tracing::error!({ foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,"r#type","tracing::field::Empty"
    tracing::error!(r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,"r#type","tracing::field::Empty"
    tracing::error!(foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,"r#type","tracing::field::Empty"
    tracing::error!(r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,"r#type","tracing::field::Empty"
    tracing::error!(foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::error!({ r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,"r#type","tracing::field::Empty"
    tracing::error!({ foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,"r#type","tracing::field::Empty"
    tracing::error!({ r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,"r#type","tracing::field::Empty"
    tracing::error!({ foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::error!(var); // DEBUG:error,-,-,-,-,-,"var"
    tracing::error!(foo = true, var); // DEBUG:error,-,-,p,-,-,"var"
    tracing::error!(var, qux = 3); // DEBUG:error,-,-,f,-,-,"var"
    tracing::error!(foo = true, var, qux = 3); // DEBUG:error,-,-,pf,-,-,"var"
    tracing::error!(var, "msg without args"); // DEBUG:error,-,-,-,m,-,"var"
    tracing::error!(foo = true, var, "msg without args"); // DEBUG:error,-,-,p,m,-,"var"
    tracing::error!(var, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,-,"var"
    tracing::error!(foo = true, var, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,-,"var"
    tracing::error!({ var }, "msg without args"); // DEBUG:error,-,{},-,m,-,"var"
    tracing::error!({ foo = true, var }, "msg without args"); // DEBUG:error,-,{},p,m,-,"var"
    tracing::error!({ var, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,-,"var"
    tracing::error!({ foo = true, var, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,-,"var"
    tracing::error!(var, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,-,"var"
    tracing::error!(foo = true, var, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,-,"var"
    tracing::error!(var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,-,"var"
    tracing::error!(foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,-,"var"
    tracing::error!({ var }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,-,"var"
    tracing::error!({ foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,-,"var"
    tracing::error!({ var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,-,"var"
    tracing::error!({ foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,-,"var"
    tracing::error!(sub.field); // DEBUG:error,-,-,-,-,-,"sub.field"
    tracing::error!(foo = true, sub.field); // DEBUG:error,-,-,p,-,-,"sub.field"
    tracing::error!(sub.field, qux = 3); // DEBUG:error,-,-,f,-,-,"sub.field"
    tracing::error!(foo = true, sub.field, qux = 3); // DEBUG:error,-,-,pf,-,-,"sub.field"
    tracing::error!(sub.field, "msg without args"); // DEBUG:error,-,-,-,m,-,"sub.field"
    tracing::error!(foo = true, sub.field, "msg without args"); // DEBUG:error,-,-,p,m,-,"sub.field"
    tracing::error!(sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,-,"sub.field"
    tracing::error!(foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,-,"sub.field"
    tracing::error!({ sub.field }, "msg without args"); // DEBUG:error,-,{},-,m,-,"sub.field"
    tracing::error!({ foo = true, sub.field }, "msg without args"); // DEBUG:error,-,{},p,m,-,"sub.field"
    tracing::error!({ sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,-,"sub.field"
    tracing::error!({ foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,-,"sub.field"
    tracing::error!(sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,-,"sub.field"
    tracing::error!(foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,-,"sub.field"
    tracing::error!(sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,-,"sub.field"
    tracing::error!(foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,-,"sub.field"
    tracing::error!({ sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,-,"sub.field"
    tracing::error!({ foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,-,"sub.field"
    tracing::error!({ sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,-,"sub.field"
    tracing::error!({ foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,-,"sub.field"
    tracing::error!(%disp); // DEBUG:error,-,-,-,-,-,"%disp"
    tracing::error!(foo = true, %disp); // DEBUG:error,-,-,p,-,-,"%disp"
    tracing::error!(%disp, qux = 3); // DEBUG:error,-,-,f,-,-,"%disp"
    tracing::error!(foo = true, %disp, qux = 3); // DEBUG:error,-,-,pf,-,-,"%disp"
    tracing::error!(%disp, "msg without args"); // DEBUG:error,-,-,-,m,-,"%disp"
    tracing::error!(foo = true, %disp, "msg without args"); // DEBUG:error,-,-,p,m,-,"%disp"
    tracing::error!(%disp, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,-,"%disp"
    tracing::error!(foo = true, %disp, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,-,"%disp"
    tracing::error!({ %disp }, "msg without args"); // DEBUG:error,-,{},-,m,-,"%disp"
    tracing::error!({ foo = true, %disp }, "msg without args"); // DEBUG:error,-,{},p,m,-,"%disp"
    tracing::error!({ %disp, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,-,"%disp"
    tracing::error!({ foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,-,"%disp"
    tracing::error!(%disp, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,-,"%disp"
    tracing::error!(foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,-,"%disp"
    tracing::error!(%disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,-,"%disp"
    tracing::error!(foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,-,"%disp"
    tracing::error!({ %disp }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,-,"%disp"
    tracing::error!({ foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,-,"%disp"
    tracing::error!({ %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,-,"%disp"
    tracing::error!({ foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,-,"%disp"
    tracing::error!(?deb); // DEBUG:error,-,-,-,-,-,"?deb"
    tracing::error!(foo = true, ?deb); // DEBUG:error,-,-,p,-,-,"?deb"
    tracing::error!(?deb, qux = 3); // DEBUG:error,-,-,f,-,-,"?deb"
    tracing::error!(foo = true, ?deb, qux = 3); // DEBUG:error,-,-,pf,-,-,"?deb"
    tracing::error!(?deb, "msg without args"); // DEBUG:error,-,-,-,m,-,"?deb"
    tracing::error!(foo = true, ?deb, "msg without args"); // DEBUG:error,-,-,p,m,-,"?deb"
    tracing::error!(?deb, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,-,"?deb"
    tracing::error!(foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,-,"?deb"
    tracing::error!({ ?deb }, "msg without args"); // DEBUG:error,-,{},-,m,-,"?deb"
    tracing::error!({ foo = true, ?deb }, "msg without args"); // DEBUG:error,-,{},p,m,-,"?deb"
    tracing::error!({ ?deb, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,-,"?deb"
    tracing::error!({ foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,-,"?deb"
    tracing::error!(?deb, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,-,"?deb"
    tracing::error!(foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,-,"?deb"
    tracing::error!(?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,-,"?deb"
    tracing::error!(foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,-,"?deb"
    tracing::error!({ ?deb }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,-,"?deb"
    tracing::error!({ foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,-,"?deb"
    tracing::error!({ ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,-,"?deb"
    tracing::error!({ foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,-,"?deb"
    tracing::error!(%sub.field); // DEBUG:error,-,-,-,-,-,"%sub.field"
    tracing::error!(foo = true, %sub.field); // DEBUG:error,-,-,p,-,-,"%sub.field"
    tracing::error!(%sub.field, qux = 3); // DEBUG:error,-,-,f,-,-,"%sub.field"
    tracing::error!(foo = true, %sub.field, qux = 3); // DEBUG:error,-,-,pf,-,-,"%sub.field"
    tracing::error!(%sub.field, "msg without args"); // DEBUG:error,-,-,-,m,-,"%sub.field"
    tracing::error!(foo = true, %sub.field, "msg without args"); // DEBUG:error,-,-,p,m,-,"%sub.field"
    tracing::error!(%sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,-,"%sub.field"
    tracing::error!(foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,-,"%sub.field"
    tracing::error!({ %sub.field }, "msg without args"); // DEBUG:error,-,{},-,m,-,"%sub.field"
    tracing::error!({ foo = true, %sub.field }, "msg without args"); // DEBUG:error,-,{},p,m,-,"%sub.field"
    tracing::error!({ %sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,-,"%sub.field"
    tracing::error!({ foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,-,"%sub.field"
    tracing::error!(%sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,-,"%sub.field"
    tracing::error!(foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,-,"%sub.field"
    tracing::error!(%sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,-,"%sub.field"
    tracing::error!(foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,-,"%sub.field"
    tracing::error!({ %sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,-,"%sub.field"
    tracing::error!({ foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,-,"%sub.field"
    tracing::error!({ %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,-,"%sub.field"
    tracing::error!({ foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,-,"%sub.field"
    tracing::error!(?sub.field); // DEBUG:error,-,-,-,-,-,"?sub.field"
    tracing::error!(foo = true, ?sub.field); // DEBUG:error,-,-,p,-,-,"?sub.field"
    tracing::error!(?sub.field, qux = 3); // DEBUG:error,-,-,f,-,-,"?sub.field"
    tracing::error!(foo = true, ?sub.field, qux = 3); // DEBUG:error,-,-,pf,-,-,"?sub.field"
    tracing::error!(?sub.field, "msg without args"); // DEBUG:error,-,-,-,m,-,"?sub.field"
    tracing::error!(foo = true, ?sub.field, "msg without args"); // DEBUG:error,-,-,p,m,-,"?sub.field"
    tracing::error!(?sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,f,m,-,"?sub.field"
    tracing::error!(foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:error,-,-,pf,m,-,"?sub.field"
    tracing::error!({ ?sub.field }, "msg without args"); // DEBUG:error,-,{},-,m,-,"?sub.field"
    tracing::error!({ foo = true, ?sub.field }, "msg without args"); // DEBUG:error,-,{},p,m,-,"?sub.field"
    tracing::error!({ ?sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},f,m,-,"?sub.field"
    tracing::error!({ foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:error,-,{},pf,m,-,"?sub.field"
    tracing::error!(?sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,-,ma,-,"?sub.field"
    tracing::error!(foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:error,-,-,p,ma,-,"?sub.field"
    tracing::error!(?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,f,ma,-,"?sub.field"
    tracing::error!(foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:error,-,-,pf,ma,-,"?sub.field"
    tracing::error!({ ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},-,ma,-,"?sub.field"
    tracing::error!({ foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},p,ma,-,"?sub.field"
    tracing::error!({ ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},f,ma,-,"?sub.field"
    tracing::error!({ foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:error,-,{},pf,ma,-,"?sub.field"
}
