/***************************************************************************
 *	Copyright (C) 2010 by cazou88											*
 *	cazou88@users.sourceforge.net											*
 *																			*
 *	This program is free software; you can redistribute it and/or modify	*
 *	it under the terms of the GNU General Public License as published by	*
 *	the Free Software Foundation; either version 2 of the License, or		*
 *	(at your option) any later version.										*
 *																			*
 *	This program is distributed in the hope that it will be useful,			*
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of			*
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *	GNU General Public License for more details.							*
 *																			*
 *	You should have received a copy of the GNU General Public License		*
 *	along with this program; if not, write to the							*
 *	Free Software Foundation, Inc.,											*
 *	59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.				*
 ***************************************************************************/

#ifndef QUEUE_LIST_MODEL
#define QUEUE_LIST_MODEL

#include <QAbstractItemModel>
#include <QList>
#include <QObject>
#include <qabstractitemmodel.h>  // for QModelIndex, QAbstractItemModel
#include <qlist.h>               // for QList
#include <qnamespace.h>          // for DisplayRole, SortOrder, Orientation
#include <qobjectdefs.h>         // for Q_OBJECT
#include <qstring.h>             // for QString
#include <qvariant.h>            // for QVariant

class PackageListItem;
class QObject;
class QueueListItem;
class QueueListView;

class QueueListModel : public QAbstractItemModel
{
	Q_OBJECT
public:
	QueueListModel(QObject *parent = nullptr);
	~QueueListModel();

	void setPackages(QList<QueueListItem*>&);

	// Declaration of pure virtual methods to be implemented.
	int columnCount(const QModelIndex& parent = QModelIndex()) const override;
	QVariant data(const QModelIndex& index, int role = Qt::DisplayRole) const override;
	QModelIndex index(int row, int column, const QModelIndex& parent = QModelIndex()) const override;
	QModelIndex parent(const QModelIndex& index) const override;
	int rowCount(const QModelIndex& parent = QModelIndex()) const override;
	void sort(int column, Qt::SortOrder order) override;

	// Some virtual methods to reimplement.

	// Used for the header.
	QVariant headerData (int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const override;
	bool hasChildren(const QModelIndex& parent = QModelIndex()) const override;

	QList<QueueListItem*> packages();

	void updateItem(QueueListItem *item, QueueListView *listView);

private:
	QList<QueueListItem*> m_packages;

	static bool packageLessThan(PackageListItem *p1, PackageListItem *p2);
	static bool packageMoreThan(PackageListItem *p1, PackageListItem *p2);
	void sortTree(QList<QueueListItem*> items, Qt::SortOrder order);
};

#endif
