/* ocp.h was originally generated by the autoSql program, which also 
 * generated ocp.c and ocp.sql.  This header links the database and the RAM 
 * representation of objects. */

#ifndef OCP_H
#define OCP_H

struct ocp
/* Information on overlapping clone pair */
    {
    struct ocp *next;  /* Next in singly linked list. */
    char *aName;	/* Name of first clone */
    int aSize;	/* Size of first clone */
    char aHitS;	/* Value Y, N and ? for corresponding end hitting, not hitting and unknown */
    char aHitT;	/* Value Y, N and ? for corresponding end hitting, not hitting and unknown */
    char *bName;	/* Name of second clone */
    int bSize;	/* Size of second clone */
    char bHitS;	/* Value Y, N and ? for corresponding end hitting, not hitting and unknown */
    char bHitT;	/* Value Y, N and ? for corresponding end hitting, not hitting and unknown */
    int overlap;	/* Bases of overlap */
    int reserved;	/* Reserved (always 0 now) */
    };

void ocpStaticLoad(char **row, struct ocp *ret);
/* Load a row from ocp table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct ocp *ocpLoad(char **row);
/* Load a ocp from row fetched with select * from ocp
 * from database.  Dispose of this with ocpFree(). */

void ocpFree(struct ocp **pEl);
/* Free a single dynamically allocated ocp such as created
 * with ocpLoad(). */

void ocpFreeList(struct ocp **pList);
/* Free a list of dynamically allocated ocp's */

void ocpOutput(struct ocp *el, FILE *f, char sep, char lastSep);
/* Print out ocp.  Separate fields with sep. Follow last field with lastSep. */

#define ocpTabOut(el,f) ocpOutput(el,f,'\t','\n');
/* Print out ocp as a line in a tab-separated file. */

#define ocpCommaOut(el,f) ocpOutput(el,f,',',',');
/* Print out ocp as a comma separated list including final comma. */

struct ocp *ocpLoadFile(char *fileName);
/* Load all ocp's from file. */

#endif /* OCP_H */

