table genomicSuperDups
"Summary of large genomic Duplications (>1KB >90% similar)"
  (
  string chrom;       "Reference sequence chromosome or scaffold"
  uint chromStart;   "Start position in chromosome"
  uint chromEnd;     "End position in chromosome"
  string name;         "Other chromosome involved"
  uint score;        "Score based on the raw BLAST alignment score. Set to 0 and not used in later versions."
  char[1] strand;       "Value should be + or -"
  string otherChrom;   "Other chromosome or scaffold"
  uint otherStart;   "Start in other sequence"
  uint otherEnd;     "End in other sequence"
  uint otherSize;    "Total size of other chromosome"
  uint uid;       "Unique id shared by the query and subject"
  uint posBasesHit;       "For future use"
  string testResult;       "For future use"
  string verdict;       "For future use"
  string chits;       "For future use"
  string ccov;       "For future use"
  string alignfile;       "alignment file path"
  uint alignL;       "spaces/positions in alignment"
  uint indelN;       "number of indels"
  uint indelS;       "indel spaces"
  uint alignB;       "bases Aligned"
  uint matchB;       "aligned bases that match"
  uint mismatchB;    "aligned bases that do not match"
  uint transitionsB;    "number of transitions"
  uint transversionsB;    "number of transversions"
  float fracMatch;    "fraction of matching bases"
  float fracMatchIndel;    "fraction of matching bases with indels"
  float jcK;          "K-value calculated with Jukes-Cantor"
  float k2K;          "Kimura K"
  )
