/* scopDes.h was originally generated by the autoSql program, which also 
 * generated scopDes.c and scopDes.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef SCOPDES_H
#define SCOPDES_H

#define SCOPDES_NUM_COLS 5

struct scopDes
/* Structural Classification of Proteins Description. See Lo Conte, Brenner et al. NAR 2002 */
    {
    struct scopDes *next;  /* Next in singly linked list. */
    int sunid;	/* Unique integer */
    char type[3];	/* Type.  sf=superfamily, fa = family, etc. */
    char *sccs;	/* Dense hierarchy info. */
    char *sid;	/* Older ID. */
    char *description;	/* Descriptive text. */
    };

void scopDesStaticLoad(char **row, struct scopDes *ret);
/* Load a row from scopDes table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct scopDes *scopDesLoad(char **row);
/* Load a scopDes from row fetched with select * from scopDes
 * from database.  Dispose of this with scopDesFree(). */

struct scopDes *scopDesLoadAll(char *fileName);
/* Load all scopDes from whitespace-separated file.
 * Dispose of this with scopDesFreeList(). */

struct scopDes *scopDesLoadAllByChar(char *fileName, char chopper);
/* Load all scopDes from chopper separated file.
 * Dispose of this with scopDesFreeList(). */

#define scopDesLoadAllByTab(a) scopDesLoadAllByChar(a, '\t');
/* Load all scopDes from tab separated file.
 * Dispose of this with scopDesFreeList(). */

struct scopDes *scopDesCommaIn(char **pS, struct scopDes *ret);
/* Create a scopDes out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new scopDes */

void scopDesFree(struct scopDes **pEl);
/* Free a single dynamically allocated scopDes such as created
 * with scopDesLoad(). */

void scopDesFreeList(struct scopDes **pList);
/* Free a list of dynamically allocated scopDes's */

void scopDesOutput(struct scopDes *el, FILE *f, char sep, char lastSep);
/* Print out scopDes.  Separate fields with sep. Follow last field with lastSep. */

#define scopDesTabOut(el,f) scopDesOutput(el,f,'\t','\n');
/* Print out scopDes as a line in a tab-separated file. */

#define scopDesCommaOut(el,f) scopDesOutput(el,f,',',',');
/* Print out scopDes as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* SCOPDES_H */

