/* cnpSharp.h was originally generated by the autoSql program, which also 
 * generated cnpSharp.c and cnpSharp.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef CNPSHARP_H
#define CNPSHARP_H

#define CNPSHARP_NUM_COLS 14

struct cnpSharp
/* CNP data from Sharp lab */
    {
    struct cnpSharp *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chrom */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* BAC name */
    char *variationType;	/* Gain, Loss, Gain and Loss */
    char *cytoName;	/* Cytoband */
    char *cytoStrain;	/* gneg, gpos, etc. */
    float dupPercent;	/* 0 to 1 */
    float repeatsPercent;	/* 0 to 1 */
    float LINEpercent;	/* 0 to 1 */
    float SINEpercent;	/* 0 to 1 */
    float LTRpercent;	/* 0 to 1 */
    float DNApercent;	/* 0 to 1 */
    float diseaseSpotsPercent;	/* 0 to 1 */
    };

void cnpSharpStaticLoad(char **row, struct cnpSharp *ret);
/* Load a row from cnpSharp table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cnpSharp *cnpSharpLoad(char **row);
/* Load a cnpSharp from row fetched with select * from cnpSharp
 * from database.  Dispose of this with cnpSharpFree(). */

struct cnpSharp *cnpSharpLoadAll(char *fileName);
/* Load all cnpSharp from whitespace-separated file.
 * Dispose of this with cnpSharpFreeList(). */

struct cnpSharp *cnpSharpLoadAllByChar(char *fileName, char chopper);
/* Load all cnpSharp from chopper separated file.
 * Dispose of this with cnpSharpFreeList(). */

#define cnpSharpLoadAllByTab(a) cnpSharpLoadAllByChar(a, '\t');
/* Load all cnpSharp from tab separated file.
 * Dispose of this with cnpSharpFreeList(). */

struct cnpSharp *cnpSharpCommaIn(char **pS, struct cnpSharp *ret);
/* Create a cnpSharp out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cnpSharp */

void cnpSharpFree(struct cnpSharp **pEl);
/* Free a single dynamically allocated cnpSharp such as created
 * with cnpSharpLoad(). */

void cnpSharpFreeList(struct cnpSharp **pList);
/* Free a list of dynamically allocated cnpSharp's */

void cnpSharpOutput(struct cnpSharp *el, FILE *f, char sep, char lastSep);
/* Print out cnpSharp.  Separate fields with sep. Follow last field with lastSep. */

#define cnpSharpTabOut(el,f) cnpSharpOutput(el,f,'\t','\n');
/* Print out cnpSharp as a line in a tab-separated file. */

#define cnpSharpCommaOut(el,f) cnpSharpOutput(el,f,',',',');
/* Print out cnpSharp as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* CNPSHARP_H */

