/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.servlet.fileset;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileSetCacheStrategy;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.servlet.fileset.FileSetRequestHandler;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerFileCheck
implements FileSetRequestHandler<Set<FileInfo>> {
    public static final String ACTION = "serverFileCheck";
    private final FilesCache filesCache;
    private final FileSetCacheStrategy strategy;

    @Inject
    public ServerFileCheck(FilesCache filesCache, FileSetCacheStrategy strategy) {
        this.filesCache = filesCache;
        this.strategy = strategy;
    }

    @Override
    public Set<FileInfo> handle(SlaveBrowser browser, Collection<FileInfo> clientFiles) {
        return this.strategy.createExpiredFileSet(clientFiles, Sets.newHashSet(this.filesCache.getAllFileInfos()));
    }

    @Override
    public boolean canHandle(String action) {
        return ACTION.equalsIgnoreCase(action);
    }
}

