/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.requesthandlers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.jstestdriver.requesthandlers.HttpMethod;
import com.google.jstestdriver.requesthandlers.NullRequestHandler;
import com.google.jstestdriver.requesthandlers.ProxyRequestHandler;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import com.google.jstestdriver.requesthandlers.RequestMatcher;
import com.google.jstestdriver.server.proxy.JstdProxyServlet;
import com.google.jstestdriver.server.proxy.ProxyServletConfig;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.mortbay.servlet.ProxyServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ProxyConfiguration.class);
    public static final String MATCHER = "matcher";
    public static final String SERVER = "server";
    private final Provider<JstdProxyServlet> proxyProvider;
    private final ProxyServletConfig.Factory servletConfigFactory;
    private final ProxyRequestHandler.Factory handlerFactory;
    private JsonArray proxyConfig = new JsonArray();
    private List<RequestMatcher> matchers;
    private Map<RequestMatcher, JstdProxyServlet> proxyServlets;

    @Inject
    public ProxyConfiguration(Provider<JstdProxyServlet> proxyProvider, ProxyServletConfig.Factory servletConfigFactory, ProxyRequestHandler.Factory handlerFactory) {
        this.proxyProvider = proxyProvider;
        this.servletConfigFactory = servletConfigFactory;
        this.handlerFactory = handlerFactory;
        this.clearConfiguration();
    }

    public synchronized List<RequestMatcher> getMatchers() {
        return this.matchers;
    }

    public synchronized RequestHandler getRequestHandler(RequestMatcher matcher) {
        ProxyServlet.Transparent proxy = this.proxyServlets.get(matcher);
        return proxy == null ? new NullRequestHandler() : this.handlerFactory.create(proxy);
    }

    public synchronized JsonArray getProxyConfig() {
        return this.proxyConfig;
    }

    public synchronized void updateConfiguration(JsonArray configuration) throws ServletException {
        this.proxyConfig = configuration;
        ImmutableList.Builder<RequestMatcher> listBuilder = ImmutableList.builder();
        ImmutableMap.Builder<RequestMatcher, JstdProxyServlet> mapBuilder = ImmutableMap.builder();
        for (JsonElement element : configuration) {
            JstdProxyServlet proxy;
            JsonObject entry = element.getAsJsonObject();
            RequestMatcher matcher = new RequestMatcher(HttpMethod.ANY, entry.get(MATCHER).getAsString());
            ProxyServletConfig config = this.servletConfigFactory.create(matcher.getPrefix(), entry.get(SERVER).getAsString());
            if (this.proxyServlets.get(matcher) != null) {
                logger.debug("Reusing previous proxy bound to {}.", matcher);
                proxy = this.proxyServlets.get(matcher);
            } else {
                logger.debug("Creating new proxy bound to {}.", matcher);
                proxy = this.proxyProvider.get();
            }
            proxy.init(config);
            listBuilder.add(matcher);
            mapBuilder.put(matcher, proxy);
        }
        this.matchers = listBuilder.build();
        this.proxyServlets = mapBuilder.build();
    }

    public synchronized void clearConfiguration() {
        this.matchers = ImmutableList.of();
        this.proxyServlets = ImmutableMap.of();
    }
}

