/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BitVector;
import com.sun.electric.tool.simulation.test.ChainNode;
import com.sun.electric.tool.simulation.test.JtagTester;
import com.sun.electric.tool.simulation.test.LogicSettableArray;

public class MockJtag
extends JtagTester {
    public static final int NUM_OUTPUT_PINS = 3;
    private LogicSettableArray logicOutput = new LogicSettableArray(3);

    public MockJtag() {
        this.setParallelIO(this.logicOutput.getLogicStates());
    }

    @Override
    void configure(float tapVolt, long kiloHerz) {
        this.logSet("MockJTAG configure: set tapVolt=" + tapVolt + ", kiloHerz=" + kiloHerz);
    }

    @Override
    public void reset() {
        this.logSet("MockJTAG reset()");
    }

    @Override
    public void tms_reset() {
        this.logSet("MockJTAG reset()");
    }

    @Override
    void disconnect() {
        this.logSet("MockJTAG disconnect()");
    }

    @Override
    void shift(ChainNode chain2, boolean readEnable, boolean writeEnable, int irBadSeverity) {
        this.logOther("MockJTAG shift: opcode=" + chain2.getOpcode() + "\n " + chain2.getInBits());
        int length = chain2.getLength();
        BitVector outBits = new BitVector(length, "MockJtag.shift().outBits");
        BitVector outBitsExpected = chain2.getOutBitsExpected();
        for (int ibit = 0; ibit < length; ++ibit) {
            if (outBitsExpected.isValid(ibit)) {
                if (!writeEnable) {
                    outBits.set(ibit, outBitsExpected.get(ibit));
                    continue;
                }
                outBits.putIndiscriminate(ibit, chain2.getShadowState().getIndiscriminate(ibit, 1));
                continue;
            }
            outBits.clear(ibit);
        }
        chain2.getOutBits().putIndiscriminate(0, outBits);
    }

    private void setParallelIO(boolean[] newLevel) {
        String msg = "Parallel output state now:";
        for (int ind = 0; ind < newLevel.length; ++ind) {
            msg = msg + " " + newLevel[ind];
        }
        System.out.println(msg);
    }

    @Override
    void setLogicOutput(int index, boolean newLevel) {
        this.logicOutput.setLogicState(index, newLevel);
        this.setParallelIO(this.logicOutput.getLogicStates());
    }
}

