// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Capture Declare Capture
//
// swagger:model capture
type Capture struct {

	// length
	// Required: true
	Length int64 `json:"length"`

	// type
	// Required: true
	// Enum: ["request","response"]
	// +kubebuilder:validation:Enum=request;response;
	Type string `json:"type"`
}

// Validate validates this capture
func (m *Capture) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLength(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Capture) validateLength(formats strfmt.Registry) error {

	if err := validate.Required("length", "body", int64(m.Length)); err != nil {
		return err
	}

	return nil
}

var captureTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["request","response"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		captureTypeTypePropEnum = append(captureTypeTypePropEnum, v)
	}
}

const (

	// CaptureTypeRequest captures enum value "request"
	CaptureTypeRequest string = "request"

	// CaptureTypeResponse captures enum value "response"
	CaptureTypeResponse string = "response"
)

// prop value enum
func (m *Capture) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, captureTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Capture) validateType(formats strfmt.Registry) error {

	if err := validate.RequiredString("type", "body", m.Type); err != nil {
		return err
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this capture based on context it is used
func (m *Capture) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *Capture) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Capture) UnmarshalBinary(b []byte) error {
	var res Capture
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
