// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Balance balance
//
// swagger:model balance
type Balance struct {
	// algorithm
	// Required: true
	// Enum: ["first","hash","hdr","leastconn","random","rdp-cookie","roundrobin","source","static-rr","uri","url_param"]
	// +kubebuilder:validation:Enum=first;hash;hdr;leastconn;random;rdp-cookie;roundrobin;source;static-rr;uri;url_param;
	Algorithm *string `json:"algorithm"`

	// hash expression
	HashExpression string `json:"hash_expression,omitempty"`

	// hdr name
	HdrName string `json:"hdr_name,omitempty"`

	// hdr use domain only
	HdrUseDomainOnly bool `json:"hdr_use_domain_only,omitempty"`

	// random draws
	RandomDraws int64 `json:"random_draws,omitempty"`

	// rdp cookie name
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	RdpCookieName string `json:"rdp_cookie_name,omitempty"`

	// uri depth
	URIDepth int64 `json:"uri_depth,omitempty"`

	// uri len
	URILen int64 `json:"uri_len,omitempty"`

	// uri path only
	URIPathOnly bool `json:"uri_path_only,omitempty"`

	// uri whole
	URIWhole bool `json:"uri_whole,omitempty"`

	// url param
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	URLParam string `json:"url_param,omitempty"`

	// url param check post
	URLParamCheckPost int64 `json:"url_param_check_post,omitempty"`

	// url param max wait
	URLParamMaxWait int64 `json:"url_param_max_wait,omitempty"`
}

// Validate validates this balance
func (m *Balance) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAlgorithm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRdpCookieName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateURLParam(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var balanceTypeAlgorithmPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["first","hash","hdr","leastconn","random","rdp-cookie","roundrobin","source","static-rr","uri","url_param"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		balanceTypeAlgorithmPropEnum = append(balanceTypeAlgorithmPropEnum, v)
	}
}

const (

	// BalanceAlgorithmFirst captures enum value "first"
	BalanceAlgorithmFirst string = "first"

	// BalanceAlgorithmHash captures enum value "hash"
	BalanceAlgorithmHash string = "hash"

	// BalanceAlgorithmHdr captures enum value "hdr"
	BalanceAlgorithmHdr string = "hdr"

	// BalanceAlgorithmLeastconn captures enum value "leastconn"
	BalanceAlgorithmLeastconn string = "leastconn"

	// BalanceAlgorithmRandom captures enum value "random"
	BalanceAlgorithmRandom string = "random"

	// BalanceAlgorithmRdpDashCookie captures enum value "rdp-cookie"
	BalanceAlgorithmRdpDashCookie string = "rdp-cookie"

	// BalanceAlgorithmRoundrobin captures enum value "roundrobin"
	BalanceAlgorithmRoundrobin string = "roundrobin"

	// BalanceAlgorithmSource captures enum value "source"
	BalanceAlgorithmSource string = "source"

	// BalanceAlgorithmStaticDashRr captures enum value "static-rr"
	BalanceAlgorithmStaticDashRr string = "static-rr"

	// BalanceAlgorithmURI captures enum value "uri"
	BalanceAlgorithmURI string = "uri"

	// BalanceAlgorithmURLParam captures enum value "url_param"
	BalanceAlgorithmURLParam string = "url_param"
)

// prop value enum
func (m *Balance) validateAlgorithmEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, balanceTypeAlgorithmPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Balance) validateAlgorithm(formats strfmt.Registry) error {

	if err := validate.Required("algorithm", "body", m.Algorithm); err != nil {
		return err
	}

	// value enum
	if err := m.validateAlgorithmEnum("algorithm", "body", *m.Algorithm); err != nil {
		return err
	}

	return nil
}

func (m *Balance) validateRdpCookieName(formats strfmt.Registry) error {
	if swag.IsZero(m.RdpCookieName) { // not required
		return nil
	}

	if err := validate.Pattern("rdp_cookie_name", "body", m.RdpCookieName, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *Balance) validateURLParam(formats strfmt.Registry) error {
	if swag.IsZero(m.URLParam) { // not required
		return nil
	}

	if err := validate.Pattern("url_param", "body", m.URLParam, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this balance based on context it is used
func (m *Balance) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *Balance) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Balance) UnmarshalBinary(b []byte) error {
	var res Balance
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
