/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include <stdlib.h>
#include "../ballistics.h"
#include "../terrain.h"
#include "funkybomb.h"

Shellstat_bal
wepFunkyGuidance(void *info, struct Projectilepos_bal *prjpos,
		 Shellstat_bal(*initexplosion) (struct Projectilepos_bal *
						prjpos,
						void **explosioninfo),
		 void **explosioninfo)
{
    Shellstat_bal res;
    int ix, iy;
    Player_pl *plhit = NULL;
    Weapon_wep *bs;
    struct Projectilelist_bal *prj;
    int direction, tmp_vx, tmp_vy;

    prjpos->rox = prjpos->ox = prjpos->x;
    prjpos->roy = prjpos->oy = prjpos->y;
    prjpos->x += prjpos->vx;
    prjpos->y += prjpos->vy;
    prjpos->vy -= (bal_grav / bal_lerp_tweak);

    if((res = balEnvironmentAdjustProjPos(prjpos)) != FLYING
       || balCheckIntersect(prjpos->ox, prjpos->oy, prjpos->x, prjpos->y,
			    &plhit, &ix, &iy))
    {

	switch (res)
	{
	    case HOLDING:
		/* wtf ??? */
		break;
	    case FLYING:
		prjpos->x = ix;
		prjpos->y = iy;
		/* fall through */
	    case EXPLODING:

		bs = wepLookupWeapon("Funky Fragment");

		direction = (((unsigned int) (prjpos->vx)) % 2) ? 1 : -1;
		tmp_vx =
		    ((((unsigned int) (prjpos->ox + prjpos->vx)) % VX_RANGE) +
		     MIN_VX) * direction;
		if(!(((unsigned int) (prjpos->ox + prjpos->vy)) % FREAK_CHANCE))
		{
		    tmp_vx *= FREAK_POWER;
		}
		tmp_vy =
		    (((unsigned int) (prjpos->oy + prjpos->vy)) % VY_RANGE) +
		    MIN_VY;
		prj =
		    balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y + 5,
				 tmp_vx, tmp_vy, bs);
		prj->stat = INITSHOT(prj);

		direction = (((unsigned int) (prjpos->vy)) % 2) ? 1 : -1;
		tmp_vx =
		    ((((unsigned int) (prjpos->ox + prjpos->y)) % VX_RANGE) +
		     MIN_VX) * direction;
		if(!(((unsigned int) (prjpos->ox + prjpos->y)) % FREAK_CHANCE))
		{
		    tmp_vx *= FREAK_POWER;
		}
		tmp_vy =
		    (((unsigned int) (prjpos->oy + prjpos->x)) % VY_RANGE) +
		    MIN_VY;
		prj =
		    balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y + 5,
				 tmp_vx, tmp_vy, bs);
		prj->stat = INITSHOT(prj);

		direction = (((unsigned int) (prjpos->x)) % 2) ? 1 : -1;
		tmp_vx =
		    ((((unsigned int) (prjpos->y + prjpos->vx)) % VX_RANGE) +
		     MIN_VX) * direction;
		if(!(((unsigned int) (prjpos->y + prjpos->vx)) % FREAK_CHANCE))
		{
		    tmp_vx *= FREAK_POWER;
		}
		tmp_vy =
		    (((unsigned int) (prjpos->x + prjpos->vy)) % VY_RANGE) +
		    MIN_VY;
		prj =
		    balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y + 5,
				 tmp_vx, tmp_vy, bs);
		prj->stat = INITSHOT(prj);

		direction = (((unsigned int) (prjpos->y)) % 2) ? 1 : -1;
		tmp_vx =
		    ((((unsigned int) (prjpos->vy + prjpos->vx)) % VX_RANGE) +
		     MIN_VX) * direction;
		if(!(((unsigned int) (prjpos->vy + prjpos->vx)) % FREAK_CHANCE))
		{
		    tmp_vx *= FREAK_POWER;
		}
		tmp_vy =
		    (((unsigned int) (prjpos->y + prjpos->x)) % VY_RANGE) +
		    MIN_VY;
		prj =
		    balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y + 5,
				 tmp_vx, tmp_vy, bs);
		prj->stat = INITSHOT(prj);

		direction = (((unsigned int) (prjpos->oy)) % 2) ? 1 : -1;
		tmp_vx =
		    ((((unsigned int) (prjpos->ox + prjpos->x +
				       prjpos->vx)) % VX_RANGE) +
		     MIN_VX) * direction;
		if(!
		   (((unsigned int) (prjpos->ox + prjpos->x +
				     prjpos->vx)) % FREAK_CHANCE))
		{
		    tmp_vx *= FREAK_POWER;
		}
		tmp_vy =
		    (((unsigned int) (prjpos->oy + prjpos->y +
				      prjpos->vy)) % VY_RANGE) + MIN_VY;
		prj =
		    balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y + 5,
				 tmp_vx, tmp_vy, bs);
		prj->stat = INITSHOT(prj);

		direction = (((unsigned int) (prjpos->oy)) % 2) ? 1 : -1;
		tmp_vx =
		    ((((unsigned int) (prjpos->vy + prjpos->vx +
				       prjpos->x)) % VX_RANGE) +
		     MIN_VX) * direction;
		if(!
		   (((unsigned int) (prjpos->vy + prjpos->vx +
				     prjpos->x)) % FREAK_CHANCE))
		{
		    tmp_vx *= FREAK_POWER;
		}
		tmp_vy =
		    (((unsigned int) (prjpos->y + prjpos->ox +
				      prjpos->oy)) % VY_RANGE) + MIN_VY;
		prj =
		    balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y + 5,
				 tmp_vx, tmp_vy, bs);
		prj->stat = INITSHOT(prj);

		direction =
		    (((unsigned int) ((prjpos->oy + prjpos->ox))) % 2) ? 1 : -1;
		tmp_vx =
		    ((((unsigned int) (prjpos->vy + prjpos->vx +
				       prjpos->y)) % VX_RANGE) +
		     MIN_VX) * direction;
		if(!
		   (((unsigned int) (prjpos->vy + prjpos->vx +
				     prjpos->y)) % FREAK_CHANCE))
		{
		    tmp_vx *= FREAK_POWER;
		}
		tmp_vy =
		    (((unsigned int) (prjpos->oy + prjpos->x +
				      prjpos->ox)) % VY_RANGE) + MIN_VY;
		prj =
		    balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y + 5,
				 tmp_vx, tmp_vy, bs);
		prj->stat = INITSHOT(prj);

		return initexplosion(prjpos, explosioninfo);
		break;
	    case FREEING:
		return FREEING;
		break;
	}
    }

    return FLYING;
}
