// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A document to include in a message.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct DocumentBlock {
    /// <p>The format of a document, or its extension.</p>
    pub format: crate::types::DocumentFormat,
    /// <p>A name for the document. The name can only contain the following characters:</p>
    /// <ul>
    /// <li>
    /// <p>Alphanumeric characters</p></li>
    /// <li>
    /// <p>Whitespace characters (no more than one in a row)</p></li>
    /// <li>
    /// <p>Hyphens</p></li>
    /// <li>
    /// <p>Parentheses</p></li>
    /// <li>
    /// <p>Square brackets</p></li>
    /// </ul><note>
    /// <p>This field is vulnerable to prompt injections, because the model might inadvertently interpret it as instructions. Therefore, we recommend that you specify a neutral name.</p>
    /// </note>
    pub name: ::std::string::String,
    /// <p>Contains the content of the document.</p>
    pub source: ::std::option::Option<crate::types::DocumentSource>,
    /// <p>Contextual information about how the document should be processed or interpreted by the model when generating citations.</p>
    pub context: ::std::option::Option<::std::string::String>,
    /// <p>Configuration settings that control how citations should be generated for this specific document.</p>
    pub citations: ::std::option::Option<crate::types::CitationsConfig>,
}
impl DocumentBlock {
    /// <p>The format of a document, or its extension.</p>
    pub fn format(&self) -> &crate::types::DocumentFormat {
        &self.format
    }
    /// <p>A name for the document. The name can only contain the following characters:</p>
    /// <ul>
    /// <li>
    /// <p>Alphanumeric characters</p></li>
    /// <li>
    /// <p>Whitespace characters (no more than one in a row)</p></li>
    /// <li>
    /// <p>Hyphens</p></li>
    /// <li>
    /// <p>Parentheses</p></li>
    /// <li>
    /// <p>Square brackets</p></li>
    /// </ul><note>
    /// <p>This field is vulnerable to prompt injections, because the model might inadvertently interpret it as instructions. Therefore, we recommend that you specify a neutral name.</p>
    /// </note>
    pub fn name(&self) -> &str {
        use std::ops::Deref;
        self.name.deref()
    }
    /// <p>Contains the content of the document.</p>
    pub fn source(&self) -> ::std::option::Option<&crate::types::DocumentSource> {
        self.source.as_ref()
    }
    /// <p>Contextual information about how the document should be processed or interpreted by the model when generating citations.</p>
    pub fn context(&self) -> ::std::option::Option<&str> {
        self.context.as_deref()
    }
    /// <p>Configuration settings that control how citations should be generated for this specific document.</p>
    pub fn citations(&self) -> ::std::option::Option<&crate::types::CitationsConfig> {
        self.citations.as_ref()
    }
}
impl DocumentBlock {
    /// Creates a new builder-style object to manufacture [`DocumentBlock`](crate::types::DocumentBlock).
    pub fn builder() -> crate::types::builders::DocumentBlockBuilder {
        crate::types::builders::DocumentBlockBuilder::default()
    }
}

/// A builder for [`DocumentBlock`](crate::types::DocumentBlock).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct DocumentBlockBuilder {
    pub(crate) format: ::std::option::Option<crate::types::DocumentFormat>,
    pub(crate) name: ::std::option::Option<::std::string::String>,
    pub(crate) source: ::std::option::Option<crate::types::DocumentSource>,
    pub(crate) context: ::std::option::Option<::std::string::String>,
    pub(crate) citations: ::std::option::Option<crate::types::CitationsConfig>,
}
impl DocumentBlockBuilder {
    /// <p>The format of a document, or its extension.</p>
    pub fn format(mut self, input: crate::types::DocumentFormat) -> Self {
        self.format = ::std::option::Option::Some(input);
        self
    }
    /// <p>The format of a document, or its extension.</p>
    pub fn set_format(mut self, input: ::std::option::Option<crate::types::DocumentFormat>) -> Self {
        self.format = input;
        self
    }
    /// <p>The format of a document, or its extension.</p>
    pub fn get_format(&self) -> &::std::option::Option<crate::types::DocumentFormat> {
        &self.format
    }
    /// <p>A name for the document. The name can only contain the following characters:</p>
    /// <ul>
    /// <li>
    /// <p>Alphanumeric characters</p></li>
    /// <li>
    /// <p>Whitespace characters (no more than one in a row)</p></li>
    /// <li>
    /// <p>Hyphens</p></li>
    /// <li>
    /// <p>Parentheses</p></li>
    /// <li>
    /// <p>Square brackets</p></li>
    /// </ul><note>
    /// <p>This field is vulnerable to prompt injections, because the model might inadvertently interpret it as instructions. Therefore, we recommend that you specify a neutral name.</p>
    /// </note>
    /// This field is required.
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A name for the document. The name can only contain the following characters:</p>
    /// <ul>
    /// <li>
    /// <p>Alphanumeric characters</p></li>
    /// <li>
    /// <p>Whitespace characters (no more than one in a row)</p></li>
    /// <li>
    /// <p>Hyphens</p></li>
    /// <li>
    /// <p>Parentheses</p></li>
    /// <li>
    /// <p>Square brackets</p></li>
    /// </ul><note>
    /// <p>This field is vulnerable to prompt injections, because the model might inadvertently interpret it as instructions. Therefore, we recommend that you specify a neutral name.</p>
    /// </note>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>A name for the document. The name can only contain the following characters:</p>
    /// <ul>
    /// <li>
    /// <p>Alphanumeric characters</p></li>
    /// <li>
    /// <p>Whitespace characters (no more than one in a row)</p></li>
    /// <li>
    /// <p>Hyphens</p></li>
    /// <li>
    /// <p>Parentheses</p></li>
    /// <li>
    /// <p>Square brackets</p></li>
    /// </ul><note>
    /// <p>This field is vulnerable to prompt injections, because the model might inadvertently interpret it as instructions. Therefore, we recommend that you specify a neutral name.</p>
    /// </note>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// <p>Contains the content of the document.</p>
    /// This field is required.
    pub fn source(mut self, input: crate::types::DocumentSource) -> Self {
        self.source = ::std::option::Option::Some(input);
        self
    }
    /// <p>Contains the content of the document.</p>
    pub fn set_source(mut self, input: ::std::option::Option<crate::types::DocumentSource>) -> Self {
        self.source = input;
        self
    }
    /// <p>Contains the content of the document.</p>
    pub fn get_source(&self) -> &::std::option::Option<crate::types::DocumentSource> {
        &self.source
    }
    /// <p>Contextual information about how the document should be processed or interpreted by the model when generating citations.</p>
    pub fn context(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.context = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Contextual information about how the document should be processed or interpreted by the model when generating citations.</p>
    pub fn set_context(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.context = input;
        self
    }
    /// <p>Contextual information about how the document should be processed or interpreted by the model when generating citations.</p>
    pub fn get_context(&self) -> &::std::option::Option<::std::string::String> {
        &self.context
    }
    /// <p>Configuration settings that control how citations should be generated for this specific document.</p>
    pub fn citations(mut self, input: crate::types::CitationsConfig) -> Self {
        self.citations = ::std::option::Option::Some(input);
        self
    }
    /// <p>Configuration settings that control how citations should be generated for this specific document.</p>
    pub fn set_citations(mut self, input: ::std::option::Option<crate::types::CitationsConfig>) -> Self {
        self.citations = input;
        self
    }
    /// <p>Configuration settings that control how citations should be generated for this specific document.</p>
    pub fn get_citations(&self) -> &::std::option::Option<crate::types::CitationsConfig> {
        &self.citations
    }
    /// Consumes the builder and constructs a [`DocumentBlock`](crate::types::DocumentBlock).
    /// This method will fail if any of the following fields are not set:
    /// - [`name`](crate::types::builders::DocumentBlockBuilder::name)
    pub fn build(self) -> ::std::result::Result<crate::types::DocumentBlock, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::DocumentBlock {
            format: self
                .format
                .unwrap_or("txt".parse::<crate::types::DocumentFormat>().expect("static value validated to member")),
            name: self.name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "name",
                    "name was not specified but it is required when building DocumentBlock",
                )
            })?,
            source: self.source,
            context: self.context,
            citations: self.citations,
        })
    }
}
