#include <map>
#include <string>

#include <wayfire/core.hpp>
#include <wayfire/util.hpp>
#include <wayfire/view.hpp>
#include <wayfire/object.hpp>
#include <wayfire/plugin.hpp>
#include <wayfire/toplevel.hpp>
#include <wayfire/toplevel-view.hpp>
#include <wayfire/window-manager.hpp>
#include <wayfire/signal-definitions.hpp>
#include <wayfire/nonstd/wlroots-full.hpp>

class wayfire_focus_request : public wf::plugin_interface_t {
    wf::signal::connection_t<wf::view_focus_request_signal> onFocusRequested {
        [ = ] (wf::view_focus_request_signal *ev) {
            /** Worry about this only if it's a toplevel */
            if ( wf::toplevel_cast( ev->view ) == nullptr ) {
                return;
            }

            /** Cast it into a toplevel object */
            auto toplevel = wf::toplevel_cast( ev->view );

            /** We're interested only in */
            if ( ev->self_request and not ev->carried_out ) {
                LOGI( "Recieved focus request. ", toplevel->get_app_id() );
                /** Grant it focus automatically, or just highlight it? */
                wf::option_wrapper_t<bool> auto_focus{ "focus-request/auto_grant_focus" };

                /** If the request is to be granted without ado, let's do that */
                if ( auto_focus.value() ) {
                    LOGI( "Granting focus ", toplevel->get_app_id() );
                    wf::get_core().default_wm->focus_request( toplevel );
                }

                /** We will translate this to a view_hints_changed_signal */
                else {
                    LOGW( "Setting demands-attention hint ", toplevel->get_app_id() );
                    wf::view_hints_changed_signal hints_signal;
                    hints_signal.view = ev->view;
                    hints_signal.demands_attention = true;
                    ev->view->emit( &hints_signal );
                    wf::get_core().emit( &hints_signal );
                }
            }
        }
    };

    public:
        void init() override {
            wf::get_core().connect( &onFocusRequested );
        }

        bool is_unloadable() override {
            return true;
        }

        void fini() override {
            wf::get_core().disconnect( &onFocusRequested );
        }
};

DECLARE_WAYFIRE_PLUGIN( wayfire_focus_request );
