// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlplogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/logs/v1"
)

func CopyOrigLogRecordSlice(dest, src []*otlplogs.LogRecord) []*otlplogs.LogRecord {
	var newDest []*otlplogs.LogRecord
	if cap(dest) < len(src) {
		newDest = make([]*otlplogs.LogRecord, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigLogRecord()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigLogRecord(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigLogRecord()
		}
	}
	for i := range src {
		CopyOrigLogRecord(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestLogRecordSlice() []*otlplogs.LogRecord {
	orig := make([]*otlplogs.LogRecord, 5)
	orig[0] = NewOrigLogRecord()
	orig[1] = GenTestOrigLogRecord()
	orig[2] = NewOrigLogRecord()
	orig[3] = GenTestOrigLogRecord()
	orig[4] = NewOrigLogRecord()
	return orig
}
