.TH ITVal n
.SH NAME
ITVal \- iptables analysis engine
.SH SYNOPSIS
.B ITVal
[ options ]
.SH DESCRIPTION
.| ITVal
ITVal is a firewall analysis tool that provides answers to user specified 
queries about an iptables firewall or firewall system.
Unlike many other firewall testing tools, ITVal uses offline analysis of 
the firewall policy file.  To generate inputs to ITVal, you can simply use
the commands 
.PP 
.B iptables -L -v \> filter.out
.PP 
and
.PP 
.B iptables -t nat -L -v \> nat.out
.PP 
to create the necessary input files.  You will also need to create a
topology file.  The topology file lists the network interfaces on the
firewall box one per line and specifies the IP address assigned to that
interface.
.SH OPTIONS
.PP
.B -F <filterfileX>
.PP
Specifies the filter table input file to use for firewall host X.
.PP
.B -N <natfileX>
.PP
Specifies the NAT table input file to use for firewall host X.
.PP
.B -t <topologyfileX>
.PP
Specifies the Topology input file to use for firewall host X.
.PP
.B -q <queryfile>
.PP
Specifies a file containing a list of queries to process against the
firewall or firewall system.

.SH QUERIES
Queries are saved in a query file which is used as input to the tool.
The queries are of the form:

.PP 
QUERY <subject> <predicate>;

.PP 
The subject tells ITVal what information to print about packets that match the
query conditions.  The predicate provides a list of criteria that are used to
specify the packets to consider.

.SH QUERY SUBJECTS
The following query subjects are allowed:
.PP 
.B SADDY - Source Address
.PP
.B DADDY - Destination Address
.PP
.B SPORT - Source Port
.PP
.B DPORT - Destination Port
.PP
.B STATE - Connection State
.PP
.B CLASSES - Firewall-equivalent host lists.
.PP
.B SCLASSES - Firewall-equivalent service lists.
.PP

The CLASSES and SCLASSES queries are special queries that generate a list of
firewall-equivalent hosts and services.  Each set in the list represents a
class of hosts or services that are treated identically by the firewall system.
These special queries requires no predicate and are described below.

.SH QUERY PREDICATES
The query predicate is built from eleven simple primitives:
.PP
.B ACCEPTED <input_chain> - Accepted packets for a particular chain.
.PP
.B DROPPED <input_chain> - Discarded packets for a particular chain.
.PP 
.B FROM <alist> - matches packets from the addresses in <alist>. 
.PP 
.B TO <alist> - matches packets to the addresses in <alist>.
.PP 
.B ON <plist> - matches packets from the source ports in <plist>.
.PP 
.B FOR <plist> - matches packets for the destination ports in <plist>.
.PP 
.B IN <states> - matches packets associated with any connection state in
.PP 
<states>.
.PP
.B INFACE <interface> - matches packets incoming on a particular network interface
.PP
.B OUTFACE <interface> - matches packets outgoing on a particular network interface
.PP 
.B WITH <flags> - matches TCP packets that have the flags in <flags> set
to true.
.PP 
.B LOGGED - matches packets for which a LOG rule exists in the rule set.

These packets may or may not actually be logged by the firewall
depending on certain external criteria such as rate limiting, etc.

.PP 
Queries may be combined using the NOT, AND, and OR operators.

.SH INPUT CHAINS
iptables uses three built-in chains to organize firewall rules.  The
INPUT chain represents packets that are inbound to the firewall host.
The OUTPUT chain represents packets generated by the firewall host to
the outside world.  The FORWARD chain represents packets that pass
through the firewall host, but are forwarded to other systems. 
.PP 
When considering systems of multiple firewalls, ITval views the entire
system as a meta-firewall.  The INPUT chain of the meta-firewall
handles all packets inbound to the innermost firewall (i.e. the one
specified last on the command line) that pass through all of the other
firewall hosts.  The OUTPUT chain of the meta-firewall handles all
packets outbound from the innermost firewall that pass through all of
the other firewall hosts.  The FORWARD chain handles packets that pass
through all of the firewall hosts in either direction.

.SH ADDRESS LISTS

An address list consists of a numeric IP address in dot notation, a set
of numeric IP addresses specified using wildcards, or a user defined
address group name.

.SH PORT LISTS

A port list consists of a protocol name followed by a port number, a
protocol name followed by a wildcard, or a user defined service group
name.  Permitted protocols are ICMP, UDP, TCP, and BOTH.  The BOTH
keyword is equivalent to specifying both TCP and UDP.

.SH DEFINING GROUPS
ITVal allows the user to define sets of addresses and sets of ports for
use in multiple queries.  To define a group, use the syntax:

.PP 
GROUP <name> { <address1> ... <addressN> }
.PP 
to define a group of addresses.  Or use:

.PP 
SERVICE <name> { <protocol1> <port1> ... <protocolN> <portN> }
.PP 
to define a group of ports.

.SH HOST AND SERVICE CLASSES
ITVal also provides two special queries that print a description of the
network topology from a firewall's point of view.  These queries have
the syntax:
.PP
QUERY CLASSES:
.PP
QUERY SCLASSES;
.PP
The CLASSES query divides network hosts into distinct groups based on
how the firewall treats packets from and to those hosts.  If two hosts
are in the same group, they will be able to access identical services on
the same destination hosts under identical conditions.  This can be
useful for detecting anomalies in the firewall configuration.  For
instance if you web server appears in the same group as a machine from
outside your network, it is likely you have a typo in your firewall
configuration.

The SCLASSES query divides the provided services into groups based on
how the firewall treats packets with those services.  If two services
can be used to access the same hosts under the same conditions, they
will appear in the same service class.  Service classes can be also be
used for anomaly detection.

.SH ASSERTIONS

The ASSERT keyword is similar to the QUERY keyword, but allows the user to
compare two conditions for equality or containment.  Assertions are of the form:
.PP
ASSERT [EXAMPLE] <condition1> <operator> <condition2>;

where condition1 and condition2 are constructed just as for queries and the
operator can be either IS or SUBSET OF.  The optional keyword EXAMPLE
will cause ITVal to generate a witness (a packet that honors the
assertion) or counter-example(a packet that illustrates why the
assertion failed).

.SH SEE ALSO
.PP
iptables(8)
.PP
Freenix '05: An Automated Technique for iptables Firewall Analysis
.PP
LISA '05: An Open-Source Solution for Testing NAT'd and Nested iptables Firewalls
.PP
LISA '06: Firewall Analysis with Policy-Based Host Classification
.PP
;Login: The Usenix Magazine: Debugging Firewalls with Policy-Mapping, Feb. 6, 2007
.PP
The ITVal web site located at http://itval.sourceforge.net
.PP
