package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveTaskForUpdatingRegistrantInfoByRegistrantProfileID invokes the domain.SaveTaskForUpdatingRegistrantInfoByRegistrantProfileID API synchronously
func (client *Client) SaveTaskForUpdatingRegistrantInfoByRegistrantProfileID(request *SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDRequest) (response *SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDResponse, err error) {
	response = CreateSaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDResponse()
	err = client.DoAction(request, response)
	return
}

// SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDWithChan invokes the domain.SaveTaskForUpdatingRegistrantInfoByRegistrantProfileID API asynchronously
func (client *Client) SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDWithChan(request *SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDRequest) (<-chan *SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDResponse, <-chan error) {
	responseChan := make(chan *SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveTaskForUpdatingRegistrantInfoByRegistrantProfileID(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDWithCallback invokes the domain.SaveTaskForUpdatingRegistrantInfoByRegistrantProfileID API asynchronously
func (client *Client) SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDWithCallback(request *SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDRequest, callback func(response *SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDResponse
		var err error
		defer close(result)
		response, err = client.SaveTaskForUpdatingRegistrantInfoByRegistrantProfileID(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDRequest is the request struct for api SaveTaskForUpdatingRegistrantInfoByRegistrantProfileID
type SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDRequest struct {
	*requests.RpcRequest
	RegistrantProfileId   requests.Integer `position:"Query" name:"RegistrantProfileId"`
	DomainName            *[]string        `position:"Query" name:"DomainName"  type:"Repeated"`
	TransferOutProhibited requests.Boolean `position:"Query" name:"TransferOutProhibited"`
	UserClientIp          string           `position:"Query" name:"UserClientIp"`
	Lang                  string           `position:"Query" name:"Lang"`
}

// SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDResponse is the response struct for api SaveTaskForUpdatingRegistrantInfoByRegistrantProfileID
type SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskNo    string `json:"TaskNo" xml:"TaskNo"`
}

// CreateSaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDRequest creates a request to invoke SaveTaskForUpdatingRegistrantInfoByRegistrantProfileID API
func CreateSaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDRequest() (request *SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDRequest) {
	request = &SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "SaveTaskForUpdatingRegistrantInfoByRegistrantProfileID", "", "")
	request.Method = requests.POST
	return
}

// CreateSaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDResponse creates a response to parse from SaveTaskForUpdatingRegistrantInfoByRegistrantProfileID response
func CreateSaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDResponse() (response *SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDResponse) {
	response = &SaveTaskForUpdatingRegistrantInfoByRegistrantProfileIDResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
