package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNodeCode invokes the dataworks_public.GetNodeCode API synchronously
func (client *Client) GetNodeCode(request *GetNodeCodeRequest) (response *GetNodeCodeResponse, err error) {
	response = CreateGetNodeCodeResponse()
	err = client.DoAction(request, response)
	return
}

// GetNodeCodeWithChan invokes the dataworks_public.GetNodeCode API asynchronously
func (client *Client) GetNodeCodeWithChan(request *GetNodeCodeRequest) (<-chan *GetNodeCodeResponse, <-chan error) {
	responseChan := make(chan *GetNodeCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNodeCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNodeCodeWithCallback invokes the dataworks_public.GetNodeCode API asynchronously
func (client *Client) GetNodeCodeWithCallback(request *GetNodeCodeRequest, callback func(response *GetNodeCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNodeCodeResponse
		var err error
		defer close(result)
		response, err = client.GetNodeCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNodeCodeRequest is the request struct for api GetNodeCode
type GetNodeCodeRequest struct {
	*requests.RpcRequest
	ProjectEnv string           `position:"Body" name:"ProjectEnv"`
	NodeId     requests.Integer `position:"Body" name:"NodeId"`
}

// GetNodeCodeResponse is the response struct for api GetNodeCode
type GetNodeCodeResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           string `json:"Data" xml:"Data"`
}

// CreateGetNodeCodeRequest creates a request to invoke GetNodeCode API
func CreateGetNodeCodeRequest() (request *GetNodeCodeRequest) {
	request = &GetNodeCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetNodeCode", "", "")
	request.Method = requests.POST
	return
}

// CreateGetNodeCodeResponse creates a response to parse from GetNodeCode response
func CreateGetNodeCodeResponse() (response *GetNodeCodeResponse) {
	response = &GetNodeCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
