package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateView invokes the dataworks_public.CreateView API synchronously
func (client *Client) CreateView(request *CreateViewRequest) (response *CreateViewResponse, err error) {
	response = CreateCreateViewResponse()
	err = client.DoAction(request, response)
	return
}

// CreateViewWithChan invokes the dataworks_public.CreateView API asynchronously
func (client *Client) CreateViewWithChan(request *CreateViewRequest) (<-chan *CreateViewResponse, <-chan error) {
	responseChan := make(chan *CreateViewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateView(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateViewWithCallback invokes the dataworks_public.CreateView API asynchronously
func (client *Client) CreateViewWithCallback(request *CreateViewRequest, callback func(response *CreateViewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateViewResponse
		var err error
		defer close(result)
		response, err = client.CreateView(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateViewRequest is the request struct for api CreateView
type CreateViewRequest struct {
	*requests.RpcRequest
	ViewName        string                  `position:"Body" name:"ViewName"`
	ClientToken     string                  `position:"Body" name:"ClientToken"`
	SelectSQL       string                  `position:"Body" name:"SelectSQL"`
	SelectWhere     string                  `position:"Body" name:"SelectWhere"`
	SelectTableName string                  `position:"Body" name:"SelectTableName"`
	Comment         string                  `position:"Body" name:"Comment"`
	SelectColumn    string                  `position:"Body" name:"SelectColumn"`
	AppGuid         string                  `position:"Body" name:"AppGuid"`
	ViewColumn      *[]CreateViewViewColumn `position:"Body" name:"ViewColumn"  type:"Repeated"`
}

// CreateViewViewColumn is a repeated param struct in CreateViewRequest
type CreateViewViewColumn struct {
	Comment    string `name:"Comment"`
	ColumnName string `name:"ColumnName"`
}

// CreateViewResponse is the response struct for api CreateView
type CreateViewResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	TaskInfo  TaskInfo `json:"TaskInfo" xml:"TaskInfo"`
}

// CreateCreateViewRequest creates a request to invoke CreateView API
func CreateCreateViewRequest() (request *CreateViewRequest) {
	request = &CreateViewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CreateView", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateViewResponse creates a response to parse from CreateView response
func CreateCreateViewResponse() (response *CreateViewResponse) {
	response = &CreateViewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
