package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterAddonsUpgradeStatus invokes the cs.DescribeClusterAddonsUpgradeStatus API synchronously
func (client *Client) DescribeClusterAddonsUpgradeStatus(request *DescribeClusterAddonsUpgradeStatusRequest) (response *DescribeClusterAddonsUpgradeStatusResponse, err error) {
	response = CreateDescribeClusterAddonsUpgradeStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterAddonsUpgradeStatusWithChan invokes the cs.DescribeClusterAddonsUpgradeStatus API asynchronously
func (client *Client) DescribeClusterAddonsUpgradeStatusWithChan(request *DescribeClusterAddonsUpgradeStatusRequest) (<-chan *DescribeClusterAddonsUpgradeStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterAddonsUpgradeStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterAddonsUpgradeStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterAddonsUpgradeStatusWithCallback invokes the cs.DescribeClusterAddonsUpgradeStatus API asynchronously
func (client *Client) DescribeClusterAddonsUpgradeStatusWithCallback(request *DescribeClusterAddonsUpgradeStatusRequest, callback func(response *DescribeClusterAddonsUpgradeStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterAddonsUpgradeStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterAddonsUpgradeStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterAddonsUpgradeStatusRequest is the request struct for api DescribeClusterAddonsUpgradeStatus
type DescribeClusterAddonsUpgradeStatusRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Path" name:"ClusterId"`
}

// DescribeClusterAddonsUpgradeStatusResponse is the response struct for api DescribeClusterAddonsUpgradeStatus
type DescribeClusterAddonsUpgradeStatusResponse struct {
	*responses.BaseResponse
}

// CreateDescribeClusterAddonsUpgradeStatusRequest creates a request to invoke DescribeClusterAddonsUpgradeStatus API
func CreateDescribeClusterAddonsUpgradeStatusRequest() (request *DescribeClusterAddonsUpgradeStatusRequest) {
	request = &DescribeClusterAddonsUpgradeStatusRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "DescribeClusterAddonsUpgradeStatus", "/clusters/[ClusterId]/components/upgradestatus", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeClusterAddonsUpgradeStatusResponse creates a response to parse from DescribeClusterAddonsUpgradeStatus response
func CreateDescribeClusterAddonsUpgradeStatusResponse() (response *DescribeClusterAddonsUpgradeStatusResponse) {
	response = &DescribeClusterAddonsUpgradeStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
