package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAggregateResourceComplianceByPack invokes the config.GetAggregateResourceComplianceByPack API synchronously
func (client *Client) GetAggregateResourceComplianceByPack(request *GetAggregateResourceComplianceByPackRequest) (response *GetAggregateResourceComplianceByPackResponse, err error) {
	response = CreateGetAggregateResourceComplianceByPackResponse()
	err = client.DoAction(request, response)
	return
}

// GetAggregateResourceComplianceByPackWithChan invokes the config.GetAggregateResourceComplianceByPack API asynchronously
func (client *Client) GetAggregateResourceComplianceByPackWithChan(request *GetAggregateResourceComplianceByPackRequest) (<-chan *GetAggregateResourceComplianceByPackResponse, <-chan error) {
	responseChan := make(chan *GetAggregateResourceComplianceByPackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAggregateResourceComplianceByPack(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAggregateResourceComplianceByPackWithCallback invokes the config.GetAggregateResourceComplianceByPack API asynchronously
func (client *Client) GetAggregateResourceComplianceByPackWithCallback(request *GetAggregateResourceComplianceByPackRequest, callback func(response *GetAggregateResourceComplianceByPackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAggregateResourceComplianceByPackResponse
		var err error
		defer close(result)
		response, err = client.GetAggregateResourceComplianceByPack(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAggregateResourceComplianceByPackRequest is the request struct for api GetAggregateResourceComplianceByPack
type GetAggregateResourceComplianceByPackRequest struct {
	*requests.RpcRequest
	AggregatorId     string `position:"Query" name:"AggregatorId"`
	CompliancePackId string `position:"Query" name:"CompliancePackId"`
}

// GetAggregateResourceComplianceByPackResponse is the response struct for api GetAggregateResourceComplianceByPack
type GetAggregateResourceComplianceByPackResponse struct {
	*responses.BaseResponse
	RequestId                string                   `json:"RequestId" xml:"RequestId"`
	ResourceComplianceResult ResourceComplianceResult `json:"ResourceComplianceResult" xml:"ResourceComplianceResult"`
}

// CreateGetAggregateResourceComplianceByPackRequest creates a request to invoke GetAggregateResourceComplianceByPack API
func CreateGetAggregateResourceComplianceByPackRequest() (request *GetAggregateResourceComplianceByPackRequest) {
	request = &GetAggregateResourceComplianceByPackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetAggregateResourceComplianceByPack", "", "")
	request.Method = requests.GET
	return
}

// CreateGetAggregateResourceComplianceByPackResponse creates a response to parse from GetAggregateResourceComplianceByPack response
func CreateGetAggregateResourceComplianceByPackResponse() (response *GetAggregateResourceComplianceByPackResponse) {
	response = &GetAggregateResourceComplianceByPackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
