package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEslDevice invokes the cloudesl.DescribeEslDevice API synchronously
func (client *Client) DescribeEslDevice(request *DescribeEslDeviceRequest) (response *DescribeEslDeviceResponse, err error) {
	response = CreateDescribeEslDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEslDeviceWithChan invokes the cloudesl.DescribeEslDevice API asynchronously
func (client *Client) DescribeEslDeviceWithChan(request *DescribeEslDeviceRequest) (<-chan *DescribeEslDeviceResponse, <-chan error) {
	responseChan := make(chan *DescribeEslDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEslDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEslDeviceWithCallback invokes the cloudesl.DescribeEslDevice API asynchronously
func (client *Client) DescribeEslDeviceWithCallback(request *DescribeEslDeviceRequest, callback func(response *DescribeEslDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEslDeviceResponse
		var err error
		defer close(result)
		response, err = client.DescribeEslDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEslDeviceRequest is the request struct for api DescribeEslDevice
type DescribeEslDeviceRequest struct {
	*requests.RpcRequest
	StoreId    string           `position:"Body" name:"StoreId"`
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	FromDate   string           `position:"Body" name:"FromDate"`
	ToDate     string           `position:"Body" name:"ToDate"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
}

// DescribeEslDeviceResponse is the response struct for api DescribeEslDevice
type DescribeEslDeviceResponse struct {
	*responses.BaseResponse
	TotalCount int64        `json:"TotalCount" xml:"TotalCount"`
	PageSize   int64        `json:"PageSize" xml:"PageSize"`
	RequestId  string       `json:"RequestId" xml:"RequestId"`
	PageNumber int64        `json:"PageNumber" xml:"PageNumber"`
	Success    bool         `json:"Success" xml:"Success"`
	EslDetails []EslDetails `json:"EslDetails" xml:"EslDetails"`
}

// CreateDescribeEslDeviceRequest creates a request to invoke DescribeEslDevice API
func CreateDescribeEslDeviceRequest() (request *DescribeEslDeviceRequest) {
	request = &DescribeEslDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "DescribeEslDevice", "cloudesl", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEslDeviceResponse creates a response to parse from DescribeEslDevice response
func CreateDescribeEslDeviceResponse() (response *DescribeEslDeviceResponse) {
	response = &DescribeEslDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
