package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSkillGroupSummaryReportsByInterval invokes the cloudcallcenter.ListSkillGroupSummaryReportsByInterval API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listskillgroupsummaryreportsbyinterval.html
func (client *Client) ListSkillGroupSummaryReportsByInterval(request *ListSkillGroupSummaryReportsByIntervalRequest) (response *ListSkillGroupSummaryReportsByIntervalResponse, err error) {
	response = CreateListSkillGroupSummaryReportsByIntervalResponse()
	err = client.DoAction(request, response)
	return
}

// ListSkillGroupSummaryReportsByIntervalWithChan invokes the cloudcallcenter.ListSkillGroupSummaryReportsByInterval API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listskillgroupsummaryreportsbyinterval.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListSkillGroupSummaryReportsByIntervalWithChan(request *ListSkillGroupSummaryReportsByIntervalRequest) (<-chan *ListSkillGroupSummaryReportsByIntervalResponse, <-chan error) {
	responseChan := make(chan *ListSkillGroupSummaryReportsByIntervalResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSkillGroupSummaryReportsByInterval(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSkillGroupSummaryReportsByIntervalWithCallback invokes the cloudcallcenter.ListSkillGroupSummaryReportsByInterval API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listskillgroupsummaryreportsbyinterval.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListSkillGroupSummaryReportsByIntervalWithCallback(request *ListSkillGroupSummaryReportsByIntervalRequest, callback func(response *ListSkillGroupSummaryReportsByIntervalResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSkillGroupSummaryReportsByIntervalResponse
		var err error
		defer close(result)
		response, err = client.ListSkillGroupSummaryReportsByInterval(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSkillGroupSummaryReportsByIntervalRequest is the request struct for api ListSkillGroupSummaryReportsByInterval
type ListSkillGroupSummaryReportsByIntervalRequest struct {
	*requests.RpcRequest
	IntervalType  string           `position:"Query" name:"IntervalType"`
	EndTime       string           `position:"Query" name:"EndTime"`
	StartTime     string           `position:"Query" name:"StartTime"`
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	Agents        string           `position:"Query" name:"Agents"`
	InstanceId    string           `position:"Query" name:"InstanceId"`
	SkillGroupIds string           `position:"Query" name:"SkillGroupIds"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
}

// ListSkillGroupSummaryReportsByIntervalResponse is the response struct for api ListSkillGroupSummaryReportsByInterval
type ListSkillGroupSummaryReportsByIntervalResponse struct {
	*responses.BaseResponse
	RequestId      string                                       `json:"RequestId" xml:"RequestId"`
	Success        bool                                         `json:"Success" xml:"Success"`
	Code           string                                       `json:"Code" xml:"Code"`
	Message        string                                       `json:"Message" xml:"Message"`
	HttpStatusCode int                                          `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           DataInListSkillGroupSummaryReportsByInterval `json:"Data" xml:"Data"`
}

// CreateListSkillGroupSummaryReportsByIntervalRequest creates a request to invoke ListSkillGroupSummaryReportsByInterval API
func CreateListSkillGroupSummaryReportsByIntervalRequest() (request *ListSkillGroupSummaryReportsByIntervalRequest) {
	request = &ListSkillGroupSummaryReportsByIntervalRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListSkillGroupSummaryReportsByInterval", "", "")
	request.Method = requests.POST
	return
}

// CreateListSkillGroupSummaryReportsByIntervalResponse creates a response to parse from ListSkillGroupSummaryReportsByInterval response
func CreateListSkillGroupSummaryReportsByIntervalResponse() (response *ListSkillGroupSummaryReportsByIntervalResponse) {
	response = &ListSkillGroupSummaryReportsByIntervalResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
