package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssignContactFlowToPhoneNumber invokes the cloudcallcenter.AssignContactFlowToPhoneNumber API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/assigncontactflowtophonenumber.html
func (client *Client) AssignContactFlowToPhoneNumber(request *AssignContactFlowToPhoneNumberRequest) (response *AssignContactFlowToPhoneNumberResponse, err error) {
	response = CreateAssignContactFlowToPhoneNumberResponse()
	err = client.DoAction(request, response)
	return
}

// AssignContactFlowToPhoneNumberWithChan invokes the cloudcallcenter.AssignContactFlowToPhoneNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/assigncontactflowtophonenumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AssignContactFlowToPhoneNumberWithChan(request *AssignContactFlowToPhoneNumberRequest) (<-chan *AssignContactFlowToPhoneNumberResponse, <-chan error) {
	responseChan := make(chan *AssignContactFlowToPhoneNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssignContactFlowToPhoneNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssignContactFlowToPhoneNumberWithCallback invokes the cloudcallcenter.AssignContactFlowToPhoneNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/assigncontactflowtophonenumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AssignContactFlowToPhoneNumberWithCallback(request *AssignContactFlowToPhoneNumberRequest, callback func(response *AssignContactFlowToPhoneNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssignContactFlowToPhoneNumberResponse
		var err error
		defer close(result)
		response, err = client.AssignContactFlowToPhoneNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssignContactFlowToPhoneNumberRequest is the request struct for api AssignContactFlowToPhoneNumber
type AssignContactFlowToPhoneNumberRequest struct {
	*requests.RpcRequest
	ContactFlowId string `position:"Query" name:"ContactFlowId"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	PhoneNumberId string `position:"Query" name:"PhoneNumberId"`
}

// AssignContactFlowToPhoneNumberResponse is the response struct for api AssignContactFlowToPhoneNumber
type AssignContactFlowToPhoneNumberResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateAssignContactFlowToPhoneNumberRequest creates a request to invoke AssignContactFlowToPhoneNumber API
func CreateAssignContactFlowToPhoneNumberRequest() (request *AssignContactFlowToPhoneNumberRequest) {
	request = &AssignContactFlowToPhoneNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "AssignContactFlowToPhoneNumber", "", "")
	request.Method = requests.POST
	return
}

// CreateAssignContactFlowToPhoneNumberResponse creates a response to parse from AssignContactFlowToPhoneNumber response
func CreateAssignContactFlowToPhoneNumberResponse() (response *AssignContactFlowToPhoneNumberResponse) {
	response = &AssignContactFlowToPhoneNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
