package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetResellerUserQuota invokes the bssopenapi.SetResellerUserQuota API synchronously
func (client *Client) SetResellerUserQuota(request *SetResellerUserQuotaRequest) (response *SetResellerUserQuotaResponse, err error) {
	response = CreateSetResellerUserQuotaResponse()
	err = client.DoAction(request, response)
	return
}

// SetResellerUserQuotaWithChan invokes the bssopenapi.SetResellerUserQuota API asynchronously
func (client *Client) SetResellerUserQuotaWithChan(request *SetResellerUserQuotaRequest) (<-chan *SetResellerUserQuotaResponse, <-chan error) {
	responseChan := make(chan *SetResellerUserQuotaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetResellerUserQuota(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetResellerUserQuotaWithCallback invokes the bssopenapi.SetResellerUserQuota API asynchronously
func (client *Client) SetResellerUserQuotaWithCallback(request *SetResellerUserQuotaRequest, callback func(response *SetResellerUserQuotaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetResellerUserQuotaResponse
		var err error
		defer close(result)
		response, err = client.SetResellerUserQuota(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetResellerUserQuotaRequest is the request struct for api SetResellerUserQuota
type SetResellerUserQuotaRequest struct {
	*requests.RpcRequest
	Amount   string           `position:"Query" name:"Amount"`
	OutBizId string           `position:"Query" name:"OutBizId"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	Currency string           `position:"Query" name:"Currency"`
}

// SetResellerUserQuotaResponse is the response struct for api SetResellerUserQuota
type SetResellerUserQuotaResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      bool   `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSetResellerUserQuotaRequest creates a request to invoke SetResellerUserQuota API
func CreateSetResellerUserQuotaRequest() (request *SetResellerUserQuotaRequest) {
	request = &SetResellerUserQuotaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "SetResellerUserQuota", "", "")
	request.Method = requests.POST
	return
}

// CreateSetResellerUserQuotaResponse creates a response to parse from SetResellerUserQuota response
func CreateSetResellerUserQuotaResponse() (response *SetResellerUserQuotaResponse) {
	response = &SetResellerUserQuotaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
