package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UninstallPromCluster invokes the arms.UninstallPromCluster API synchronously
func (client *Client) UninstallPromCluster(request *UninstallPromClusterRequest) (response *UninstallPromClusterResponse, err error) {
	response = CreateUninstallPromClusterResponse()
	err = client.DoAction(request, response)
	return
}

// UninstallPromClusterWithChan invokes the arms.UninstallPromCluster API asynchronously
func (client *Client) UninstallPromClusterWithChan(request *UninstallPromClusterRequest) (<-chan *UninstallPromClusterResponse, <-chan error) {
	responseChan := make(chan *UninstallPromClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UninstallPromCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UninstallPromClusterWithCallback invokes the arms.UninstallPromCluster API asynchronously
func (client *Client) UninstallPromClusterWithCallback(request *UninstallPromClusterRequest, callback func(response *UninstallPromClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UninstallPromClusterResponse
		var err error
		defer close(result)
		response, err = client.UninstallPromCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UninstallPromClusterRequest is the request struct for api UninstallPromCluster
type UninstallPromClusterRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// UninstallPromClusterResponse is the response struct for api UninstallPromCluster
type UninstallPromClusterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateUninstallPromClusterRequest creates a request to invoke UninstallPromCluster API
func CreateUninstallPromClusterRequest() (request *UninstallPromClusterRequest) {
	request = &UninstallPromClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "UninstallPromCluster", "", "")
	request.Method = requests.POST
	return
}

// CreateUninstallPromClusterResponse creates a response to parse from UninstallPromCluster response
func CreateUninstallPromClusterResponse() (response *UninstallPromClusterResponse) {
	response = &UninstallPromClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
