/* draw status window

   Written by Matthias Hensler
   Copyright WSPse 1999-2004
   eMail: matthias@wspse.de

Created: 1999/06/06
Updated: 2004/04/15
*/

/* Copying:
   This program is free software; you can redistribute it and/or modify it under
   the terms of the GNU Gerneral Public License as published by the Free Soft-
   ware Foundation; either version 2 of License, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILTY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 675 Mass
   Ave, Cambridge, MA 02139, USA.
   */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <ncurses.h>
#include "mp3creat.h"

extern WINDOW *c_newwin(int h, int l, int y, int x, void *proc, int arg1, int arg2);
extern void c_delwin(WINDOW *win);
extern void store_win_poi(WINDOW *win, void *pointer);
extern void *pop_win_poi(WINDOW *win);
extern int set_active_win(WINDOW *win);
extern void win_effect(WINDOW *win, BOOL e_refresh, BOOL save_coor);
extern signed char config_fancy_colors;
extern BOOL careful_batch;

WINDOW *stat_win;
int s_length;
int count_stat_win = 0;
int sw_x, sw_y, sw_l, sw_h;

void print_stat_win(char *text);

void stat_rebuild(WINDOW *win, int dummy1, int dummy2)
{
  int maxy, maxx;

  getmaxyx(stdscr, maxy, maxx);
  if((maxy < sw_y+sw_h) || (maxx < sw_x + sw_l)) {
    if(sw_l > maxx) sw_l = maxx;
    if(sw_h > maxy) sw_h = maxy;
    sw_x = (maxx-sw_l)>>1;
    sw_y = (maxy-sw_h)>>1;

    mvwin(win, sw_y, sw_x);
    wresize(win, sw_h, sw_l);
    mvwin(win, sw_y, sw_x);
  }
  
  wclear(win);
  wbkgd(win, COLOR_PAIR(1) | A_BOLD);
  box(win, 0, 0);
  print_stat_win(pop_win_poi(win));

  wrefresh(win);
}

void setup_stat_win(int max_length)
{
  int i;
  int maxx, maxy;

  if(careful_batch) return;
  count_stat_win++;
  if(count_stat_win != 1) return;
  
  getmaxyx(stdscr, maxy, maxx);
  i = max_length+2;
  if(i>maxx) i = maxx;
  stat_win = c_newwin(3, i, (maxy-3)>>1, (maxx-i)>>1, stat_rebuild, 0, 0);
  sw_x = (maxx-i)>>1;
  sw_y = (maxy-3)>>1;
  sw_h = 3;
  sw_l = i;
  s_length = i-2;
  
  wclear(stat_win);
  wbkgd(stat_win, COLOR_PAIR(1) | A_BOLD);
  box(stat_win, 0, 0);

  wrefresh(stat_win);
}

void print_stat_win(char *text)
{
  int i;
  chtype old_ch;

  if(careful_batch) {
    fprintf(stderr, "%s\n", text);
    return;
  }
  
  if(count_stat_win < 1) return;
  if(! text) return;

  store_win_poi(stat_win, text);
  old_ch = getbkgd(stat_win);
  wbkgdset(stat_win, COLOR_PAIR(2) | A_BOLD);

  wmove(stat_win, 1, 1);
  whline(stat_win, ' ', s_length);

  if(strlen(text) > s_length) i=1;
  else
    i = ((s_length - strlen(text))>>1) +1;

  mvwaddnstr(stat_win, 1, i, text, s_length);

  wbkgdset(stat_win, old_ch);
  wrefresh(stat_win);
}

void destroy_stat_win()
{
  if(careful_batch) return;
  count_stat_win--;
  if(count_stat_win == -1) {
    count_stat_win = 0;
    return;
  }
  if(count_stat_win != 0) return;
	
  c_delwin(stat_win);
}

void popup_error_win(char *tx)
{
  int inp_ch;
  int maxy, maxx;
  
  if(careful_batch) {
    fprintf(stderr, _("ERROR: %s\n"), tx);
    return;
  }

  if(! tx) return;

  setup_stat_win(strlen(tx));
  print_stat_win(tx);
  getmaxyx(stat_win, maxy, maxx);
  mvwaddnstr(stat_win, 2, 1+((maxx-12)>>1), _("press a key"), maxx);

  cbreak();
  noecho();
  keypad(stat_win, TRUE);
  if(config_fancy_colors)
    halfdelay(1);
  else
    nodelay(stat_win, FALSE);
  
  while(1) {
    inp_ch = wgetch(stat_win);
    if(config_fancy_colors)
      win_effect(stat_win, TRUE, FALSE);
    switch(inp_ch) {
      case '':
       	set_active_win(stat_win);
	break;
      case KEY_ENTER:
      case '\r':
      case '\n':
      case KEY_F(12):
      case 'Q':
      case 'q':
      case ' ':
      case 27:
      case '\'':
	destroy_stat_win();
	return;
	break;
    }
  }
}

