/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.IOException;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFStructTreeRoot;
import org.apache.fop.render.pdf.pdfbox.PDFBoxAdapter;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;

public class DocumentRootModifier {
    private PDFBoxAdapter adapter;
    private PDFDocument pdfDoc;

    public DocumentRootModifier(PDFBoxAdapter adapter, PDFDocument pdfDoc) {
        this.adapter = adapter;
        this.pdfDoc = pdfDoc;
    }

    public void structTreeRootEntriesToCopy(COSDictionary structRootDict) throws IOException {
        this.checkForMap(structRootDict, COSName.ROLE_MAP.getName());
        this.checkForMap(structRootDict, "ClassMap");
    }

    private void checkForMap(COSDictionary structRootDict, String mapName) throws IOException {
        if (structRootDict.containsKey(mapName)) {
            COSDictionary addedMapDict = (COSDictionary)structRootDict.getDictionaryObject(mapName);
            PDFDictionary temp = (PDFDictionary)this.adapter.cloneForNewDocument(addedMapDict);
            PDFStructTreeRoot structTreeRoot = this.pdfDoc.getRoot().getStructTreeRoot();
            if (!structTreeRoot.containsKey(mapName)) {
                structTreeRoot.put(mapName, (Object)temp);
            } else {
                PDFDictionary rootMap = (PDFDictionary)structTreeRoot.get(mapName);
                this.addMapToStructTreeRoot(rootMap, temp, mapName);
            }
        }
    }

    private void mergeMapClass(PDFDictionary main, PDFDictionary addition) {
        for (String key : addition.keySet()) {
            main.put(key, addition.get(key));
        }
    }

    private void mergeRoleMaps(PDFDictionary structRoot, PDFDictionary addition) {
        for (String key : addition.keySet()) {
            if (structRoot.containsKey(key)) continue;
            structRoot.put(key, addition.get(key));
        }
    }

    private void addMapToStructTreeRoot(PDFDictionary rootMap, PDFDictionary map, String mapName) {
        if (mapName.equals(COSName.ROLE_MAP.getName())) {
            this.mergeRoleMaps(rootMap, map);
        } else {
            this.mergeMapClass(rootMap, map);
        }
    }
}

