/*
 * Decompiled with CFR 0.152.
 */
package com.idiominc.ws.opentopic.fo.index2;

import com.idiominc.ws.opentopic.fo.index2.IndexCollator;
import com.idiominc.ws.opentopic.fo.index2.IndexEntry;
import com.idiominc.ws.opentopic.fo.index2.IndexGroup;
import com.idiominc.ws.opentopic.fo.index2.IndexPreprocessorTask;
import com.idiominc.ws.opentopic.fo.index2.configuration.ConfigEntry;
import com.idiominc.ws.opentopic.fo.index2.configuration.IndexConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;

@Deprecated
public final class IndexGroupProcessor {
    private DITAOTLogger logger;
    public static final String SPECIAL_CHARACTER_GROUP_KEY = "Specials";

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public IndexGroup[] process(IndexEntry[] theIndexEntries, IndexConfiguration theIndexConfiguration, Locale theLocale) {
        int i;
        IndexCollator collator = new IndexCollator(theLocale);
        ArrayList<MyIndexGroup> result = new ArrayList<MyIndexGroup>();
        ConfigEntry[] entries = theIndexConfiguration.getEntries();
        HashMap<String, IndexEntry> indexMap = IndexGroupProcessor.createMap(theIndexEntries);
        for (ConfigEntry configEntry : entries) {
            String label = configEntry.getLabel();
            MyIndexGroup group = new MyIndexGroup(label, configEntry);
            result.add(group);
        }
        MyIndexGroup[] IndexGroups = result.toArray(new MyIndexGroup[0]);
        for (i = 0; i < IndexGroups.length; ++i) {
            MyIndexGroup thisGroup = IndexGroups[i];
            String[] thisGroupMembers = thisGroup.getConfigEntry().getGroupMembers();
            for (int j = 0; j < IndexGroups.length; ++j) {
                Object compGroup;
                String[] compGroupMembers;
                if (j == i || !IndexGroupProcessor.doesStart(compGroupMembers = ((MyIndexGroup)(compGroup = IndexGroups[j])).getConfigEntry().getGroupMembers(), thisGroupMembers)) continue;
                thisGroup.addChild((MyIndexGroup)compGroup);
            }
        }
        for (i = 0; i < IndexGroups.length; ++i) {
            String[] indexMapKeys;
            ConfigEntry configEntry;
            MyIndexGroup group = IndexGroups[i];
            configEntry = group.getConfigEntry();
            String[] groupMembers = configEntry.getGroupMembers();
            if (groupMembers.length > 0) {
                for (String key : new ArrayList<String>(indexMap.keySet())) {
                    String value;
                    if (key.length() <= 0 || !configEntry.isInRange(value = IndexGroupProcessor.getValue(indexMap.get(key)), collator)) continue;
                    IndexEntry indexEntry = indexMap.remove(key);
                    group.addEntry(indexEntry);
                }
                continue;
            }
            String key1 = configEntry.getKey();
            String key2 = null;
            if (i + 1 < entries.length) {
                ConfigEntry nextEntry = entries[i + 1];
                key2 = nextEntry.getKey();
            }
            for (String mapKey : indexMapKeys = IndexGroupProcessor.getIndexKeysOfIndexesInRange(key1, key2, collator, indexMap)) {
                IndexEntry entry = indexMap.remove(mapKey);
                group.addEntry(entry);
            }
        }
        for (MyIndexGroup group : IndexGroups) {
            ConfigEntry configEntry = group.getConfigEntry();
            String configKey = configEntry.getKey();
            if (!configKey.equals(SPECIAL_CHARACTER_GROUP_KEY)) continue;
            for (String string : new ArrayList<String>(indexMap.keySet())) {
                if (string.length() <= 0) continue;
                String value = IndexGroupProcessor.getValue(indexMap.get(string));
                this.logger.info(MessageUtils.getMessage((String)"PDFJ003I", (String[])new String[]{value}).toString());
                IndexEntry entry = indexMap.remove(string);
                group.addEntry(entry);
            }
        }
        if (!indexMap.isEmpty()) {
            for (String key : new ArrayList<String>(indexMap.keySet())) {
                if (key.length() <= 0) continue;
                IndexEntry entry = indexMap.get(key);
                this.logger.error(MessageUtils.getMessage((String)"PDFJ001E", (String[])new String[]{entry.toString()}).toString());
            }
            if (IndexPreprocessorTask.failOnError) {
                this.logger.error(MessageUtils.getMessage((String)"PDFJ002E", (String[])new String[0]).toString());
                IndexPreprocessorTask.processingFaild = true;
            }
        }
        ArrayList<MyIndexGroup> cleanResult = new ArrayList<MyIndexGroup>();
        for (MyIndexGroup indexGroup : IndexGroups) {
            if (indexGroup.getEntries().length <= 0) continue;
            cleanResult.add(indexGroup);
        }
        return cleanResult.toArray(new MyIndexGroup[0]);
    }

    private static String getValue(IndexEntry theEntry) {
        String sortValue = theEntry.getSortString();
        if (sortValue != null && sortValue.length() > 0) {
            return sortValue;
        }
        return theEntry.getValue();
    }

    private static String[] getIndexKeysOfIndexesInRange(String theKey1, String theKey2, IndexCollator theCollator, HashMap<String, IndexEntry> theIndexEntryMap) {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, IndexEntry> e : theIndexEntryMap.entrySet()) {
            int res1 = theCollator.compare(theKey1, IndexGroupProcessor.getValue(e.getValue()));
            if (res1 > 0) continue;
            if (theKey2 == null) {
                res.add(e.getKey());
                continue;
            }
            int res2 = theCollator.compare(theKey2, e.getKey());
            if (res2 <= 0) continue;
            res.add(e.getKey());
        }
        return res.toArray(new String[0]);
    }

    private static boolean doesStart(String sourceString, String[] compStrings) {
        for (String compString : compStrings) {
            if (!sourceString.startsWith(compString)) continue;
            return true;
        }
        return false;
    }

    private static boolean doesStart(String[] sourceStrings, String[] compStrings) {
        for (String sourceString2 : sourceStrings) {
            for (String compString : compStrings) {
                if (!sourceString2.startsWith(compString) || sourceString2.equals(compString)) continue;
                return true;
            }
        }
        return false;
    }

    private static HashMap<String, IndexEntry> createMap(IndexEntry[] theIndexEntries) {
        HashMap<String, IndexEntry> map = new HashMap<String, IndexEntry>();
        for (IndexEntry theIndexEntrie : theIndexEntries) {
            String[] refIDs;
            IndexEntry[] childIndexEntries;
            String value = theIndexEntrie.getValue();
            if (!map.containsKey(value)) {
                map.put(value, theIndexEntrie);
                continue;
            }
            IndexEntry existingEntry = map.get(value);
            for (IndexEntry childIndexEntry : childIndexEntries = theIndexEntrie.getChildIndexEntries()) {
                existingEntry.addChild(childIndexEntry);
            }
            IndexEntry[] seeChildIndexEntries = theIndexEntrie.getSeeChildIndexEntries();
            for (int j = 0; seeChildIndexEntries != null && j < seeChildIndexEntries.length; ++j) {
                IndexEntry seeChildIndexEntry = seeChildIndexEntries[j];
                existingEntry.addSeeChild(seeChildIndexEntry);
            }
            IndexEntry[] seeAlsoChildIndexEntries = theIndexEntrie.getSeeAlsoChildIndexEntries();
            for (int j = 0; seeAlsoChildIndexEntries != null && j < seeAlsoChildIndexEntries.length; ++j) {
                IndexEntry seeAlsoChildIndexEntry = seeAlsoChildIndexEntries[j];
                existingEntry.addSeeAlsoChild(seeAlsoChildIndexEntry);
            }
            if (theIndexEntrie.isRestoresPageNumber()) {
                existingEntry.setRestoresPageNumber(true);
            }
            for (String refID : refIDs = theIndexEntrie.getRefIDs()) {
                existingEntry.addRefID(refID);
            }
            if (!theIndexEntrie.isSuppressesThePageNumber()) {
                existingEntry.setSuppressesThePageNumber(false);
            }
            if (!theIndexEntrie.isStartingRange()) continue;
            existingEntry.setStartRange(true);
        }
        return map;
    }

    private static class MyIndexGroup
    implements IndexGroup {
        private final String label;
        private final ConfigEntry configEntry;
        private final ArrayList<IndexEntry> entries = new ArrayList();
        private final ArrayList<MyIndexGroup> childList = new ArrayList();

        public MyIndexGroup(String theLabel, ConfigEntry theConfigEntry) {
            this.label = theLabel;
            this.configEntry = theConfigEntry;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public IndexEntry[] getEntries() {
            return this.entries.toArray(new IndexEntry[0]);
        }

        public ConfigEntry getConfigEntry() {
            return this.configEntry;
        }

        @Override
        public void addEntry(IndexEntry theEntry) {
            boolean isInserted = false;
            if (!this.childList.isEmpty()) {
                for (int i = 0; i < this.childList.size() && !isInserted; ++i) {
                    MyIndexGroup thisChild = this.childList.get(i);
                    String[] thisGroupMembers = thisChild.getConfigEntry().getGroupMembers();
                    if (!IndexGroupProcessor.doesStart(theEntry.getValue(), thisGroupMembers)) continue;
                    thisChild.addEntry(theEntry);
                    isInserted = true;
                }
            }
            if (!isInserted) {
                this.entries.add(theEntry);
            }
        }

        public void addChild(MyIndexGroup theIndexGroup) {
            if (!this.childList.contains(theIndexGroup)) {
                this.childList.add(theIndexGroup);
            }
            for (int i = 0; i < this.childList.size(); ++i) {
                MyIndexGroup thisChild = this.childList.get(i);
                for (int j = 0; j < this.childList.size(); ++j) {
                    String[] compGroupMembers;
                    if (i == j) continue;
                    MyIndexGroup compChild = this.childList.get(j);
                    String[] thisGroupMembers = thisChild.getConfigEntry().getGroupMembers();
                    if (!IndexGroupProcessor.doesStart(thisGroupMembers, compGroupMembers = compChild.getConfigEntry().getGroupMembers())) continue;
                    this.childList.remove(thisChild);
                    compChild.addChild(thisChild);
                }
            }
        }

        public void removeChild(MyIndexGroup theIndexGroup) {
            this.childList.remove(theIndexGroup);
        }
    }
}

