/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.psi.java1.media.audio;

import java.io.BufferedInputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import org.me4se.impl.BasicMMDataSource;
import org.me4se.impl.BasicMMPlayer;

public class WavePlayerImpl
extends BasicMMPlayer
implements LineListener {
    BasicMMDataSource source;
    Clip clip;
    AudioInputStream audioInputStream;
    AudioFormat audioFormat;
    DataLine.Info info;

    public WavePlayerImpl() {
        super(false);
    }

    public void setSource(BasicMMDataSource ds) {
        this.source = ds;
    }

    public void realizeImpl() throws Exception {
        this.audioInputStream = AudioSystem.getAudioInputStream(new BufferedInputStream(this.source.getInputStream(), 1024));
        this.audioFormat = this.audioInputStream.getFormat();
        System.out.println("AudioFormat = " + this.audioFormat.toString());
        this.info = new DataLine.Info(Clip.class, this.audioInputStream.getFormat(), (int)this.audioInputStream.getFrameLength() * this.audioFormat.getFrameSize());
        if (this.audioFormat.getFrameRate() != -1.0f) {
            this.duration = (long)((float)(this.audioInputStream.getFrameLength() * 1000000L) / this.audioFormat.getFrameRate());
        }
    }

    public void startImpl() throws Exception {
        System.out.println("Start called for clip: " + this.clip);
        if (this.clip == null) {
            this.audioInputStream = AudioSystem.getAudioInputStream(this.source.getInputStream());
            this.clip = (Clip)AudioSystem.getLine(this.info);
            this.clip.open(this.audioInputStream);
            this.clip.addLineListener(this);
            if (this.desiredTime != -1L) {
                this.clip.setMicrosecondPosition(this.desiredTime);
                this.desiredTime = 0L;
            }
            this.clip.start();
            this.state = 400;
            this.startListenerNotification("started", null);
        }
    }

    public void stopImpl() throws Exception {
        if (this.clip != null) {
            this.desiredTime = this.clip.getMicrosecondPosition();
            if (this.desiredTime >= this.clip.getMicrosecondLength()) {
                this.desiredTime = 0L;
            }
            Clip save = this.clip;
            this.clip = null;
            save.stop();
            save.close();
        }
    }

    public void update(LineEvent event) {
        System.out.println("Event: " + event + ";  clip: " + this.clip);
        LineEvent.Type type = event.getType();
        if (type.equals(LineEvent.Type.STOP)) {
            if (this.clip != null && (this.loopCount > 1 || this.loopCount == -1)) {
                this.notifyListeners("endOfMedia", null);
                this.clip.setMicrosecondPosition(0L);
                this.clip.start();
                if (this.loopCount > 1) {
                    --this.loopCount;
                }
            } else {
                if (this.state == 400) {
                    this.state = 300;
                }
                this.notifyListeners("stopped", null);
                if (this.clip != null) {
                    this.clip.close();
                    this.clip = null;
                }
            }
        }
    }

    public long getMediaTime() {
        return this.clip == null ? this.desiredTime : this.clip.getMicrosecondPosition();
    }

    public String getContentType() {
        return this.source.getContentType();
    }
}

