/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.benchmark;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.FastAggregation;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.IteratingRLW;
import com.googlecode.javaewah.IteratorAggregation;
import com.googlecode.javaewah.IteratorUtil;
import com.googlecode.javaewah.LogicalElement;
import com.googlecode.javaewah.benchmark.ClusteredDataGenerator;
import java.text.DecimalFormat;

public class BenchmarkXOR {
    public static void main(String[] args) {
        BenchmarkXOR.test(2, 22, 1);
    }

    public static void test(int N, int nbr, int repeat) {
        long bogus = 0L;
        DecimalFormat df = new DecimalFormat("0.###");
        ClusteredDataGenerator cdg = new ClusteredDataGenerator();
        for (int sparsity = 1; sparsity < 30 - nbr; ++sparsity) {
            for (int times = 0; times < 2; ++times) {
                Object ewahor;
                Object[] ewahcp;
                int r;
                String line = "";
                line = line + sparsity;
                int[][] data = new int[N][];
                int Max2 = 1 << nbr + sparsity;
                for (int k = 0; k < N; ++k) {
                    data[k] = cdg.generateClustered(1 << nbr, Max2);
                }
                LogicalElement[] ewah = new EWAHCompressedBitmap[N];
                for (int k = 0; k < N; ++k) {
                    ewah[k] = new EWAHCompressedBitmap();
                    for (int x = 0; x < data[k].length; ++x) {
                        ((EWAHCompressedBitmap)ewah[k]).set(data[k][x]);
                    }
                    data[k] = null;
                }
                EWAHCompressedBitmap answer = ewah[0].xor(ewah[1]);
                for (int k = 2; k < ewah.length; ++k) {
                    answer = answer.xor((EWAHCompressedBitmap)ewah[k]);
                }
                EWAHCompressedBitmap ewahor3 = (EWAHCompressedBitmap)FastAggregation.xor((LogicalElement[])ewah);
                if (!answer.equals(ewahor3)) {
                    throw new RuntimeException("bug FastAggregation.xor");
                }
                EWAHCompressedBitmap ewahor2 = FastAggregation.bufferedxor(65536, (EWAHCompressedBitmap[])ewah);
                if (!answer.equals(ewahor2)) {
                    throw new RuntimeException("bug FastAggregation.bufferedxor ");
                }
                EWAHCompressedBitmap iwah = IteratorUtil.materialize(IteratorAggregation.bufferedxor(IteratorUtil.toIterators((EWAHCompressedBitmap[])ewah)));
                if (!answer.equals(iwah)) {
                    throw new RuntimeException("bug xor it ");
                }
                long bef = System.currentTimeMillis();
                for (r = 0; r < repeat; ++r) {
                    for (int k = 0; k < N; ++k) {
                        LogicalElement ewahor4 = ewah[0];
                        for (int j = 1; j < k + 1; ++j) {
                            ewahor4 = ((EWAHCompressedBitmap)ewahor4).xor((EWAHCompressedBitmap)ewah[j]);
                        }
                    }
                }
                long aft = System.currentTimeMillis();
                line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
                bef = System.currentTimeMillis();
                for (r = 0; r < repeat; ++r) {
                    for (int k = 0; k < N; ++k) {
                        ewahcp = new EWAHCompressedBitmap[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = ewah[j];
                        }
                        ewahor = (EWAHCompressedBitmap)FastAggregation.xor((LogicalElement[])ewahcp);
                        bogus += (long)((EWAHCompressedBitmap)ewahor).sizeInBits();
                    }
                }
                aft = System.currentTimeMillis();
                line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
                bef = System.currentTimeMillis();
                for (r = 0; r < repeat; ++r) {
                    for (int k = 0; k < N; ++k) {
                        ewahcp = new EWAHCompressedBitmap[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = ewah[j];
                        }
                        ewahor = FastAggregation.bufferedxor(65536, (EWAHCompressedBitmap[])ewahcp);
                        bogus += (long)((EWAHCompressedBitmap)ewahor).sizeInBits();
                    }
                }
                aft = System.currentTimeMillis();
                line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
                bef = System.currentTimeMillis();
                for (r = 0; r < repeat; ++r) {
                    for (int k = 0; k < N; ++k) {
                        ewahcp = new IteratingRLW[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = new IteratingBufferedRunningLengthWord((EWAHCompressedBitmap)ewah[j]);
                        }
                        ewahor = IteratorAggregation.bufferedxor((IteratingRLW[])ewahcp);
                        int wordcounter = IteratorUtil.cardinality((IteratingRLW)ewahor);
                        bogus += (long)wordcounter;
                    }
                }
                aft = System.currentTimeMillis();
                line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
                System.out.println("# times for: 2by2 FastAggregation.xor  bufferedxor iterator-based");
                System.out.println(line);
            }
            System.out.println("# bogus =" + bogus);
        }
    }
}

