// Code generated by sdkgen. DO NOT EDIT.

// nolint
package vpc

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	vpc "github.com/yandex-cloud/go-genproto/yandex/cloud/vpc/v1"
)

//revive:disable

// NetworkServiceClient is a vpc.NetworkServiceClient with
// lazy GRPC connection initialization.
type NetworkServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) Create(ctx context.Context, in *vpc.CreateNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) Delete(ctx context.Context, in *vpc.DeleteNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) Get(ctx context.Context, in *vpc.GetNetworkRequest, opts ...grpc.CallOption) (*vpc.Network, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).Get(ctx, in, opts...)
}

// List implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) List(ctx context.Context, in *vpc.ListNetworksRequest, opts ...grpc.CallOption) (*vpc.ListNetworksResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).List(ctx, in, opts...)
}

type NetworkIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *NetworkServiceClient
	request *vpc.ListNetworksRequest

	items []*vpc.Network
}

func (c *NetworkServiceClient) NetworkIterator(ctx context.Context, req *vpc.ListNetworksRequest, opts ...grpc.CallOption) *NetworkIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &NetworkIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *NetworkIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Networks
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *NetworkIterator) Take(size int64) ([]*vpc.Network, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*vpc.Network

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *NetworkIterator) TakeAll() ([]*vpc.Network, error) {
	return it.Take(0)
}

func (it *NetworkIterator) Value() *vpc.Network {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *NetworkIterator) Error() error {
	return it.err
}

// ListOperations implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) ListOperations(ctx context.Context, in *vpc.ListNetworkOperationsRequest, opts ...grpc.CallOption) (*vpc.ListNetworkOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).ListOperations(ctx, in, opts...)
}

type NetworkOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *NetworkServiceClient
	request *vpc.ListNetworkOperationsRequest

	items []*operation.Operation
}

func (c *NetworkServiceClient) NetworkOperationsIterator(ctx context.Context, req *vpc.ListNetworkOperationsRequest, opts ...grpc.CallOption) *NetworkOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &NetworkOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *NetworkOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *NetworkOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *NetworkOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *NetworkOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *NetworkOperationsIterator) Error() error {
	return it.err
}

// ListRouteTables implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) ListRouteTables(ctx context.Context, in *vpc.ListNetworkRouteTablesRequest, opts ...grpc.CallOption) (*vpc.ListNetworkRouteTablesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).ListRouteTables(ctx, in, opts...)
}

type NetworkRouteTablesIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *NetworkServiceClient
	request *vpc.ListNetworkRouteTablesRequest

	items []*vpc.RouteTable
}

func (c *NetworkServiceClient) NetworkRouteTablesIterator(ctx context.Context, req *vpc.ListNetworkRouteTablesRequest, opts ...grpc.CallOption) *NetworkRouteTablesIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &NetworkRouteTablesIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *NetworkRouteTablesIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListRouteTables(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.RouteTables
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *NetworkRouteTablesIterator) Take(size int64) ([]*vpc.RouteTable, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*vpc.RouteTable

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *NetworkRouteTablesIterator) TakeAll() ([]*vpc.RouteTable, error) {
	return it.Take(0)
}

func (it *NetworkRouteTablesIterator) Value() *vpc.RouteTable {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *NetworkRouteTablesIterator) Error() error {
	return it.err
}

// ListSecurityGroups implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) ListSecurityGroups(ctx context.Context, in *vpc.ListNetworkSecurityGroupsRequest, opts ...grpc.CallOption) (*vpc.ListNetworkSecurityGroupsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).ListSecurityGroups(ctx, in, opts...)
}

type NetworkSecurityGroupsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *NetworkServiceClient
	request *vpc.ListNetworkSecurityGroupsRequest

	items []*vpc.SecurityGroup
}

func (c *NetworkServiceClient) NetworkSecurityGroupsIterator(ctx context.Context, req *vpc.ListNetworkSecurityGroupsRequest, opts ...grpc.CallOption) *NetworkSecurityGroupsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &NetworkSecurityGroupsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *NetworkSecurityGroupsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListSecurityGroups(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.SecurityGroups
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *NetworkSecurityGroupsIterator) Take(size int64) ([]*vpc.SecurityGroup, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*vpc.SecurityGroup

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *NetworkSecurityGroupsIterator) TakeAll() ([]*vpc.SecurityGroup, error) {
	return it.Take(0)
}

func (it *NetworkSecurityGroupsIterator) Value() *vpc.SecurityGroup {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *NetworkSecurityGroupsIterator) Error() error {
	return it.err
}

// ListSubnets implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) ListSubnets(ctx context.Context, in *vpc.ListNetworkSubnetsRequest, opts ...grpc.CallOption) (*vpc.ListNetworkSubnetsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).ListSubnets(ctx, in, opts...)
}

type NetworkSubnetsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *NetworkServiceClient
	request *vpc.ListNetworkSubnetsRequest

	items []*vpc.Subnet
}

func (c *NetworkServiceClient) NetworkSubnetsIterator(ctx context.Context, req *vpc.ListNetworkSubnetsRequest, opts ...grpc.CallOption) *NetworkSubnetsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &NetworkSubnetsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *NetworkSubnetsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListSubnets(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Subnets
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *NetworkSubnetsIterator) Take(size int64) ([]*vpc.Subnet, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*vpc.Subnet

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *NetworkSubnetsIterator) TakeAll() ([]*vpc.Subnet, error) {
	return it.Take(0)
}

func (it *NetworkSubnetsIterator) Value() *vpc.Subnet {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *NetworkSubnetsIterator) Error() error {
	return it.err
}

// Move implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) Move(ctx context.Context, in *vpc.MoveNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).Move(ctx, in, opts...)
}

// Update implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) Update(ctx context.Context, in *vpc.UpdateNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).Update(ctx, in, opts...)
}
