/* theme-2d.c generated by valac 0.46.3, the Vala compiler
 * generated from theme-2d.vala, do not modify */

/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2010  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>

#define PASANG_TYPE_LAYOUT2_D (pasang_layout2_d_get_type ())
typedef struct _PasangLayout2D PasangLayout2D;

#define PASANG_TYPE_RGB (pasang_rgb_get_type ())
typedef struct _PasangRgb PasangRgb;

#define PASANG_TYPE_THEME (pasang_theme_get_type ())
#define PASANG_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_THEME, PasangTheme))
#define PASANG_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_THEME, PasangThemeClass))
#define PASANG_IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_THEME))
#define PASANG_IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_THEME))
#define PASANG_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_THEME, PasangThemeClass))

typedef struct _PasangTheme PasangTheme;
typedef struct _PasangThemeClass PasangThemeClass;
typedef struct _PasangThemePrivate PasangThemePrivate;

#define PASANG_TYPE_GAME_VIEW (pasang_game_view_get_type ())
#define PASANG_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME_VIEW, PasangGameView))
#define PASANG_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME_VIEW, PasangGameViewClass))
#define PASANG_IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME_VIEW))
#define PASANG_IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME_VIEW))
#define PASANG_GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME_VIEW, PasangGameViewClass))

typedef struct _PasangGameView PasangGameView;
typedef struct _PasangGameViewClass PasangGameViewClass;
typedef enum  {
	PASANG_PIECE_NULL = -999,
	PASANG_PIECE_KAS_0 = 0,
	PASANG_PIECE_KAS_1 = 1,
	PASANG_PIECE_BLACK = 2,
	PASANG_PIECE_WHITE = 3,
	PASANG_PIECE_COUNT = 4,
	PASANG_PIECE_BOARD = 4,
	PASANG_PIECE_GUARD = 5,
	PASANG_PIECE_GUIDE = 6,
	PASANG_PIECE_EMPTY = 100
} PasangPiece;

#define PASANG_TYPE_PIECE (pasang_piece_get_type ())

#define PASANG_TYPE_POINT (pasang_point_get_type ())
typedef struct _PasangPoint PasangPoint;

#define PASANG_TYPE_GAME (pasang_game_get_type ())
#define PASANG_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME, PasangGame))
#define PASANG_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME, PasangGameClass))
#define PASANG_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME))
#define PASANG_IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME))
#define PASANG_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME, PasangGameClass))

typedef struct _PasangGame PasangGame;
typedef struct _PasangGameClass PasangGameClass;

#define PASANG_TYPE_THEME_ITEM (pasang_theme_item_get_type ())
typedef struct _PasangThemeItem PasangThemeItem;

#define PASANG_TYPE_FILM (pasang_film_get_type ())
typedef struct _PasangFilm PasangFilm;

#define PASANG_TYPE_THEME2_D (pasang_theme2_d_get_type ())
#define PASANG_THEME2_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_THEME2_D, PasangTheme2D))
#define PASANG_THEME2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_THEME2_D, PasangTheme2DClass))
#define PASANG_IS_THEME2_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_THEME2_D))
#define PASANG_IS_THEME2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_THEME2_D))
#define PASANG_THEME2_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_THEME2_D, PasangTheme2DClass))

typedef struct _PasangTheme2D PasangTheme2D;
typedef struct _PasangTheme2DClass PasangTheme2DClass;
typedef struct _PasangTheme2DPrivate PasangTheme2DPrivate;
enum  {
	PASANG_THEME2_D_0_PROPERTY,
	PASANG_THEME2_D_NUM_PROPERTIES
};
static GParamSpec* pasang_theme2_d_properties[PASANG_THEME2_D_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define PASANG_TYPE_GAME_SERIES (pasang_game_series_get_type ())
#define PASANG_GAME_SERIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME_SERIES, PasangGameSeries))
#define PASANG_GAME_SERIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME_SERIES, PasangGameSeriesClass))
#define PASANG_IS_GAME_SERIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME_SERIES))
#define PASANG_IS_GAME_SERIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME_SERIES))
#define PASANG_GAME_SERIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME_SERIES, PasangGameSeriesClass))

typedef struct _PasangGameSeries PasangGameSeries;
typedef struct _PasangGameSeriesClass PasangGameSeriesClass;
typedef enum  {
	PASANG_STAGE_NULL = -999,
	PASANG_STAGE_OPENING = 0,
	PASANG_STAGE_SELECT = 1,
	PASANG_STAGE_SUB_SELECT = 2,
	PASANG_STAGE_MOVE = 3,
	PASANG_STAGE_SUB_MOVE = 4,
	PASANG_STAGE_GAME_OVER = 5
} PasangStage;

#define PASANG_TYPE_STAGE (pasang_stage_get_type ())

#define PASANG_TYPE_MOVE (pasang_move_get_type ())
#define PASANG_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_MOVE, PasangMove))
#define PASANG_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_MOVE, PasangMoveClass))
#define PASANG_IS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_MOVE))
#define PASANG_IS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_MOVE))
#define PASANG_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_MOVE, PasangMoveClass))

typedef struct _PasangMove PasangMove;
typedef struct _PasangMoveClass PasangMoveClass;
typedef struct _PasangGameViewPrivate PasangGameViewPrivate;
typedef struct _PasangGamePrivate PasangGamePrivate;
typedef struct _PasangGameSeriesPrivate PasangGameSeriesPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PasangRgb {
	gdouble red;
	gdouble green;
	gdouble blue;
	gdouble alpha;
};

struct _PasangLayout2D {
	gint x;
	gint y;
	gint width;
	gint height;
	gint board_x;
	gint board_y;
	gint board_size;
	gint score_x[2];
	gint score_y[2];
	gint score_font_size;
	PasangRgb score_color[2];
	gint kas_x[2];
	gint kas_y[2];
	gint kas_frame[2];
	gint num_wins_x[2];
	gint num_wins_y[2];
	gint num_wins_font_size;
	PasangRgb num_wins_color;
	gint num_rounds_x;
	gint num_rounds_y;
	gint num_rounds_format;
	gint num_rounds_font_size;
	PasangRgb num_rounds_color;
	gint filler_left;
	gint filler_top;
	gint filler_right;
	gint filler_bottom;
	gint image_x;
	gint image_y;
	gint image_width;
	gint image_height;
};

struct _PasangPoint {
	gint x;
	gint y;
};

struct _PasangThemeItem {
	gchar* name;
	gchar* path;
	GdkPixbuf* pixbuf;
	gchar* license;
	gchar* artist;
	gchar* comment;
	PasangTheme* engine;
};

struct _PasangFilm {
	gint stop;
	gint length;
	gint viewed;
	gint n;
};

struct _PasangTheme {
	GObject parent_instance;
	PasangThemePrivate * priv;
	PasangThemeItem* items;
	gint items_length1;
	gint _items_size_;
	PasangFilm* films;
	gint films_length1;
	gint _films_size_;
	gint* cycles;
	gint cycles_length1;
	gint _cycles_size_;
};

struct _PasangThemeClass {
	GObjectClass parent_class;
	PasangTheme* (*select) (PasangTheme* self, const gchar* path, gint width, gint height);
	void (*resize) (PasangTheme* self, gint width, gint height);
	void (*free) (PasangTheme* self);
	void (*draw) (PasangTheme* self, PasangGameView* game_view, cairo_t* cr);
	void (*queue_draw_piece) (PasangTheme* self, GtkDrawingArea* view, PasangPiece piece, PasangPoint* p);
	gint (*count_frames) (PasangTheme* self, PasangPiece piece);
	void (*to_point) (PasangTheme* self, gint pos, gboolean rotated, PasangPoint* result);
	gint (*to_position) (PasangTheme* self, PasangGame* game, PasangPoint* p, gboolean rotated, gboolean precise);
	gint (*to_side) (PasangTheme* self, PasangPoint* p);
};

struct _PasangTheme2D {
	PasangTheme parent_instance;
	PasangTheme2DPrivate * priv;
	PasangLayout2D default_layout;
	PasangLayout2D layout;
	PasangLayout2D table;
	gboolean layout_changed;
	cairo_surface_t** images;
	gint images_length1;
	gint _images_size_;
	gint* num_rows_in_image;
	gint num_rows_in_image_length1;
	gint _num_rows_in_image_size_;
};

struct _PasangTheme2DClass {
	PasangThemeClass parent_class;
	void (*resize_images) (PasangTheme2D* self);
};

struct _PasangGameView {
	GtkDrawingArea parent_instance;
	PasangGameViewPrivate * priv;
	PasangPoint kas_point;
};

struct _PasangGameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _PasangGame {
	GObject parent_instance;
	PasangGamePrivate * priv;
	PasangPiece* board;
	gint board_length1;
	gint* score;
	gint score_length1;
	gint* kas_position;
	gint kas_position_length1;
	gint* first_move;
	gint first_move_length1;
};

struct _PasangGameClass {
	GObjectClass parent_class;
};

struct _PasangGameSeries {
	PasangGame parent_instance;
	PasangGameSeriesPrivate * priv;
	gboolean rotated;
	gint num_wins[2];
	gint num_rounds;
};

struct _PasangGameSeriesClass {
	PasangGameClass parent_class;
};

static gpointer pasang_theme2_d_parent_class = NULL;

GType pasang_layout2_d_get_type (void) G_GNUC_CONST;
GType pasang_rgb_get_type (void) G_GNUC_CONST;
PasangRgb* pasang_rgb_dup (const PasangRgb* self);
void pasang_rgb_free (PasangRgb* self);
PasangLayout2D* pasang_layout2_d_dup (const PasangLayout2D* self);
void pasang_layout2_d_free (PasangLayout2D* self);
GType pasang_theme_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangTheme, g_object_unref)
GType pasang_game_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGameView, g_object_unref)
GType pasang_piece_get_type (void) G_GNUC_CONST;
GType pasang_point_get_type (void) G_GNUC_CONST;
PasangPoint* pasang_point_dup (const PasangPoint* self);
void pasang_point_free (PasangPoint* self);
GType pasang_game_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGame, g_object_unref)
GType pasang_theme_item_get_type (void) G_GNUC_CONST;
PasangThemeItem* pasang_theme_item_dup (const PasangThemeItem* self);
void pasang_theme_item_free (PasangThemeItem* self);
void pasang_theme_item_copy (const PasangThemeItem* self,
                             PasangThemeItem* dest);
void pasang_theme_item_destroy (PasangThemeItem* self);
GType pasang_film_get_type (void) G_GNUC_CONST;
PasangFilm* pasang_film_dup (const PasangFilm* self);
void pasang_film_free (PasangFilm* self);
GType pasang_theme2_d_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangTheme2D, g_object_unref)
void pasang_rgb_init (PasangRgb *self,
                      gdouble r,
                      gdouble g,
                      gdouble b,
                      gdouble a);
static void pasang_theme2_d_real_free (PasangTheme* base);
static void pasang_theme2_d_real_resize (PasangTheme* base,
                                  gint allocated_width,
                                  gint allocated_height);
#define PASANG_BOARD_WIDTH 13
void pasang_theme2_d_resize_images (PasangTheme2D* self);
static void pasang_theme2_d_real_resize_images (PasangTheme2D* self);
static void pasang_theme2_d_real_draw (PasangTheme* base,
                                PasangGameView* game_view,
                                cairo_t* cr);
static void pasang_theme2_d_draw_table (PasangTheme2D* self,
                                 cairo_t* cr);
GType pasang_game_series_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGameSeries, g_object_unref)
static void pasang_theme2_d_draw_scores (PasangTheme2D* self,
                                  cairo_t* cr,
                                  PasangGameSeries* game);
PasangGameSeries* pasang_game_view_get_game (PasangGameView* self);
static void pasang_theme2_d_draw_pieces (PasangTheme2D* self,
                                  PasangGameView* game_view,
                                  cairo_t* cr);
static void pasang_theme2_d_draw_message (PasangTheme2D* self,
                                   cairo_t* cr,
                                   const gchar* message);
const gchar* pasang_game_view_get_message (PasangGameView* self);
GType pasang_stage_get_type (void) G_GNUC_CONST;
PasangStage pasang_game_get_stage (PasangGame* self);
GType pasang_move_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangMove, g_object_unref)
PasangMove* pasang_game_view_get_selected_move (PasangGameView* self);
#define PASANG_BOARD_SIZE (13 * 13)
gboolean pasang_piece_is_real (PasangPiece self);
gint pasang_move_get_position (PasangMove* self);
PasangPiece pasang_game_get_kas (PasangGame* self);
void pasang_theme_to_point (PasangTheme* self,
                            gint pos,
                            gboolean rotated,
                            PasangPoint* result);
static gint pasang_theme2_d_piece_image_width (PasangTheme2D* self,
                                        PasangPiece piece);
static void pasang_theme2_d_draw_piece (PasangTheme2D* self,
                                 cairo_t* cr,
                                 PasangPiece piece,
                                 gint frame,
                                 gint x,
                                 gint y);
gint pasang_theme_count_frames (PasangTheme* self,
                                PasangPiece piece);
void pasang_rgb_set_source_for (PasangRgb *self,
                                cairo_t* cr);
void pasang_theme2_d_show_text (PasangTheme2D* self,
                                cairo_t* cr,
                                const gchar* text,
                                gint font_size,
                                gint cx,
                                gint cy,
                                gboolean boxed);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void pasang_theme2_d_real_queue_draw_piece (PasangTheme* base,
                                            GtkDrawingArea* view,
                                            PasangPiece piece,
                                            PasangPoint* p);
gint pasang_theme2_d_cell_width (PasangTheme2D* self);
static gint pasang_theme2_d_real_count_frames (PasangTheme* base,
                                        PasangPiece piece);
static void pasang_theme2_d_real_to_point (PasangTheme* base,
                                    gint pos,
                                    gboolean rotated,
                                    PasangPoint* result);
void pasang_point_init_xy (PasangPoint *self,
                           gint x,
                           gint y);
static gint pasang_theme2_d_real_to_position (PasangTheme* base,
                                       PasangGame* game,
                                       PasangPoint* raw_p,
                                       gboolean rotated,
                                       gboolean precise);
static gboolean pasang_theme2_d_detect_piece (PasangTheme2D* self,
                                       PasangPiece piece,
                                       gint frame,
                                       gint x,
                                       gint y);
static gint pasang_theme2_d_real_to_side (PasangTheme* base,
                                   PasangPoint* p);
PasangTheme2D* pasang_theme2_d_construct (GType object_type);
PasangTheme* pasang_theme_construct (GType object_type);
static GObject * pasang_theme2_d_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void pasang_theme2_d_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

PasangLayout2D*
pasang_layout2_d_dup (const PasangLayout2D* self)
{
	PasangLayout2D* dup;
#line 25 "theme-2d.vala"
	dup = g_new0 (PasangLayout2D, 1);
#line 25 "theme-2d.vala"
	memcpy (dup, self, sizeof (PasangLayout2D));
#line 25 "theme-2d.vala"
	return dup;
#line 445 "theme-2d.c"
}

void
pasang_layout2_d_free (PasangLayout2D* self)
{
#line 25 "theme-2d.vala"
	g_free (self);
#line 453 "theme-2d.c"
}

GType
pasang_layout2_d_get_type (void)
{
	static volatile gsize pasang_layout2_d_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_layout2_d_type_id__volatile)) {
		GType pasang_layout2_d_type_id;
		pasang_layout2_d_type_id = g_boxed_type_register_static ("PasangLayout2D", (GBoxedCopyFunc) pasang_layout2_d_dup, (GBoxedFreeFunc) pasang_layout2_d_free);
		g_once_init_leave (&pasang_layout2_d_type_id__volatile, pasang_layout2_d_type_id);
	}
	return pasang_layout2_d_type_id__volatile;
}

static void
pasang_theme2_d_real_free (PasangTheme* base)
{
	PasangTheme2D * self;
#line 132 "theme-2d.vala"
	self = (PasangTheme2D*) base;
#line 474 "theme-2d.c"
	{
		gint i = 0;
#line 133 "theme-2d.vala"
		i = 0;
#line 479 "theme-2d.c"
		{
			gboolean _tmp0_ = FALSE;
#line 133 "theme-2d.vala"
			_tmp0_ = TRUE;
#line 133 "theme-2d.vala"
			while (TRUE) {
#line 486 "theme-2d.c"
				cairo_surface_t** _tmp2_;
				gint _tmp2__length1;
				cairo_surface_t** _tmp3_;
				gint _tmp3__length1;
#line 133 "theme-2d.vala"
				if (!_tmp0_) {
#line 493 "theme-2d.c"
					gint _tmp1_;
#line 133 "theme-2d.vala"
					_tmp1_ = i;
#line 133 "theme-2d.vala"
					i = _tmp1_ + 1;
#line 499 "theme-2d.c"
				}
#line 133 "theme-2d.vala"
				_tmp0_ = FALSE;
#line 133 "theme-2d.vala"
				_tmp2_ = self->images;
#line 133 "theme-2d.vala"
				_tmp2__length1 = self->images_length1;
#line 133 "theme-2d.vala"
				if (!(i < _tmp2__length1)) {
#line 133 "theme-2d.vala"
					break;
#line 511 "theme-2d.c"
				}
#line 133 "theme-2d.vala"
				_tmp3_ = self->images;
#line 133 "theme-2d.vala"
				_tmp3__length1 = self->images_length1;
#line 133 "theme-2d.vala"
				_cairo_surface_destroy0 (_tmp3_[i]);
#line 133 "theme-2d.vala"
				_tmp3_[i] = NULL;
#line 521 "theme-2d.c"
			}
		}
	}
}

/**
     * Set table according to layout and the allocated size.
     * Then resize images.
     */
static void
pasang_theme2_d_real_resize (PasangTheme* base,
                             gint allocated_width,
                             gint allocated_height)
{
	PasangTheme2D * self;
	gint width_for_board_only = 0;
	PasangLayout2D _tmp0_;
	PasangLayout2D _tmp1_;
	gint height_for_board_only = 0;
	PasangLayout2D _tmp2_;
	PasangLayout2D _tmp3_;
	gint size = 0;
	gdouble scale = 0.0;
	PasangLayout2D _tmp4_;
	PasangLayout2D _tmp5_;
	PasangLayout2D _tmp6_;
	PasangLayout2D _tmp7_;
	PasangLayout2D _tmp8_;
	PasangLayout2D _tmp9_;
	PasangLayout2D _tmp10_;
	PasangLayout2D _tmp11_;
	gint gap = 0;
	PasangLayout2D _tmp12_;
	gboolean _tmp13_ = FALSE;
	PasangLayout2D _tmp24_;
	PasangLayout2D _tmp25_;
	PasangLayout2D _tmp26_;
	PasangLayout2D _tmp27_;
	PasangLayout2D _tmp28_;
	PasangLayout2D _tmp29_;
	PasangLayout2D _tmp30_;
	PasangLayout2D _tmp31_;
	PasangLayout2D _tmp32_;
	gboolean _tmp33_ = FALSE;
	PasangLayout2D _tmp44_;
	PasangLayout2D _tmp45_;
	PasangLayout2D _tmp68_;
	PasangLayout2D _tmp69_;
	PasangLayout2D _tmp70_;
	PasangLayout2D _tmp71_;
	PasangLayout2D _tmp72_;
	PasangLayout2D _tmp73_;
	PasangLayout2D _tmp74_;
#line 140 "theme-2d.vala"
	self = (PasangTheme2D*) base;
#line 142 "theme-2d.vala"
	_tmp0_ = self->layout;
#line 142 "theme-2d.vala"
	_tmp1_ = self->layout;
#line 142 "theme-2d.vala"
	width_for_board_only = (allocated_width * _tmp0_.board_size) / _tmp1_.width;
#line 143 "theme-2d.vala"
	_tmp2_ = self->layout;
#line 143 "theme-2d.vala"
	_tmp3_ = self->layout;
#line 143 "theme-2d.vala"
	height_for_board_only = (allocated_height * _tmp2_.board_size) / _tmp3_.height;
#line 144 "theme-2d.vala"
	size = (MIN (width_for_board_only, height_for_board_only) / PASANG_BOARD_WIDTH) * PASANG_BOARD_WIDTH;
#line 145 "theme-2d.vala"
	_tmp4_ = self->layout;
#line 145 "theme-2d.vala"
	scale = ((gdouble) size) / _tmp4_.board_size;
#line 147 "theme-2d.vala"
	_tmp5_ = self->table;
#line 147 "theme-2d.vala"
	self->layout_changed = self->layout_changed | (size != _tmp5_.board_size);
#line 148 "theme-2d.vala"
	self->table.board_size = size;
#line 151 "theme-2d.vala"
	_tmp6_ = self->layout;
#line 151 "theme-2d.vala"
	self->table.width = (gint) (scale * _tmp6_.width);
#line 152 "theme-2d.vala"
	_tmp7_ = self->layout;
#line 152 "theme-2d.vala"
	self->table.filler_left = (gint) (scale * _tmp7_.filler_left);
#line 153 "theme-2d.vala"
	_tmp8_ = self->layout;
#line 153 "theme-2d.vala"
	self->table.filler_right = (gint) (scale * _tmp8_.filler_right);
#line 154 "theme-2d.vala"
	_tmp9_ = self->table;
#line 154 "theme-2d.vala"
	_tmp10_ = self->table;
#line 154 "theme-2d.vala"
	_tmp11_ = self->table;
#line 154 "theme-2d.vala"
	self->table.image_width = (_tmp9_.width + _tmp10_.filler_left) + _tmp11_.filler_right;
#line 155 "theme-2d.vala"
	_tmp12_ = self->table;
#line 155 "theme-2d.vala"
	gap = allocated_width - _tmp12_.image_width;
#line 156 "theme-2d.vala"
	if (gap > 0) {
#line 156 "theme-2d.vala"
		_tmp13_ = TRUE;
#line 629 "theme-2d.c"
	} else {
		PasangLayout2D _tmp14_;
		PasangLayout2D _tmp15_;
#line 156 "theme-2d.vala"
		_tmp14_ = self->layout;
#line 156 "theme-2d.vala"
		_tmp15_ = self->layout;
#line 156 "theme-2d.vala"
		_tmp13_ = _tmp14_.filler_left == _tmp15_.filler_right;
#line 639 "theme-2d.c"
	}
#line 156 "theme-2d.vala"
	if (_tmp13_) {
#line 643 "theme-2d.c"
		PasangLayout2D _tmp16_;
		PasangLayout2D _tmp17_;
#line 159 "theme-2d.vala"
		self->table.image_x = gap / 2;
#line 160 "theme-2d.vala"
		_tmp16_ = self->table;
#line 160 "theme-2d.vala"
		_tmp17_ = self->table;
#line 160 "theme-2d.vala"
		self->table.x = _tmp16_.image_x + _tmp17_.filler_left;
#line 654 "theme-2d.c"
	} else {
		gint filler = 0;
		PasangLayout2D _tmp18_;
		PasangLayout2D _tmp19_;
		PasangLayout2D _tmp20_;
		PasangLayout2D _tmp21_;
		PasangLayout2D _tmp22_;
		PasangLayout2D _tmp23_;
#line 164 "theme-2d.vala"
		_tmp18_ = self->table;
#line 164 "theme-2d.vala"
		filler = allocated_width - _tmp18_.width;
#line 165 "theme-2d.vala"
		_tmp19_ = self->layout;
#line 165 "theme-2d.vala"
		_tmp20_ = self->layout;
#line 165 "theme-2d.vala"
		_tmp21_ = self->layout;
#line 165 "theme-2d.vala"
		self->table.x = (filler * _tmp19_.filler_left) / (_tmp20_.filler_left + _tmp21_.filler_right);
#line 166 "theme-2d.vala"
		_tmp22_ = self->table;
#line 166 "theme-2d.vala"
		_tmp23_ = self->table;
#line 166 "theme-2d.vala"
		self->table.image_x = _tmp22_.x - _tmp23_.filler_left;
#line 681 "theme-2d.c"
	}
#line 168 "theme-2d.vala"
	_tmp24_ = self->table;
#line 168 "theme-2d.vala"
	_tmp25_ = self->layout;
#line 168 "theme-2d.vala"
	self->table.board_x = _tmp24_.x + ((gint) (scale * _tmp25_.board_x));
#line 171 "theme-2d.vala"
	_tmp26_ = self->layout;
#line 171 "theme-2d.vala"
	self->table.height = (gint) (scale * _tmp26_.height);
#line 172 "theme-2d.vala"
	_tmp27_ = self->layout;
#line 172 "theme-2d.vala"
	self->table.filler_top = (gint) (scale * _tmp27_.filler_top);
#line 173 "theme-2d.vala"
	_tmp28_ = self->layout;
#line 173 "theme-2d.vala"
	self->table.filler_bottom = (gint) (scale * _tmp28_.filler_bottom);
#line 174 "theme-2d.vala"
	_tmp29_ = self->table;
#line 174 "theme-2d.vala"
	_tmp30_ = self->table;
#line 174 "theme-2d.vala"
	_tmp31_ = self->table;
#line 174 "theme-2d.vala"
	self->table.image_height = (_tmp29_.height + _tmp30_.filler_top) + _tmp31_.filler_bottom;
#line 175 "theme-2d.vala"
	_tmp32_ = self->table;
#line 175 "theme-2d.vala"
	gap = allocated_height - _tmp32_.image_height;
#line 176 "theme-2d.vala"
	if (gap > 0) {
#line 176 "theme-2d.vala"
		_tmp33_ = TRUE;
#line 717 "theme-2d.c"
	} else {
		PasangLayout2D _tmp34_;
		PasangLayout2D _tmp35_;
#line 176 "theme-2d.vala"
		_tmp34_ = self->layout;
#line 176 "theme-2d.vala"
		_tmp35_ = self->layout;
#line 176 "theme-2d.vala"
		_tmp33_ = _tmp34_.filler_top == _tmp35_.filler_bottom;
#line 727 "theme-2d.c"
	}
#line 176 "theme-2d.vala"
	if (_tmp33_) {
#line 731 "theme-2d.c"
		PasangLayout2D _tmp36_;
		PasangLayout2D _tmp37_;
#line 177 "theme-2d.vala"
		self->table.image_y = gap / 2;
#line 178 "theme-2d.vala"
		_tmp36_ = self->table;
#line 178 "theme-2d.vala"
		_tmp37_ = self->table;
#line 178 "theme-2d.vala"
		self->table.y = _tmp36_.image_y + _tmp37_.filler_top;
#line 742 "theme-2d.c"
	} else {
		gint filler = 0;
		PasangLayout2D _tmp38_;
		PasangLayout2D _tmp39_;
		PasangLayout2D _tmp40_;
		PasangLayout2D _tmp41_;
		PasangLayout2D _tmp42_;
		PasangLayout2D _tmp43_;
#line 181 "theme-2d.vala"
		_tmp38_ = self->table;
#line 181 "theme-2d.vala"
		filler = allocated_height - _tmp38_.height;
#line 182 "theme-2d.vala"
		_tmp39_ = self->layout;
#line 182 "theme-2d.vala"
		_tmp40_ = self->layout;
#line 182 "theme-2d.vala"
		_tmp41_ = self->layout;
#line 182 "theme-2d.vala"
		self->table.y = (filler * _tmp39_.filler_top) / (_tmp40_.filler_top + _tmp41_.filler_bottom);
#line 183 "theme-2d.vala"
		_tmp42_ = self->table;
#line 183 "theme-2d.vala"
		_tmp43_ = self->table;
#line 183 "theme-2d.vala"
		self->table.image_y = _tmp42_.y - _tmp43_.filler_top;
#line 769 "theme-2d.c"
	}
#line 185 "theme-2d.vala"
	_tmp44_ = self->table;
#line 185 "theme-2d.vala"
	_tmp45_ = self->layout;
#line 185 "theme-2d.vala"
	self->table.board_y = _tmp44_.y + ((gint) (scale * _tmp45_.board_y));
#line 777 "theme-2d.c"
	{
		gint i = 0;
#line 187 "theme-2d.vala"
		i = 0;
#line 782 "theme-2d.c"
		{
			gboolean _tmp46_ = FALSE;
#line 187 "theme-2d.vala"
			_tmp46_ = TRUE;
#line 187 "theme-2d.vala"
			while (TRUE) {
#line 789 "theme-2d.c"
				PasangLayout2D _tmp48_;
				PasangLayout2D _tmp49_;
				gint _tmp50_;
				PasangLayout2D _tmp51_;
				PasangLayout2D _tmp52_;
				gint _tmp53_;
				PasangLayout2D _tmp54_;
				PasangLayout2D _tmp55_;
				gint _tmp56_;
				PasangLayout2D _tmp57_;
				PasangLayout2D _tmp58_;
				gint _tmp59_;
				PasangLayout2D _tmp60_;
				gint _tmp61_;
				PasangLayout2D _tmp62_;
				PasangLayout2D _tmp63_;
				gint _tmp64_;
				PasangLayout2D _tmp65_;
				PasangLayout2D _tmp66_;
				gint _tmp67_;
#line 187 "theme-2d.vala"
				if (!_tmp46_) {
#line 812 "theme-2d.c"
					gint _tmp47_;
#line 187 "theme-2d.vala"
					_tmp47_ = i;
#line 187 "theme-2d.vala"
					i = _tmp47_ + 1;
#line 818 "theme-2d.c"
				}
#line 187 "theme-2d.vala"
				_tmp46_ = FALSE;
#line 187 "theme-2d.vala"
				if (!(i < 2)) {
#line 187 "theme-2d.vala"
					break;
#line 826 "theme-2d.c"
				}
#line 188 "theme-2d.vala"
				_tmp48_ = self->table;
#line 188 "theme-2d.vala"
				_tmp49_ = self->layout;
#line 188 "theme-2d.vala"
				_tmp50_ = _tmp49_.score_x[i];
#line 188 "theme-2d.vala"
				self->table.score_x[i] = _tmp48_.x + ((gint) (scale * _tmp50_));
#line 189 "theme-2d.vala"
				_tmp51_ = self->table;
#line 189 "theme-2d.vala"
				_tmp52_ = self->layout;
#line 189 "theme-2d.vala"
				_tmp53_ = _tmp52_.score_y[i];
#line 189 "theme-2d.vala"
				self->table.score_y[i] = _tmp51_.y + ((gint) (scale * _tmp53_));
#line 190 "theme-2d.vala"
				_tmp54_ = self->table;
#line 190 "theme-2d.vala"
				_tmp55_ = self->layout;
#line 190 "theme-2d.vala"
				_tmp56_ = _tmp55_.kas_x[i];
#line 190 "theme-2d.vala"
				self->table.kas_x[i] = _tmp54_.x + ((gint) (scale * _tmp56_));
#line 191 "theme-2d.vala"
				_tmp57_ = self->table;
#line 191 "theme-2d.vala"
				_tmp58_ = self->layout;
#line 191 "theme-2d.vala"
				_tmp59_ = _tmp58_.kas_y[i];
#line 191 "theme-2d.vala"
				self->table.kas_y[i] = _tmp57_.y + ((gint) (scale * _tmp59_));
#line 192 "theme-2d.vala"
				_tmp60_ = self->layout;
#line 192 "theme-2d.vala"
				_tmp61_ = _tmp60_.kas_frame[i];
#line 192 "theme-2d.vala"
				self->table.kas_frame[i] = _tmp61_;
#line 193 "theme-2d.vala"
				_tmp62_ = self->table;
#line 193 "theme-2d.vala"
				_tmp63_ = self->layout;
#line 193 "theme-2d.vala"
				_tmp64_ = _tmp63_.num_wins_x[i];
#line 193 "theme-2d.vala"
				self->table.num_wins_x[i] = _tmp62_.x + ((gint) (scale * _tmp64_));
#line 194 "theme-2d.vala"
				_tmp65_ = self->table;
#line 194 "theme-2d.vala"
				_tmp66_ = self->layout;
#line 194 "theme-2d.vala"
				_tmp67_ = _tmp66_.num_wins_y[i];
#line 194 "theme-2d.vala"
				self->table.num_wins_y[i] = _tmp65_.y + ((gint) (scale * _tmp67_));
#line 882 "theme-2d.c"
			}
		}
	}
#line 196 "theme-2d.vala"
	_tmp68_ = self->layout;
#line 196 "theme-2d.vala"
	self->table.score_font_size = (gint) (scale * _tmp68_.score_font_size);
#line 197 "theme-2d.vala"
	_tmp69_ = self->layout;
#line 197 "theme-2d.vala"
	self->table.num_wins_font_size = (gint) (scale * _tmp69_.num_wins_font_size);
#line 199 "theme-2d.vala"
	_tmp70_ = self->table;
#line 199 "theme-2d.vala"
	_tmp71_ = self->layout;
#line 199 "theme-2d.vala"
	self->table.num_rounds_x = _tmp70_.x + ((gint) (scale * _tmp71_.num_rounds_x));
#line 200 "theme-2d.vala"
	_tmp72_ = self->table;
#line 200 "theme-2d.vala"
	_tmp73_ = self->layout;
#line 200 "theme-2d.vala"
	self->table.num_rounds_y = _tmp72_.y + ((gint) (scale * _tmp73_.num_rounds_y));
#line 201 "theme-2d.vala"
	_tmp74_ = self->layout;
#line 201 "theme-2d.vala"
	self->table.num_rounds_font_size = (gint) (scale * _tmp74_.num_rounds_font_size);
#line 203 "theme-2d.vala"
	if (self->layout_changed) {
#line 204 "theme-2d.vala"
		self->layout_changed = FALSE;
#line 205 "theme-2d.vala"
		pasang_theme2_d_resize_images (self);
#line 916 "theme-2d.c"
	}
}

/**
     * Resize images based on board_size.
     * Input: table.
     */
static void
pasang_theme2_d_real_resize_images (PasangTheme2D* self)
{
#line 213 "theme-2d.vala"
	g_critical ("Type `%s' does not implement abstract method `pasang_theme2_d_resize_images'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 213 "theme-2d.vala"
	return;
#line 931 "theme-2d.c"
}

void
pasang_theme2_d_resize_images (PasangTheme2D* self)
{
#line 213 "theme-2d.vala"
	g_return_if_fail (self != NULL);
#line 213 "theme-2d.vala"
	PASANG_THEME2_D_GET_CLASS (self)->resize_images (self);
#line 941 "theme-2d.c"
}

static void
pasang_theme2_d_real_draw (PasangTheme* base,
                           PasangGameView* game_view,
                           cairo_t* cr)
{
	PasangTheme2D * self;
	PasangGameSeries* _tmp0_;
	PasangGameSeries* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 215 "theme-2d.vala"
	self = (PasangTheme2D*) base;
#line 215 "theme-2d.vala"
	g_return_if_fail (game_view != NULL);
#line 215 "theme-2d.vala"
	g_return_if_fail (cr != NULL);
#line 216 "theme-2d.vala"
	pasang_theme2_d_draw_table (self, cr);
#line 217 "theme-2d.vala"
	_tmp0_ = pasang_game_view_get_game (game_view);
#line 217 "theme-2d.vala"
	_tmp1_ = _tmp0_;
#line 217 "theme-2d.vala"
	pasang_theme2_d_draw_scores (self, cr, _tmp1_);
#line 218 "theme-2d.vala"
	pasang_theme2_d_draw_pieces (self, game_view, cr);
#line 219 "theme-2d.vala"
	_tmp2_ = pasang_game_view_get_message (game_view);
#line 219 "theme-2d.vala"
	_tmp3_ = _tmp2_;
#line 219 "theme-2d.vala"
	pasang_theme2_d_draw_message (self, cr, _tmp3_);
#line 976 "theme-2d.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 223 "theme-2d.vala"
	return self ? g_object_ref (self) : NULL;
#line 984 "theme-2d.c"
}

static void
pasang_theme2_d_draw_pieces (PasangTheme2D* self,
                             PasangGameView* game_view,
                             cairo_t* cr)
{
	PasangGameSeries* game = NULL;
	PasangGameSeries* _tmp0_;
	PasangGameSeries* _tmp1_;
	PasangGameSeries* _tmp2_;
	PasangStage stage = 0;
	PasangGameSeries* _tmp3_;
	PasangGameSeries* _tmp4_;
	PasangStage _tmp5_;
	PasangStage _tmp6_;
	PasangMove* move = NULL;
	PasangMove* _tmp7_;
	PasangMove* _tmp8_;
	PasangMove* _tmp9_;
	PasangPoint kas_point = {0};
	PasangPoint _tmp10_;
#line 222 "theme-2d.vala"
	g_return_if_fail (self != NULL);
#line 222 "theme-2d.vala"
	g_return_if_fail (game_view != NULL);
#line 222 "theme-2d.vala"
	g_return_if_fail (cr != NULL);
#line 223 "theme-2d.vala"
	_tmp0_ = pasang_game_view_get_game (game_view);
#line 223 "theme-2d.vala"
	_tmp1_ = _tmp0_;
#line 223 "theme-2d.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 223 "theme-2d.vala"
	game = _tmp2_;
#line 224 "theme-2d.vala"
	_tmp3_ = pasang_game_view_get_game (game_view);
#line 224 "theme-2d.vala"
	_tmp4_ = _tmp3_;
#line 224 "theme-2d.vala"
	_tmp5_ = pasang_game_get_stage ((PasangGame*) _tmp4_);
#line 224 "theme-2d.vala"
	_tmp6_ = _tmp5_;
#line 224 "theme-2d.vala"
	stage = _tmp6_;
#line 225 "theme-2d.vala"
	_tmp7_ = pasang_game_view_get_selected_move (game_view);
#line 225 "theme-2d.vala"
	_tmp8_ = _tmp7_;
#line 225 "theme-2d.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 225 "theme-2d.vala"
	move = _tmp9_;
#line 226 "theme-2d.vala"
	_tmp10_ = game_view->kas_point;
#line 226 "theme-2d.vala"
	kas_point = _tmp10_;
#line 1043 "theme-2d.c"
	{
		gint layer = 0;
#line 227 "theme-2d.vala"
		layer = 0;
#line 1048 "theme-2d.c"
		{
			gboolean _tmp11_ = FALSE;
#line 227 "theme-2d.vala"
			_tmp11_ = TRUE;
#line 227 "theme-2d.vala"
			while (TRUE) {
#line 1055 "theme-2d.c"
				PasangFilm* _tmp44_;
				gint _tmp44__length1;
				PasangGameSeries* _tmp45_;
				PasangPiece _tmp46_;
				PasangPiece _tmp47_;
				PasangFilm _tmp48_;
				gboolean _tmp49_ = FALSE;
				gboolean _tmp50_ = FALSE;
				PasangStage _tmp51_;
#line 227 "theme-2d.vala"
				if (!_tmp11_) {
#line 1067 "theme-2d.c"
					gint _tmp12_;
#line 227 "theme-2d.vala"
					_tmp12_ = layer;
#line 227 "theme-2d.vala"
					layer = _tmp12_ + 1;
#line 1073 "theme-2d.c"
				}
#line 227 "theme-2d.vala"
				_tmp11_ = FALSE;
#line 227 "theme-2d.vala"
				if (!(layer < 150)) {
#line 227 "theme-2d.vala"
					break;
#line 1081 "theme-2d.c"
				}
				{
					gint position = 0;
#line 228 "theme-2d.vala"
					position = 0;
#line 1087 "theme-2d.c"
					{
						gboolean _tmp13_ = FALSE;
#line 228 "theme-2d.vala"
						_tmp13_ = TRUE;
#line 228 "theme-2d.vala"
						while (TRUE) {
#line 1094 "theme-2d.c"
							PasangFilm* _tmp15_;
							gint _tmp15__length1;
							PasangFilm _tmp16_;
							PasangPiece piece = 0;
							PasangGameSeries* _tmp17_;
							PasangPiece* _tmp18_;
							gint _tmp18__length1;
							PasangPiece _tmp19_;
							PasangPiece _tmp20_;
							gboolean _tmp21_ = FALSE;
							gboolean _tmp22_ = FALSE;
							PasangStage _tmp23_;
							gboolean _tmp28_ = FALSE;
							gboolean _tmp29_ = FALSE;
							PasangStage _tmp30_;
							PasangPoint p = {0};
							PasangGameSeries* _tmp36_;
							PasangPoint _tmp37_ = {0};
							gint radius = 0;
							PasangPiece _tmp38_;
							PasangPiece _tmp39_;
							PasangFilm* _tmp40_;
							gint _tmp40__length1;
							PasangFilm _tmp41_;
							PasangPoint _tmp42_;
							PasangPoint _tmp43_;
#line 228 "theme-2d.vala"
							if (!_tmp13_) {
#line 1123 "theme-2d.c"
								gint _tmp14_;
#line 228 "theme-2d.vala"
								_tmp14_ = position;
#line 228 "theme-2d.vala"
								position = _tmp14_ + 1;
#line 1129 "theme-2d.c"
							}
#line 228 "theme-2d.vala"
							_tmp13_ = FALSE;
#line 228 "theme-2d.vala"
							if (!(position < PASANG_BOARD_SIZE)) {
#line 228 "theme-2d.vala"
								break;
#line 1137 "theme-2d.c"
							}
#line 229 "theme-2d.vala"
							_tmp15_ = ((PasangTheme*) self)->films;
#line 229 "theme-2d.vala"
							_tmp15__length1 = ((PasangTheme*) self)->films_length1;
#line 229 "theme-2d.vala"
							_tmp16_ = _tmp15_[position];
#line 229 "theme-2d.vala"
							if (_tmp16_.viewed != layer) {
#line 229 "theme-2d.vala"
								continue;
#line 1149 "theme-2d.c"
							}
#line 232 "theme-2d.vala"
							_tmp17_ = game;
#line 232 "theme-2d.vala"
							_tmp18_ = ((PasangGame*) _tmp17_)->board;
#line 232 "theme-2d.vala"
							_tmp18__length1 = ((PasangGame*) _tmp17_)->board_length1;
#line 232 "theme-2d.vala"
							_tmp19_ = _tmp18_[position];
#line 232 "theme-2d.vala"
							piece = _tmp19_;
#line 233 "theme-2d.vala"
							_tmp20_ = piece;
#line 233 "theme-2d.vala"
							if (!pasang_piece_is_real (_tmp20_)) {
#line 233 "theme-2d.vala"
								continue;
#line 1167 "theme-2d.c"
							}
#line 238 "theme-2d.vala"
							_tmp23_ = stage;
#line 238 "theme-2d.vala"
							if (_tmp23_ == PASANG_STAGE_SELECT) {
#line 1173 "theme-2d.c"
								PasangMove* _tmp24_;
#line 238 "theme-2d.vala"
								_tmp24_ = move;
#line 238 "theme-2d.vala"
								_tmp22_ = _tmp24_ != NULL;
#line 1179 "theme-2d.c"
							} else {
#line 238 "theme-2d.vala"
								_tmp22_ = FALSE;
#line 1183 "theme-2d.c"
							}
#line 238 "theme-2d.vala"
							if (_tmp22_) {
#line 1187 "theme-2d.c"
								PasangMove* _tmp25_;
								gint _tmp26_;
								gint _tmp27_;
#line 238 "theme-2d.vala"
								_tmp25_ = move;
#line 238 "theme-2d.vala"
								_tmp26_ = pasang_move_get_position (_tmp25_);
#line 238 "theme-2d.vala"
								_tmp27_ = _tmp26_;
#line 238 "theme-2d.vala"
								_tmp21_ = position == _tmp27_;
#line 1199 "theme-2d.c"
							} else {
#line 238 "theme-2d.vala"
								_tmp21_ = FALSE;
#line 1203 "theme-2d.c"
							}
#line 238 "theme-2d.vala"
							if (_tmp21_) {
#line 238 "theme-2d.vala"
								continue;
#line 1209 "theme-2d.c"
							}
#line 243 "theme-2d.vala"
							_tmp30_ = stage;
#line 243 "theme-2d.vala"
							if (_tmp30_ == PASANG_STAGE_MOVE) {
#line 1215 "theme-2d.c"
								PasangPoint _tmp31_;
#line 243 "theme-2d.vala"
								_tmp31_ = kas_point;
#line 243 "theme-2d.vala"
								_tmp29_ = _tmp31_.x != -1;
#line 1221 "theme-2d.c"
							} else {
#line 243 "theme-2d.vala"
								_tmp29_ = FALSE;
#line 1225 "theme-2d.c"
							}
#line 243 "theme-2d.vala"
							if (_tmp29_) {
#line 1229 "theme-2d.c"
								PasangPiece _tmp32_;
								PasangGameSeries* _tmp33_;
								PasangPiece _tmp34_;
								PasangPiece _tmp35_;
#line 243 "theme-2d.vala"
								_tmp32_ = piece;
#line 243 "theme-2d.vala"
								_tmp33_ = game;
#line 243 "theme-2d.vala"
								_tmp34_ = pasang_game_get_kas ((PasangGame*) _tmp33_);
#line 243 "theme-2d.vala"
								_tmp35_ = _tmp34_;
#line 243 "theme-2d.vala"
								_tmp28_ = _tmp32_ == _tmp35_;
#line 1244 "theme-2d.c"
							} else {
#line 243 "theme-2d.vala"
								_tmp28_ = FALSE;
#line 1248 "theme-2d.c"
							}
#line 243 "theme-2d.vala"
							if (_tmp28_) {
#line 243 "theme-2d.vala"
								continue;
#line 1254 "theme-2d.c"
							}
#line 245 "theme-2d.vala"
							_tmp36_ = game;
#line 245 "theme-2d.vala"
							pasang_theme_to_point ((PasangTheme*) self, position, _tmp36_->rotated, &_tmp37_);
#line 245 "theme-2d.vala"
							p = _tmp37_;
#line 246 "theme-2d.vala"
							_tmp38_ = piece;
#line 246 "theme-2d.vala"
							radius = pasang_theme2_d_piece_image_width (self, _tmp38_) / 2;
#line 247 "theme-2d.vala"
							_tmp39_ = piece;
#line 247 "theme-2d.vala"
							_tmp40_ = ((PasangTheme*) self)->films;
#line 247 "theme-2d.vala"
							_tmp40__length1 = ((PasangTheme*) self)->films_length1;
#line 247 "theme-2d.vala"
							_tmp41_ = _tmp40_[position];
#line 247 "theme-2d.vala"
							_tmp42_ = p;
#line 247 "theme-2d.vala"
							_tmp43_ = p;
#line 247 "theme-2d.vala"
							pasang_theme2_d_draw_piece (self, cr, _tmp39_, _tmp41_.viewed, _tmp42_.x - radius, _tmp43_.y - radius);
#line 1280 "theme-2d.c"
						}
					}
				}
#line 250 "theme-2d.vala"
				_tmp44_ = ((PasangTheme*) self)->films;
#line 250 "theme-2d.vala"
				_tmp44__length1 = ((PasangTheme*) self)->films_length1;
#line 250 "theme-2d.vala"
				_tmp45_ = game;
#line 250 "theme-2d.vala"
				_tmp46_ = pasang_game_get_kas ((PasangGame*) _tmp45_);
#line 250 "theme-2d.vala"
				_tmp47_ = _tmp46_;
#line 250 "theme-2d.vala"
				_tmp48_ = _tmp44_[_tmp47_];
#line 250 "theme-2d.vala"
				if (_tmp48_.viewed != layer) {
#line 250 "theme-2d.vala"
					continue;
#line 1300 "theme-2d.c"
				}
#line 251 "theme-2d.vala"
				_tmp51_ = stage;
#line 251 "theme-2d.vala"
				if (_tmp51_ == PASANG_STAGE_SELECT) {
#line 1306 "theme-2d.c"
					PasangMove* _tmp52_;
#line 251 "theme-2d.vala"
					_tmp52_ = move;
#line 251 "theme-2d.vala"
					_tmp50_ = _tmp52_ != NULL;
#line 1312 "theme-2d.c"
				} else {
#line 251 "theme-2d.vala"
					_tmp50_ = FALSE;
#line 1316 "theme-2d.c"
				}
#line 251 "theme-2d.vala"
				if (_tmp50_) {
#line 251 "theme-2d.vala"
					_tmp49_ = TRUE;
#line 1322 "theme-2d.c"
				} else {
					gboolean _tmp53_ = FALSE;
					PasangStage _tmp54_;
#line 252 "theme-2d.vala"
					_tmp54_ = stage;
#line 252 "theme-2d.vala"
					if (_tmp54_ == PASANG_STAGE_MOVE) {
#line 1330 "theme-2d.c"
						PasangPoint _tmp55_;
#line 252 "theme-2d.vala"
						_tmp55_ = kas_point;
#line 252 "theme-2d.vala"
						_tmp53_ = _tmp55_.x != -1;
#line 1336 "theme-2d.c"
					} else {
#line 252 "theme-2d.vala"
						_tmp53_ = FALSE;
#line 1340 "theme-2d.c"
					}
#line 252 "theme-2d.vala"
					_tmp49_ = _tmp53_;
#line 1344 "theme-2d.c"
				}
#line 251 "theme-2d.vala"
				if (_tmp49_) {
#line 1348 "theme-2d.c"
					PasangPiece piece = 0;
					PasangGameSeries* _tmp56_;
					PasangPiece _tmp57_;
					PasangPiece _tmp58_;
					gint radius = 0;
					PasangPiece _tmp59_;
					PasangPiece _tmp60_;
					PasangFilm* _tmp61_;
					gint _tmp61__length1;
					PasangGameSeries* _tmp62_;
					PasangPiece _tmp63_;
					PasangPiece _tmp64_;
					PasangFilm _tmp65_;
					PasangPoint _tmp66_;
					PasangPoint _tmp67_;
#line 253 "theme-2d.vala"
					_tmp56_ = game;
#line 253 "theme-2d.vala"
					_tmp57_ = pasang_game_get_kas ((PasangGame*) _tmp56_);
#line 253 "theme-2d.vala"
					_tmp58_ = _tmp57_;
#line 253 "theme-2d.vala"
					piece = _tmp58_;
#line 254 "theme-2d.vala"
					_tmp59_ = piece;
#line 254 "theme-2d.vala"
					radius = pasang_theme2_d_piece_image_width (self, _tmp59_) / 2;
#line 255 "theme-2d.vala"
					_tmp60_ = piece;
#line 255 "theme-2d.vala"
					_tmp61_ = ((PasangTheme*) self)->films;
#line 255 "theme-2d.vala"
					_tmp61__length1 = ((PasangTheme*) self)->films_length1;
#line 255 "theme-2d.vala"
					_tmp62_ = game;
#line 255 "theme-2d.vala"
					_tmp63_ = pasang_game_get_kas ((PasangGame*) _tmp62_);
#line 255 "theme-2d.vala"
					_tmp64_ = _tmp63_;
#line 255 "theme-2d.vala"
					_tmp65_ = _tmp61_[_tmp64_];
#line 255 "theme-2d.vala"
					_tmp66_ = kas_point;
#line 255 "theme-2d.vala"
					_tmp67_ = kas_point;
#line 255 "theme-2d.vala"
					pasang_theme2_d_draw_piece (self, cr, _tmp60_, _tmp65_.viewed, _tmp66_.x - radius, _tmp67_.y - radius);
#line 1396 "theme-2d.c"
				}
			}
		}
	}
#line 222 "theme-2d.vala"
	_g_object_unref0 (move);
#line 222 "theme-2d.vala"
	_g_object_unref0 (game);
#line 1405 "theme-2d.c"
}

static void
pasang_theme2_d_draw_piece (PasangTheme2D* self,
                            cairo_t* cr,
                            PasangPiece piece,
                            gint frame,
                            gint x,
                            gint y)
{
	gint frames_per_row = 0;
	cairo_surface_t** _tmp0_;
	gint _tmp0__length1;
	cairo_surface_t* _tmp1_;
	gint frame_col = 0;
	gint frame_row = 0;
	gint width = 0;
	cairo_surface_t** _tmp2_;
	gint _tmp2__length1;
	cairo_surface_t* _tmp3_;
#line 260 "theme-2d.vala"
	g_return_if_fail (self != NULL);
#line 260 "theme-2d.vala"
	g_return_if_fail (cr != NULL);
#line 260 "theme-2d.vala"
	_vala_return_if_fail (pasang_piece_is_real (piece), "piece.is_real ()");
#line 262 "theme-2d.vala"
	cairo_save (cr);
#line 263 "theme-2d.vala"
	frame = MIN (frame, pasang_theme_count_frames ((PasangTheme*) self, piece) - 1);
#line 264 "theme-2d.vala"
	_tmp0_ = self->images;
#line 264 "theme-2d.vala"
	_tmp0__length1 = self->images_length1;
#line 264 "theme-2d.vala"
	_tmp1_ = _tmp0_[piece];
#line 264 "theme-2d.vala"
	frames_per_row = cairo_image_surface_get_width (_tmp1_) / pasang_theme2_d_piece_image_width (self, piece);
#line 265 "theme-2d.vala"
	frame_col = frame % frames_per_row;
#line 266 "theme-2d.vala"
	frame_row = frame / frames_per_row;
#line 267 "theme-2d.vala"
	width = pasang_theme2_d_piece_image_width (self, piece);
#line 268 "theme-2d.vala"
	cairo_translate (cr, (gdouble) x, (gdouble) y);
#line 269 "theme-2d.vala"
	_tmp2_ = self->images;
#line 269 "theme-2d.vala"
	_tmp2__length1 = self->images_length1;
#line 269 "theme-2d.vala"
	_tmp3_ = _tmp2_[piece];
#line 269 "theme-2d.vala"
	cairo_set_source_surface (cr, _tmp3_, (gdouble) ((-frame_col) * width), (gdouble) ((-frame_row) * width));
#line 270 "theme-2d.vala"
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) width);
#line 271 "theme-2d.vala"
	cairo_fill (cr);
#line 272 "theme-2d.vala"
	cairo_restore (cr);
#line 1466 "theme-2d.c"
}

static void
pasang_theme2_d_draw_table (PasangTheme2D* self,
                            cairo_t* cr)
{
	PasangLayout2D _tmp0_;
	PasangLayout2D _tmp1_;
	cairo_surface_t** _tmp2_;
	gint _tmp2__length1;
	cairo_surface_t* _tmp3_;
#line 275 "theme-2d.vala"
	g_return_if_fail (self != NULL);
#line 275 "theme-2d.vala"
	g_return_if_fail (cr != NULL);
#line 276 "theme-2d.vala"
	cairo_save (cr);
#line 277 "theme-2d.vala"
	_tmp0_ = self->table;
#line 277 "theme-2d.vala"
	_tmp1_ = self->table;
#line 277 "theme-2d.vala"
	cairo_translate (cr, (gdouble) _tmp0_.image_x, (gdouble) _tmp1_.image_y);
#line 278 "theme-2d.vala"
	_tmp2_ = self->images;
#line 278 "theme-2d.vala"
	_tmp2__length1 = self->images_length1;
#line 278 "theme-2d.vala"
	_tmp3_ = _tmp2_[PASANG_PIECE_BOARD];
#line 278 "theme-2d.vala"
	cairo_set_source_surface (cr, _tmp3_, (gdouble) 0, (gdouble) 0);
#line 279 "theme-2d.vala"
	cairo_paint (cr);
#line 280 "theme-2d.vala"
	cairo_restore (cr);
#line 1502 "theme-2d.c"
}

static void
pasang_theme2_d_draw_scores (PasangTheme2D* self,
                             cairo_t* cr,
                             PasangGameSeries* game)
{
	gint _tmp30_ = 0;
	PasangStage _tmp31_;
	PasangStage _tmp32_;
	gint round = 0;
	const gchar* _tmp33_ = NULL;
	PasangLayout2D _tmp34_;
	gchar* format = NULL;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	PasangLayout2D _tmp40_;
	PasangLayout2D _tmp41_;
	PasangLayout2D _tmp42_;
#line 283 "theme-2d.vala"
	g_return_if_fail (self != NULL);
#line 283 "theme-2d.vala"
	g_return_if_fail (cr != NULL);
#line 283 "theme-2d.vala"
	g_return_if_fail (game != NULL);
#line 1529 "theme-2d.c"
	{
		gint player = 0;
#line 284 "theme-2d.vala"
		player = 0;
#line 1534 "theme-2d.c"
		{
			gboolean _tmp0_ = FALSE;
#line 284 "theme-2d.vala"
			_tmp0_ = TRUE;
#line 284 "theme-2d.vala"
			while (TRUE) {
#line 1541 "theme-2d.c"
				gint _tmp2_ = 0;
				gint side = 0;
				PasangPiece _tmp3_ = 0;
				PasangPiece kas = 0;
				gint radius = 0;
				PasangPiece _tmp4_;
				gint sx = 0;
				PasangLayout2D _tmp5_;
				gint _tmp6_;
				gint sy = 0;
				PasangLayout2D _tmp7_;
				gint _tmp8_;
				PasangPiece _tmp9_;
				PasangLayout2D _tmp10_;
				gint _tmp11_;
				PasangLayout2D _tmp12_;
				gint* _tmp13_;
				gint _tmp13__length1;
				gint _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				PasangLayout2D _tmp17_;
				PasangLayout2D _tmp18_;
				gint _tmp19_;
				PasangLayout2D _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				PasangLayout2D _tmp25_;
				PasangLayout2D _tmp26_;
				gint _tmp27_;
				PasangLayout2D _tmp28_;
				gint _tmp29_;
#line 284 "theme-2d.vala"
				if (!_tmp0_) {
#line 1578 "theme-2d.c"
					gint _tmp1_;
#line 284 "theme-2d.vala"
					_tmp1_ = player;
#line 284 "theme-2d.vala"
					player = _tmp1_ + 1;
#line 1584 "theme-2d.c"
				}
#line 284 "theme-2d.vala"
				_tmp0_ = FALSE;
#line 284 "theme-2d.vala"
				if (!(player < 2)) {
#line 284 "theme-2d.vala"
					break;
#line 1592 "theme-2d.c"
				}
#line 285 "theme-2d.vala"
				if (game->rotated) {
#line 285 "theme-2d.vala"
					_tmp2_ = 1 - player;
#line 1598 "theme-2d.c"
				} else {
#line 285 "theme-2d.vala"
					_tmp2_ = player;
#line 1602 "theme-2d.c"
				}
#line 285 "theme-2d.vala"
				side = _tmp2_;
#line 287 "theme-2d.vala"
				if (player == 0) {
#line 287 "theme-2d.vala"
					_tmp3_ = PASANG_PIECE_KAS_0;
#line 1610 "theme-2d.c"
				} else {
#line 287 "theme-2d.vala"
					_tmp3_ = PASANG_PIECE_KAS_1;
#line 1614 "theme-2d.c"
				}
#line 287 "theme-2d.vala"
				kas = _tmp3_;
#line 288 "theme-2d.vala"
				_tmp4_ = kas;
#line 288 "theme-2d.vala"
				radius = pasang_theme2_d_piece_image_width (self, _tmp4_) / 2;
#line 289 "theme-2d.vala"
				_tmp5_ = self->table;
#line 289 "theme-2d.vala"
				_tmp6_ = _tmp5_.kas_x[side];
#line 289 "theme-2d.vala"
				sx = _tmp6_ - radius;
#line 290 "theme-2d.vala"
				_tmp7_ = self->table;
#line 290 "theme-2d.vala"
				_tmp8_ = _tmp7_.kas_y[side];
#line 290 "theme-2d.vala"
				sy = _tmp8_ - radius;
#line 291 "theme-2d.vala"
				_tmp9_ = kas;
#line 291 "theme-2d.vala"
				_tmp10_ = self->table;
#line 291 "theme-2d.vala"
				_tmp11_ = _tmp10_.kas_frame[player];
#line 291 "theme-2d.vala"
				pasang_theme2_d_draw_piece (self, cr, _tmp9_, _tmp11_, sx, sy);
#line 293 "theme-2d.vala"
				_tmp12_ = self->layout;
#line 293 "theme-2d.vala"
				pasang_rgb_set_source_for (&_tmp12_.score_color[player], cr);
#line 294 "theme-2d.vala"
				_tmp13_ = ((PasangGame*) game)->score;
#line 294 "theme-2d.vala"
				_tmp13__length1 = ((PasangGame*) game)->score_length1;
#line 294 "theme-2d.vala"
				_tmp14_ = _tmp13_[player];
#line 294 "theme-2d.vala"
				_tmp15_ = g_strdup_printf ("%d", _tmp14_);
#line 294 "theme-2d.vala"
				_tmp16_ = _tmp15_;
#line 294 "theme-2d.vala"
				_tmp17_ = self->table;
#line 294 "theme-2d.vala"
				_tmp18_ = self->table;
#line 294 "theme-2d.vala"
				_tmp19_ = _tmp18_.score_x[side];
#line 294 "theme-2d.vala"
				_tmp20_ = self->table;
#line 294 "theme-2d.vala"
				_tmp21_ = _tmp20_.score_y[side];
#line 294 "theme-2d.vala"
				pasang_theme2_d_show_text (self, cr, _tmp16_, _tmp17_.score_font_size, _tmp19_, _tmp21_, FALSE);
#line 294 "theme-2d.vala"
				_g_free0 (_tmp16_);
#line 296 "theme-2d.vala"
				pasang_rgb_set_source_for (&self->layout.num_wins_color, cr);
#line 297 "theme-2d.vala"
				_tmp22_ = game->num_wins[side];
#line 297 "theme-2d.vala"
				_tmp23_ = g_strdup_printf ("%d", _tmp22_);
#line 297 "theme-2d.vala"
				_tmp24_ = _tmp23_;
#line 297 "theme-2d.vala"
				_tmp25_ = self->table;
#line 297 "theme-2d.vala"
				_tmp26_ = self->table;
#line 297 "theme-2d.vala"
				_tmp27_ = _tmp26_.num_wins_x[side];
#line 297 "theme-2d.vala"
				_tmp28_ = self->table;
#line 297 "theme-2d.vala"
				_tmp29_ = _tmp28_.num_wins_y[side];
#line 297 "theme-2d.vala"
				pasang_theme2_d_show_text (self, cr, _tmp24_, _tmp25_.num_wins_font_size, _tmp27_, _tmp29_, FALSE);
#line 297 "theme-2d.vala"
				_g_free0 (_tmp24_);
#line 1692 "theme-2d.c"
			}
		}
	}
#line 300 "theme-2d.vala"
	_tmp31_ = pasang_game_get_stage ((PasangGame*) game);
#line 300 "theme-2d.vala"
	_tmp32_ = _tmp31_;
#line 300 "theme-2d.vala"
	if (_tmp32_ == PASANG_STAGE_GAME_OVER) {
#line 300 "theme-2d.vala"
		_tmp30_ = game->num_rounds;
#line 1704 "theme-2d.c"
	} else {
#line 300 "theme-2d.vala"
		_tmp30_ = game->num_rounds + 1;
#line 1708 "theme-2d.c"
	}
#line 300 "theme-2d.vala"
	round = _tmp30_;
#line 301 "theme-2d.vala"
	pasang_rgb_set_source_for (&self->layout.num_rounds_color, cr);
#line 302 "theme-2d.vala"
	_tmp34_ = self->layout;
#line 302 "theme-2d.vala"
	if (_tmp34_.num_rounds_format == 0) {
#line 302 "theme-2d.vala"
		_tmp33_ = _ ("Round\n%d");
#line 1720 "theme-2d.c"
	} else {
		const gchar* _tmp35_ = NULL;
		PasangLayout2D _tmp36_;
#line 303 "theme-2d.vala"
		_tmp36_ = self->layout;
#line 303 "theme-2d.vala"
		if (_tmp36_.num_rounds_format == 1) {
#line 303 "theme-2d.vala"
			_tmp35_ = _ ("Round %d");
#line 1730 "theme-2d.c"
		} else {
#line 303 "theme-2d.vala"
			_tmp35_ = "%d";
#line 1734 "theme-2d.c"
		}
#line 303 "theme-2d.vala"
		_tmp33_ = _tmp35_;
#line 1738 "theme-2d.c"
	}
#line 302 "theme-2d.vala"
	_tmp37_ = g_strdup (_tmp33_);
#line 302 "theme-2d.vala"
	format = _tmp37_;
#line 304 "theme-2d.vala"
	_tmp38_ = g_strdup_printf (format, round);
#line 304 "theme-2d.vala"
	_tmp39_ = _tmp38_;
#line 304 "theme-2d.vala"
	_tmp40_ = self->table;
#line 304 "theme-2d.vala"
	_tmp41_ = self->table;
#line 304 "theme-2d.vala"
	_tmp42_ = self->table;
#line 304 "theme-2d.vala"
	pasang_theme2_d_show_text (self, cr, _tmp39_, _tmp40_.num_rounds_font_size, _tmp41_.num_rounds_x, _tmp42_.num_rounds_y, FALSE);
#line 304 "theme-2d.vala"
	_g_free0 (_tmp39_);
#line 283 "theme-2d.vala"
	_g_free0 (format);
#line 1760 "theme-2d.c"
}

static void
pasang_theme2_d_draw_message (PasangTheme2D* self,
                              cairo_t* cr,
                              const gchar* message)
{
	PasangLayout2D _tmp0_;
	PasangLayout2D _tmp1_;
	PasangLayout2D _tmp2_;
	PasangLayout2D _tmp3_;
	PasangLayout2D _tmp4_;
#line 308 "theme-2d.vala"
	g_return_if_fail (self != NULL);
#line 308 "theme-2d.vala"
	g_return_if_fail (cr != NULL);
#line 309 "theme-2d.vala"
	if (message == NULL) {
#line 309 "theme-2d.vala"
		return;
#line 1781 "theme-2d.c"
	}
#line 310 "theme-2d.vala"
	cairo_set_source_rgb (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0);
#line 311 "theme-2d.vala"
	_tmp0_ = self->table;
#line 311 "theme-2d.vala"
	_tmp1_ = self->table;
#line 311 "theme-2d.vala"
	_tmp2_ = self->table;
#line 311 "theme-2d.vala"
	_tmp3_ = self->table;
#line 311 "theme-2d.vala"
	_tmp4_ = self->table;
#line 311 "theme-2d.vala"
	pasang_theme2_d_show_text (self, cr, message, (_tmp0_.board_size / PASANG_BOARD_WIDTH) / 3, _tmp1_.board_x + (_tmp2_.board_size / 2), _tmp3_.board_y + (_tmp4_.board_size / 4), TRUE);
#line 1797 "theme-2d.c"
}

/**
     * Show text centred at x,y
     */
static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
#line 318 "theme-2d.vala"
	g_boxed_free (pango_font_description_get_type (), self);
#line 1808 "theme-2d.c"
}

void
pasang_theme2_d_show_text (PasangTheme2D* self,
                           cairo_t* cr,
                           const gchar* text,
                           gint font_size,
                           gint cx,
                           gint cy,
                           gboolean boxed)
{
	PangoFontDescription* font = NULL;
	PangoFontDescription* _tmp0_;
	PangoFontDescription* _tmp1_;
	PangoFontDescription* _tmp2_;
	PangoLayout* pango_layout = NULL;
	PangoLayout* _tmp3_;
	PangoLayout* _tmp4_;
	PangoFontDescription* _tmp5_;
	PangoLayout* _tmp6_;
	PangoLayout* _tmp7_;
	gint width = 0;
	gint height = 0;
	PangoLayout* _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint x = 0;
	gint y = 0;
	PangoLayout* _tmp12_;
#line 318 "theme-2d.vala"
	g_return_if_fail (self != NULL);
#line 318 "theme-2d.vala"
	g_return_if_fail (cr != NULL);
#line 318 "theme-2d.vala"
	g_return_if_fail (text != NULL);
#line 321 "theme-2d.vala"
	_tmp0_ = pango_font_description_new ();
#line 321 "theme-2d.vala"
	font = _tmp0_;
#line 322 "theme-2d.vala"
	_tmp1_ = font;
#line 322 "theme-2d.vala"
	pango_font_description_set_family (_tmp1_, "Sans");
#line 323 "theme-2d.vala"
	_tmp2_ = font;
#line 323 "theme-2d.vala"
	pango_font_description_set_size (_tmp2_, (gint) (font_size * PANGO_SCALE));
#line 325 "theme-2d.vala"
	_tmp3_ = pango_cairo_create_layout (cr);
#line 325 "theme-2d.vala"
	pango_layout = _tmp3_;
#line 326 "theme-2d.vala"
	_tmp4_ = pango_layout;
#line 326 "theme-2d.vala"
	_tmp5_ = font;
#line 326 "theme-2d.vala"
	pango_layout_set_font_description (_tmp4_, _tmp5_);
#line 327 "theme-2d.vala"
	_tmp6_ = pango_layout;
#line 327 "theme-2d.vala"
	pango_layout_set_alignment (_tmp6_, PANGO_ALIGN_CENTER);
#line 328 "theme-2d.vala"
	_tmp7_ = pango_layout;
#line 328 "theme-2d.vala"
	pango_layout_set_text (_tmp7_, text, -1);
#line 330 "theme-2d.vala"
	_tmp8_ = pango_layout;
#line 330 "theme-2d.vala"
	pango_layout_get_pixel_size (_tmp8_, &_tmp9_, &_tmp10_);
#line 330 "theme-2d.vala"
	width = _tmp9_;
#line 330 "theme-2d.vala"
	height = _tmp10_;
#line 331 "theme-2d.vala"
	x = cx - (width / 2);
#line 332 "theme-2d.vala"
	y = cy - (height / 2);
#line 333 "theme-2d.vala"
	if (boxed) {
#line 1888 "theme-2d.c"
		gdouble gap = 0.0;
		PangoLayout* _tmp11_;
#line 334 "theme-2d.vala"
		cairo_save (cr);
#line 335 "theme-2d.vala"
		cairo_set_source_rgba (cr, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.6);
#line 336 "theme-2d.vala"
		gap = 0.8 * font_size;
#line 337 "theme-2d.vala"
		cairo_rectangle (cr, x - gap, y - gap, width + (2 * gap), height + (2 * gap));
#line 338 "theme-2d.vala"
		cairo_fill (cr);
#line 339 "theme-2d.vala"
		cairo_set_source_rgb (cr, 0.5, 0.5, 0.5);
#line 340 "theme-2d.vala"
		cairo_move_to (cr, (gdouble) (x + 1), (gdouble) (y + 1));
#line 341 "theme-2d.vala"
		_tmp11_ = pango_layout;
#line 341 "theme-2d.vala"
		pango_cairo_show_layout (cr, _tmp11_);
#line 342 "theme-2d.vala"
		cairo_restore (cr);
#line 1911 "theme-2d.c"
	}
#line 344 "theme-2d.vala"
	cairo_move_to (cr, (gdouble) x, (gdouble) y);
#line 345 "theme-2d.vala"
	_tmp12_ = pango_layout;
#line 345 "theme-2d.vala"
	pango_cairo_show_layout (cr, _tmp12_);
#line 318 "theme-2d.vala"
	_g_object_unref0 (pango_layout);
#line 318 "theme-2d.vala"
	__vala_PangoFontDescription_free0 (font);
#line 1923 "theme-2d.c"
}

static void
pasang_theme2_d_real_queue_draw_piece (PasangTheme* base,
                                       GtkDrawingArea* view,
                                       PasangPiece piece,
                                       PasangPoint* p)
{
	PasangTheme2D * self;
	PasangPoint _tmp0_;
	gint _tmp1_ = 0;
	gint width = 0;
	PasangPoint _tmp2_;
	PasangPoint _tmp3_;
#line 348 "theme-2d.vala"
	self = (PasangTheme2D*) base;
#line 348 "theme-2d.vala"
	g_return_if_fail (view != NULL);
#line 348 "theme-2d.vala"
	g_return_if_fail (p != NULL);
#line 349 "theme-2d.vala"
	_tmp0_ = *p;
#line 349 "theme-2d.vala"
	if (_tmp0_.x == -1) {
#line 349 "theme-2d.vala"
		return;
#line 1950 "theme-2d.c"
	}
#line 350 "theme-2d.vala"
	if (piece == PASANG_PIECE_EMPTY) {
#line 350 "theme-2d.vala"
		_tmp1_ = pasang_theme2_d_cell_width (self);
#line 1956 "theme-2d.c"
	} else {
#line 350 "theme-2d.vala"
		_tmp1_ = pasang_theme2_d_piece_image_width (self, piece);
#line 1960 "theme-2d.c"
	}
#line 350 "theme-2d.vala"
	width = _tmp1_;
#line 351 "theme-2d.vala"
	_tmp2_ = *p;
#line 351 "theme-2d.vala"
	_tmp3_ = *p;
#line 351 "theme-2d.vala"
	gtk_widget_queue_draw_area ((GtkWidget*) view, _tmp2_.x - (width / 2), _tmp3_.y - (width / 2), width, width);
#line 1970 "theme-2d.c"
}

static gint
pasang_theme2_d_real_count_frames (PasangTheme* base,
                                   PasangPiece piece)
{
	PasangTheme2D * self;
	cairo_surface_t** _tmp0_;
	gint _tmp0__length1;
	cairo_surface_t* _tmp1_;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gint result = 0;
#line 354 "theme-2d.vala"
	self = (PasangTheme2D*) base;
#line 354 "theme-2d.vala"
	_vala_return_val_if_fail (pasang_piece_is_real (piece), "piece.is_real ()", 0);
#line 356 "theme-2d.vala"
	_tmp0_ = self->images;
#line 356 "theme-2d.vala"
	_tmp0__length1 = self->images_length1;
#line 356 "theme-2d.vala"
	_tmp1_ = _tmp0_[piece];
#line 356 "theme-2d.vala"
	_tmp2_ = self->num_rows_in_image;
#line 356 "theme-2d.vala"
	_tmp2__length1 = self->num_rows_in_image_length1;
#line 356 "theme-2d.vala"
	_tmp3_ = _tmp2_[piece];
#line 356 "theme-2d.vala"
	result = (cairo_image_surface_get_width (_tmp1_) / pasang_theme2_d_piece_image_width (self, piece)) * _tmp3_;
#line 356 "theme-2d.vala"
	return result;
#line 2005 "theme-2d.c"
}

static gint
pasang_theme2_d_piece_image_width (PasangTheme2D* self,
                                   PasangPiece piece)
{
	cairo_surface_t** _tmp0_;
	gint _tmp0__length1;
	cairo_surface_t* _tmp1_;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gint result = 0;
#line 359 "theme-2d.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 359 "theme-2d.vala"
	_vala_return_val_if_fail (pasang_piece_is_real (piece), "piece.is_real ()", 0);
#line 361 "theme-2d.vala"
	_tmp0_ = self->images;
#line 361 "theme-2d.vala"
	_tmp0__length1 = self->images_length1;
#line 361 "theme-2d.vala"
	_tmp1_ = _tmp0_[piece];
#line 361 "theme-2d.vala"
	_tmp2_ = self->num_rows_in_image;
#line 361 "theme-2d.vala"
	_tmp2__length1 = self->num_rows_in_image_length1;
#line 361 "theme-2d.vala"
	_tmp3_ = _tmp2_[piece];
#line 361 "theme-2d.vala"
	result = cairo_image_surface_get_height (_tmp1_) / _tmp3_;
#line 361 "theme-2d.vala"
	return result;
#line 2039 "theme-2d.c"
}

gint
pasang_theme2_d_cell_width (PasangTheme2D* self)
{
	PasangLayout2D _tmp0_;
	gint result = 0;
#line 364 "theme-2d.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 365 "theme-2d.vala"
	_tmp0_ = self->table;
#line 365 "theme-2d.vala"
	result = _tmp0_.board_size / PASANG_BOARD_WIDTH;
#line 365 "theme-2d.vala"
	return result;
#line 2055 "theme-2d.c"
}

static void
pasang_theme2_d_real_to_point (PasangTheme* base,
                               gint pos,
                               gboolean rotated,
                               PasangPoint* result)
{
	PasangTheme2D * self;
	gint border_width = 0;
	PasangLayout2D _tmp0_;
	PasangLayout2D _tmp1_;
	PasangPoint _tmp2_ = {0};
#line 368 "theme-2d.vala"
	self = (PasangTheme2D*) base;
#line 368 "theme-2d.vala"
	_vala_return_if_fail ((pos >= 0) && (pos < PASANG_BOARD_SIZE), "pos >= 0 && pos < BOARD_SIZE");
#line 370 "theme-2d.vala"
	if (rotated) {
#line 370 "theme-2d.vala"
		pos = (PASANG_BOARD_SIZE - 1) - pos;
#line 2077 "theme-2d.c"
	}
#line 371 "theme-2d.vala"
	border_width = pasang_theme2_d_cell_width (self) / 2;
#line 372 "theme-2d.vala"
	_tmp0_ = self->table;
#line 372 "theme-2d.vala"
	_tmp1_ = self->table;
#line 372 "theme-2d.vala"
	pasang_point_init_xy (&_tmp2_, (_tmp0_.board_x + ((pos % PASANG_BOARD_WIDTH) * pasang_theme2_d_cell_width (self))) + border_width, (_tmp1_.board_y + ((pos / PASANG_BOARD_WIDTH) * pasang_theme2_d_cell_width (self))) + border_width);
#line 372 "theme-2d.vala"
	*result = _tmp2_;
#line 372 "theme-2d.vala"
	return;
#line 2091 "theme-2d.c"
}

static gint
pasang_theme2_d_real_to_position (PasangTheme* base,
                                  PasangGame* game,
                                  PasangPoint* raw_p,
                                  gboolean rotated,
                                  gboolean precise)
{
	PasangTheme2D * self;
	PasangPoint p = {0};
	PasangPoint _tmp0_;
	PasangLayout2D _tmp1_;
	PasangPoint _tmp2_;
	PasangLayout2D _tmp3_;
	gint col = 0;
	PasangPoint _tmp4_;
	gint row = 0;
	PasangPoint _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gint pos = 0;
	PasangPoint c = {0};
	PasangPoint _tmp9_ = {0};
	PasangLayout2D _tmp10_;
	PasangLayout2D _tmp11_;
	gint x = 0;
	PasangPoint _tmp12_;
	PasangPoint _tmp13_;
	gint y = 0;
	PasangPoint _tmp14_;
	PasangPoint _tmp15_;
	PasangPiece piece = 0;
	PasangPiece* _tmp16_;
	gint _tmp16__length1;
	PasangPiece _tmp17_;
	gint _tmp18_ = 0;
	gint snap_range = 0;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	PasangPoint _tmp21_;
	PasangPoint _tmp22_;
	PasangPoint _tmp23_;
	PasangPoint _tmp24_;
	PasangPoint _tmp25_;
	PasangPoint _tmp26_;
	PasangPoint _tmp27_;
	PasangPoint _tmp28_;
	gint result = 0;
#line 378 "theme-2d.vala"
	self = (PasangTheme2D*) base;
#line 378 "theme-2d.vala"
	g_return_val_if_fail (game != NULL, 0);
#line 378 "theme-2d.vala"
	g_return_val_if_fail (raw_p != NULL, 0);
#line 380 "theme-2d.vala"
	_tmp0_ = *raw_p;
#line 380 "theme-2d.vala"
	_tmp1_ = self->table;
#line 380 "theme-2d.vala"
	_tmp2_ = *raw_p;
#line 380 "theme-2d.vala"
	_tmp3_ = self->table;
#line 380 "theme-2d.vala"
	pasang_point_init_xy (&p, _tmp0_.x - _tmp1_.board_x, _tmp2_.y - _tmp3_.board_y);
#line 382 "theme-2d.vala"
	_tmp4_ = p;
#line 382 "theme-2d.vala"
	col = _tmp4_.x / pasang_theme2_d_cell_width (self);
#line 383 "theme-2d.vala"
	_tmp5_ = p;
#line 383 "theme-2d.vala"
	row = _tmp5_.y / pasang_theme2_d_cell_width (self);
#line 384 "theme-2d.vala"
	if (col < 1) {
#line 384 "theme-2d.vala"
		_tmp8_ = TRUE;
#line 2170 "theme-2d.c"
	} else {
#line 384 "theme-2d.vala"
		_tmp8_ = col > 11;
#line 2174 "theme-2d.c"
	}
#line 384 "theme-2d.vala"
	if (_tmp8_) {
#line 384 "theme-2d.vala"
		_tmp7_ = TRUE;
#line 2180 "theme-2d.c"
	} else {
#line 384 "theme-2d.vala"
		_tmp7_ = row < 1;
#line 2184 "theme-2d.c"
	}
#line 384 "theme-2d.vala"
	if (_tmp7_) {
#line 384 "theme-2d.vala"
		_tmp6_ = TRUE;
#line 2190 "theme-2d.c"
	} else {
#line 384 "theme-2d.vala"
		_tmp6_ = row > 11;
#line 2194 "theme-2d.c"
	}
#line 384 "theme-2d.vala"
	if (_tmp6_) {
#line 384 "theme-2d.vala"
		result = -1;
#line 384 "theme-2d.vala"
		return result;
#line 2202 "theme-2d.c"
	}
#line 385 "theme-2d.vala"
	pos = (row * PASANG_BOARD_WIDTH) + col;
#line 386 "theme-2d.vala"
	if (rotated) {
#line 387 "theme-2d.vala"
		pos = (PASANG_BOARD_SIZE - 1) - pos;
#line 2210 "theme-2d.c"
	}
#line 390 "theme-2d.vala"
	pasang_theme_to_point ((PasangTheme*) self, pos, rotated, &_tmp9_);
#line 390 "theme-2d.vala"
	c = _tmp9_;
#line 391 "theme-2d.vala"
	_tmp10_ = self->table;
#line 391 "theme-2d.vala"
	c.x = c.x - _tmp10_.board_x;
#line 392 "theme-2d.vala"
	_tmp11_ = self->table;
#line 392 "theme-2d.vala"
	c.y = c.y - _tmp11_.board_y;
#line 394 "theme-2d.vala"
	_tmp12_ = p;
#line 394 "theme-2d.vala"
	_tmp13_ = c;
#line 394 "theme-2d.vala"
	x = _tmp12_.x - _tmp13_.x;
#line 395 "theme-2d.vala"
	_tmp14_ = p;
#line 395 "theme-2d.vala"
	_tmp15_ = c;
#line 395 "theme-2d.vala"
	y = _tmp14_.y - _tmp15_.y;
#line 396 "theme-2d.vala"
	_tmp16_ = game->board;
#line 396 "theme-2d.vala"
	_tmp16__length1 = game->board_length1;
#line 396 "theme-2d.vala"
	_tmp17_ = _tmp16_[pos];
#line 396 "theme-2d.vala"
	piece = _tmp17_;
#line 397 "theme-2d.vala"
	if (precise) {
#line 397 "theme-2d.vala"
		_tmp18_ = 1;
#line 2248 "theme-2d.c"
	} else {
#line 397 "theme-2d.vala"
		_tmp18_ = pasang_theme2_d_cell_width (self) / 6;
#line 2252 "theme-2d.c"
	}
#line 397 "theme-2d.vala"
	snap_range = 1 + _tmp18_;
#line 399 "theme-2d.vala"
	_tmp21_ = p;
#line 399 "theme-2d.vala"
	_tmp22_ = c;
#line 399 "theme-2d.vala"
	_tmp23_ = p;
#line 399 "theme-2d.vala"
	_tmp24_ = c;
#line 399 "theme-2d.vala"
	_tmp25_ = p;
#line 399 "theme-2d.vala"
	_tmp26_ = c;
#line 399 "theme-2d.vala"
	_tmp27_ = p;
#line 399 "theme-2d.vala"
	_tmp28_ = c;
#line 399 "theme-2d.vala"
	if ((((_tmp21_.x - _tmp22_.x) * (_tmp23_.x - _tmp24_.x)) + ((_tmp25_.y - _tmp26_.y) * (_tmp27_.y - _tmp28_.y))) <= (snap_range * snap_range)) {
#line 399 "theme-2d.vala"
		_tmp20_ = TRUE;
#line 2276 "theme-2d.c"
	} else {
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
#line 401 "theme-2d.vala"
		if (!precise) {
#line 2282 "theme-2d.c"
			PasangPiece _tmp31_;
#line 401 "theme-2d.vala"
			_tmp31_ = piece;
#line 401 "theme-2d.vala"
			_tmp30_ = pasang_piece_is_real (_tmp31_);
#line 2288 "theme-2d.c"
		} else {
#line 401 "theme-2d.vala"
			_tmp30_ = FALSE;
#line 2292 "theme-2d.c"
		}
#line 401 "theme-2d.vala"
		if (_tmp30_) {
#line 2296 "theme-2d.c"
			PasangPiece _tmp32_;
#line 401 "theme-2d.vala"
			_tmp32_ = piece;
#line 401 "theme-2d.vala"
			_tmp29_ = pasang_theme2_d_detect_piece (self, _tmp32_, 0, x, y);
#line 2302 "theme-2d.c"
		} else {
#line 401 "theme-2d.vala"
			_tmp29_ = FALSE;
#line 2306 "theme-2d.c"
		}
#line 401 "theme-2d.vala"
		_tmp20_ = _tmp29_;
#line 2310 "theme-2d.c"
	}
#line 399 "theme-2d.vala"
	if (_tmp20_) {
#line 399 "theme-2d.vala"
		_tmp19_ = TRUE;
#line 2316 "theme-2d.c"
	} else {
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
#line 403 "theme-2d.vala"
		if (!precise) {
#line 2322 "theme-2d.c"
			PasangPiece _tmp35_;
#line 403 "theme-2d.vala"
			_tmp35_ = piece;
#line 403 "theme-2d.vala"
			_tmp34_ = _tmp35_ == PASANG_PIECE_EMPTY;
#line 2328 "theme-2d.c"
		} else {
#line 403 "theme-2d.vala"
			_tmp34_ = FALSE;
#line 2332 "theme-2d.c"
		}
#line 403 "theme-2d.vala"
		if (_tmp34_) {
#line 2336 "theme-2d.c"
			gboolean _tmp36_ = FALSE;
			PasangPiece _tmp37_;
			PasangPiece _tmp38_;
#line 404 "theme-2d.vala"
			_tmp37_ = pasang_game_get_kas (game);
#line 404 "theme-2d.vala"
			_tmp38_ = _tmp37_;
#line 404 "theme-2d.vala"
			if (pasang_theme2_d_detect_piece (self, _tmp38_, 0, -x, -y)) {
#line 404 "theme-2d.vala"
				_tmp36_ = TRUE;
#line 2348 "theme-2d.c"
			} else {
				PasangPiece _tmp39_;
				PasangPiece _tmp40_;
				PasangFilm* _tmp41_;
				gint _tmp41__length1;
				PasangFilm _tmp42_;
#line 404 "theme-2d.vala"
				_tmp39_ = pasang_game_get_kas (game);
#line 404 "theme-2d.vala"
				_tmp40_ = _tmp39_;
#line 404 "theme-2d.vala"
				_tmp41_ = ((PasangTheme*) self)->films;
#line 404 "theme-2d.vala"
				_tmp41__length1 = ((PasangTheme*) self)->films_length1;
#line 404 "theme-2d.vala"
				_tmp42_ = _tmp41_[0];
#line 404 "theme-2d.vala"
				_tmp36_ = pasang_theme2_d_detect_piece (self, _tmp40_, _tmp42_.viewed, -x, -y);
#line 2367 "theme-2d.c"
			}
#line 404 "theme-2d.vala"
			_tmp33_ = _tmp36_;
#line 2371 "theme-2d.c"
		} else {
#line 403 "theme-2d.vala"
			_tmp33_ = FALSE;
#line 2375 "theme-2d.c"
		}
#line 403 "theme-2d.vala"
		_tmp19_ = _tmp33_;
#line 2379 "theme-2d.c"
	}
#line 398 "theme-2d.vala"
	if (_tmp19_) {
#line 405 "theme-2d.vala"
		result = pos;
#line 405 "theme-2d.vala"
		return result;
#line 2387 "theme-2d.c"
	} else {
#line 408 "theme-2d.vala"
		result = -1;
#line 408 "theme-2d.vala"
		return result;
#line 2393 "theme-2d.c"
	}
}

static gboolean
pasang_theme2_d_detect_piece (PasangTheme2D* self,
                              PasangPiece piece,
                              gint frame,
                              gint x,
                              gint y)
{
	gint width = 0;
	gint frames_per_row = 0;
	cairo_surface_t** _tmp0_;
	gint _tmp0__length1;
	cairo_surface_t* _tmp1_;
	gint frame_col = 0;
	gint frame_row = 0;
	guchar* data = NULL;
	cairo_surface_t** _tmp2_;
	gint _tmp2__length1;
	cairo_surface_t* _tmp3_;
	guchar* _tmp4_;
	gint data_length1;
	gint _data_size_;
	gint n = 0;
	cairo_surface_t** _tmp5_;
	gint _tmp5__length1;
	cairo_surface_t* _tmp6_;
	guchar _tmp7_;
	guchar _tmp8_;
	guchar _tmp9_;
	guchar _tmp10_;
	gboolean result = FALSE;
#line 412 "theme-2d.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 412 "theme-2d.vala"
	_vala_return_val_if_fail (pasang_piece_is_real (piece), "piece.is_real ()", FALSE);
#line 414 "theme-2d.vala"
	width = pasang_theme2_d_piece_image_width (self, piece);
#line 415 "theme-2d.vala"
	x = x + (width / 2);
#line 416 "theme-2d.vala"
	y = y + (width / 2);
#line 417 "theme-2d.vala"
	frame = MIN (frame, pasang_theme_count_frames ((PasangTheme*) self, piece) - 1);
#line 418 "theme-2d.vala"
	_tmp0_ = self->images;
#line 418 "theme-2d.vala"
	_tmp0__length1 = self->images_length1;
#line 418 "theme-2d.vala"
	_tmp1_ = _tmp0_[piece];
#line 418 "theme-2d.vala"
	frames_per_row = cairo_image_surface_get_width (_tmp1_) / pasang_theme2_d_piece_image_width (self, piece);
#line 419 "theme-2d.vala"
	frame_col = frame % frames_per_row;
#line 420 "theme-2d.vala"
	frame_row = frame / frames_per_row;
#line 421 "theme-2d.vala"
	_tmp2_ = self->images;
#line 421 "theme-2d.vala"
	_tmp2__length1 = self->images_length1;
#line 421 "theme-2d.vala"
	_tmp3_ = _tmp2_[piece];
#line 421 "theme-2d.vala"
	_tmp4_ = cairo_image_surface_get_data (_tmp3_);
#line 421 "theme-2d.vala"
	data = _tmp4_;
#line 421 "theme-2d.vala"
	data_length1 = -1;
#line 421 "theme-2d.vala"
	_data_size_ = data_length1;
#line 422 "theme-2d.vala"
	_tmp5_ = self->images;
#line 422 "theme-2d.vala"
	_tmp5__length1 = self->images_length1;
#line 422 "theme-2d.vala"
	_tmp6_ = _tmp5_[piece];
#line 422 "theme-2d.vala"
	n = 4 * (((((frame_row * width) + y) * cairo_image_surface_get_width (_tmp6_)) + (frame_col * width)) + x);
#line 423 "theme-2d.vala"
	_tmp7_ = data[n];
#line 423 "theme-2d.vala"
	_tmp8_ = data[n + 1];
#line 423 "theme-2d.vala"
	_tmp9_ = data[n + 2];
#line 423 "theme-2d.vala"
	_tmp10_ = data[n + 3];
#line 423 "theme-2d.vala"
	result = ((gint) (((_tmp7_ | _tmp8_) | _tmp9_) | _tmp10_)) != 0;
#line 423 "theme-2d.vala"
	return result;
#line 2485 "theme-2d.c"
}

static gint
pasang_theme2_d_real_to_side (PasangTheme* base,
                              PasangPoint* p)
{
	PasangTheme2D * self;
	gboolean _tmp0_ = FALSE;
	PasangPoint _tmp1_;
	PasangLayout2D _tmp2_;
	gint result = 0;
#line 426 "theme-2d.vala"
	self = (PasangTheme2D*) base;
#line 426 "theme-2d.vala"
	g_return_val_if_fail (p != NULL, 0);
#line 427 "theme-2d.vala"
	_tmp1_ = *p;
#line 427 "theme-2d.vala"
	_tmp2_ = self->table;
#line 427 "theme-2d.vala"
	if (_tmp1_.x >= _tmp2_.board_x) {
#line 2507 "theme-2d.c"
		PasangPoint _tmp3_;
		PasangLayout2D _tmp4_;
		PasangLayout2D _tmp5_;
#line 427 "theme-2d.vala"
		_tmp3_ = *p;
#line 427 "theme-2d.vala"
		_tmp4_ = self->table;
#line 427 "theme-2d.vala"
		_tmp5_ = self->table;
#line 427 "theme-2d.vala"
		_tmp0_ = _tmp3_.x <= (_tmp4_.board_x + _tmp5_.board_size);
#line 2519 "theme-2d.c"
	} else {
#line 427 "theme-2d.vala"
		_tmp0_ = FALSE;
#line 2523 "theme-2d.c"
	}
#line 427 "theme-2d.vala"
	if (_tmp0_) {
#line 2527 "theme-2d.c"
		gboolean _tmp6_ = FALSE;
		PasangPoint _tmp7_;
		PasangLayout2D _tmp8_;
#line 428 "theme-2d.vala"
		_tmp7_ = *p;
#line 428 "theme-2d.vala"
		_tmp8_ = self->table;
#line 428 "theme-2d.vala"
		if (_tmp7_.y >= _tmp8_.board_y) {
#line 2537 "theme-2d.c"
			PasangPoint _tmp9_;
			PasangLayout2D _tmp10_;
			PasangLayout2D _tmp11_;
#line 428 "theme-2d.vala"
			_tmp9_ = *p;
#line 428 "theme-2d.vala"
			_tmp10_ = self->table;
#line 428 "theme-2d.vala"
			_tmp11_ = self->table;
#line 428 "theme-2d.vala"
			_tmp6_ = _tmp9_.y <= (_tmp10_.board_y + (_tmp11_.board_size / 2));
#line 2549 "theme-2d.c"
		} else {
#line 428 "theme-2d.vala"
			_tmp6_ = FALSE;
#line 2553 "theme-2d.c"
		}
#line 428 "theme-2d.vala"
		if (_tmp6_) {
#line 429 "theme-2d.vala"
			result = 0;
#line 429 "theme-2d.vala"
			return result;
#line 2561 "theme-2d.c"
		} else {
			gboolean _tmp12_ = FALSE;
			PasangPoint _tmp13_;
			PasangLayout2D _tmp14_;
			PasangLayout2D _tmp15_;
#line 430 "theme-2d.vala"
			_tmp13_ = *p;
#line 430 "theme-2d.vala"
			_tmp14_ = self->table;
#line 430 "theme-2d.vala"
			_tmp15_ = self->table;
#line 430 "theme-2d.vala"
			if (_tmp13_.y >= (_tmp14_.board_y + (_tmp15_.board_size / 2))) {
#line 2575 "theme-2d.c"
				PasangPoint _tmp16_;
				PasangLayout2D _tmp17_;
				PasangLayout2D _tmp18_;
#line 430 "theme-2d.vala"
				_tmp16_ = *p;
#line 430 "theme-2d.vala"
				_tmp17_ = self->table;
#line 430 "theme-2d.vala"
				_tmp18_ = self->table;
#line 430 "theme-2d.vala"
				_tmp12_ = _tmp16_.y <= (_tmp17_.board_y + _tmp18_.board_size);
#line 2587 "theme-2d.c"
			} else {
#line 430 "theme-2d.vala"
				_tmp12_ = FALSE;
#line 2591 "theme-2d.c"
			}
#line 430 "theme-2d.vala"
			if (_tmp12_) {
#line 431 "theme-2d.vala"
				result = 1;
#line 431 "theme-2d.vala"
				return result;
#line 2599 "theme-2d.c"
			}
		}
	}
#line 433 "theme-2d.vala"
	result = 1;
#line 433 "theme-2d.vala"
	return result;
#line 2607 "theme-2d.c"
}

PasangTheme2D*
pasang_theme2_d_construct (GType object_type)
{
	PasangTheme2D * self = NULL;
#line 72 "theme-2d.vala"
	self = (PasangTheme2D*) pasang_theme_construct (object_type);
#line 72 "theme-2d.vala"
	return self;
#line 2618 "theme-2d.c"
}

static GObject *
pasang_theme2_d_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PasangTheme2D * self;
	PasangLayout2D _tmp0_;
#line 106 "theme-2d.vala"
	parent_class = G_OBJECT_CLASS (pasang_theme2_d_parent_class);
#line 106 "theme-2d.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 106 "theme-2d.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_THEME2_D, PasangTheme2D);
#line 107 "theme-2d.vala"
	_tmp0_ = self->default_layout;
#line 107 "theme-2d.vala"
	self->layout = _tmp0_;
#line 2640 "theme-2d.c"
	{
		gint i = 0;
#line 108 "theme-2d.vala"
		i = 0;
#line 2645 "theme-2d.c"
		{
			gboolean _tmp1_ = FALSE;
#line 108 "theme-2d.vala"
			_tmp1_ = TRUE;
#line 108 "theme-2d.vala"
			while (TRUE) {
#line 2652 "theme-2d.c"
				gint* _tmp3_;
				gint _tmp3__length1;
#line 108 "theme-2d.vala"
				if (!_tmp1_) {
#line 2657 "theme-2d.c"
					gint _tmp2_;
#line 108 "theme-2d.vala"
					_tmp2_ = i;
#line 108 "theme-2d.vala"
					i = _tmp2_ + 1;
#line 2663 "theme-2d.c"
				}
#line 108 "theme-2d.vala"
				_tmp1_ = FALSE;
#line 108 "theme-2d.vala"
				if (!(i < ((gint) PASANG_PIECE_COUNT))) {
#line 108 "theme-2d.vala"
					break;
#line 2671 "theme-2d.c"
				}
#line 108 "theme-2d.vala"
				_tmp3_ = self->num_rows_in_image;
#line 108 "theme-2d.vala"
				_tmp3__length1 = self->num_rows_in_image_length1;
#line 108 "theme-2d.vala"
				_tmp3_[i] = 1;
#line 2679 "theme-2d.c"
			}
		}
	}
#line 106 "theme-2d.vala"
	return obj;
#line 2685 "theme-2d.c"
}

static void
pasang_theme2_d_class_init (PasangTheme2DClass * klass,
                            gpointer klass_data)
{
#line 72 "theme-2d.vala"
	pasang_theme2_d_parent_class = g_type_class_peek_parent (klass);
#line 72 "theme-2d.vala"
	((PasangThemeClass *) klass)->free = (void (*) (PasangTheme*)) pasang_theme2_d_real_free;
#line 72 "theme-2d.vala"
	((PasangThemeClass *) klass)->resize = (void (*) (PasangTheme*, gint, gint)) pasang_theme2_d_real_resize;
#line 72 "theme-2d.vala"
	((PasangTheme2DClass *) klass)->resize_images = (void (*) (PasangTheme2D*)) pasang_theme2_d_real_resize_images;
#line 72 "theme-2d.vala"
	((PasangThemeClass *) klass)->draw = (void (*) (PasangTheme*, PasangGameView*, cairo_t*)) pasang_theme2_d_real_draw;
#line 72 "theme-2d.vala"
	((PasangThemeClass *) klass)->queue_draw_piece = (void (*) (PasangTheme*, GtkDrawingArea*, PasangPiece, PasangPoint*)) pasang_theme2_d_real_queue_draw_piece;
#line 72 "theme-2d.vala"
	((PasangThemeClass *) klass)->count_frames = (gint (*) (PasangTheme*, PasangPiece)) pasang_theme2_d_real_count_frames;
#line 72 "theme-2d.vala"
	((PasangThemeClass *) klass)->to_point = (void (*) (PasangTheme*, gint, gboolean, PasangPoint*)) pasang_theme2_d_real_to_point;
#line 72 "theme-2d.vala"
	((PasangThemeClass *) klass)->to_position = (gint (*) (PasangTheme*, PasangGame*, PasangPoint*, gboolean, gboolean)) pasang_theme2_d_real_to_position;
#line 72 "theme-2d.vala"
	((PasangThemeClass *) klass)->to_side = (gint (*) (PasangTheme*, PasangPoint*)) pasang_theme2_d_real_to_side;
#line 72 "theme-2d.vala"
	G_OBJECT_CLASS (klass)->constructor = pasang_theme2_d_constructor;
#line 72 "theme-2d.vala"
	G_OBJECT_CLASS (klass)->finalize = pasang_theme2_d_finalize;
#line 2716 "theme-2d.c"
}

static void
pasang_theme2_d_instance_init (PasangTheme2D * self,
                               gpointer klass)
{
	gint _tmp0_[2] = {0};
	gint _tmp1_[2] = {0};
	PasangRgb _tmp2_ = {0};
	PasangRgb _tmp3_ = {0};
	PasangRgb _tmp4_[2] = {0};
	gint _tmp5_[2] = {0};
	gint _tmp6_[2] = {0};
	gint _tmp7_[2] = {0};
	gint _tmp8_[2] = {0};
	gint _tmp9_[2] = {0};
	PasangRgb _tmp10_ = {0};
	PasangRgb _tmp11_ = {0};
	PasangLayout2D _tmp12_ = {0};
	cairo_surface_t** _tmp13_;
	gint* _tmp14_;
#line 78 "theme-2d.vala"
	_tmp0_[0] = 1100;
#line 78 "theme-2d.vala"
	_tmp0_[1] = 1100;
#line 78 "theme-2d.vala"
	_tmp1_[0] = 300;
#line 78 "theme-2d.vala"
	_tmp1_[1] = 700;
#line 78 "theme-2d.vala"
	pasang_rgb_init (&_tmp2_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
#line 78 "theme-2d.vala"
	pasang_rgb_init (&_tmp3_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
#line 78 "theme-2d.vala"
	_tmp4_[0] = _tmp2_;
#line 78 "theme-2d.vala"
	_tmp4_[1] = _tmp3_;
#line 78 "theme-2d.vala"
	_tmp5_[0] = 1100;
#line 78 "theme-2d.vala"
	_tmp5_[1] = 1100;
#line 78 "theme-2d.vala"
	_tmp6_[0] = 400;
#line 78 "theme-2d.vala"
	_tmp6_[1] = 600;
#line 78 "theme-2d.vala"
	_tmp7_[0] = 0;
#line 78 "theme-2d.vala"
	_tmp7_[1] = 0;
#line 78 "theme-2d.vala"
	_tmp8_[0] = 1100;
#line 78 "theme-2d.vala"
	_tmp8_[1] = 1100;
#line 78 "theme-2d.vala"
	_tmp9_[0] = 100;
#line 78 "theme-2d.vala"
	_tmp9_[1] = 900;
#line 78 "theme-2d.vala"
	pasang_rgb_init (&_tmp10_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
#line 78 "theme-2d.vala"
	pasang_rgb_init (&_tmp11_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
#line 78 "theme-2d.vala"
	memset (&_tmp12_, 0, sizeof (PasangLayout2D));
#line 78 "theme-2d.vala"
	_tmp12_.width = 1200;
#line 78 "theme-2d.vala"
	_tmp12_.height = 1000;
#line 78 "theme-2d.vala"
	_tmp12_.board_x = 0;
#line 78 "theme-2d.vala"
	_tmp12_.board_y = 0;
#line 78 "theme-2d.vala"
	_tmp12_.board_size = 1000;
#line 78 "theme-2d.vala"
	memcpy (_tmp12_.score_x, _tmp0_, 2 * sizeof (gint));
#line 78 "theme-2d.vala"
	memcpy (_tmp12_.score_y, _tmp1_, 2 * sizeof (gint));
#line 78 "theme-2d.vala"
	_tmp12_.score_font_size = 40;
#line 78 "theme-2d.vala"
	memcpy (_tmp12_.score_color, _tmp4_, 2 * sizeof (PasangRgb));
#line 78 "theme-2d.vala"
	memcpy (_tmp12_.kas_x, _tmp5_, 2 * sizeof (gint));
#line 78 "theme-2d.vala"
	memcpy (_tmp12_.kas_y, _tmp6_, 2 * sizeof (gint));
#line 78 "theme-2d.vala"
	memcpy (_tmp12_.kas_frame, _tmp7_, 2 * sizeof (gint));
#line 78 "theme-2d.vala"
	memcpy (_tmp12_.num_wins_x, _tmp8_, 2 * sizeof (gint));
#line 78 "theme-2d.vala"
	memcpy (_tmp12_.num_wins_y, _tmp9_, 2 * sizeof (gint));
#line 78 "theme-2d.vala"
	_tmp12_.num_wins_font_size = 50;
#line 78 "theme-2d.vala"
	_tmp12_.num_wins_color = _tmp10_;
#line 78 "theme-2d.vala"
	_tmp12_.num_rounds_x = 1100;
#line 78 "theme-2d.vala"
	_tmp12_.num_rounds_y = 500;
#line 78 "theme-2d.vala"
	_tmp12_.num_rounds_format = 0;
#line 78 "theme-2d.vala"
	_tmp12_.num_rounds_font_size = 20;
#line 78 "theme-2d.vala"
	_tmp12_.num_rounds_color = _tmp11_;
#line 78 "theme-2d.vala"
	_tmp12_.filler_left = 0;
#line 78 "theme-2d.vala"
	_tmp12_.filler_top = 0;
#line 78 "theme-2d.vala"
	_tmp12_.filler_right = 0;
#line 78 "theme-2d.vala"
	_tmp12_.filler_bottom = 0;
#line 78 "theme-2d.vala"
	self->default_layout = _tmp12_;
#line 120 "theme-2d.vala"
	self->layout_changed = TRUE;
#line 125 "theme-2d.vala"
	_tmp13_ = g_new0 (cairo_surface_t*, (PASANG_PIECE_COUNT + 1) + 1);
#line 125 "theme-2d.vala"
	self->images = _tmp13_;
#line 125 "theme-2d.vala"
	self->images_length1 = PASANG_PIECE_COUNT + 1;
#line 125 "theme-2d.vala"
	self->_images_size_ = self->images_length1;
#line 130 "theme-2d.vala"
	_tmp14_ = g_new0 (gint, PASANG_PIECE_COUNT);
#line 130 "theme-2d.vala"
	self->num_rows_in_image = _tmp14_;
#line 130 "theme-2d.vala"
	self->num_rows_in_image_length1 = PASANG_PIECE_COUNT;
#line 130 "theme-2d.vala"
	self->_num_rows_in_image_size_ = self->num_rows_in_image_length1;
#line 2850 "theme-2d.c"
}

static void
pasang_theme2_d_finalize (GObject * obj)
{
	PasangTheme2D * self;
#line 72 "theme-2d.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_THEME2_D, PasangTheme2D);
#line 125 "theme-2d.vala"
	self->images = (_vala_array_free (self->images, self->images_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
#line 130 "theme-2d.vala"
	self->num_rows_in_image = (g_free (self->num_rows_in_image), NULL);
#line 72 "theme-2d.vala"
	G_OBJECT_CLASS (pasang_theme2_d_parent_class)->finalize (obj);
#line 2865 "theme-2d.c"
}

GType
pasang_theme2_d_get_type (void)
{
	static volatile gsize pasang_theme2_d_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_theme2_d_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangTheme2DClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_theme2_d_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangTheme2D), 0, (GInstanceInitFunc) pasang_theme2_d_instance_init, NULL };
		GType pasang_theme2_d_type_id;
		pasang_theme2_d_type_id = g_type_register_static (PASANG_TYPE_THEME, "PasangTheme2D", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&pasang_theme2_d_type_id__volatile, pasang_theme2_d_type_id);
	}
	return pasang_theme2_d_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

