/* game-view.c generated by valac 0.46.3, the Vala compiler
 * generated from game-view.vala, do not modify */

/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2010  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

typedef enum  {
	PASANG_PLAYER_AI,
	PASANG_PLAYER_HUMAN,
	PASANG_PLAYER_REMOTE
} PasangPlayer;

#define PASANG_TYPE_PLAYER (pasang_player_get_type ())

#define PASANG_TYPE_POINT (pasang_point_get_type ())
typedef struct _PasangPoint PasangPoint;

#define PASANG_TYPE_GAME_VIEW (pasang_game_view_get_type ())
#define PASANG_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME_VIEW, PasangGameView))
#define PASANG_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME_VIEW, PasangGameViewClass))
#define PASANG_IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME_VIEW))
#define PASANG_IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME_VIEW))
#define PASANG_GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME_VIEW, PasangGameViewClass))

typedef struct _PasangGameView PasangGameView;
typedef struct _PasangGameViewClass PasangGameViewClass;
typedef struct _PasangGameViewPrivate PasangGameViewPrivate;

#define PASANG_TYPE_GAME (pasang_game_get_type ())
#define PASANG_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME, PasangGame))
#define PASANG_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME, PasangGameClass))
#define PASANG_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME))
#define PASANG_IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME))
#define PASANG_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME, PasangGameClass))

typedef struct _PasangGame PasangGame;
typedef struct _PasangGameClass PasangGameClass;

#define PASANG_TYPE_GAME_SERIES (pasang_game_series_get_type ())
#define PASANG_GAME_SERIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME_SERIES, PasangGameSeries))
#define PASANG_GAME_SERIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME_SERIES, PasangGameSeriesClass))
#define PASANG_IS_GAME_SERIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME_SERIES))
#define PASANG_IS_GAME_SERIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME_SERIES))
#define PASANG_GAME_SERIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME_SERIES, PasangGameSeriesClass))

typedef struct _PasangGameSeries PasangGameSeries;
typedef struct _PasangGameSeriesClass PasangGameSeriesClass;

#define PASANG_TYPE_THEME_SWITCH (pasang_theme_switch_get_type ())
#define PASANG_THEME_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_THEME_SWITCH, PasangThemeSwitch))
#define PASANG_THEME_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_THEME_SWITCH, PasangThemeSwitchClass))
#define PASANG_IS_THEME_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_THEME_SWITCH))
#define PASANG_IS_THEME_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_THEME_SWITCH))
#define PASANG_THEME_SWITCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_THEME_SWITCH, PasangThemeSwitchClass))

typedef struct _PasangThemeSwitch PasangThemeSwitch;
typedef struct _PasangThemeSwitchClass PasangThemeSwitchClass;

#define PASANG_TYPE_THEME (pasang_theme_get_type ())
#define PASANG_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_THEME, PasangTheme))
#define PASANG_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_THEME, PasangThemeClass))
#define PASANG_IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_THEME))
#define PASANG_IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_THEME))
#define PASANG_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_THEME, PasangThemeClass))

typedef struct _PasangTheme PasangTheme;
typedef struct _PasangThemeClass PasangThemeClass;

#define PASANG_TYPE_MOVE (pasang_move_get_type ())
#define PASANG_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_MOVE, PasangMove))
#define PASANG_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_MOVE, PasangMoveClass))
#define PASANG_IS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_MOVE))
#define PASANG_IS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_MOVE))
#define PASANG_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_MOVE, PasangMoveClass))

typedef struct _PasangMove PasangMove;
typedef struct _PasangMoveClass PasangMoveClass;
enum  {
	PASANG_GAME_VIEW_0_PROPERTY,
	PASANG_GAME_VIEW_GAME_PROPERTY,
	PASANG_GAME_VIEW_THEME_SWITCH_PROPERTY,
	PASANG_GAME_VIEW_THEME_PROPERTY,
	PASANG_GAME_VIEW_SELECTED_MOVE_PROPERTY,
	PASANG_GAME_VIEW_MESSAGE_PROPERTY,
	PASANG_GAME_VIEW_PLAYER_TYPE_PROPERTY,
	PASANG_GAME_VIEW_PLAYER_SIDE_PROPERTY,
	PASANG_GAME_VIEW_NUM_PROPERTIES
};
static GParamSpec* pasang_game_view_properties[PASANG_GAME_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PasangGamePrivate PasangGamePrivate;
typedef enum  {
	PASANG_PIECE_NULL = -999,
	PASANG_PIECE_KAS_0 = 0,
	PASANG_PIECE_KAS_1 = 1,
	PASANG_PIECE_BLACK = 2,
	PASANG_PIECE_WHITE = 3,
	PASANG_PIECE_COUNT = 4,
	PASANG_PIECE_BOARD = 4,
	PASANG_PIECE_GUARD = 5,
	PASANG_PIECE_GUIDE = 6,
	PASANG_PIECE_EMPTY = 100
} PasangPiece;

#define PASANG_TYPE_PIECE (pasang_piece_get_type ())
typedef struct _PasangGameSeriesPrivate PasangGameSeriesPrivate;
typedef enum  {
	PASANG_STAGE_NULL = -999,
	PASANG_STAGE_OPENING = 0,
	PASANG_STAGE_SELECT = 1,
	PASANG_STAGE_SUB_SELECT = 2,
	PASANG_STAGE_MOVE = 3,
	PASANG_STAGE_SUB_MOVE = 4,
	PASANG_STAGE_GAME_OVER = 5
} PasangStage;

#define PASANG_TYPE_STAGE (pasang_stage_get_type ())

#define PASANG_GAME_TYPE_ITERATOR (pasang_game_iterator_get_type ())
#define PASANG_GAME_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_GAME_TYPE_ITERATOR, PasangGameIterator))
#define PASANG_GAME_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_GAME_TYPE_ITERATOR, PasangGameIteratorClass))
#define PASANG_GAME_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_GAME_TYPE_ITERATOR))
#define PASANG_GAME_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_GAME_TYPE_ITERATOR))
#define PASANG_GAME_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_GAME_TYPE_ITERATOR, PasangGameIteratorClass))

typedef struct _PasangGameIterator PasangGameIterator;
typedef struct _PasangGameIteratorClass PasangGameIteratorClass;
typedef struct _PasangMovePrivate PasangMovePrivate;
#define _pasang_game_iterator_unref0(var) ((var == NULL) ? NULL : (var = (pasang_game_iterator_unref (var), NULL)))
typedef struct _PasangGameViewSubmitSelectedMoveAsyncData PasangGameViewSubmitSelectedMoveAsyncData;
typedef struct _PasangGameViewShowSubMovesData PasangGameViewShowSubMovesData;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _PasangGameViewSimulateAsyncData PasangGameViewSimulateAsyncData;
typedef struct _PasangGameViewAnimateData PasangGameViewAnimateData;
enum  {
	PASANG_GAME_VIEW_NEXT_MOVE_SIGNAL_SIGNAL,
	PASANG_GAME_VIEW_NUM_SIGNALS
};
static guint pasang_game_view_signals[PASANG_GAME_VIEW_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PasangPoint {
	gint x;
	gint y;
};

struct _PasangGameView {
	GtkDrawingArea parent_instance;
	PasangGameViewPrivate * priv;
	PasangPoint kas_point;
};

struct _PasangGameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _PasangGameViewPrivate {
	PasangGameSeries* _game;
	PasangThemeSwitch* _theme_switch;
	PasangTheme* _theme;
	PasangMove* _selected_move;
	gchar* _message;
	PasangPlayer* player_types;
	gint player_types_length1;
	gint _player_types_size_;
	PasangPoint drag_point;
	gboolean submitting_move;
	GtkGestureDrag* gesture;
	GtkEventControllerMotion* event_controller;
	gint submission_ticket;
	gint motion_ticket;
	gboolean animating;
};

struct _PasangGame {
	GObject parent_instance;
	PasangGamePrivate * priv;
	PasangPiece* board;
	gint board_length1;
	gint* score;
	gint score_length1;
	gint* kas_position;
	gint kas_position_length1;
	gint* first_move;
	gint first_move_length1;
};

struct _PasangGameClass {
	GObjectClass parent_class;
};

struct _PasangGameSeries {
	PasangGame parent_instance;
	PasangGameSeriesPrivate * priv;
	gboolean rotated;
	gint num_wins[2];
	gint num_rounds;
};

struct _PasangGameSeriesClass {
	PasangGameClass parent_class;
};

struct _PasangMove {
	GObject parent_instance;
	PasangMovePrivate * priv;
	gint* booties;
	gint booties_length1;
};

struct _PasangMoveClass {
	GObjectClass parent_class;
};

struct _PasangGameViewSubmitSelectedMoveAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PasangGameView* self;
	gint my_submission_ticket;
	gint lifting_time;
	PasangTheme* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gboolean _tmp3_;
};

struct _PasangGameViewShowSubMovesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PasangGameView* self;
	gint n;
	gboolean _tmp0_;
	gboolean _tmp1_;
	PasangGameSeries* _tmp2_;
	PasangStage _tmp3_;
	PasangStage _tmp4_;
	PasangGameSeries* _tmp5_;
	PasangStage _tmp6_;
	PasangStage _tmp7_;
	gint highlight_time;
	PasangTheme* _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	PasangMove* _tmp11_;
	gint num_moves;
	PasangGameSeries* _tmp12_;
	PasangTheme* _tmp13_;
	PasangTheme* _tmp14_;
	PasangGameSeries* _tmp15_;
	PasangGameSeries* _tmp16_;
	PasangMove* _tmp17_;
	PasangMove* _tmp18_;
};

struct _PasangGameViewSimulateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PasangGameView* self;
	gint press_pos;
	gint release_pos;
	PasangPlayer _tmp0_;
	PasangPlayer _tmp1_;
	gint my_motion_ticket;
	GTimer* timer;
	GTimer* _tmp2_;
	PasangPoint press_point;
	PasangPoint _tmp3_;
	PasangPoint release_point;
	PasangPoint _tmp4_;
	PasangGameSeries* _tmp5_;
	PasangStage _tmp6_;
	PasangStage _tmp7_;
	PasangPoint _tmp8_;
	PasangPoint _tmp9_;
	gdouble time_to_move;
	PasangTheme* _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	PasangPoint _tmp13_;
	PasangPoint _tmp14_;
	gdouble lapse;
	GTimer* _tmp15_;
	PasangGameSeries* _tmp16_;
	PasangStage _tmp17_;
	PasangStage _tmp18_;
	PasangPoint _tmp19_;
	gdouble time_to_pick_kas;
	gdouble distance;
	PasangPoint _tmp20_;
	PasangPoint _tmp21_;
	PasangPoint _tmp22_;
	PasangPoint _tmp23_;
	PasangPoint _tmp24_;
	PasangPoint _tmp25_;
};

struct _PasangGameViewAnimateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PasangGameView* self;
	GTimer* timer;
	GTimer* _tmp0_;
	gdouble last_motion;
	GTimer* _tmp1_;
	PasangTheme* _tmp2_;
	GTimer* _tmp3_;
	PasangTheme* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	GTimer* _tmp7_;
	GTimer* _tmp8_;
};

static gint PasangGameView_private_offset;
static gpointer pasang_game_view_parent_class = NULL;

GType pasang_player_get_type (void) G_GNUC_CONST;
GType pasang_point_get_type (void) G_GNUC_CONST;
PasangPoint* pasang_point_dup (const PasangPoint* self);
void pasang_point_free (PasangPoint* self);
void pasang_point_init_xy (PasangPoint *self,
                           gint x,
                           gint y);
GType pasang_game_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGameView, g_object_unref)
GType pasang_game_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGame, g_object_unref)
GType pasang_game_series_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGameSeries, g_object_unref)
GType pasang_theme_switch_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangThemeSwitch, g_object_unref)
GType pasang_theme_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangTheme, g_object_unref)
GType pasang_move_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangMove, g_object_unref)
PasangThemeSwitch* pasang_theme_switch_new (void);
PasangThemeSwitch* pasang_theme_switch_construct (GType object_type);
PasangGameView* pasang_game_view_new (PasangGameSeries* game);
PasangGameView* pasang_game_view_construct (GType object_type,
                                            PasangGameSeries* game);
static void pasang_game_view_set_game (PasangGameView* self,
                                PasangGameSeries* value);
void pasang_game_view_set_turn (PasangGameView* self,
                                PasangPlayer top_player,
                                PasangPlayer bottom_player,
                                gint first_player);
static gboolean __lambda16_ (PasangGameView* self,
                      cairo_t* cr);
PasangTheme* pasang_game_view_get_theme (PasangGameView* self);
void pasang_theme_draw (PasangTheme* self,
                        PasangGameView* game_view,
                        cairo_t* cr);
static gboolean ___lambda16__gtk_widget_draw (GtkWidget* _sender,
                                       cairo_t* cr,
                                       gpointer self);
PasangThemeSwitch* pasang_game_view_get_theme_switch (PasangGameView* self);
void pasang_theme_switch_resize (PasangThemeSwitch* self,
                                 GtkAllocation* allocation);
static void _pasang_theme_switch_resize_gtk_widget_size_allocate (GtkWidget* _sender,
                                                           GtkAllocation* allocation,
                                                           gpointer self);
static void __lambda17_ (PasangGameView* self);
PasangTheme* pasang_theme_switch_get_theme (PasangThemeSwitch* self);
static void pasang_game_view_set_theme (PasangGameView* self,
                                 PasangTheme* value);
static void ___lambda17__pasang_theme_switch_changed (PasangThemeSwitch* _sender,
                                               gpointer self);
static void __lambda18_ (PasangGameView* self,
                  gdouble x,
                  gdouble y);
static gboolean pasang_game_view_get_input_allowed (PasangGameView* self);
static void pasang_game_view_hover (PasangGameView* self,
                             PasangPoint* point);
static void ___lambda18__gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                      gdouble x,
                                                      gdouble y,
                                                      gpointer self);
static void __lambda19_ (PasangGameView* self,
                  gdouble x,
                  gdouble y);
static void pasang_game_view_drag_start (PasangGameView* self,
                                  PasangPoint* point);
static void ___lambda19__gtk_gesture_drag_drag_begin (GtkGestureDrag* _sender,
                                               gdouble start_x,
                                               gdouble start_y,
                                               gpointer self);
static void __lambda20_ (PasangGameView* self,
                  gdouble x,
                  gdouble y);
static void pasang_game_view_drag_update (PasangGameView* self,
                                   PasangPoint* point);
static void ___lambda20__gtk_gesture_drag_drag_update (GtkGestureDrag* _sender,
                                                gdouble offset_x,
                                                gdouble offset_y,
                                                gpointer self);
static void __lambda21_ (PasangGameView* self,
                  gdouble x,
                  gdouble y);
static void pasang_game_view_drag_stop (PasangGameView* self,
                                 PasangPoint* point);
static void ___lambda21__gtk_gesture_drag_drag_end (GtkGestureDrag* _sender,
                                             gdouble offset_x,
                                             gdouble offset_y,
                                             gpointer self);
static void pasang_game_view_init_state (PasangGameView* self);
static void pasang_game_view_set_selected_move (PasangGameView* self,
                                         PasangMove* value);
void pasang_theme_drop_pieces (PasangTheme* self);
void pasang_theme_drop_kas (PasangTheme* self,
                            PasangGame* game);
PasangGameSeries* pasang_game_view_get_game (PasangGameView* self);
void pasang_game_view_start_game (PasangGameView* self,
                                  const gchar* starting_pattern);
void pasang_game_series_start_recorded (PasangGameSeries* self,
                                        const gchar* starting_pattern);
void pasang_game_view_hang_message (PasangGameView* self);
GType pasang_piece_get_type (void) G_GNUC_CONST;
static void pasang_game_view_set_message (PasangGameView* self,
                                   const gchar* value);
GType pasang_stage_get_type (void) G_GNUC_CONST;
PasangStage pasang_game_get_stage (PasangGame* self);
void pasang_game_view_queue_draw_piece (PasangGameView* self,
                                        gint position);
void pasang_theme_queue_draw_piece (PasangTheme* self,
                                    GtkDrawingArea* view,
                                    PasangPiece piece,
                                    PasangPoint* p);
static void pasang_game_view_to_point (PasangGameView* self,
                                gint pos,
                                PasangPoint* result);
static void pasang_game_view_animate (PasangGameView* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
static void pasang_game_view_animate_finish (PasangGameView* self,
                                      GAsyncResult* _res_);
gint pasang_theme_to_side (PasangTheme* self,
                           PasangPoint* p);
void pasang_theme_pick_booties (PasangTheme* self,
                                PasangGame* game,
                                PasangMove* move,
                                gboolean full);
static PasangMove* pasang_game_view_find_move (PasangGameView* self,
                                        PasangPoint* point);
PasangMove* pasang_game_view_get_selected_move (PasangGameView* self);
static gboolean pasang_game_view_drag_candidate (PasangGameView* self,
                                          PasangPoint* point);
static void pasang_game_view_drag_kas (PasangGameView* self,
                                PasangPoint* point);
void pasang_game_leave_one_move (PasangGame* self,
                                 PasangMove* move);
static void pasang_game_view_submit_selected_move (PasangGameView* self);
static void pasang_game_view_pick_candidate (PasangGameView* self,
                                      PasangPoint* point);
static void pasang_game_view_pick_kas (PasangGameView* self,
                                PasangPoint* point);
static void pasang_game_view_drop_candidate (PasangGameView* self,
                                      PasangPoint* point);
static void pasang_game_view_drop_kas (PasangGameView* self,
                                PasangPoint* point);
static gint pasang_game_view_to_position (PasangGameView* self,
                                   PasangPoint* p);
gpointer pasang_game_iterator_ref (gpointer instance);
void pasang_game_iterator_unref (gpointer instance);
GParamSpec* pasang_game_param_spec_iterator (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
void pasang_game_value_set_iterator (GValue* value,
                                     gpointer v_object);
void pasang_game_value_take_iterator (GValue* value,
                                      gpointer v_object);
gpointer pasang_game_value_get_iterator (const GValue* value);
GType pasang_game_iterator_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGameIterator, pasang_game_iterator_unref)
PasangGameIterator* pasang_game_iterator (PasangGame* self);
PasangMove* pasang_game_iterator_next_value (PasangGameIterator* self);
gint pasang_move_get_position (PasangMove* self);
void pasang_theme_pick_kas (PasangTheme* self,
                            PasangGame* game);
#define PASANG_BOARD_WIDTH 13
gint pasang_game_get_player (PasangGame* self);
void pasang_theme_to_point (PasangTheme* self,
                            gint pos,
                            gboolean rotated,
                            PasangPoint* result);
gint pasang_theme_to_position (PasangTheme* self,
                               PasangGame* game,
                               PasangPoint* p,
                               gboolean rotated,
                               gboolean precise);
PasangPlayer pasang_game_view_get_player_type (PasangGameView* self);
gint pasang_game_count_submoves (PasangGame* self,
                                 PasangMove* move);
static void pasang_game_view_perform_selected_move (PasangGameView* self);
static void pasang_game_view_submit_selected_move_async (PasangGameView* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static void pasang_game_view_submit_selected_move_finish (PasangGameView* self,
                                                   GAsyncResult* _res_);
static void pasang_game_view_submit_selected_move_async_data_free (gpointer _data);
static gboolean pasang_game_view_submit_selected_move_async_co (PasangGameViewSubmitSelectedMoveAsyncData* _data_);
gdouble pasang_theme_get_time_span (PasangTheme* self);
void pasang_util_wait_async (gint millisecs,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
void pasang_util_wait_finish (GAsyncResult* _res_);
static void pasang_game_view_submit_selected_move_async_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
void pasang_game_series_perform_recorded (PasangGameSeries* self,
                                          PasangMove* move,
                                          gboolean full_move);
static void pasang_game_view_show_sub_moves (PasangGameView* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void pasang_game_view_show_sub_moves_finish (PasangGameView* self,
                                             GAsyncResult* _res_);
static void pasang_game_view_show_sub_moves_data_free (gpointer _data);
static gboolean pasang_game_view_show_sub_moves_co (PasangGameViewShowSubMovesData* _data_);
gint pasang_game_numMoves (PasangGame* self);
PasangMove* pasang_game_getMove (PasangGame* self,
                                 gint n);
static void pasang_game_view_show_sub_moves_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
void pasang_game_view_simulate (PasangGameView* self,
                                PasangMove* move);
static void pasang_game_view_simulate_async (PasangGameView* self,
                                      gint press_pos,
                                      gint release_pos,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void pasang_game_view_simulate_finish (PasangGameView* self,
                                       GAsyncResult* _res_);
static void pasang_game_view_simulate_async_data_free (gpointer _data);
static gboolean pasang_game_view_simulate_async_co (PasangGameViewSimulateAsyncData* _data_);
static void pasang_game_view_simulate_async_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
void pasang_game_view_stop_simulation (PasangGameView* self);
static void pasang_game_view_animate_data_free (gpointer _data);
static gboolean pasang_game_view_animate_co (PasangGameViewAnimateData* _data_);
gboolean pasang_theme_animate (PasangTheme* self,
                               PasangGameView* game_view,
                               gdouble lapse);
static void pasang_game_view_animate_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
static GtkSizeRequestMode pasang_game_view_real_get_request_mode (GtkWidget* base);
static void pasang_game_view_real_get_preferred_width (GtkWidget* base,
                                                gint* minimum_width,
                                                gint* natural_width);
static void pasang_game_view_real_get_preferred_height (GtkWidget* base,
                                                 gint* minimum_height,
                                                 gint* natural_height);
static void pasang_game_view_real_get_preferred_height_for_width (GtkWidget* base,
                                                           gint width,
                                                           gint* minimum_height,
                                                           gint* natural_height);
static void pasang_game_view_set_theme_switch (PasangGameView* self,
                                        PasangThemeSwitch* value);
const gchar* pasang_game_view_get_message (PasangGameView* self);
gint pasang_game_view_get_player_side (PasangGameView* self);
static void pasang_game_view_finalize (GObject * obj);
static void _vala_pasang_game_view_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_pasang_game_view_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

GType
pasang_player_get_type (void)
{
	static volatile gsize pasang_player_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_player_type_id__volatile)) {
		static const GEnumValue values[] = {{PASANG_PLAYER_AI, "PASANG_PLAYER_AI", "ai"}, {PASANG_PLAYER_HUMAN, "PASANG_PLAYER_HUMAN", "human"}, {PASANG_PLAYER_REMOTE, "PASANG_PLAYER_REMOTE", "remote"}, {0, NULL, NULL}};
		GType pasang_player_type_id;
		pasang_player_type_id = g_enum_register_static ("PasangPlayer", values);
		g_once_init_leave (&pasang_player_type_id__volatile, pasang_player_type_id);
	}
	return pasang_player_type_id__volatile;
}

void
pasang_point_init_xy (PasangPoint *self,
                      gint x,
                      gint y)
{
#line 30 "game-view.vala"
	memset (self, 0, sizeof (PasangPoint));
#line 30 "game-view.vala"
	(*self).x = x;
#line 30 "game-view.vala"
	(*self).y = y;
#line 640 "game-view.c"
}

PasangPoint*
pasang_point_dup (const PasangPoint* self)
{
	PasangPoint* dup;
#line 27 "game-view.vala"
	dup = g_new0 (PasangPoint, 1);
#line 27 "game-view.vala"
	memcpy (dup, self, sizeof (PasangPoint));
#line 27 "game-view.vala"
	return dup;
#line 653 "game-view.c"
}

void
pasang_point_free (PasangPoint* self)
{
#line 27 "game-view.vala"
	g_free (self);
#line 661 "game-view.c"
}

GType
pasang_point_get_type (void)
{
	static volatile gsize pasang_point_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_point_type_id__volatile)) {
		GType pasang_point_type_id;
		pasang_point_type_id = g_boxed_type_register_static ("PasangPoint", (GBoxedCopyFunc) pasang_point_dup, (GBoxedFreeFunc) pasang_point_free);
		g_once_init_leave (&pasang_point_type_id__volatile, pasang_point_type_id);
	}
	return pasang_point_type_id__volatile;
}

static inline gpointer
pasang_game_view_get_instance_private (PasangGameView* self)
{
	return G_STRUCT_MEMBER_P (self, PasangGameView_private_offset);
}

static gboolean
__lambda16_ (PasangGameView* self,
             cairo_t* cr)
{
	PasangTheme* _tmp0_;
	gboolean result = FALSE;
#line 85 "game-view.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 86 "game-view.vala"
	_tmp0_ = self->priv->_theme;
#line 86 "game-view.vala"
	pasang_theme_draw (_tmp0_, self, cr);
#line 87 "game-view.vala"
	result = TRUE;
#line 87 "game-view.vala"
	return result;
#line 698 "game-view.c"
}

static gboolean
___lambda16__gtk_widget_draw (GtkWidget* _sender,
                              cairo_t* cr,
                              gpointer self)
{
	gboolean result;
	result = __lambda16_ ((PasangGameView*) self, cr);
#line 85 "game-view.vala"
	return result;
#line 710 "game-view.c"
}

static void
_pasang_theme_switch_resize_gtk_widget_size_allocate (GtkWidget* _sender,
                                                      GtkAllocation* allocation,
                                                      gpointer self)
{
#line 89 "game-view.vala"
	pasang_theme_switch_resize ((PasangThemeSwitch*) self, allocation);
#line 720 "game-view.c"
}

static void
__lambda17_ (PasangGameView* self)
{
	PasangThemeSwitch* _tmp0_;
	PasangTheme* _tmp1_;
	PasangTheme* _tmp2_;
#line 91 "game-view.vala"
	_tmp0_ = self->priv->_theme_switch;
#line 91 "game-view.vala"
	_tmp1_ = pasang_theme_switch_get_theme (_tmp0_);
#line 91 "game-view.vala"
	_tmp2_ = _tmp1_;
#line 91 "game-view.vala"
	pasang_game_view_set_theme (self, _tmp2_);
#line 92 "game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 739 "game-view.c"
}

static void
___lambda17__pasang_theme_switch_changed (PasangThemeSwitch* _sender,
                                          gpointer self)
{
#line 90 "game-view.vala"
	__lambda17_ ((PasangGameView*) self);
#line 748 "game-view.c"
}

static void
__lambda18_ (PasangGameView* self,
             gdouble x,
             gdouble y)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 99 "game-view.vala"
	_tmp0_ = pasang_game_view_get_input_allowed (self);
#line 99 "game-view.vala"
	_tmp1_ = _tmp0_;
#line 99 "game-view.vala"
	if (_tmp1_) {
#line 764 "game-view.c"
		PasangPoint _tmp2_ = {0};
#line 99 "game-view.vala"
		pasang_point_init_xy (&_tmp2_, (gint) x, (gint) y);
#line 99 "game-view.vala"
		pasang_game_view_hover (self, &_tmp2_);
#line 770 "game-view.c"
	}
}

static void
___lambda18__gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                 gdouble x,
                                                 gdouble y,
                                                 gpointer self)
{
#line 98 "game-view.vala"
	__lambda18_ ((PasangGameView*) self, x, y);
#line 782 "game-view.c"
}

static void
__lambda19_ (PasangGameView* self,
             gdouble x,
             gdouble y)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 107 "game-view.vala"
	_tmp0_ = pasang_game_view_get_input_allowed (self);
#line 107 "game-view.vala"
	_tmp1_ = _tmp0_;
#line 107 "game-view.vala"
	if (_tmp1_) {
#line 798 "game-view.c"
		PasangPoint _tmp2_ = {0};
#line 107 "game-view.vala"
		pasang_point_init_xy (&_tmp2_, (gint) x, (gint) y);
#line 107 "game-view.vala"
		pasang_game_view_drag_start (self, &_tmp2_);
#line 804 "game-view.c"
	}
}

static void
___lambda19__gtk_gesture_drag_drag_begin (GtkGestureDrag* _sender,
                                          gdouble start_x,
                                          gdouble start_y,
                                          gpointer self)
{
#line 106 "game-view.vala"
	__lambda19_ ((PasangGameView*) self, start_x, start_y);
#line 816 "game-view.c"
}

static void
__lambda20_ (PasangGameView* self,
             gdouble x,
             gdouble y)
{
	gdouble sx = 0.0;
	gdouble sy = 0.0;
	GtkGestureDrag* _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp3_;
	gboolean _tmp4_;
#line 111 "game-view.vala"
	_tmp0_ = self->priv->gesture;
#line 111 "game-view.vala"
	gtk_gesture_drag_get_start_point (_tmp0_, &_tmp1_, &_tmp2_);
#line 111 "game-view.vala"
	sx = _tmp1_;
#line 111 "game-view.vala"
	sy = _tmp2_;
#line 112 "game-view.vala"
	_tmp3_ = pasang_game_view_get_input_allowed (self);
#line 112 "game-view.vala"
	_tmp4_ = _tmp3_;
#line 112 "game-view.vala"
	if (_tmp4_) {
#line 845 "game-view.c"
		PasangPoint _tmp5_ = {0};
#line 112 "game-view.vala"
		pasang_point_init_xy (&_tmp5_, (gint) (sx + x), (gint) (sy + y));
#line 112 "game-view.vala"
		pasang_game_view_drag_update (self, &_tmp5_);
#line 851 "game-view.c"
	}
}

static void
___lambda20__gtk_gesture_drag_drag_update (GtkGestureDrag* _sender,
                                           gdouble offset_x,
                                           gdouble offset_y,
                                           gpointer self)
{
#line 109 "game-view.vala"
	__lambda20_ ((PasangGameView*) self, offset_x, offset_y);
#line 863 "game-view.c"
}

static void
__lambda21_ (PasangGameView* self,
             gdouble x,
             gdouble y)
{
	gdouble sx = 0.0;
	gdouble sy = 0.0;
	GtkGestureDrag* _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp3_;
	gboolean _tmp4_;
#line 116 "game-view.vala"
	_tmp0_ = self->priv->gesture;
#line 116 "game-view.vala"
	gtk_gesture_drag_get_start_point (_tmp0_, &_tmp1_, &_tmp2_);
#line 116 "game-view.vala"
	sx = _tmp1_;
#line 116 "game-view.vala"
	sy = _tmp2_;
#line 117 "game-view.vala"
	_tmp3_ = pasang_game_view_get_input_allowed (self);
#line 117 "game-view.vala"
	_tmp4_ = _tmp3_;
#line 117 "game-view.vala"
	if (_tmp4_) {
#line 892 "game-view.c"
		PasangPoint _tmp5_ = {0};
#line 117 "game-view.vala"
		pasang_point_init_xy (&_tmp5_, (gint) (sx + x), (gint) (sy + y));
#line 117 "game-view.vala"
		pasang_game_view_drag_stop (self, &_tmp5_);
#line 898 "game-view.c"
	}
}

static void
___lambda21__gtk_gesture_drag_drag_end (GtkGestureDrag* _sender,
                                        gdouble offset_x,
                                        gdouble offset_y,
                                        gpointer self)
{
#line 114 "game-view.vala"
	__lambda21_ ((PasangGameView*) self, offset_x, offset_y);
#line 910 "game-view.c"
}

PasangGameView*
pasang_game_view_construct (GType object_type,
                            PasangGameSeries* game)
{
	PasangGameView * self = NULL;
	PasangThemeSwitch* _tmp0_;
	PasangThemeSwitch* _tmp1_;
	GtkEventControllerMotion* _tmp2_;
	GtkEventControllerMotion* _tmp3_;
	GtkGestureDrag* _tmp4_;
	GtkGestureDrag* _tmp5_;
	GtkGestureDrag* _tmp6_;
	GtkGestureDrag* _tmp7_;
	GtkGestureDrag* _tmp8_;
	GtkGestureDrag* _tmp9_;
	PasangThemeSwitch* _tmp10_;
	PasangTheme* _tmp11_;
	PasangTheme* _tmp12_;
#line 82 "game-view.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 82 "game-view.vala"
	self = (PasangGameView*) g_object_new (object_type, NULL);
#line 83 "game-view.vala"
	pasang_game_view_set_game (self, game);
#line 84 "game-view.vala"
	pasang_game_view_set_turn (self, PASANG_PLAYER_AI, PASANG_PLAYER_HUMAN, 1);
#line 85 "game-view.vala"
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) ___lambda16__gtk_widget_draw, self, 0);
#line 89 "game-view.vala"
	_tmp0_ = self->priv->_theme_switch;
#line 89 "game-view.vala"
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _pasang_theme_switch_resize_gtk_widget_size_allocate, _tmp0_, 0);
#line 90 "game-view.vala"
	_tmp1_ = self->priv->_theme_switch;
#line 90 "game-view.vala"
	g_signal_connect_object (_tmp1_, "changed", (GCallback) ___lambda17__pasang_theme_switch_changed, self, 0);
#line 96 "game-view.vala"
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_POINTER_MOTION_MASK);
#line 97 "game-view.vala"
	_tmp2_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ((GtkWidget*) self);
#line 97 "game-view.vala"
	_g_object_unref0 (self->priv->event_controller);
#line 97 "game-view.vala"
	self->priv->event_controller = _tmp2_;
#line 98 "game-view.vala"
	_tmp3_ = self->priv->event_controller;
#line 98 "game-view.vala"
	g_signal_connect_object (_tmp3_, "motion", (GCallback) ___lambda18__gtk_event_controller_motion_motion, self, 0);
#line 103 "game-view.vala"
	_tmp4_ = (GtkGestureDrag*) gtk_gesture_drag_new ((GtkWidget*) self);
#line 103 "game-view.vala"
	_g_object_unref0 (self->priv->gesture);
#line 103 "game-view.vala"
	self->priv->gesture = _tmp4_;
#line 104 "game-view.vala"
	_tmp5_ = self->priv->gesture;
#line 104 "game-view.vala"
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp5_, GTK_PHASE_BUBBLE);
#line 105 "game-view.vala"
	_tmp6_ = self->priv->gesture;
#line 105 "game-view.vala"
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp6_, (guint) 1);
#line 106 "game-view.vala"
	_tmp7_ = self->priv->gesture;
#line 106 "game-view.vala"
	g_signal_connect_object (_tmp7_, "drag-begin", (GCallback) ___lambda19__gtk_gesture_drag_drag_begin, self, 0);
#line 109 "game-view.vala"
	_tmp8_ = self->priv->gesture;
#line 109 "game-view.vala"
	g_signal_connect_object (_tmp8_, "drag-update", (GCallback) ___lambda20__gtk_gesture_drag_drag_update, self, 0);
#line 114 "game-view.vala"
	_tmp9_ = self->priv->gesture;
#line 114 "game-view.vala"
	g_signal_connect_object (_tmp9_, "drag-end", (GCallback) ___lambda21__gtk_gesture_drag_drag_end, self, 0);
#line 120 "game-view.vala"
	_tmp10_ = self->priv->_theme_switch;
#line 120 "game-view.vala"
	_tmp11_ = pasang_theme_switch_get_theme (_tmp10_);
#line 120 "game-view.vala"
	_tmp12_ = _tmp11_;
#line 120 "game-view.vala"
	pasang_game_view_set_theme (self, _tmp12_);
#line 121 "game-view.vala"
	pasang_game_view_init_state (self);
#line 82 "game-view.vala"
	return self;
#line 999 "game-view.c"
}

PasangGameView*
pasang_game_view_new (PasangGameSeries* game)
{
#line 82 "game-view.vala"
	return pasang_game_view_construct (PASANG_TYPE_GAME_VIEW, game);
#line 1007 "game-view.c"
}

static void
pasang_game_view_init_state (PasangGameView* self)
{
	PasangTheme* _tmp0_;
	PasangTheme* _tmp1_;
	PasangGameSeries* _tmp2_;
#line 124 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 125 "game-view.vala"
	pasang_game_view_set_selected_move (self, NULL);
#line 126 "game-view.vala"
	self->priv->submitting_move = FALSE;
#line 127 "game-view.vala"
	self->kas_point.x = -1;
#line 128 "game-view.vala"
	_tmp0_ = self->priv->_theme;
#line 128 "game-view.vala"
	pasang_theme_drop_pieces (_tmp0_);
#line 129 "game-view.vala"
	_tmp1_ = self->priv->_theme;
#line 129 "game-view.vala"
	_tmp2_ = self->priv->_game;
#line 129 "game-view.vala"
	pasang_theme_drop_kas (_tmp1_, (PasangGame*) _tmp2_);
#line 130 "game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 1036 "game-view.c"
}

void
pasang_game_view_start_game (PasangGameView* self,
                             const gchar* starting_pattern)
{
	PasangGameSeries* _tmp0_;
#line 133 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 133 "game-view.vala"
	g_return_if_fail (starting_pattern != NULL);
#line 134 "game-view.vala"
	_tmp0_ = self->priv->_game;
#line 134 "game-view.vala"
	pasang_game_series_start_recorded (_tmp0_, starting_pattern);
#line 135 "game-view.vala"
	pasang_game_view_init_state (self);
#line 136 "game-view.vala"
	pasang_game_view_hang_message (self);
#line 1056 "game-view.c"
}

/**
     * top_player: Player who "sits" at the top
     * bottom_player: Player who "sits" at the bottom
     * first_player: who plays first, top_player (0) or bottom_player (1)
     */
void
pasang_game_view_set_turn (PasangGameView* self,
                           PasangPlayer top_player,
                           PasangPlayer bottom_player,
                           gint first_player)
{
	PasangGameSeries* _tmp0_;
	PasangPlayer* _tmp1_;
	gint _tmp1__length1;
	PasangPlayer* _tmp2_;
	gint _tmp2__length1;
#line 144 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 144 "game-view.vala"
	_vala_return_if_fail ((first_player == 0) || (first_player == 1), "first_player == 0 || first_player == 1");
#line 146 "game-view.vala"
	_tmp0_ = self->priv->_game;
#line 146 "game-view.vala"
	_tmp0_->rotated = first_player == 1;
#line 147 "game-view.vala"
	_tmp1_ = self->priv->player_types;
#line 147 "game-view.vala"
	_tmp1__length1 = self->priv->player_types_length1;
#line 147 "game-view.vala"
	_tmp1_[first_player] = top_player;
#line 148 "game-view.vala"
	_tmp2_ = self->priv->player_types;
#line 148 "game-view.vala"
	_tmp2__length1 = self->priv->player_types_length1;
#line 148 "game-view.vala"
	_tmp2_[1 - first_player] = bottom_player;
#line 149 "game-view.vala"
	pasang_game_view_hang_message (self);
#line 1097 "game-view.c"
}

/**
     * Set a suitable message to display depending on the
     * state of the game
     */
void
pasang_game_view_hang_message (PasangGameView* self)
{
	gboolean _tmp0_ = FALSE;
	PasangGameSeries* _tmp1_;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
#line 156 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 157 "game-view.vala"
	_tmp1_ = self->priv->_game;
#line 157 "game-view.vala"
	_tmp2_ = ((PasangGame*) _tmp1_)->score;
#line 157 "game-view.vala"
	_tmp2__length1 = ((PasangGame*) _tmp1_)->score_length1;
#line 157 "game-view.vala"
	_tmp3_ = _tmp2_[0];
#line 157 "game-view.vala"
	if (_tmp3_ == 0) {
#line 1124 "game-view.c"
		PasangGameSeries* _tmp4_;
		gint* _tmp5_;
		gint _tmp5__length1;
		gint _tmp6_;
#line 157 "game-view.vala"
		_tmp4_ = self->priv->_game;
#line 157 "game-view.vala"
		_tmp5_ = ((PasangGame*) _tmp4_)->score;
#line 157 "game-view.vala"
		_tmp5__length1 = ((PasangGame*) _tmp4_)->score_length1;
#line 157 "game-view.vala"
		_tmp6_ = _tmp5_[1];
#line 157 "game-view.vala"
		_tmp0_ = _tmp6_ == 0;
#line 1139 "game-view.c"
	} else {
#line 157 "game-view.vala"
		_tmp0_ = FALSE;
#line 1143 "game-view.c"
	}
#line 157 "game-view.vala"
	if (_tmp0_) {
#line 1147 "game-view.c"
		gboolean _tmp7_ = FALSE;
		PasangPlayer* _tmp8_;
		gint _tmp8__length1;
		PasangPlayer _tmp9_;
#line 158 "game-view.vala"
		_tmp8_ = self->priv->player_types;
#line 158 "game-view.vala"
		_tmp8__length1 = self->priv->player_types_length1;
#line 158 "game-view.vala"
		_tmp9_ = _tmp8_[1];
#line 158 "game-view.vala"
		if (_tmp9_ == PASANG_PLAYER_AI) {
#line 1160 "game-view.c"
			PasangPlayer* _tmp10_;
			gint _tmp10__length1;
			PasangPlayer _tmp11_;
#line 158 "game-view.vala"
			_tmp10_ = self->priv->player_types;
#line 158 "game-view.vala"
			_tmp10__length1 = self->priv->player_types_length1;
#line 158 "game-view.vala"
			_tmp11_ = _tmp10_[0];
#line 158 "game-view.vala"
			_tmp7_ = _tmp11_ == PASANG_PLAYER_HUMAN;
#line 1172 "game-view.c"
		} else {
#line 158 "game-view.vala"
			_tmp7_ = FALSE;
#line 1176 "game-view.c"
		}
#line 158 "game-view.vala"
		if (_tmp7_) {
#line 159 "game-view.vala"
			pasang_game_view_set_message (self, _ ("Press this side to let\nthe machine move first."));
#line 1182 "game-view.c"
		} else {
			gboolean _tmp12_ = FALSE;
			PasangPlayer* _tmp13_;
			gint _tmp13__length1;
			PasangPlayer _tmp14_;
#line 160 "game-view.vala"
			_tmp13_ = self->priv->player_types;
#line 160 "game-view.vala"
			_tmp13__length1 = self->priv->player_types_length1;
#line 160 "game-view.vala"
			_tmp14_ = _tmp13_[0];
#line 160 "game-view.vala"
			if (_tmp14_ == PASANG_PLAYER_REMOTE) {
#line 160 "game-view.vala"
				_tmp12_ = TRUE;
#line 1198 "game-view.c"
			} else {
				PasangPlayer* _tmp15_;
				gint _tmp15__length1;
				PasangPlayer _tmp16_;
#line 160 "game-view.vala"
				_tmp15_ = self->priv->player_types;
#line 160 "game-view.vala"
				_tmp15__length1 = self->priv->player_types_length1;
#line 160 "game-view.vala"
				_tmp16_ = _tmp15_[1];
#line 160 "game-view.vala"
				_tmp12_ = _tmp16_ == PASANG_PLAYER_REMOTE;
#line 1211 "game-view.c"
			}
#line 160 "game-view.vala"
			if (_tmp12_) {
#line 161 "game-view.vala"
				pasang_game_view_set_message (self, _ ("Playing online"));
#line 1217 "game-view.c"
			} else {
#line 163 "game-view.vala"
				pasang_game_view_set_message (self, NULL);
#line 1221 "game-view.c"
			}
		}
	} else {
		PasangGameSeries* _tmp17_;
		PasangStage _tmp18_;
		PasangStage _tmp19_;
#line 165 "game-view.vala"
		_tmp17_ = self->priv->_game;
#line 165 "game-view.vala"
		_tmp18_ = pasang_game_get_stage ((PasangGame*) _tmp17_);
#line 165 "game-view.vala"
		_tmp19_ = _tmp18_;
#line 165 "game-view.vala"
		if (_tmp19_ == PASANG_STAGE_GAME_OVER) {
#line 1236 "game-view.c"
			gboolean _tmp20_ = FALSE;
			PasangPlayer* _tmp21_;
			gint _tmp21__length1;
			PasangPlayer _tmp22_;
#line 166 "game-view.vala"
			_tmp21_ = self->priv->player_types;
#line 166 "game-view.vala"
			_tmp21__length1 = self->priv->player_types_length1;
#line 166 "game-view.vala"
			_tmp22_ = _tmp21_[0];
#line 166 "game-view.vala"
			if (_tmp22_ == PASANG_PLAYER_HUMAN) {
#line 166 "game-view.vala"
				_tmp20_ = TRUE;
#line 1251 "game-view.c"
			} else {
				PasangPlayer* _tmp23_;
				gint _tmp23__length1;
				PasangPlayer _tmp24_;
#line 166 "game-view.vala"
				_tmp23_ = self->priv->player_types;
#line 166 "game-view.vala"
				_tmp23__length1 = self->priv->player_types_length1;
#line 166 "game-view.vala"
				_tmp24_ = _tmp23_[1];
#line 166 "game-view.vala"
				_tmp20_ = _tmp24_ == PASANG_PLAYER_HUMAN;
#line 1264 "game-view.c"
			}
#line 166 "game-view.vala"
			if (_tmp20_) {
#line 167 "game-view.vala"
				pasang_game_view_set_message (self, _ ("Game over.\nClick for\nanother round."));
#line 1270 "game-view.c"
			} else {
#line 169 "game-view.vala"
				pasang_game_view_set_message (self, _ ("Game over"));
#line 1274 "game-view.c"
			}
		} else {
#line 172 "game-view.vala"
			pasang_game_view_set_message (self, NULL);
#line 1279 "game-view.c"
		}
	}
#line 174 "game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 1284 "game-view.c"
}

void
pasang_game_view_queue_draw_piece (PasangGameView* self,
                                   gint position)
{
	PasangTheme* _tmp0_;
	PasangGameSeries* _tmp1_;
	PasangPiece* _tmp2_;
	gint _tmp2__length1;
	PasangPiece _tmp3_;
	PasangPoint _tmp4_ = {0};
#line 191 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 192 "game-view.vala"
	_tmp0_ = self->priv->_theme;
#line 192 "game-view.vala"
	_tmp1_ = self->priv->_game;
#line 192 "game-view.vala"
	_tmp2_ = ((PasangGame*) _tmp1_)->board;
#line 192 "game-view.vala"
	_tmp2__length1 = ((PasangGame*) _tmp1_)->board_length1;
#line 192 "game-view.vala"
	_tmp3_ = _tmp2_[position];
#line 192 "game-view.vala"
	pasang_game_view_to_point (self, position, &_tmp4_);
#line 192 "game-view.vala"
	pasang_theme_queue_draw_piece (_tmp0_, (GtkDrawingArea*) self, _tmp3_, &_tmp4_);
#line 1313 "game-view.c"
}

static void
pasang_game_view_hover (PasangGameView* self,
                        PasangPoint* point)
{
	gboolean _tmp0_ = FALSE;
	PasangGameSeries* _tmp1_;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	PasangGameSeries* _tmp17_;
	PasangStage _tmp18_;
	PasangStage _tmp19_;
#line 204 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 204 "game-view.vala"
	g_return_if_fail (point != NULL);
#line 205 "game-view.vala"
	pasang_game_view_animate (self, NULL, NULL);
#line 207 "game-view.vala"
	_tmp1_ = self->priv->_game;
#line 207 "game-view.vala"
	_tmp2_ = ((PasangGame*) _tmp1_)->score;
#line 207 "game-view.vala"
	_tmp2__length1 = ((PasangGame*) _tmp1_)->score_length1;
#line 207 "game-view.vala"
	_tmp3_ = _tmp2_[0];
#line 207 "game-view.vala"
	if (_tmp3_ == 0) {
#line 1344 "game-view.c"
		PasangGameSeries* _tmp4_;
		gint* _tmp5_;
		gint _tmp5__length1;
		gint _tmp6_;
#line 207 "game-view.vala"
		_tmp4_ = self->priv->_game;
#line 207 "game-view.vala"
		_tmp5_ = ((PasangGame*) _tmp4_)->score;
#line 207 "game-view.vala"
		_tmp5__length1 = ((PasangGame*) _tmp4_)->score_length1;
#line 207 "game-view.vala"
		_tmp6_ = _tmp5_[1];
#line 207 "game-view.vala"
		_tmp0_ = _tmp6_ == 0;
#line 1359 "game-view.c"
	} else {
#line 207 "game-view.vala"
		_tmp0_ = FALSE;
#line 1363 "game-view.c"
	}
#line 207 "game-view.vala"
	if (_tmp0_) {
#line 1367 "game-view.c"
		gboolean _tmp7_ = FALSE;
		PasangPlayer* _tmp8_;
		gint _tmp8__length1;
		PasangPlayer _tmp9_;
#line 208 "game-view.vala"
		_tmp8_ = self->priv->player_types;
#line 208 "game-view.vala"
		_tmp8__length1 = self->priv->player_types_length1;
#line 208 "game-view.vala"
		_tmp9_ = _tmp8_[1];
#line 208 "game-view.vala"
		if (_tmp9_ == PASANG_PLAYER_HUMAN) {
#line 1380 "game-view.c"
			PasangPlayer* _tmp10_;
			gint _tmp10__length1;
			PasangPlayer _tmp11_;
#line 208 "game-view.vala"
			_tmp10_ = self->priv->player_types;
#line 208 "game-view.vala"
			_tmp10__length1 = self->priv->player_types_length1;
#line 208 "game-view.vala"
			_tmp11_ = _tmp10_[0];
#line 208 "game-view.vala"
			_tmp7_ = _tmp11_ == PASANG_PLAYER_HUMAN;
#line 1392 "game-view.c"
		} else {
#line 208 "game-view.vala"
			_tmp7_ = FALSE;
#line 1396 "game-view.c"
		}
#line 208 "game-view.vala"
		if (_tmp7_) {
#line 1400 "game-view.c"
			gboolean prev_rotated = FALSE;
			PasangGameSeries* _tmp12_;
			PasangGameSeries* _tmp13_;
			PasangTheme* _tmp14_;
			PasangPoint _tmp15_;
			PasangGameSeries* _tmp16_;
#line 209 "game-view.vala"
			_tmp12_ = self->priv->_game;
#line 209 "game-view.vala"
			prev_rotated = _tmp12_->rotated;
#line 210 "game-view.vala"
			_tmp13_ = self->priv->_game;
#line 210 "game-view.vala"
			_tmp14_ = self->priv->_theme;
#line 210 "game-view.vala"
			_tmp15_ = *point;
#line 210 "game-view.vala"
			_tmp13_->rotated = pasang_theme_to_side (_tmp14_, &_tmp15_) == 1;
#line 212 "game-view.vala"
			_tmp16_ = self->priv->_game;
#line 212 "game-view.vala"
			if (prev_rotated != _tmp16_->rotated) {
#line 212 "game-view.vala"
				gtk_widget_queue_draw ((GtkWidget*) self);
#line 1425 "game-view.c"
			}
		}
	}
#line 215 "game-view.vala"
	_tmp17_ = self->priv->_game;
#line 215 "game-view.vala"
	_tmp18_ = pasang_game_get_stage ((PasangGame*) _tmp17_);
#line 215 "game-view.vala"
	_tmp19_ = _tmp18_;
#line 215 "game-view.vala"
	switch (_tmp19_) {
#line 215 "game-view.vala"
		case PASANG_STAGE_OPENING:
#line 1439 "game-view.c"
		{
			PasangTheme* _tmp20_;
			PasangTheme* _tmp21_;
			PasangGameSeries* _tmp22_;
			PasangPoint _tmp23_;
			PasangMove* _tmp24_;
			PasangMove* _tmp25_;
#line 217 "game-view.vala"
			_tmp20_ = self->priv->_theme;
#line 217 "game-view.vala"
			pasang_theme_drop_pieces (_tmp20_);
#line 218 "game-view.vala"
			_tmp21_ = self->priv->_theme;
#line 218 "game-view.vala"
			_tmp22_ = self->priv->_game;
#line 218 "game-view.vala"
			_tmp23_ = *point;
#line 218 "game-view.vala"
			_tmp24_ = pasang_game_view_find_move (self, &_tmp23_);
#line 218 "game-view.vala"
			_tmp25_ = _tmp24_;
#line 218 "game-view.vala"
			pasang_theme_pick_booties (_tmp21_, (PasangGame*) _tmp22_, _tmp25_, FALSE);
#line 218 "game-view.vala"
			_g_object_unref0 (_tmp25_);
#line 219 "game-view.vala"
			break;
#line 1467 "game-view.c"
		}
#line 215 "game-view.vala"
		case PASANG_STAGE_SUB_SELECT:
#line 215 "game-view.vala"
		case PASANG_STAGE_SUB_MOVE:
#line 1473 "game-view.c"
		{
			PasangPoint _tmp26_;
			PasangMove* _tmp27_;
			PasangMove* _tmp28_;
			gboolean _tmp29_;
#line 222 "game-view.vala"
			_tmp26_ = *point;
#line 222 "game-view.vala"
			_tmp27_ = pasang_game_view_find_move (self, &_tmp26_);
#line 222 "game-view.vala"
			_tmp28_ = _tmp27_;
#line 222 "game-view.vala"
			_tmp29_ = _tmp28_ != NULL;
#line 222 "game-view.vala"
			_g_object_unref0 (_tmp28_);
#line 222 "game-view.vala"
			if (_tmp29_) {
#line 1491 "game-view.c"
				PasangTheme* _tmp30_;
				PasangTheme* _tmp31_;
				PasangGameSeries* _tmp32_;
				PasangMove* _tmp33_;
#line 223 "game-view.vala"
				_tmp30_ = self->priv->_theme;
#line 223 "game-view.vala"
				pasang_theme_drop_pieces (_tmp30_);
#line 224 "game-view.vala"
				_tmp31_ = self->priv->_theme;
#line 224 "game-view.vala"
				_tmp32_ = self->priv->_game;
#line 224 "game-view.vala"
				_tmp33_ = self->priv->_selected_move;
#line 224 "game-view.vala"
				pasang_theme_pick_booties (_tmp31_, (PasangGame*) _tmp32_, _tmp33_, FALSE);
#line 1508 "game-view.c"
			}
#line 226 "game-view.vala"
			break;
#line 1512 "game-view.c"
		}
		default:
#line 215 "game-view.vala"
		break;
#line 1517 "game-view.c"
	}
}

static void
pasang_game_view_drag_update (PasangGameView* self,
                              PasangPoint* point)
{
	PasangGameSeries* _tmp0_;
	PasangStage _tmp1_;
	PasangStage _tmp2_;
#line 230 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 230 "game-view.vala"
	g_return_if_fail (point != NULL);
#line 231 "game-view.vala"
	_tmp0_ = self->priv->_game;
#line 231 "game-view.vala"
	_tmp1_ = pasang_game_get_stage ((PasangGame*) _tmp0_);
#line 231 "game-view.vala"
	_tmp2_ = _tmp1_;
#line 231 "game-view.vala"
	switch (_tmp2_) {
#line 231 "game-view.vala"
		case PASANG_STAGE_SELECT:
#line 1542 "game-view.c"
		{
			PasangPoint _tmp3_;
#line 233 "game-view.vala"
			_tmp3_ = *point;
#line 233 "game-view.vala"
			pasang_game_view_drag_candidate (self, &_tmp3_);
#line 234 "game-view.vala"
			break;
#line 1551 "game-view.c"
		}
#line 231 "game-view.vala"
		case PASANG_STAGE_MOVE:
#line 1555 "game-view.c"
		{
			PasangPoint _tmp4_;
#line 236 "game-view.vala"
			_tmp4_ = *point;
#line 236 "game-view.vala"
			pasang_game_view_drag_kas (self, &_tmp4_);
#line 237 "game-view.vala"
			break;
#line 1564 "game-view.c"
		}
		default:
#line 231 "game-view.vala"
		break;
#line 1569 "game-view.c"
	}
}

static void
pasang_game_view_drag_start (PasangGameView* self,
                             PasangPoint* point)
{
	PasangPoint _tmp0_;
	gboolean _tmp1_ = FALSE;
	PasangGameSeries* _tmp2_;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	PasangGameSeries* _tmp15_;
	PasangStage _tmp16_;
	PasangStage _tmp17_;
#line 241 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 241 "game-view.vala"
	g_return_if_fail (point != NULL);
#line 242 "game-view.vala"
	_tmp0_ = *point;
#line 242 "game-view.vala"
	pasang_game_view_hover (self, &_tmp0_);
#line 243 "game-view.vala"
	_tmp2_ = self->priv->_game;
#line 243 "game-view.vala"
	_tmp3_ = ((PasangGame*) _tmp2_)->score;
#line 243 "game-view.vala"
	_tmp3__length1 = ((PasangGame*) _tmp2_)->score_length1;
#line 243 "game-view.vala"
	_tmp4_ = _tmp3_[0];
#line 243 "game-view.vala"
	if (_tmp4_ == 0) {
#line 1604 "game-view.c"
		PasangGameSeries* _tmp5_;
		gint* _tmp6_;
		gint _tmp6__length1;
		gint _tmp7_;
#line 243 "game-view.vala"
		_tmp5_ = self->priv->_game;
#line 243 "game-view.vala"
		_tmp6_ = ((PasangGame*) _tmp5_)->score;
#line 243 "game-view.vala"
		_tmp6__length1 = ((PasangGame*) _tmp5_)->score_length1;
#line 243 "game-view.vala"
		_tmp7_ = _tmp6_[1];
#line 243 "game-view.vala"
		_tmp1_ = _tmp7_ == 0;
#line 1619 "game-view.c"
	} else {
#line 243 "game-view.vala"
		_tmp1_ = FALSE;
#line 1623 "game-view.c"
	}
#line 243 "game-view.vala"
	if (_tmp1_) {
#line 1627 "game-view.c"
		gboolean _tmp8_ = FALSE;
		PasangPlayer* _tmp9_;
		gint _tmp9__length1;
		PasangPlayer _tmp10_;
#line 244 "game-view.vala"
		_tmp9_ = self->priv->player_types;
#line 244 "game-view.vala"
		_tmp9__length1 = self->priv->player_types_length1;
#line 244 "game-view.vala"
		_tmp10_ = _tmp9_[1];
#line 244 "game-view.vala"
		if (_tmp10_ == PASANG_PLAYER_AI) {
#line 1640 "game-view.c"
			PasangPlayer* _tmp11_;
			gint _tmp11__length1;
			PasangPlayer _tmp12_;
#line 244 "game-view.vala"
			_tmp11_ = self->priv->player_types;
#line 244 "game-view.vala"
			_tmp11__length1 = self->priv->player_types_length1;
#line 244 "game-view.vala"
			_tmp12_ = _tmp11_[0];
#line 244 "game-view.vala"
			_tmp8_ = _tmp12_ == PASANG_PLAYER_HUMAN;
#line 1652 "game-view.c"
		} else {
#line 244 "game-view.vala"
			_tmp8_ = FALSE;
#line 1656 "game-view.c"
		}
#line 244 "game-view.vala"
		if (_tmp8_) {
#line 1660 "game-view.c"
			PasangTheme* _tmp13_;
			PasangPoint _tmp14_;
#line 245 "game-view.vala"
			_tmp13_ = self->priv->_theme;
#line 245 "game-view.vala"
			_tmp14_ = *point;
#line 245 "game-view.vala"
			if (pasang_theme_to_side (_tmp13_, &_tmp14_) == 0) {
#line 248 "game-view.vala"
				g_signal_emit (self, pasang_game_view_signals[PASANG_GAME_VIEW_NEXT_MOVE_SIGNAL_SIGNAL], 0, NULL);
#line 249 "game-view.vala"
				return;
#line 1673 "game-view.c"
			}
		}
	}
#line 253 "game-view.vala"
	_tmp15_ = self->priv->_game;
#line 253 "game-view.vala"
	_tmp16_ = pasang_game_get_stage ((PasangGame*) _tmp15_);
#line 253 "game-view.vala"
	_tmp17_ = _tmp16_;
#line 253 "game-view.vala"
	switch (_tmp17_) {
#line 253 "game-view.vala"
		case PASANG_STAGE_OPENING:
#line 253 "game-view.vala"
		case PASANG_STAGE_SUB_SELECT:
#line 253 "game-view.vala"
		case PASANG_STAGE_SUB_MOVE:
#line 1691 "game-view.c"
		{
			PasangPoint _tmp18_;
			PasangMove* _tmp19_;
			PasangMove* _tmp20_;
			gboolean _tmp21_;
#line 257 "game-view.vala"
			_tmp18_ = *point;
#line 257 "game-view.vala"
			_tmp19_ = pasang_game_view_find_move (self, &_tmp18_);
#line 257 "game-view.vala"
			_tmp20_ = _tmp19_;
#line 257 "game-view.vala"
			_tmp21_ = _tmp20_ != NULL;
#line 257 "game-view.vala"
			_g_object_unref0 (_tmp20_);
#line 257 "game-view.vala"
			if (_tmp21_) {
#line 1709 "game-view.c"
				PasangGameSeries* _tmp22_;
				PasangMove* _tmp23_;
#line 258 "game-view.vala"
				_tmp22_ = self->priv->_game;
#line 258 "game-view.vala"
				_tmp23_ = self->priv->_selected_move;
#line 258 "game-view.vala"
				pasang_game_leave_one_move ((PasangGame*) _tmp22_, _tmp23_);
#line 259 "game-view.vala"
				pasang_game_view_submit_selected_move (self);
#line 1720 "game-view.c"
			}
#line 261 "game-view.vala"
			break;
#line 1724 "game-view.c"
		}
#line 253 "game-view.vala"
		case PASANG_STAGE_SELECT:
#line 1728 "game-view.c"
		{
			PasangPoint _tmp24_;
#line 263 "game-view.vala"
			_tmp24_ = *point;
#line 263 "game-view.vala"
			pasang_game_view_pick_candidate (self, &_tmp24_);
#line 264 "game-view.vala"
			break;
#line 1737 "game-view.c"
		}
#line 253 "game-view.vala"
		case PASANG_STAGE_MOVE:
#line 1741 "game-view.c"
		{
			PasangPoint _tmp25_;
#line 266 "game-view.vala"
			_tmp25_ = *point;
#line 266 "game-view.vala"
			pasang_game_view_pick_kas (self, &_tmp25_);
#line 267 "game-view.vala"
			break;
#line 1750 "game-view.c"
		}
#line 253 "game-view.vala"
		case PASANG_STAGE_GAME_OVER:
#line 1754 "game-view.c"
		{
#line 269 "game-view.vala"
			g_signal_emit (self, pasang_game_view_signals[PASANG_GAME_VIEW_NEXT_MOVE_SIGNAL_SIGNAL], 0, NULL);
#line 270 "game-view.vala"
			break;
#line 1760 "game-view.c"
		}
		default:
#line 253 "game-view.vala"
		break;
#line 1765 "game-view.c"
	}
}

static void
pasang_game_view_drag_stop (PasangGameView* self,
                            PasangPoint* point)
{
	PasangGameSeries* _tmp0_;
	PasangStage _tmp1_;
	PasangStage _tmp2_;
#line 274 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 274 "game-view.vala"
	g_return_if_fail (point != NULL);
#line 275 "game-view.vala"
	_tmp0_ = self->priv->_game;
#line 275 "game-view.vala"
	_tmp1_ = pasang_game_get_stage ((PasangGame*) _tmp0_);
#line 275 "game-view.vala"
	_tmp2_ = _tmp1_;
#line 275 "game-view.vala"
	switch (_tmp2_) {
#line 275 "game-view.vala"
		case PASANG_STAGE_SELECT:
#line 1790 "game-view.c"
		{
			PasangPoint _tmp3_;
#line 277 "game-view.vala"
			_tmp3_ = *point;
#line 277 "game-view.vala"
			pasang_game_view_drop_candidate (self, &_tmp3_);
#line 278 "game-view.vala"
			break;
#line 1799 "game-view.c"
		}
#line 275 "game-view.vala"
		case PASANG_STAGE_MOVE:
#line 1803 "game-view.c"
		{
			PasangPoint _tmp4_;
#line 280 "game-view.vala"
			_tmp4_ = *point;
#line 280 "game-view.vala"
			pasang_game_view_drop_kas (self, &_tmp4_);
#line 281 "game-view.vala"
			break;
#line 1812 "game-view.c"
		}
		default:
#line 275 "game-view.vala"
		break;
#line 1817 "game-view.c"
	}
}

/**
     * Find the move that captures the piece at the given screen location.
     * Side effect: set selected_move
     */
static gpointer
_g_object_ref0 (gpointer self)
{
#line 293 "game-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 1830 "game-view.c"
}

static PasangMove*
pasang_game_view_find_move (PasangGameView* self,
                            PasangPoint* point)
{
	gint position = 0;
	PasangPoint _tmp0_;
	PasangMove* _tmp10_;
	PasangMove* result = NULL;
#line 289 "game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 289 "game-view.vala"
	g_return_val_if_fail (point != NULL, NULL);
#line 290 "game-view.vala"
	_tmp0_ = *point;
#line 290 "game-view.vala"
	position = pasang_game_view_to_position (self, &_tmp0_);
#line 1849 "game-view.c"
	{
		PasangGameIterator* _move_it = NULL;
		PasangGameSeries* _tmp1_;
		PasangGameIterator* _tmp2_;
		PasangMove* move = NULL;
#line 291 "game-view.vala"
		_tmp1_ = self->priv->_game;
#line 291 "game-view.vala"
		_tmp2_ = pasang_game_iterator ((PasangGame*) _tmp1_);
#line 291 "game-view.vala"
		_move_it = _tmp2_;
#line 291 "game-view.vala"
		while (TRUE) {
#line 1863 "game-view.c"
			PasangGameIterator* _tmp3_;
			PasangMove* _tmp4_;
			PasangMove* _tmp5_;
			PasangMove* _tmp6_;
			gint* _tmp7_;
			gint _tmp7__length1;
#line 291 "game-view.vala"
			_tmp3_ = _move_it;
#line 291 "game-view.vala"
			_tmp4_ = pasang_game_iterator_next_value (_tmp3_);
#line 291 "game-view.vala"
			_g_object_unref0 (move);
#line 291 "game-view.vala"
			move = _tmp4_;
#line 291 "game-view.vala"
			_tmp5_ = move;
#line 291 "game-view.vala"
			if (!(_tmp5_ != NULL)) {
#line 291 "game-view.vala"
				break;
#line 1884 "game-view.c"
			}
#line 292 "game-view.vala"
			_tmp6_ = move;
#line 292 "game-view.vala"
			_tmp7_ = _tmp6_->booties;
#line 292 "game-view.vala"
			_tmp7__length1 = _tmp6_->booties_length1;
#line 1892 "game-view.c"
			{
				gint* pos_collection = NULL;
				gint pos_collection_length1 = 0;
				gint _pos_collection_size_ = 0;
				gint pos_it = 0;
#line 292 "game-view.vala"
				pos_collection = _tmp7_;
#line 292 "game-view.vala"
				pos_collection_length1 = _tmp7__length1;
#line 292 "game-view.vala"
				for (pos_it = 0; pos_it < pos_collection_length1; pos_it = pos_it + 1) {
#line 1904 "game-view.c"
					gint pos = 0;
#line 292 "game-view.vala"
					pos = pos_collection[pos_it];
#line 1908 "game-view.c"
					{
#line 293 "game-view.vala"
						if (position == pos) {
#line 1912 "game-view.c"
							PasangMove* _tmp8_;
							PasangMove* _tmp9_;
#line 293 "game-view.vala"
							_tmp8_ = move;
#line 293 "game-view.vala"
							pasang_game_view_set_selected_move (self, _tmp8_);
#line 293 "game-view.vala"
							_tmp9_ = _g_object_ref0 (_tmp8_);
#line 293 "game-view.vala"
							result = _tmp9_;
#line 293 "game-view.vala"
							_g_object_unref0 (move);
#line 293 "game-view.vala"
							_pasang_game_iterator_unref0 (_move_it);
#line 293 "game-view.vala"
							return result;
#line 1929 "game-view.c"
						}
					}
				}
			}
		}
#line 291 "game-view.vala"
		_g_object_unref0 (move);
#line 291 "game-view.vala"
		_pasang_game_iterator_unref0 (_move_it);
#line 1939 "game-view.c"
	}
#line 296 "game-view.vala"
	pasang_game_view_set_selected_move (self, NULL);
#line 296 "game-view.vala"
	_tmp10_ = _g_object_ref0 (NULL);
#line 296 "game-view.vala"
	result = _tmp10_;
#line 296 "game-view.vala"
	return result;
#line 1949 "game-view.c"
}

/**
     * Select a piece to be promoted to kas. The candidate must be within
     * the vicinity of the given point.
     * Side effect: selected_move, kas_point, drag_point
     */
static void
pasang_game_view_pick_candidate (PasangGameView* self,
                                 PasangPoint* point)
{
	gint position = 0;
	PasangPoint _tmp0_;
#line 304 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 304 "game-view.vala"
	g_return_if_fail (point != NULL);
#line 305 "game-view.vala"
	pasang_game_view_set_selected_move (self, NULL);
#line 306 "game-view.vala"
	_tmp0_ = *point;
#line 306 "game-view.vala"
	position = pasang_game_view_to_position (self, &_tmp0_);
#line 1973 "game-view.c"
	{
		PasangGameIterator* _move_it = NULL;
		PasangGameSeries* _tmp1_;
		PasangGameIterator* _tmp2_;
		PasangMove* move = NULL;
#line 307 "game-view.vala"
		_tmp1_ = self->priv->_game;
#line 307 "game-view.vala"
		_tmp2_ = pasang_game_iterator ((PasangGame*) _tmp1_);
#line 307 "game-view.vala"
		_move_it = _tmp2_;
#line 307 "game-view.vala"
		while (TRUE) {
#line 1987 "game-view.c"
			PasangGameIterator* _tmp3_;
			PasangMove* _tmp4_;
			PasangMove* _tmp5_;
			PasangMove* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
#line 307 "game-view.vala"
			_tmp3_ = _move_it;
#line 307 "game-view.vala"
			_tmp4_ = pasang_game_iterator_next_value (_tmp3_);
#line 307 "game-view.vala"
			_g_object_unref0 (move);
#line 307 "game-view.vala"
			move = _tmp4_;
#line 307 "game-view.vala"
			_tmp5_ = move;
#line 307 "game-view.vala"
			if (!(_tmp5_ != NULL)) {
#line 307 "game-view.vala"
				break;
#line 2008 "game-view.c"
			}
#line 308 "game-view.vala"
			_tmp6_ = move;
#line 308 "game-view.vala"
			_tmp7_ = pasang_move_get_position (_tmp6_);
#line 308 "game-view.vala"
			_tmp8_ = _tmp7_;
#line 308 "game-view.vala"
			if (position == _tmp8_) {
#line 2018 "game-view.c"
				PasangMove* _tmp9_;
				PasangPoint _tmp10_ = {0};
				PasangPoint _tmp11_;
				PasangPoint _tmp12_;
				PasangPoint _tmp13_;
				PasangPoint _tmp14_;
				PasangTheme* _tmp15_;
				PasangGameSeries* _tmp16_;
#line 309 "game-view.vala"
				_tmp9_ = move;
#line 309 "game-view.vala"
				pasang_game_view_set_selected_move (self, _tmp9_);
#line 310 "game-view.vala"
				pasang_game_view_to_point (self, position, &_tmp10_);
#line 310 "game-view.vala"
				self->kas_point = _tmp10_;
#line 311 "game-view.vala"
				_tmp11_ = self->kas_point;
#line 311 "game-view.vala"
				_tmp12_ = *point;
#line 311 "game-view.vala"
				_tmp13_ = self->kas_point;
#line 311 "game-view.vala"
				_tmp14_ = *point;
#line 311 "game-view.vala"
				pasang_point_init_xy (&self->priv->drag_point, _tmp11_.x - _tmp12_.x, _tmp13_.y - _tmp14_.y);
#line 312 "game-view.vala"
				_tmp15_ = self->priv->_theme;
#line 312 "game-view.vala"
				_tmp16_ = self->priv->_game;
#line 312 "game-view.vala"
				pasang_theme_pick_kas (_tmp15_, (PasangGame*) _tmp16_);
#line 313 "game-view.vala"
				break;
#line 2053 "game-view.c"
			}
		}
#line 307 "game-view.vala"
		_g_object_unref0 (move);
#line 307 "game-view.vala"
		_pasang_game_iterator_unref0 (_move_it);
#line 2060 "game-view.c"
	}
}

/**
     * If there was a selected candidate, drag it. If it goes to the
     * empty column (which was captured during the opening move), highlight 
     * all its possible captures.
     * Side effect: kas_point
     * Return: true if the candidate is dragged home
     */
static gboolean
pasang_game_view_drag_candidate (PasangGameView* self,
                                 PasangPoint* point)
{
	PasangMove* _tmp0_;
	PasangPoint _tmp1_;
	PasangPoint _tmp2_;
	PasangPoint _tmp3_;
	PasangPoint _tmp4_;
	PasangPoint _tmp5_;
	gint pos = 0;
	PasangPoint _tmp6_;
	gint row = 0;
	gint col = 0;
	gint kas_row = 0;
	PasangMove* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint empty_column = 0;
	PasangGameSeries* _tmp10_;
	gint* _tmp11_;
	gint _tmp11__length1;
	PasangGameSeries* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gboolean _tmp16_ = FALSE;
	gboolean dragged_home = FALSE;
	gboolean result = FALSE;
#line 325 "game-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 325 "game-view.vala"
	g_return_val_if_fail (point != NULL, FALSE);
#line 326 "game-view.vala"
	_tmp0_ = self->priv->_selected_move;
#line 326 "game-view.vala"
	if (_tmp0_ == NULL) {
#line 326 "game-view.vala"
		result = FALSE;
#line 326 "game-view.vala"
		return result;
#line 2112 "game-view.c"
	}
#line 327 "game-view.vala"
	_tmp1_ = *point;
#line 327 "game-view.vala"
	_tmp2_ = self->priv->drag_point;
#line 327 "game-view.vala"
	_tmp3_ = *point;
#line 327 "game-view.vala"
	_tmp4_ = self->priv->drag_point;
#line 327 "game-view.vala"
	pasang_point_init_xy (&self->kas_point, _tmp1_.x + _tmp2_.x, _tmp3_.y + _tmp4_.y);
#line 328 "game-view.vala"
	_tmp5_ = self->kas_point;
#line 328 "game-view.vala"
	if (_tmp5_.x == -1) {
#line 328 "game-view.vala"
		self->kas_point.x = 0;
#line 2130 "game-view.c"
	}
#line 331 "game-view.vala"
	_tmp6_ = self->kas_point;
#line 331 "game-view.vala"
	pos = pasang_game_view_to_position (self, &_tmp6_);
#line 332 "game-view.vala"
	row = pos / PASANG_BOARD_WIDTH;
#line 333 "game-view.vala"
	col = pos % PASANG_BOARD_WIDTH;
#line 334 "game-view.vala"
	_tmp7_ = self->priv->_selected_move;
#line 334 "game-view.vala"
	_tmp8_ = pasang_move_get_position (_tmp7_);
#line 334 "game-view.vala"
	_tmp9_ = _tmp8_;
#line 334 "game-view.vala"
	kas_row = _tmp9_ / PASANG_BOARD_WIDTH;
#line 335 "game-view.vala"
	_tmp10_ = self->priv->_game;
#line 335 "game-view.vala"
	_tmp11_ = ((PasangGame*) _tmp10_)->first_move;
#line 335 "game-view.vala"
	_tmp11__length1 = ((PasangGame*) _tmp10_)->first_move_length1;
#line 335 "game-view.vala"
	_tmp12_ = self->priv->_game;
#line 335 "game-view.vala"
	_tmp13_ = pasang_game_get_player ((PasangGame*) _tmp12_);
#line 335 "game-view.vala"
	_tmp14_ = _tmp13_;
#line 335 "game-view.vala"
	_tmp15_ = _tmp11_[_tmp14_];
#line 335 "game-view.vala"
	empty_column = _tmp15_;
#line 336 "game-view.vala"
	if (row == kas_row) {
#line 336 "game-view.vala"
		_tmp16_ = col == empty_column;
#line 2168 "game-view.c"
	} else {
#line 336 "game-view.vala"
		_tmp16_ = FALSE;
#line 2172 "game-view.c"
	}
#line 336 "game-view.vala"
	dragged_home = _tmp16_;
#line 337 "game-view.vala"
	if (dragged_home) {
#line 2178 "game-view.c"
		{
			PasangGameIterator* _move_it = NULL;
			PasangGameSeries* _tmp17_;
			PasangGameIterator* _tmp18_;
			PasangMove* move = NULL;
#line 339 "game-view.vala"
			_tmp17_ = self->priv->_game;
#line 339 "game-view.vala"
			_tmp18_ = pasang_game_iterator ((PasangGame*) _tmp17_);
#line 339 "game-view.vala"
			_move_it = _tmp18_;
#line 339 "game-view.vala"
			while (TRUE) {
#line 2192 "game-view.c"
				PasangGameIterator* _tmp19_;
				PasangMove* _tmp20_;
				PasangMove* _tmp21_;
				PasangMove* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				PasangMove* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
#line 339 "game-view.vala"
				_tmp19_ = _move_it;
#line 339 "game-view.vala"
				_tmp20_ = pasang_game_iterator_next_value (_tmp19_);
#line 339 "game-view.vala"
				_g_object_unref0 (move);
#line 339 "game-view.vala"
				move = _tmp20_;
#line 339 "game-view.vala"
				_tmp21_ = move;
#line 339 "game-view.vala"
				if (!(_tmp21_ != NULL)) {
#line 339 "game-view.vala"
					break;
#line 2216 "game-view.c"
				}
#line 340 "game-view.vala"
				_tmp22_ = move;
#line 340 "game-view.vala"
				_tmp23_ = pasang_move_get_position (_tmp22_);
#line 340 "game-view.vala"
				_tmp24_ = _tmp23_;
#line 340 "game-view.vala"
				_tmp25_ = self->priv->_selected_move;
#line 340 "game-view.vala"
				_tmp26_ = pasang_move_get_position (_tmp25_);
#line 340 "game-view.vala"
				_tmp27_ = _tmp26_;
#line 340 "game-view.vala"
				if (_tmp24_ == _tmp27_) {
#line 2232 "game-view.c"
					PasangTheme* _tmp28_;
					PasangGameSeries* _tmp29_;
					PasangMove* _tmp30_;
#line 340 "game-view.vala"
					_tmp28_ = self->priv->_theme;
#line 340 "game-view.vala"
					_tmp29_ = self->priv->_game;
#line 340 "game-view.vala"
					_tmp30_ = move;
#line 340 "game-view.vala"
					pasang_theme_pick_booties (_tmp28_, (PasangGame*) _tmp29_, _tmp30_, FALSE);
#line 2244 "game-view.c"
				}
			}
#line 339 "game-view.vala"
			_g_object_unref0 (move);
#line 339 "game-view.vala"
			_pasang_game_iterator_unref0 (_move_it);
#line 2251 "game-view.c"
		}
#line 343 "game-view.vala"
		pasang_game_view_queue_draw_piece (self, pos);
#line 2255 "game-view.c"
	} else {
		PasangTheme* _tmp31_;
#line 346 "game-view.vala"
		_tmp31_ = self->priv->_theme;
#line 346 "game-view.vala"
		pasang_theme_drop_pieces (_tmp31_);
#line 2262 "game-view.c"
	}
#line 348 "game-view.vala"
	result = dragged_home;
#line 348 "game-view.vala"
	return result;
#line 2268 "game-view.c"
}

/**
     * Promote the selected candidate to kas, if it is already dragged home.
     * Side effect: selected_move null if kas dropped elsewhere
     */
static void
pasang_game_view_drop_candidate (PasangGameView* self,
                                 PasangPoint* point)
{
	PasangMove* _tmp0_;
	PasangPoint _tmp1_;
	PasangTheme* _tmp5_;
	PasangGameSeries* _tmp6_;
#line 355 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 355 "game-view.vala"
	g_return_if_fail (point != NULL);
#line 356 "game-view.vala"
	_tmp0_ = self->priv->_selected_move;
#line 356 "game-view.vala"
	if (_tmp0_ == NULL) {
#line 356 "game-view.vala"
		return;
#line 2293 "game-view.c"
	}
#line 357 "game-view.vala"
	_tmp1_ = *point;
#line 357 "game-view.vala"
	if (pasang_game_view_drag_candidate (self, &_tmp1_)) {
#line 358 "game-view.vala"
		pasang_game_view_submit_selected_move (self);
#line 2301 "game-view.c"
	} else {
		PasangMove* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 361 "game-view.vala"
		_tmp2_ = self->priv->_selected_move;
#line 361 "game-view.vala"
		_tmp3_ = pasang_move_get_position (_tmp2_);
#line 361 "game-view.vala"
		_tmp4_ = _tmp3_;
#line 361 "game-view.vala"
		pasang_game_view_queue_draw_piece (self, _tmp4_);
#line 362 "game-view.vala"
		pasang_game_view_set_selected_move (self, NULL);
#line 2316 "game-view.c"
	}
#line 364 "game-view.vala"
	_tmp5_ = self->priv->_theme;
#line 364 "game-view.vala"
	_tmp6_ = self->priv->_game;
#line 364 "game-view.vala"
	pasang_theme_drop_kas (_tmp5_, (PasangGame*) _tmp6_);
#line 2324 "game-view.c"
}

/**
     * Pick the kas if it is being pointed at.
     * Side effect: kas_point, drag_point
     */
static void
pasang_game_view_pick_kas (PasangGameView* self,
                           PasangPoint* point)
{
	gint pos = 0;
	PasangPoint _tmp0_;
	PasangGameSeries* _tmp1_;
	gint* _tmp2_;
	gint _tmp2__length1;
	PasangGameSeries* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
#line 371 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 371 "game-view.vala"
	g_return_if_fail (point != NULL);
#line 372 "game-view.vala"
	_tmp0_ = *point;
#line 372 "game-view.vala"
	pos = pasang_game_view_to_position (self, &_tmp0_);
#line 373 "game-view.vala"
	_tmp1_ = self->priv->_game;
#line 373 "game-view.vala"
	_tmp2_ = ((PasangGame*) _tmp1_)->kas_position;
#line 373 "game-view.vala"
	_tmp2__length1 = ((PasangGame*) _tmp1_)->kas_position_length1;
#line 373 "game-view.vala"
	_tmp3_ = self->priv->_game;
#line 373 "game-view.vala"
	_tmp4_ = pasang_game_get_player ((PasangGame*) _tmp3_);
#line 373 "game-view.vala"
	_tmp5_ = _tmp4_;
#line 373 "game-view.vala"
	_tmp6_ = _tmp2_[_tmp5_];
#line 373 "game-view.vala"
	if (pos == _tmp6_) {
#line 2368 "game-view.c"
		PasangPoint _tmp7_ = {0};
		PasangPoint _tmp8_;
		PasangPoint _tmp9_;
		PasangPoint _tmp10_;
		PasangPoint _tmp11_;
		PasangTheme* _tmp12_;
		PasangGameSeries* _tmp13_;
#line 374 "game-view.vala"
		pasang_game_view_to_point (self, pos, &_tmp7_);
#line 374 "game-view.vala"
		self->kas_point = _tmp7_;
#line 375 "game-view.vala"
		_tmp8_ = self->kas_point;
#line 375 "game-view.vala"
		_tmp9_ = *point;
#line 375 "game-view.vala"
		_tmp10_ = self->kas_point;
#line 375 "game-view.vala"
		_tmp11_ = *point;
#line 375 "game-view.vala"
		pasang_point_init_xy (&self->priv->drag_point, _tmp8_.x - _tmp9_.x, _tmp10_.y - _tmp11_.y);
#line 376 "game-view.vala"
		_tmp12_ = self->priv->_theme;
#line 376 "game-view.vala"
		_tmp13_ = self->priv->_game;
#line 376 "game-view.vala"
		pasang_theme_pick_kas (_tmp12_, (PasangGame*) _tmp13_);
#line 2396 "game-view.c"
	} else {
#line 379 "game-view.vala"
		self->kas_point.x = -1;
#line 2400 "game-view.c"
	}
}

/**
     * Drag the kas to follow the user gesture. The kas must be previously picked.
     * Side effect: selected_move
     */
static void
pasang_game_view_drag_kas (PasangGameView* self,
                           PasangPoint* point)
{
	PasangPoint _tmp0_;
	PasangPoint _tmp1_;
	PasangPoint _tmp2_;
	PasangPoint _tmp3_;
	PasangPoint _tmp4_;
	PasangPoint _tmp5_;
	gint pos = 0;
	PasangPoint _tmp6_;
	PasangTheme* _tmp7_;
	PasangTheme* _tmp31_;
	PasangGameSeries* _tmp32_;
#line 387 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 387 "game-view.vala"
	g_return_if_fail (point != NULL);
#line 388 "game-view.vala"
	_tmp0_ = self->kas_point;
#line 388 "game-view.vala"
	if (_tmp0_.x == -1) {
#line 388 "game-view.vala"
		return;
#line 2433 "game-view.c"
	}
#line 389 "game-view.vala"
	_tmp1_ = *point;
#line 389 "game-view.vala"
	_tmp2_ = self->priv->drag_point;
#line 389 "game-view.vala"
	_tmp3_ = *point;
#line 389 "game-view.vala"
	_tmp4_ = self->priv->drag_point;
#line 389 "game-view.vala"
	pasang_point_init_xy (&self->kas_point, _tmp1_.x + _tmp2_.x, _tmp3_.y + _tmp4_.y);
#line 390 "game-view.vala"
	_tmp5_ = self->kas_point;
#line 390 "game-view.vala"
	if (_tmp5_.x == -1) {
#line 390 "game-view.vala"
		self->kas_point.x = 0;
#line 2451 "game-view.c"
	}
#line 392 "game-view.vala"
	_tmp6_ = self->kas_point;
#line 392 "game-view.vala"
	pos = pasang_game_view_to_position (self, &_tmp6_);
#line 393 "game-view.vala"
	pasang_game_view_set_selected_move (self, NULL);
#line 394 "game-view.vala"
	_tmp7_ = self->priv->_theme;
#line 394 "game-view.vala"
	pasang_theme_drop_pieces (_tmp7_);
#line 2463 "game-view.c"
	{
		PasangGameIterator* _move_it = NULL;
		PasangGameSeries* _tmp8_;
		PasangGameIterator* _tmp9_;
		PasangMove* move = NULL;
#line 396 "game-view.vala"
		_tmp8_ = self->priv->_game;
#line 396 "game-view.vala"
		_tmp9_ = pasang_game_iterator ((PasangGame*) _tmp8_);
#line 396 "game-view.vala"
		_move_it = _tmp9_;
#line 396 "game-view.vala"
		while (TRUE) {
#line 2477 "game-view.c"
			PasangGameIterator* _tmp10_;
			PasangMove* _tmp11_;
			PasangMove* _tmp12_;
			PasangMove* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
#line 396 "game-view.vala"
			_tmp10_ = _move_it;
#line 396 "game-view.vala"
			_tmp11_ = pasang_game_iterator_next_value (_tmp10_);
#line 396 "game-view.vala"
			_g_object_unref0 (move);
#line 396 "game-view.vala"
			move = _tmp11_;
#line 396 "game-view.vala"
			_tmp12_ = move;
#line 396 "game-view.vala"
			if (!(_tmp12_ != NULL)) {
#line 396 "game-view.vala"
				break;
#line 2498 "game-view.c"
			}
#line 397 "game-view.vala"
			_tmp13_ = move;
#line 397 "game-view.vala"
			_tmp14_ = pasang_move_get_position (_tmp13_);
#line 397 "game-view.vala"
			_tmp15_ = _tmp14_;
#line 397 "game-view.vala"
			if (_tmp15_ == pos) {
#line 2508 "game-view.c"
				PasangMove* _tmp16_;
#line 398 "game-view.vala"
				_tmp16_ = move;
#line 398 "game-view.vala"
				pasang_game_view_set_selected_move (self, _tmp16_);
#line 2514 "game-view.c"
				{
					PasangGameIterator* _m_it = NULL;
					PasangGameSeries* _tmp17_;
					PasangGameIterator* _tmp18_;
					PasangMove* m = NULL;
#line 400 "game-view.vala"
					_tmp17_ = self->priv->_game;
#line 400 "game-view.vala"
					_tmp18_ = pasang_game_iterator ((PasangGame*) _tmp17_);
#line 400 "game-view.vala"
					_m_it = _tmp18_;
#line 400 "game-view.vala"
					while (TRUE) {
#line 2528 "game-view.c"
						PasangGameIterator* _tmp19_;
						PasangMove* _tmp20_;
						PasangMove* _tmp21_;
						PasangMove* _tmp22_;
						gint _tmp23_;
						gint _tmp24_;
						PasangMove* _tmp25_;
						gint _tmp26_;
						gint _tmp27_;
#line 400 "game-view.vala"
						_tmp19_ = _m_it;
#line 400 "game-view.vala"
						_tmp20_ = pasang_game_iterator_next_value (_tmp19_);
#line 400 "game-view.vala"
						_g_object_unref0 (m);
#line 400 "game-view.vala"
						m = _tmp20_;
#line 400 "game-view.vala"
						_tmp21_ = m;
#line 400 "game-view.vala"
						if (!(_tmp21_ != NULL)) {
#line 400 "game-view.vala"
							break;
#line 2552 "game-view.c"
						}
#line 401 "game-view.vala"
						_tmp22_ = m;
#line 401 "game-view.vala"
						_tmp23_ = pasang_move_get_position (_tmp22_);
#line 401 "game-view.vala"
						_tmp24_ = _tmp23_;
#line 401 "game-view.vala"
						_tmp25_ = self->priv->_selected_move;
#line 401 "game-view.vala"
						_tmp26_ = pasang_move_get_position (_tmp25_);
#line 401 "game-view.vala"
						_tmp27_ = _tmp26_;
#line 401 "game-view.vala"
						if (_tmp24_ == _tmp27_) {
#line 2568 "game-view.c"
							PasangTheme* _tmp28_;
							PasangGameSeries* _tmp29_;
							PasangMove* _tmp30_;
#line 401 "game-view.vala"
							_tmp28_ = self->priv->_theme;
#line 401 "game-view.vala"
							_tmp29_ = self->priv->_game;
#line 401 "game-view.vala"
							_tmp30_ = m;
#line 401 "game-view.vala"
							pasang_theme_pick_booties (_tmp28_, (PasangGame*) _tmp29_, _tmp30_, FALSE);
#line 2580 "game-view.c"
						}
					}
#line 400 "game-view.vala"
					_g_object_unref0 (m);
#line 400 "game-view.vala"
					_pasang_game_iterator_unref0 (_m_it);
#line 2587 "game-view.c"
				}
#line 403 "game-view.vala"
				break;
#line 2591 "game-view.c"
			}
		}
#line 396 "game-view.vala"
		_g_object_unref0 (move);
#line 396 "game-view.vala"
		_pasang_game_iterator_unref0 (_move_it);
#line 2598 "game-view.c"
	}
#line 406 "game-view.vala"
	_tmp31_ = self->priv->_theme;
#line 406 "game-view.vala"
	_tmp32_ = self->priv->_game;
#line 406 "game-view.vala"
	pasang_theme_pick_kas (_tmp31_, (PasangGame*) _tmp32_);
#line 2606 "game-view.c"
}

/**
     * Drop the kas at the given location.
     */
static void
pasang_game_view_drop_kas (PasangGameView* self,
                           PasangPoint* point)
{
	PasangPoint _tmp0_;
	PasangPoint _tmp1_;
	PasangMove* _tmp2_;
	PasangTheme* _tmp9_;
	PasangGameSeries* _tmp10_;
#line 412 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 412 "game-view.vala"
	g_return_if_fail (point != NULL);
#line 413 "game-view.vala"
	_tmp0_ = self->kas_point;
#line 413 "game-view.vala"
	if (_tmp0_.x == -1) {
#line 413 "game-view.vala"
		return;
#line 2631 "game-view.c"
	}
#line 414 "game-view.vala"
	_tmp1_ = *point;
#line 414 "game-view.vala"
	pasang_game_view_drag_kas (self, &_tmp1_);
#line 415 "game-view.vala"
	_tmp2_ = self->priv->_selected_move;
#line 415 "game-view.vala"
	if (_tmp2_ != NULL) {
#line 416 "game-view.vala"
		pasang_game_view_submit_selected_move (self);
#line 2643 "game-view.c"
	} else {
		PasangGameSeries* _tmp3_;
		gint* _tmp4_;
		gint _tmp4__length1;
		PasangGameSeries* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
#line 419 "game-view.vala"
		self->kas_point.x = -1;
#line 420 "game-view.vala"
		_tmp3_ = self->priv->_game;
#line 420 "game-view.vala"
		_tmp4_ = ((PasangGame*) _tmp3_)->kas_position;
#line 420 "game-view.vala"
		_tmp4__length1 = ((PasangGame*) _tmp3_)->kas_position_length1;
#line 420 "game-view.vala"
		_tmp5_ = self->priv->_game;
#line 420 "game-view.vala"
		_tmp6_ = pasang_game_get_player ((PasangGame*) _tmp5_);
#line 420 "game-view.vala"
		_tmp7_ = _tmp6_;
#line 420 "game-view.vala"
		_tmp8_ = _tmp4_[_tmp7_];
#line 420 "game-view.vala"
		pasang_game_view_queue_draw_piece (self, _tmp8_);
#line 2670 "game-view.c"
	}
#line 422 "game-view.vala"
	_tmp9_ = self->priv->_theme;
#line 422 "game-view.vala"
	_tmp10_ = self->priv->_game;
#line 422 "game-view.vala"
	pasang_theme_drop_kas (_tmp9_, (PasangGame*) _tmp10_);
#line 2678 "game-view.c"
}

static void
pasang_game_view_to_point (PasangGameView* self,
                           gint pos,
                           PasangPoint* result)
{
	PasangTheme* _tmp0_;
	PasangGameSeries* _tmp1_;
	PasangPoint _tmp2_ = {0};
#line 425 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 426 "game-view.vala"
	_tmp0_ = self->priv->_theme;
#line 426 "game-view.vala"
	_tmp1_ = self->priv->_game;
#line 426 "game-view.vala"
	pasang_theme_to_point (_tmp0_, pos, _tmp1_->rotated, &_tmp2_);
#line 426 "game-view.vala"
	*result = _tmp2_;
#line 426 "game-view.vala"
	return;
#line 2701 "game-view.c"
}

static gint
pasang_game_view_to_position (PasangGameView* self,
                              PasangPoint* p)
{
	PasangTheme* _tmp0_;
	PasangGameSeries* _tmp1_;
	PasangPoint _tmp2_;
	PasangGameSeries* _tmp3_;
	PasangPlayer _tmp4_;
	PasangPlayer _tmp5_;
	gint result = 0;
#line 429 "game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 429 "game-view.vala"
	g_return_val_if_fail (p != NULL, 0);
#line 433 "game-view.vala"
	_tmp0_ = self->priv->_theme;
#line 433 "game-view.vala"
	_tmp1_ = self->priv->_game;
#line 433 "game-view.vala"
	_tmp2_ = *p;
#line 433 "game-view.vala"
	_tmp3_ = self->priv->_game;
#line 433 "game-view.vala"
	_tmp4_ = pasang_game_view_get_player_type (self);
#line 433 "game-view.vala"
	_tmp5_ = _tmp4_;
#line 433 "game-view.vala"
	result = pasang_theme_to_position (_tmp0_, (PasangGame*) _tmp1_, &_tmp2_, _tmp3_->rotated, _tmp5_ != PASANG_PLAYER_HUMAN);
#line 433 "game-view.vala"
	return result;
#line 2735 "game-view.c"
}

/**
     * To be called only when the user gesture has been completed.
     */
static void
pasang_game_view_submit_selected_move (PasangGameView* self)
{
	PasangMove* _tmp0_;
	PasangGameSeries* _tmp1_;
	PasangMove* _tmp2_;
	PasangPoint _tmp7_;
	PasangGameSeries* _tmp10_;
	PasangMove* _tmp11_;
#line 439 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 439 "game-view.vala"
	_tmp0_ = self->priv->_selected_move;
#line 439 "game-view.vala"
	_vala_return_if_fail (_tmp0_ != NULL, "selected_move != null");
#line 441 "game-view.vala"
	_tmp1_ = self->priv->_game;
#line 441 "game-view.vala"
	_tmp2_ = self->priv->_selected_move;
#line 441 "game-view.vala"
	if (pasang_game_count_submoves ((PasangGame*) _tmp1_, _tmp2_) == 1) {
#line 2762 "game-view.c"
		PasangTheme* _tmp3_;
		PasangTheme* _tmp4_;
		PasangGameSeries* _tmp5_;
		PasangMove* _tmp6_;
#line 442 "game-view.vala"
		_tmp3_ = self->priv->_theme;
#line 442 "game-view.vala"
		pasang_theme_drop_pieces (_tmp3_);
#line 443 "game-view.vala"
		_tmp4_ = self->priv->_theme;
#line 443 "game-view.vala"
		_tmp5_ = self->priv->_game;
#line 443 "game-view.vala"
		_tmp6_ = self->priv->_selected_move;
#line 443 "game-view.vala"
		pasang_theme_pick_booties (_tmp4_, (PasangGame*) _tmp5_, _tmp6_, TRUE);
#line 2779 "game-view.c"
	}
#line 445 "game-view.vala"
	_tmp7_ = self->kas_point;
#line 445 "game-view.vala"
	if (_tmp7_.x != -1) {
#line 2785 "game-view.c"
		PasangPoint _tmp8_;
		PasangPoint _tmp9_ = {0};
#line 446 "game-view.vala"
		_tmp8_ = self->kas_point;
#line 446 "game-view.vala"
		pasang_game_view_to_point (self, pasang_game_view_to_position (self, &_tmp8_), &_tmp9_);
#line 446 "game-view.vala"
		self->kas_point = _tmp9_;
#line 2794 "game-view.c"
	}
#line 448 "game-view.vala"
	_tmp10_ = self->priv->_game;
#line 448 "game-view.vala"
	_tmp11_ = self->priv->_selected_move;
#line 448 "game-view.vala"
	if (pasang_game_count_submoves ((PasangGame*) _tmp10_, _tmp11_) > 1) {
#line 450 "game-view.vala"
		pasang_game_view_perform_selected_move (self);
#line 2804 "game-view.c"
	} else {
#line 453 "game-view.vala"
		pasang_game_view_submit_selected_move_async (self, NULL, NULL);
#line 2808 "game-view.c"
	}
}

static void
pasang_game_view_submit_selected_move_async_data_free (gpointer _data)
{
	PasangGameViewSubmitSelectedMoveAsyncData* _data_;
	_data_ = _data;
#line 33 "game-view.vala"
	_g_object_unref0 (_data_->self);
#line 33 "game-view.vala"
	g_slice_free (PasangGameViewSubmitSelectedMoveAsyncData, _data_);
#line 2821 "game-view.c"
}

static void
pasang_game_view_submit_selected_move_async (PasangGameView* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	PasangGameViewSubmitSelectedMoveAsyncData* _data_;
	PasangGameView* _tmp0_;
#line 33 "game-view.vala"
	_data_ = g_slice_new0 (PasangGameViewSubmitSelectedMoveAsyncData);
#line 33 "game-view.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 33 "game-view.vala"
	g_task_set_task_data (_data_->_async_result, _data_, pasang_game_view_submit_selected_move_async_data_free);
#line 33 "game-view.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "game-view.vala"
	_data_->self = _tmp0_;
#line 33 "game-view.vala"
	pasang_game_view_submit_selected_move_async_co (_data_);
#line 2843 "game-view.c"
}

static void
pasang_game_view_submit_selected_move_finish (PasangGameView* self,
                                              GAsyncResult* _res_)
{
	PasangGameViewSubmitSelectedMoveAsyncData* _data_;
#line 33 "game-view.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2853 "game-view.c"
}

static void
pasang_game_view_submit_selected_move_async_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	PasangGameViewSubmitSelectedMoveAsyncData* _data_;
#line 467 "game-view.vala"
	_data_ = _user_data_;
#line 467 "game-view.vala"
	_data_->_source_object_ = source_object;
#line 467 "game-view.vala"
	_data_->_res_ = _res_;
#line 467 "game-view.vala"
	pasang_game_view_submit_selected_move_async_co (_data_);
#line 2870 "game-view.c"
}

static gboolean
pasang_game_view_submit_selected_move_async_co (PasangGameViewSubmitSelectedMoveAsyncData* _data_)
{
#line 463 "game-view.vala"
	switch (_data_->_state_) {
#line 463 "game-view.vala"
		case 0:
#line 2880 "game-view.c"
		goto _state_0;
#line 463 "game-view.vala"
		case 1:
#line 2884 "game-view.c"
		goto _state_1;
		default:
#line 463 "game-view.vala"
		g_assert_not_reached ();
#line 2889 "game-view.c"
	}
	_state_0:
#line 464 "game-view.vala"
	_data_->self->priv->submitting_move = TRUE;
#line 465 "game-view.vala"
	_data_->self->priv->submission_ticket = _data_->self->priv->submission_ticket + 1;
#line 465 "game-view.vala"
	_data_->my_submission_ticket = _data_->self->priv->submission_ticket;
#line 466 "game-view.vala"
	_data_->_tmp0_ = _data_->self->priv->_theme;
#line 466 "game-view.vala"
	_data_->_tmp1_ = pasang_theme_get_time_span (_data_->_tmp0_);
#line 466 "game-view.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 466 "game-view.vala"
	_data_->lifting_time = (gint) (_data_->_tmp2_ * 1000);
#line 467 "game-view.vala"
	_data_->_state_ = 1;
#line 467 "game-view.vala"
	pasang_util_wait_async (_data_->lifting_time, pasang_game_view_submit_selected_move_async_ready, _data_);
#line 467 "game-view.vala"
	return FALSE;
#line 2912 "game-view.c"
	_state_1:
#line 467 "game-view.vala"
	pasang_util_wait_finish (_data_->_res_);
#line 468 "game-view.vala"
	if (_data_->self->priv->submitting_move) {
#line 468 "game-view.vala"
		_data_->_tmp3_ = _data_->my_submission_ticket == _data_->self->priv->submission_ticket;
#line 2920 "game-view.c"
	} else {
#line 468 "game-view.vala"
		_data_->_tmp3_ = FALSE;
#line 2924 "game-view.c"
	}
#line 468 "game-view.vala"
	if (_data_->_tmp3_) {
#line 469 "game-view.vala"
		pasang_game_view_perform_selected_move (_data_->self);
#line 2930 "game-view.c"
	}
#line 471 "game-view.vala"
	_data_->self->priv->submitting_move = FALSE;
#line 463 "game-view.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 463 "game-view.vala"
	if (_data_->_state_ != 0) {
#line 463 "game-view.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 463 "game-view.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2942 "game-view.c"
		}
	}
#line 463 "game-view.vala"
	g_object_unref (_data_->_async_result);
#line 463 "game-view.vala"
	return FALSE;
#line 2949 "game-view.c"
}

/**
     * Actually perform the selected move by calling game.perform().
     */
static void
pasang_game_view_perform_selected_move (PasangGameView* self)
{
	PasangMove* applied_move = NULL;
	PasangMove* _tmp0_;
	PasangMove* _tmp1_;
	PasangGameSeries* _tmp2_;
	PasangMove* _tmp3_;
	PasangPlayer _tmp4_;
	PasangPlayer _tmp5_;
	PasangTheme* _tmp6_;
	PasangGameSeries* _tmp7_;
	PasangTheme* _tmp8_;
#line 477 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 478 "game-view.vala"
	_tmp0_ = self->priv->_selected_move;
#line 478 "game-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 478 "game-view.vala"
	applied_move = _tmp1_;
#line 479 "game-view.vala"
	_tmp2_ = self->priv->_game;
#line 479 "game-view.vala"
	_tmp3_ = self->priv->_selected_move;
#line 479 "game-view.vala"
	_tmp4_ = pasang_game_view_get_player_type (self);
#line 479 "game-view.vala"
	_tmp5_ = _tmp4_;
#line 479 "game-view.vala"
	pasang_game_series_perform_recorded (_tmp2_, _tmp3_, _tmp5_ != PASANG_PLAYER_HUMAN);
#line 480 "game-view.vala"
	_tmp6_ = self->priv->_theme;
#line 480 "game-view.vala"
	_tmp7_ = self->priv->_game;
#line 480 "game-view.vala"
	pasang_theme_drop_kas (_tmp6_, (PasangGame*) _tmp7_);
#line 481 "game-view.vala"
	_tmp8_ = self->priv->_theme;
#line 481 "game-view.vala"
	pasang_theme_drop_pieces (_tmp8_);
#line 482 "game-view.vala"
	pasang_game_view_hang_message (self);
#line 483 "game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 484 "game-view.vala"
	pasang_game_view_set_selected_move (self, NULL);
#line 485 "game-view.vala"
	self->kas_point.x = -1;
#line 486 "game-view.vala"
	pasang_game_view_show_sub_moves (self, NULL, NULL);
#line 487 "game-view.vala"
	g_signal_emit (self, pasang_game_view_signals[PASANG_GAME_VIEW_NEXT_MOVE_SIGNAL_SIGNAL], 0, applied_move);
#line 477 "game-view.vala"
	_g_object_unref0 (applied_move);
#line 3010 "game-view.c"
}

static void
pasang_game_view_show_sub_moves_data_free (gpointer _data)
{
	PasangGameViewShowSubMovesData* _data_;
	_data_ = _data;
#line 33 "game-view.vala"
	_g_object_unref0 (_data_->self);
#line 33 "game-view.vala"
	g_slice_free (PasangGameViewShowSubMovesData, _data_);
#line 3022 "game-view.c"
}

static void
pasang_game_view_show_sub_moves (PasangGameView* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	PasangGameViewShowSubMovesData* _data_;
	PasangGameView* _tmp0_;
#line 33 "game-view.vala"
	_data_ = g_slice_new0 (PasangGameViewShowSubMovesData);
#line 33 "game-view.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 33 "game-view.vala"
	g_task_set_task_data (_data_->_async_result, _data_, pasang_game_view_show_sub_moves_data_free);
#line 33 "game-view.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "game-view.vala"
	_data_->self = _tmp0_;
#line 33 "game-view.vala"
	pasang_game_view_show_sub_moves_co (_data_);
#line 3044 "game-view.c"
}

static void
pasang_game_view_show_sub_moves_finish (PasangGameView* self,
                                        GAsyncResult* _res_)
{
	PasangGameViewShowSubMovesData* _data_;
#line 33 "game-view.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3054 "game-view.c"
}

/**
     * Show all possible captures for SUB_SELECT or SUB_MOVE
     */
static void
pasang_game_view_show_sub_moves_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	PasangGameViewShowSubMovesData* _data_;
#line 504 "game-view.vala"
	_data_ = _user_data_;
#line 504 "game-view.vala"
	_data_->_source_object_ = source_object;
#line 504 "game-view.vala"
	_data_->_res_ = _res_;
#line 504 "game-view.vala"
	pasang_game_view_show_sub_moves_co (_data_);
#line 3074 "game-view.c"
}

static gboolean
pasang_game_view_show_sub_moves_co (PasangGameViewShowSubMovesData* _data_)
{
#line 493 "game-view.vala"
	switch (_data_->_state_) {
#line 493 "game-view.vala"
		case 0:
#line 3084 "game-view.c"
		goto _state_0;
#line 493 "game-view.vala"
		case 1:
#line 3088 "game-view.c"
		goto _state_1;
		default:
#line 493 "game-view.vala"
		g_assert_not_reached ();
#line 3093 "game-view.c"
	}
	_state_0:
#line 494 "game-view.vala"
	_data_->n = 0;
#line 495 "game-view.vala"
	while (TRUE) {
#line 495 "game-view.vala"
		if (!_data_->self->priv->submitting_move) {
#line 495 "game-view.vala"
			_data_->_tmp2_ = _data_->self->priv->_game;
#line 495 "game-view.vala"
			_data_->_tmp3_ = pasang_game_get_stage ((PasangGame*) _data_->_tmp2_);
#line 495 "game-view.vala"
			_data_->_tmp4_ = _data_->_tmp3_;
#line 495 "game-view.vala"
			if (_data_->_tmp4_ == PASANG_STAGE_SUB_SELECT) {
#line 495 "game-view.vala"
				_data_->_tmp1_ = TRUE;
#line 3112 "game-view.c"
			} else {
#line 495 "game-view.vala"
				_data_->_tmp5_ = _data_->self->priv->_game;
#line 495 "game-view.vala"
				_data_->_tmp6_ = pasang_game_get_stage ((PasangGame*) _data_->_tmp5_);
#line 495 "game-view.vala"
				_data_->_tmp7_ = _data_->_tmp6_;
#line 495 "game-view.vala"
				_data_->_tmp1_ = _data_->_tmp7_ == PASANG_STAGE_SUB_MOVE;
#line 3122 "game-view.c"
			}
#line 495 "game-view.vala"
			_data_->_tmp0_ = _data_->_tmp1_;
#line 3126 "game-view.c"
		} else {
#line 495 "game-view.vala"
			_data_->_tmp0_ = FALSE;
#line 3130 "game-view.c"
		}
#line 495 "game-view.vala"
		if (!_data_->_tmp0_) {
#line 495 "game-view.vala"
			break;
#line 3136 "game-view.c"
		}
#line 496 "game-view.vala"
		_data_->_tmp8_ = _data_->self->priv->_theme;
#line 496 "game-view.vala"
		_data_->_tmp9_ = pasang_theme_get_time_span (_data_->_tmp8_);
#line 496 "game-view.vala"
		_data_->_tmp10_ = _data_->_tmp9_;
#line 496 "game-view.vala"
		_data_->highlight_time = (gint) (_data_->_tmp10_ * 750);
#line 497 "game-view.vala"
		_data_->_tmp11_ = _data_->self->priv->_selected_move;
#line 497 "game-view.vala"
		if (_data_->_tmp11_ == NULL) {
#line 498 "game-view.vala"
			_data_->_tmp12_ = _data_->self->priv->_game;
#line 498 "game-view.vala"
			_data_->num_moves = pasang_game_numMoves ((PasangGame*) _data_->_tmp12_);
#line 499 "game-view.vala"
			_vala_assert (_data_->num_moves > 1, "num_moves > 1");
#line 500 "game-view.vala"
			_data_->_tmp13_ = _data_->self->priv->_theme;
#line 500 "game-view.vala"
			pasang_theme_drop_pieces (_data_->_tmp13_);
#line 501 "game-view.vala"
			_data_->_tmp14_ = _data_->self->priv->_theme;
#line 501 "game-view.vala"
			_data_->_tmp15_ = _data_->self->priv->_game;
#line 501 "game-view.vala"
			_data_->_tmp16_ = _data_->self->priv->_game;
#line 501 "game-view.vala"
			_data_->_tmp17_ = pasang_game_getMove ((PasangGame*) _data_->_tmp16_, _data_->n);
#line 501 "game-view.vala"
			_data_->_tmp18_ = _data_->_tmp17_;
#line 501 "game-view.vala"
			pasang_theme_pick_booties (_data_->_tmp14_, (PasangGame*) _data_->_tmp15_, _data_->_tmp18_, FALSE);
#line 501 "game-view.vala"
			_g_object_unref0 (_data_->_tmp18_);
#line 502 "game-view.vala"
			_data_->n = (_data_->n + 1) % _data_->num_moves;
#line 3176 "game-view.c"
		}
#line 504 "game-view.vala"
		_data_->_state_ = 1;
#line 504 "game-view.vala"
		pasang_util_wait_async (_data_->highlight_time, pasang_game_view_show_sub_moves_ready, _data_);
#line 504 "game-view.vala"
		return FALSE;
#line 3184 "game-view.c"
		_state_1:
#line 504 "game-view.vala"
		pasang_util_wait_finish (_data_->_res_);
#line 3188 "game-view.c"
	}
#line 493 "game-view.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 493 "game-view.vala"
	if (_data_->_state_ != 0) {
#line 493 "game-view.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 493 "game-view.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3198 "game-view.c"
		}
	}
#line 493 "game-view.vala"
	g_object_unref (_data_->_async_result);
#line 493 "game-view.vala"
	return FALSE;
#line 3205 "game-view.c"
}

/**
     * Simulate user gesture to effect the given move
     */
void
pasang_game_view_simulate (PasangGameView* self,
                           PasangMove* move)
{
	PasangGameSeries* _tmp0_;
	gint row = 0;
	gint col = 0;
	PasangGameSeries* _tmp1_;
	PasangStage _tmp2_;
	PasangStage _tmp3_;
#line 511 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 511 "game-view.vala"
	g_return_if_fail (move != NULL);
#line 512 "game-view.vala"
	_tmp0_ = self->priv->_game;
#line 512 "game-view.vala"
	pasang_game_leave_one_move ((PasangGame*) _tmp0_, move);
#line 513 "game-view.vala"
	row = 0;
#line 514 "game-view.vala"
	col = 0;
#line 515 "game-view.vala"
	_tmp1_ = self->priv->_game;
#line 515 "game-view.vala"
	_tmp2_ = pasang_game_get_stage ((PasangGame*) _tmp1_);
#line 515 "game-view.vala"
	_tmp3_ = _tmp2_;
#line 515 "game-view.vala"
	switch (_tmp3_) {
#line 515 "game-view.vala"
		case PASANG_STAGE_OPENING:
#line 3243 "game-view.c"
		{
			gint _tmp4_ = 0;
			PasangGameSeries* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
#line 517 "game-view.vala"
			_tmp5_ = self->priv->_game;
#line 517 "game-view.vala"
			_tmp6_ = pasang_game_get_player ((PasangGame*) _tmp5_);
#line 517 "game-view.vala"
			_tmp7_ = _tmp6_;
#line 517 "game-view.vala"
			if (_tmp7_ == 0) {
#line 517 "game-view.vala"
				_tmp4_ = 1;
#line 3263 "game-view.c"
			} else {
#line 517 "game-view.vala"
				_tmp4_ = 7;
#line 3267 "game-view.c"
			}
#line 517 "game-view.vala"
			row = _tmp4_;
#line 518 "game-view.vala"
			_tmp8_ = pasang_move_get_position (move);
#line 518 "game-view.vala"
			_tmp9_ = _tmp8_;
#line 518 "game-view.vala"
			_tmp10_ = pasang_move_get_position (move);
#line 518 "game-view.vala"
			_tmp11_ = _tmp10_;
#line 518 "game-view.vala"
			pasang_game_view_simulate_async (self, _tmp9_ + (row * PASANG_BOARD_WIDTH), _tmp11_ + (row * PASANG_BOARD_WIDTH), NULL, NULL);
#line 520 "game-view.vala"
			break;
#line 3283 "game-view.c"
		}
#line 515 "game-view.vala"
		case PASANG_STAGE_SELECT:
#line 3287 "game-view.c"
		{
			gint _tmp12_;
			gint _tmp13_;
			PasangGameSeries* _tmp14_;
			gint* _tmp15_;
			gint _tmp15__length1;
			PasangGameSeries* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
#line 522 "game-view.vala"
			_tmp12_ = pasang_move_get_position (move);
#line 522 "game-view.vala"
			_tmp13_ = _tmp12_;
#line 522 "game-view.vala"
			row = _tmp13_ / PASANG_BOARD_WIDTH;
#line 523 "game-view.vala"
			_tmp14_ = self->priv->_game;
#line 523 "game-view.vala"
			_tmp15_ = ((PasangGame*) _tmp14_)->first_move;
#line 523 "game-view.vala"
			_tmp15__length1 = ((PasangGame*) _tmp14_)->first_move_length1;
#line 523 "game-view.vala"
			_tmp16_ = self->priv->_game;
#line 523 "game-view.vala"
			_tmp17_ = pasang_game_get_player ((PasangGame*) _tmp16_);
#line 523 "game-view.vala"
			_tmp18_ = _tmp17_;
#line 523 "game-view.vala"
			_tmp19_ = _tmp15_[_tmp18_];
#line 523 "game-view.vala"
			col = _tmp19_;
#line 524 "game-view.vala"
			_tmp20_ = pasang_move_get_position (move);
#line 524 "game-view.vala"
			_tmp21_ = _tmp20_;
#line 524 "game-view.vala"
			pasang_game_view_simulate_async (self, _tmp21_, col + (row * PASANG_BOARD_WIDTH), NULL, NULL);
#line 526 "game-view.vala"
			break;
#line 3330 "game-view.c"
		}
#line 515 "game-view.vala"
		case PASANG_STAGE_MOVE:
#line 3334 "game-view.c"
		{
			PasangGameSeries* _tmp22_;
			gint* _tmp23_;
			gint _tmp23__length1;
			PasangGameSeries* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
#line 528 "game-view.vala"
			_tmp22_ = self->priv->_game;
#line 528 "game-view.vala"
			_tmp23_ = ((PasangGame*) _tmp22_)->kas_position;
#line 528 "game-view.vala"
			_tmp23__length1 = ((PasangGame*) _tmp22_)->kas_position_length1;
#line 528 "game-view.vala"
			_tmp24_ = self->priv->_game;
#line 528 "game-view.vala"
			_tmp25_ = pasang_game_get_player ((PasangGame*) _tmp24_);
#line 528 "game-view.vala"
			_tmp26_ = _tmp25_;
#line 528 "game-view.vala"
			_tmp27_ = _tmp23_[_tmp26_];
#line 528 "game-view.vala"
			_tmp28_ = pasang_move_get_position (move);
#line 528 "game-view.vala"
			_tmp29_ = _tmp28_;
#line 528 "game-view.vala"
			pasang_game_view_simulate_async (self, _tmp27_, _tmp29_, NULL, NULL);
#line 530 "game-view.vala"
			break;
#line 3367 "game-view.c"
		}
		default:
#line 515 "game-view.vala"
		break;
#line 3372 "game-view.c"
	}
}

static void
pasang_game_view_simulate_async_data_free (gpointer _data)
{
	PasangGameViewSimulateAsyncData* _data_;
	_data_ = _data;
#line 33 "game-view.vala"
	_g_object_unref0 (_data_->self);
#line 33 "game-view.vala"
	g_slice_free (PasangGameViewSimulateAsyncData, _data_);
#line 3385 "game-view.c"
}

static void
pasang_game_view_simulate_async (PasangGameView* self,
                                 gint press_pos,
                                 gint release_pos,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	PasangGameViewSimulateAsyncData* _data_;
	PasangGameView* _tmp0_;
#line 33 "game-view.vala"
	_data_ = g_slice_new0 (PasangGameViewSimulateAsyncData);
#line 33 "game-view.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 33 "game-view.vala"
	g_task_set_task_data (_data_->_async_result, _data_, pasang_game_view_simulate_async_data_free);
#line 33 "game-view.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "game-view.vala"
	_data_->self = _tmp0_;
#line 33 "game-view.vala"
	_data_->press_pos = press_pos;
#line 33 "game-view.vala"
	_data_->release_pos = release_pos;
#line 33 "game-view.vala"
	pasang_game_view_simulate_async_co (_data_);
#line 3413 "game-view.c"
}

static void
pasang_game_view_simulate_finish (PasangGameView* self,
                                  GAsyncResult* _res_)
{
	PasangGameViewSimulateAsyncData* _data_;
#line 33 "game-view.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3423 "game-view.c"
}

static void
pasang_game_view_simulate_async_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	PasangGameViewSimulateAsyncData* _data_;
#line 577 "game-view.vala"
	_data_ = _user_data_;
#line 577 "game-view.vala"
	_data_->_source_object_ = source_object;
#line 577 "game-view.vala"
	_data_->_res_ = _res_;
#line 577 "game-view.vala"
	pasang_game_view_simulate_async_co (_data_);
#line 3440 "game-view.c"
}

static gboolean
pasang_game_view_simulate_async_co (PasangGameViewSimulateAsyncData* _data_)
{
#line 539 "game-view.vala"
	switch (_data_->_state_) {
#line 539 "game-view.vala"
		case 0:
#line 3450 "game-view.c"
		goto _state_0;
#line 539 "game-view.vala"
		case 1:
#line 3454 "game-view.c"
		goto _state_1;
		default:
#line 539 "game-view.vala"
		g_assert_not_reached ();
#line 3459 "game-view.c"
	}
	_state_0:
#line 539 "game-view.vala"
	_data_->_tmp0_ = pasang_game_view_get_player_type (_data_->self);
#line 539 "game-view.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 539 "game-view.vala"
	_vala_return_val_if_fail (_data_->_tmp1_ != PASANG_PLAYER_HUMAN, "player_type != Player.HUMAN", FALSE);
#line 541 "game-view.vala"
	_data_->self->priv->motion_ticket = _data_->self->priv->motion_ticket + 1;
#line 541 "game-view.vala"
	_data_->my_motion_ticket = _data_->self->priv->motion_ticket;
#line 542 "game-view.vala"
	_data_->_tmp2_ = g_timer_new ();
#line 542 "game-view.vala"
	_data_->timer = _data_->_tmp2_;
#line 543 "game-view.vala"
	memset (&_data_->_tmp3_, 0, sizeof (PasangPoint));
#line 543 "game-view.vala"
	pasang_game_view_to_point (_data_->self, _data_->press_pos, &_data_->_tmp3_);
#line 543 "game-view.vala"
	_data_->press_point = _data_->_tmp3_;
#line 544 "game-view.vala"
	memset (&_data_->_tmp4_, 0, sizeof (PasangPoint));
#line 544 "game-view.vala"
	pasang_game_view_to_point (_data_->self, _data_->release_pos, &_data_->_tmp4_);
#line 544 "game-view.vala"
	_data_->release_point = _data_->_tmp4_;
#line 546 "game-view.vala"
	_data_->_tmp5_ = _data_->self->priv->_game;
#line 546 "game-view.vala"
	_data_->_tmp6_ = pasang_game_get_stage ((PasangGame*) _data_->_tmp5_);
#line 546 "game-view.vala"
	_data_->_tmp7_ = _data_->_tmp6_;
#line 546 "game-view.vala"
	if (_data_->_tmp7_ != PASANG_STAGE_OPENING) {
#line 546 "game-view.vala"
		_data_->_tmp8_ = _data_->press_point;
#line 546 "game-view.vala"
		pasang_game_view_drag_start (_data_->self, &_data_->_tmp8_);
#line 3500 "game-view.c"
	} else {
#line 547 "game-view.vala"
		_data_->_tmp9_ = _data_->press_point;
#line 547 "game-view.vala"
		pasang_game_view_hover (_data_->self, &_data_->_tmp9_);
#line 3506 "game-view.c"
	}
#line 549 "game-view.vala"
	_data_->_tmp10_ = _data_->self->priv->_theme;
#line 549 "game-view.vala"
	_data_->_tmp11_ = pasang_theme_get_time_span (_data_->_tmp10_);
#line 549 "game-view.vala"
	_data_->_tmp12_ = _data_->_tmp11_;
#line 549 "game-view.vala"
	_data_->time_to_move = MAX (1.5, _data_->_tmp12_);
#line 550 "game-view.vala"
	while (TRUE) {
#line 553 "game-view.vala"
		memset (&_data_->_tmp13_, 0, sizeof (PasangPoint));
#line 553 "game-view.vala"
		pasang_game_view_to_point (_data_->self, _data_->press_pos, &_data_->_tmp13_);
#line 553 "game-view.vala"
		_data_->press_point = _data_->_tmp13_;
#line 554 "game-view.vala"
		memset (&_data_->_tmp14_, 0, sizeof (PasangPoint));
#line 554 "game-view.vala"
		pasang_game_view_to_point (_data_->self, _data_->release_pos, &_data_->_tmp14_);
#line 554 "game-view.vala"
		_data_->release_point = _data_->_tmp14_;
#line 555 "game-view.vala"
		_data_->_tmp15_ = _data_->timer;
#line 555 "game-view.vala"
		_data_->lapse = g_timer_elapsed (_data_->_tmp15_, NULL) / _data_->time_to_move;
#line 556 "game-view.vala"
		_data_->_tmp16_ = _data_->self->priv->_game;
#line 556 "game-view.vala"
		_data_->_tmp17_ = pasang_game_get_stage ((PasangGame*) _data_->_tmp16_);
#line 556 "game-view.vala"
		_data_->_tmp18_ = _data_->_tmp17_;
#line 556 "game-view.vala"
		if (_data_->_tmp18_ == PASANG_STAGE_OPENING) {
#line 557 "game-view.vala"
			if (_data_->lapse > ((gdouble) 1)) {
#line 558 "game-view.vala"
				_data_->_tmp19_ = _data_->press_point;
#line 558 "game-view.vala"
				pasang_game_view_drag_start (_data_->self, &_data_->_tmp19_);
#line 559 "game-view.vala"
				break;
#line 3550 "game-view.c"
			}
		} else {
#line 565 "game-view.vala"
			_data_->time_to_pick_kas = 0.5;
#line 568 "game-view.vala"
			_data_->distance = CLAMP (_data_->lapse - _data_->time_to_pick_kas, (gdouble) 0, 1.0);
#line 569 "game-view.vala"
			_data_->_tmp20_ = _data_->press_point;
#line 569 "game-view.vala"
			_data_->_tmp21_ = _data_->release_point;
#line 569 "game-view.vala"
			_data_->_tmp22_ = _data_->press_point;
#line 569 "game-view.vala"
			_data_->_tmp23_ = _data_->release_point;
#line 569 "game-view.vala"
			memset (&_data_->_tmp24_, 0, sizeof (PasangPoint));
#line 569 "game-view.vala"
			pasang_point_init_xy (&_data_->_tmp24_, (gint) ((_data_->_tmp20_.x * (1 - _data_->distance)) + (_data_->_tmp21_.x * _data_->distance)), (gint) ((_data_->_tmp22_.y * (1 - _data_->distance)) + (_data_->_tmp23_.y * _data_->distance)));
#line 569 "game-view.vala"
			pasang_game_view_drag_update (_data_->self, &_data_->_tmp24_);
#line 572 "game-view.vala"
			if (_data_->distance == 1.0) {
#line 573 "game-view.vala"
				_data_->_tmp25_ = _data_->release_point;
#line 573 "game-view.vala"
				pasang_game_view_drag_stop (_data_->self, &_data_->_tmp25_);
#line 574 "game-view.vala"
				break;
#line 3579 "game-view.c"
			}
		}
#line 577 "game-view.vala"
		_data_->_state_ = 1;
#line 577 "game-view.vala"
		pasang_util_wait_async (30, pasang_game_view_simulate_async_ready, _data_);
#line 577 "game-view.vala"
		return FALSE;
#line 3588 "game-view.c"
		_state_1:
#line 577 "game-view.vala"
		pasang_util_wait_finish (_data_->_res_);
#line 578 "game-view.vala"
		if (_data_->my_motion_ticket != _data_->self->priv->motion_ticket) {
#line 578 "game-view.vala"
			break;
#line 3596 "game-view.c"
		}
	}
#line 539 "game-view.vala"
	_g_timer_destroy0 (_data_->timer);
#line 539 "game-view.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 539 "game-view.vala"
	if (_data_->_state_ != 0) {
#line 539 "game-view.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 539 "game-view.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3609 "game-view.c"
		}
	}
#line 539 "game-view.vala"
	g_object_unref (_data_->_async_result);
#line 539 "game-view.vala"
	return FALSE;
#line 3616 "game-view.c"
}

/**
     * Call this to prematurely stop simulating user gesture initiated by simulate()
     */
void
pasang_game_view_stop_simulation (PasangGameView* self)
{
	gint _tmp0_;
#line 585 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 586 "game-view.vala"
	_tmp0_ = self->priv->motion_ticket;
#line 586 "game-view.vala"
	self->priv->motion_ticket = _tmp0_ + 1;
#line 587 "game-view.vala"
	pasang_game_view_init_state (self);
#line 3634 "game-view.c"
}

static void
pasang_game_view_animate_data_free (gpointer _data)
{
	PasangGameViewAnimateData* _data_;
	_data_ = _data;
#line 33 "game-view.vala"
	_g_object_unref0 (_data_->self);
#line 33 "game-view.vala"
	g_slice_free (PasangGameViewAnimateData, _data_);
#line 3646 "game-view.c"
}

static void
pasang_game_view_animate (PasangGameView* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	PasangGameViewAnimateData* _data_;
	PasangGameView* _tmp0_;
#line 33 "game-view.vala"
	_data_ = g_slice_new0 (PasangGameViewAnimateData);
#line 33 "game-view.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 33 "game-view.vala"
	g_task_set_task_data (_data_->_async_result, _data_, pasang_game_view_animate_data_free);
#line 33 "game-view.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "game-view.vala"
	_data_->self = _tmp0_;
#line 33 "game-view.vala"
	pasang_game_view_animate_co (_data_);
#line 3668 "game-view.c"
}

static void
pasang_game_view_animate_finish (PasangGameView* self,
                                 GAsyncResult* _res_)
{
	PasangGameViewAnimateData* _data_;
#line 33 "game-view.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3678 "game-view.c"
}

static void
pasang_game_view_animate_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	PasangGameViewAnimateData* _data_;
#line 608 "game-view.vala"
	_data_ = _user_data_;
#line 608 "game-view.vala"
	_data_->_source_object_ = source_object;
#line 608 "game-view.vala"
	_data_->_res_ = _res_;
#line 608 "game-view.vala"
	pasang_game_view_animate_co (_data_);
#line 3695 "game-view.c"
}

static gboolean
pasang_game_view_animate_co (PasangGameViewAnimateData* _data_)
{
#line 595 "game-view.vala"
	switch (_data_->_state_) {
#line 595 "game-view.vala"
		case 0:
#line 3705 "game-view.c"
		goto _state_0;
#line 595 "game-view.vala"
		case 1:
#line 3709 "game-view.c"
		goto _state_1;
		default:
#line 595 "game-view.vala"
		g_assert_not_reached ();
#line 3714 "game-view.c"
	}
	_state_0:
#line 596 "game-view.vala"
	if (_data_->self->priv->animating) {
#line 596 "game-view.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 596 "game-view.vala"
		if (_data_->_state_ != 0) {
#line 596 "game-view.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 596 "game-view.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3727 "game-view.c"
			}
		}
#line 596 "game-view.vala"
		g_object_unref (_data_->_async_result);
#line 596 "game-view.vala"
		return FALSE;
#line 3734 "game-view.c"
	}
#line 597 "game-view.vala"
	_data_->self->priv->animating = TRUE;
#line 598 "game-view.vala"
	_data_->_tmp0_ = g_timer_new ();
#line 598 "game-view.vala"
	_data_->timer = _data_->_tmp0_;
#line 599 "game-view.vala"
	_data_->_tmp1_ = _data_->timer;
#line 599 "game-view.vala"
	_data_->last_motion = g_timer_elapsed (_data_->_tmp1_, NULL);
#line 600 "game-view.vala"
	while (TRUE) {
#line 601 "game-view.vala"
		_data_->_tmp2_ = _data_->self->priv->_theme;
#line 601 "game-view.vala"
		_data_->_tmp3_ = _data_->timer;
#line 601 "game-view.vala"
		_data_->_tmp4_ = _data_->self->priv->_theme;
#line 601 "game-view.vala"
		_data_->_tmp5_ = pasang_theme_get_time_span (_data_->_tmp4_);
#line 601 "game-view.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 601 "game-view.vala"
		if (pasang_theme_animate (_data_->_tmp2_, _data_->self, g_timer_elapsed (_data_->_tmp3_, NULL) / _data_->_tmp6_)) {
#line 602 "game-view.vala"
			_data_->_tmp7_ = _data_->timer;
#line 602 "game-view.vala"
			_data_->last_motion = g_timer_elapsed (_data_->_tmp7_, NULL);
#line 3764 "game-view.c"
		} else {
#line 605 "game-view.vala"
			_data_->_tmp8_ = _data_->timer;
#line 605 "game-view.vala"
			if ((g_timer_elapsed (_data_->_tmp8_, NULL) - _data_->last_motion) > 2.0) {
#line 606 "game-view.vala"
				break;
#line 3772 "game-view.c"
			}
		}
#line 608 "game-view.vala"
		_data_->_state_ = 1;
#line 608 "game-view.vala"
		pasang_util_wait_async (30, pasang_game_view_animate_ready, _data_);
#line 608 "game-view.vala"
		return FALSE;
#line 3781 "game-view.c"
		_state_1:
#line 608 "game-view.vala"
		pasang_util_wait_finish (_data_->_res_);
#line 3785 "game-view.c"
	}
#line 610 "game-view.vala"
	_data_->self->priv->animating = FALSE;
#line 595 "game-view.vala"
	_g_timer_destroy0 (_data_->timer);
#line 595 "game-view.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 595 "game-view.vala"
	if (_data_->_state_ != 0) {
#line 595 "game-view.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 595 "game-view.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3799 "game-view.c"
		}
	}
#line 595 "game-view.vala"
	g_object_unref (_data_->_async_result);
#line 595 "game-view.vala"
	return FALSE;
#line 3806 "game-view.c"
}

static GtkSizeRequestMode
pasang_game_view_real_get_request_mode (GtkWidget* base)
{
	PasangGameView * self;
	GtkSizeRequestMode result = 0;
#line 613 "game-view.vala"
	self = (PasangGameView*) base;
#line 614 "game-view.vala"
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
#line 614 "game-view.vala"
	return result;
#line 3820 "game-view.c"
}

static void
pasang_game_view_real_get_preferred_width (GtkWidget* base,
                                           gint* minimum_width,
                                           gint* natural_width)
{
	PasangGameView * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
#line 617 "game-view.vala"
	self = (PasangGameView*) base;
#line 618 "game-view.vala"
	_vala_minimum_width = PASANG_BOARD_WIDTH * 25;
#line 619 "game-view.vala"
	_vala_natural_width = PASANG_BOARD_WIDTH * 40;
#line 617 "game-view.vala"
	if (minimum_width) {
#line 617 "game-view.vala"
		*minimum_width = _vala_minimum_width;
#line 3841 "game-view.c"
	}
#line 617 "game-view.vala"
	if (natural_width) {
#line 617 "game-view.vala"
		*natural_width = _vala_natural_width;
#line 3847 "game-view.c"
	}
}

static void
pasang_game_view_real_get_preferred_height (GtkWidget* base,
                                            gint* minimum_height,
                                            gint* natural_height)
{
	PasangGameView * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
#line 622 "game-view.vala"
	self = (PasangGameView*) base;
#line 623 "game-view.vala"
	_vala_minimum_height = PASANG_BOARD_WIDTH * 25;
#line 624 "game-view.vala"
	_vala_natural_height = PASANG_BOARD_WIDTH * 40;
#line 622 "game-view.vala"
	if (minimum_height) {
#line 622 "game-view.vala"
		*minimum_height = _vala_minimum_height;
#line 3869 "game-view.c"
	}
#line 622 "game-view.vala"
	if (natural_height) {
#line 622 "game-view.vala"
		*natural_height = _vala_natural_height;
#line 3875 "game-view.c"
	}
}

static void
pasang_game_view_real_get_preferred_height_for_width (GtkWidget* base,
                                                      gint width,
                                                      gint* minimum_height,
                                                      gint* natural_height)
{
	PasangGameView * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
#line 627 "game-view.vala"
	self = (PasangGameView*) base;
#line 628 "game-view.vala"
	_vala_natural_height = width;
#line 629 "game-view.vala"
	_vala_minimum_height = PASANG_BOARD_WIDTH * 25;
#line 627 "game-view.vala"
	if (minimum_height) {
#line 627 "game-view.vala"
		*minimum_height = _vala_minimum_height;
#line 3898 "game-view.c"
	}
#line 627 "game-view.vala"
	if (natural_height) {
#line 627 "game-view.vala"
		*natural_height = _vala_natural_height;
#line 3904 "game-view.c"
	}
}

PasangGameSeries*
pasang_game_view_get_game (PasangGameView* self)
{
	PasangGameSeries* result;
	PasangGameSeries* _tmp0_;
#line 41 "game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 41 "game-view.vala"
	_tmp0_ = self->priv->_game;
#line 41 "game-view.vala"
	result = _tmp0_;
#line 41 "game-view.vala"
	return result;
#line 3921 "game-view.c"
}

static void
pasang_game_view_set_game (PasangGameView* self,
                           PasangGameSeries* value)
{
#line 41 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 41 "game-view.vala"
	if (pasang_game_view_get_game (self) != value) {
#line 3932 "game-view.c"
		PasangGameSeries* _tmp0_;
#line 41 "game-view.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 41 "game-view.vala"
		_g_object_unref0 (self->priv->_game);
#line 41 "game-view.vala"
		self->priv->_game = _tmp0_;
#line 41 "game-view.vala"
		g_object_notify_by_pspec ((GObject *) self, pasang_game_view_properties[PASANG_GAME_VIEW_GAME_PROPERTY]);
#line 3942 "game-view.c"
	}
}

PasangThemeSwitch*
pasang_game_view_get_theme_switch (PasangGameView* self)
{
	PasangThemeSwitch* result;
	PasangThemeSwitch* _tmp0_;
#line 43 "game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 43 "game-view.vala"
	_tmp0_ = self->priv->_theme_switch;
#line 43 "game-view.vala"
	result = _tmp0_;
#line 43 "game-view.vala"
	return result;
#line 3959 "game-view.c"
}

static void
pasang_game_view_set_theme_switch (PasangGameView* self,
                                   PasangThemeSwitch* value)
{
#line 43 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 43 "game-view.vala"
	if (pasang_game_view_get_theme_switch (self) != value) {
#line 3970 "game-view.c"
		PasangThemeSwitch* _tmp0_;
#line 43 "game-view.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 43 "game-view.vala"
		_g_object_unref0 (self->priv->_theme_switch);
#line 43 "game-view.vala"
		self->priv->_theme_switch = _tmp0_;
#line 43 "game-view.vala"
		g_object_notify_by_pspec ((GObject *) self, pasang_game_view_properties[PASANG_GAME_VIEW_THEME_SWITCH_PROPERTY]);
#line 3980 "game-view.c"
	}
}

PasangTheme*
pasang_game_view_get_theme (PasangGameView* self)
{
	PasangTheme* result;
	PasangTheme* _tmp0_;
#line 45 "game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "game-view.vala"
	_tmp0_ = self->priv->_theme;
#line 45 "game-view.vala"
	result = _tmp0_;
#line 45 "game-view.vala"
	return result;
#line 3997 "game-view.c"
}

static void
pasang_game_view_set_theme (PasangGameView* self,
                            PasangTheme* value)
{
#line 45 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 45 "game-view.vala"
	if (pasang_game_view_get_theme (self) != value) {
#line 4008 "game-view.c"
		PasangTheme* _tmp0_;
#line 45 "game-view.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 45 "game-view.vala"
		_g_object_unref0 (self->priv->_theme);
#line 45 "game-view.vala"
		self->priv->_theme = _tmp0_;
#line 45 "game-view.vala"
		g_object_notify_by_pspec ((GObject *) self, pasang_game_view_properties[PASANG_GAME_VIEW_THEME_PROPERTY]);
#line 4018 "game-view.c"
	}
}

PasangMove*
pasang_game_view_get_selected_move (PasangGameView* self)
{
	PasangMove* result;
	PasangMove* _tmp0_;
#line 55 "game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 55 "game-view.vala"
	_tmp0_ = self->priv->_selected_move;
#line 55 "game-view.vala"
	result = _tmp0_;
#line 55 "game-view.vala"
	return result;
#line 4035 "game-view.c"
}

static void
pasang_game_view_set_selected_move (PasangGameView* self,
                                    PasangMove* value)
{
#line 55 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 55 "game-view.vala"
	if (pasang_game_view_get_selected_move (self) != value) {
#line 4046 "game-view.c"
		PasangMove* _tmp0_;
#line 55 "game-view.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 55 "game-view.vala"
		_g_object_unref0 (self->priv->_selected_move);
#line 55 "game-view.vala"
		self->priv->_selected_move = _tmp0_;
#line 55 "game-view.vala"
		g_object_notify_by_pspec ((GObject *) self, pasang_game_view_properties[PASANG_GAME_VIEW_SELECTED_MOVE_PROPERTY]);
#line 4056 "game-view.c"
	}
}

const gchar*
pasang_game_view_get_message (PasangGameView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 60 "game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 60 "game-view.vala"
	_tmp0_ = self->priv->_message;
#line 60 "game-view.vala"
	result = _tmp0_;
#line 60 "game-view.vala"
	return result;
#line 4073 "game-view.c"
}

static void
pasang_game_view_set_message (PasangGameView* self,
                              const gchar* value)
{
#line 60 "game-view.vala"
	g_return_if_fail (self != NULL);
#line 60 "game-view.vala"
	if (g_strcmp0 (value, pasang_game_view_get_message (self)) != 0) {
#line 4084 "game-view.c"
		gchar* _tmp0_;
#line 60 "game-view.vala"
		_tmp0_ = g_strdup (value);
#line 60 "game-view.vala"
		_g_free0 (self->priv->_message);
#line 60 "game-view.vala"
		self->priv->_message = _tmp0_;
#line 60 "game-view.vala"
		g_object_notify_by_pspec ((GObject *) self, pasang_game_view_properties[PASANG_GAME_VIEW_MESSAGE_PROPERTY]);
#line 4094 "game-view.c"
	}
}

PasangPlayer
pasang_game_view_get_player_type (PasangGameView* self)
{
	PasangPlayer result;
	PasangPlayer* _tmp0_;
	gint _tmp0__length1;
	PasangGameSeries* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	PasangPlayer _tmp4_;
#line 181 "game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 181 "game-view.vala"
	_tmp0_ = self->priv->player_types;
#line 181 "game-view.vala"
	_tmp0__length1 = self->priv->player_types_length1;
#line 181 "game-view.vala"
	_tmp1_ = self->priv->_game;
#line 181 "game-view.vala"
	_tmp2_ = pasang_game_get_player ((PasangGame*) _tmp1_);
#line 181 "game-view.vala"
	_tmp3_ = _tmp2_;
#line 181 "game-view.vala"
	_tmp4_ = _tmp0_[_tmp3_];
#line 181 "game-view.vala"
	result = _tmp4_;
#line 181 "game-view.vala"
	return result;
#line 4126 "game-view.c"
}

gint
pasang_game_view_get_player_side (PasangGameView* self)
{
	gint result;
	gint _tmp0_ = 0;
	PasangGameSeries* _tmp1_;
#line 188 "game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 188 "game-view.vala"
	_tmp1_ = self->priv->_game;
#line 188 "game-view.vala"
	if (!_tmp1_->rotated) {
#line 4141 "game-view.c"
		PasangGameSeries* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 188 "game-view.vala"
		_tmp2_ = self->priv->_game;
#line 188 "game-view.vala"
		_tmp3_ = pasang_game_get_player ((PasangGame*) _tmp2_);
#line 188 "game-view.vala"
		_tmp4_ = _tmp3_;
#line 188 "game-view.vala"
		_tmp0_ = _tmp4_;
#line 4153 "game-view.c"
	} else {
		PasangGameSeries* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
#line 188 "game-view.vala"
		_tmp5_ = self->priv->_game;
#line 188 "game-view.vala"
		_tmp6_ = pasang_game_get_player ((PasangGame*) _tmp5_);
#line 188 "game-view.vala"
		_tmp7_ = _tmp6_;
#line 188 "game-view.vala"
		_tmp0_ = 1 - _tmp7_;
#line 4166 "game-view.c"
	}
#line 188 "game-view.vala"
	result = _tmp0_;
#line 188 "game-view.vala"
	return result;
#line 4172 "game-view.c"
}

static gboolean
pasang_game_view_get_input_allowed (PasangGameView* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	PasangPlayer _tmp2_;
	PasangPlayer _tmp3_;
#line 196 "game-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 197 "game-view.vala"
	_tmp2_ = pasang_game_view_get_player_type (self);
#line 197 "game-view.vala"
	_tmp3_ = _tmp2_;
#line 197 "game-view.vala"
	if (_tmp3_ == PASANG_PLAYER_HUMAN) {
#line 197 "game-view.vala"
		_tmp1_ = !self->priv->submitting_move;
#line 4193 "game-view.c"
	} else {
#line 197 "game-view.vala"
		_tmp1_ = FALSE;
#line 4197 "game-view.c"
	}
#line 197 "game-view.vala"
	if (_tmp1_) {
#line 197 "game-view.vala"
		_tmp0_ = TRUE;
#line 4203 "game-view.c"
	} else {
		gboolean _tmp4_ = FALSE;
		PasangPlayer _tmp5_;
		PasangPlayer _tmp6_;
#line 200 "game-view.vala"
		_tmp5_ = pasang_game_view_get_player_type (self);
#line 200 "game-view.vala"
		_tmp6_ = _tmp5_;
#line 200 "game-view.vala"
		if (_tmp6_ == PASANG_PLAYER_REMOTE) {
#line 4214 "game-view.c"
			PasangGameSeries* _tmp7_;
			PasangStage _tmp8_;
			PasangStage _tmp9_;
#line 200 "game-view.vala"
			_tmp7_ = self->priv->_game;
#line 200 "game-view.vala"
			_tmp8_ = pasang_game_get_stage ((PasangGame*) _tmp7_);
#line 200 "game-view.vala"
			_tmp9_ = _tmp8_;
#line 200 "game-view.vala"
			_tmp4_ = _tmp9_ == PASANG_STAGE_GAME_OVER;
#line 4226 "game-view.c"
		} else {
#line 200 "game-view.vala"
			_tmp4_ = FALSE;
#line 4230 "game-view.c"
		}
#line 200 "game-view.vala"
		_tmp0_ = _tmp4_;
#line 4234 "game-view.c"
	}
#line 197 "game-view.vala"
	result = _tmp0_;
#line 197 "game-view.vala"
	return result;
#line 4240 "game-view.c"
}

static void
pasang_game_view_class_init (PasangGameViewClass * klass,
                             gpointer klass_data)
{
#line 33 "game-view.vala"
	pasang_game_view_parent_class = g_type_class_peek_parent (klass);
#line 33 "game-view.vala"
	g_type_class_adjust_private_offset (klass, &PasangGameView_private_offset);
#line 33 "game-view.vala"
	((GtkWidgetClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkWidget*)) pasang_game_view_real_get_request_mode;
#line 33 "game-view.vala"
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) pasang_game_view_real_get_preferred_width;
#line 33 "game-view.vala"
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget*, gint*, gint*)) pasang_game_view_real_get_preferred_height;
#line 33 "game-view.vala"
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = (void (*) (GtkWidget*, gint, gint*, gint*)) pasang_game_view_real_get_preferred_height_for_width;
#line 33 "game-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_pasang_game_view_get_property;
#line 33 "game-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_pasang_game_view_set_property;
#line 33 "game-view.vala"
	G_OBJECT_CLASS (klass)->finalize = pasang_game_view_finalize;
#line 33 "game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_GAME_VIEW_GAME_PROPERTY, pasang_game_view_properties[PASANG_GAME_VIEW_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", PASANG_TYPE_GAME_SERIES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 33 "game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_GAME_VIEW_THEME_SWITCH_PROPERTY, pasang_game_view_properties[PASANG_GAME_VIEW_THEME_SWITCH_PROPERTY] = g_param_spec_object ("theme-switch", "theme-switch", "theme-switch", PASANG_TYPE_THEME_SWITCH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 33 "game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_GAME_VIEW_THEME_PROPERTY, pasang_game_view_properties[PASANG_GAME_VIEW_THEME_PROPERTY] = g_param_spec_object ("theme", "theme", "theme", PASANG_TYPE_THEME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 4271 "game-view.c"
	/**
	     * Move that matches the user (or simulated) gesture.
	     */
#line 33 "game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_GAME_VIEW_SELECTED_MOVE_PROPERTY, pasang_game_view_properties[PASANG_GAME_VIEW_SELECTED_MOVE_PROPERTY] = g_param_spec_object ("selected-move", "selected-move", "selected-move", PASANG_TYPE_MOVE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 4277 "game-view.c"
	/**
	     * Message that depends on the state of the game.
	     */
#line 33 "game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_GAME_VIEW_MESSAGE_PROPERTY, pasang_game_view_properties[PASANG_GAME_VIEW_MESSAGE_PROPERTY] = g_param_spec_string ("message", "message", "message", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 4283 "game-view.c"
	/**
	     * Who is playing next turn: Player.HUMAN, or Player.AI, or ...?
	     */
#line 33 "game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_GAME_VIEW_PLAYER_TYPE_PROPERTY, pasang_game_view_properties[PASANG_GAME_VIEW_PLAYER_TYPE_PROPERTY] = g_param_spec_enum ("player-type", "player-type", "player-type", PASANG_TYPE_PLAYER, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 4289 "game-view.c"
	/**
	     * Who is playing next turn: the player sitting at the top (0) or the one at the bottom (1)?
	     */
#line 33 "game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_GAME_VIEW_PLAYER_SIDE_PROPERTY, pasang_game_view_properties[PASANG_GAME_VIEW_PLAYER_SIDE_PROPERTY] = g_param_spec_int ("player-side", "player-side", "player-side", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 4295 "game-view.c"
	/**
	     * Emitted whenever a move has been completed.
	     * move = null means "pass", i.e., let the other player make
	     * the first move.
	     */
#line 33 "game-view.vala"
	pasang_game_view_signals[PASANG_GAME_VIEW_NEXT_MOVE_SIGNAL_SIGNAL] = g_signal_new ("next-move-signal", PASANG_TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, PASANG_TYPE_MOVE);
#line 4303 "game-view.c"
}

static void
pasang_game_view_instance_init (PasangGameView * self,
                                gpointer klass)
{
	PasangThemeSwitch* _tmp0_;
	PasangPlayer* _tmp1_;
#line 33 "game-view.vala"
	self->priv = pasang_game_view_get_instance_private (self);
#line 43 "game-view.vala"
	_tmp0_ = pasang_theme_switch_new ();
#line 43 "game-view.vala"
	g_object_ref_sink (_tmp0_);
#line 43 "game-view.vala"
	self->priv->_theme_switch = _tmp0_;
#line 45 "game-view.vala"
	self->priv->_theme = NULL;
#line 50 "game-view.vala"
	memset (&self->kas_point, 0, sizeof (PasangPoint));
#line 55 "game-view.vala"
	self->priv->_selected_move = NULL;
#line 60 "game-view.vala"
	self->priv->_message = NULL;
#line 65 "game-view.vala"
	_tmp1_ = g_new0 (PasangPlayer, 2);
#line 65 "game-view.vala"
	self->priv->player_types = _tmp1_;
#line 65 "game-view.vala"
	self->priv->player_types_length1 = 2;
#line 65 "game-view.vala"
	self->priv->_player_types_size_ = self->priv->player_types_length1;
#line 70 "game-view.vala"
	memset (&self->priv->drag_point, 0, sizeof (PasangPoint));
#line 593 "game-view.vala"
	self->priv->animating = FALSE;
#line 4340 "game-view.c"
}

static void
pasang_game_view_finalize (GObject * obj)
{
	PasangGameView * self;
#line 33 "game-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_GAME_VIEW, PasangGameView);
#line 41 "game-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 43 "game-view.vala"
	_g_object_unref0 (self->priv->_theme_switch);
#line 45 "game-view.vala"
	_g_object_unref0 (self->priv->_theme);
#line 55 "game-view.vala"
	_g_object_unref0 (self->priv->_selected_move);
#line 60 "game-view.vala"
	_g_free0 (self->priv->_message);
#line 65 "game-view.vala"
	self->priv->player_types = (g_free (self->priv->player_types), NULL);
#line 79 "game-view.vala"
	_g_object_unref0 (self->priv->gesture);
#line 80 "game-view.vala"
	_g_object_unref0 (self->priv->event_controller);
#line 33 "game-view.vala"
	G_OBJECT_CLASS (pasang_game_view_parent_class)->finalize (obj);
#line 4367 "game-view.c"
}

GType
pasang_game_view_get_type (void)
{
	static volatile gsize pasang_game_view_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangGameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangGameView), 0, (GInstanceInitFunc) pasang_game_view_instance_init, NULL };
		GType pasang_game_view_type_id;
		pasang_game_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "PasangGameView", &g_define_type_info, 0);
		PasangGameView_private_offset = g_type_add_instance_private (pasang_game_view_type_id, sizeof (PasangGameViewPrivate));
		g_once_init_leave (&pasang_game_view_type_id__volatile, pasang_game_view_type_id);
	}
	return pasang_game_view_type_id__volatile;
}

static void
_vala_pasang_game_view_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	PasangGameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PASANG_TYPE_GAME_VIEW, PasangGameView);
#line 33 "game-view.vala"
	switch (property_id) {
#line 33 "game-view.vala"
		case PASANG_GAME_VIEW_GAME_PROPERTY:
#line 33 "game-view.vala"
		g_value_set_object (value, pasang_game_view_get_game (self));
#line 33 "game-view.vala"
		break;
#line 33 "game-view.vala"
		case PASANG_GAME_VIEW_THEME_SWITCH_PROPERTY:
#line 33 "game-view.vala"
		g_value_set_object (value, pasang_game_view_get_theme_switch (self));
#line 33 "game-view.vala"
		break;
#line 33 "game-view.vala"
		case PASANG_GAME_VIEW_THEME_PROPERTY:
#line 33 "game-view.vala"
		g_value_set_object (value, pasang_game_view_get_theme (self));
#line 33 "game-view.vala"
		break;
#line 33 "game-view.vala"
		case PASANG_GAME_VIEW_SELECTED_MOVE_PROPERTY:
#line 33 "game-view.vala"
		g_value_set_object (value, pasang_game_view_get_selected_move (self));
#line 33 "game-view.vala"
		break;
#line 33 "game-view.vala"
		case PASANG_GAME_VIEW_MESSAGE_PROPERTY:
#line 33 "game-view.vala"
		g_value_set_string (value, pasang_game_view_get_message (self));
#line 33 "game-view.vala"
		break;
#line 33 "game-view.vala"
		case PASANG_GAME_VIEW_PLAYER_TYPE_PROPERTY:
#line 33 "game-view.vala"
		g_value_set_enum (value, pasang_game_view_get_player_type (self));
#line 33 "game-view.vala"
		break;
#line 33 "game-view.vala"
		case PASANG_GAME_VIEW_PLAYER_SIDE_PROPERTY:
#line 33 "game-view.vala"
		g_value_set_int (value, pasang_game_view_get_player_side (self));
#line 33 "game-view.vala"
		break;
#line 4436 "game-view.c"
		default:
#line 33 "game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "game-view.vala"
		break;
#line 4442 "game-view.c"
	}
}

static void
_vala_pasang_game_view_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	PasangGameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PASANG_TYPE_GAME_VIEW, PasangGameView);
#line 33 "game-view.vala"
	switch (property_id) {
#line 33 "game-view.vala"
		case PASANG_GAME_VIEW_GAME_PROPERTY:
#line 33 "game-view.vala"
		pasang_game_view_set_game (self, g_value_get_object (value));
#line 33 "game-view.vala"
		break;
#line 33 "game-view.vala"
		case PASANG_GAME_VIEW_THEME_SWITCH_PROPERTY:
#line 33 "game-view.vala"
		pasang_game_view_set_theme_switch (self, g_value_get_object (value));
#line 33 "game-view.vala"
		break;
#line 33 "game-view.vala"
		case PASANG_GAME_VIEW_THEME_PROPERTY:
#line 33 "game-view.vala"
		pasang_game_view_set_theme (self, g_value_get_object (value));
#line 33 "game-view.vala"
		break;
#line 33 "game-view.vala"
		case PASANG_GAME_VIEW_SELECTED_MOVE_PROPERTY:
#line 33 "game-view.vala"
		pasang_game_view_set_selected_move (self, g_value_get_object (value));
#line 33 "game-view.vala"
		break;
#line 33 "game-view.vala"
		case PASANG_GAME_VIEW_MESSAGE_PROPERTY:
#line 33 "game-view.vala"
		pasang_game_view_set_message (self, g_value_get_string (value));
#line 33 "game-view.vala"
		break;
#line 4486 "game-view.c"
		default:
#line 33 "game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "game-view.vala"
		break;
#line 4492 "game-view.c"
	}
}

