/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_OptWindow
#define GUARD_OptWindow

#include "DragWindow.h"
#include "Menu_Base.h"

class ChooseResolution: public Menu_Base {
public:
	ChooseResolution();
	bool SwitchOnChoice(Uint16 x, Uint16 y);
};

class WindowColorSlider: public SliderWithUnits {
public:
	WindowColorSlider(int ix, int iy, int flags);

	bool MouseM(Uint8 state, Uint16 x, Uint16 y);
	void DrawSelf();
};

class StandardOptions: public PopupMenu {
public:
	StandardOptions(int ix, int iy, int iParentID, int flags);
	virtual void Update();
	bool SwitchOnChoice(Uint16 x, Uint16 y);

protected:
	void PushBackSharedItems();
};

#endif


