/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleDeliveryType;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElement;
import com.android.tools.build.bundletool.validation.BundleValidationUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class DeclarativeWatchFaceBundleValidator
extends SubValidator {
    private static final HashCode WEAR_3_COMPAT_DEX_SHA = HashCode.fromString("2891be8a0b1e950bb91e9c35b4dc763dd425b106218e20cd0a4eaaf40c2a9ca4");

    @Override
    public void validateBundle(AppBundle bundle) {
        if (BundleValidationUtils.isDeclarativeWatchFaceBundle(bundle)) {
            this.validateDwfBundle(bundle);
        }
    }

    private void validateDwfBundle(AppBundle bundle) {
        this.validateBundleContainsAtMostTwoModules(bundle);
        BundleModule baseModule = bundle.getBaseModule();
        this.validateBaseIsWatchModule(baseModule);
        this.validateBaseContainsLayoutDefinitions(baseModule);
        this.validateBaseHasNoExecutableComponents(baseModule);
        this.validateBaseHasNoLibs(baseModule);
        this.validateBaseHasNoRoot(baseModule);
        Optional<Map.Entry<BundleModuleName, BundleModule>> optionalRuntime = this.getOptionalRuntime(bundle);
        optionalRuntime.ifPresent(this::validateRuntimeIsConditionallyInstalled);
        this.validateMinSdkIsCorrect(baseModule, optionalRuntime.isPresent());
        this.validateNoUnexpectedDexFiles(baseModule, optionalRuntime.isPresent());
    }

    private void validateBundleContainsAtMostTwoModules(AppBundle bundle) {
        ImmutableMap<BundleModuleName, BundleModule> modules = bundle.getModules();
        this.assertWithUserMessage(modules.size() <= 2, "Watch face bundle can have at most two modules.");
    }

    private void validateBaseIsWatchModule(BundleModule baseModule) {
        ImmutableList<XmlProtoElement> usesFeatureWatch = baseModule.getAndroidManifest().getUsesFeatureElement("android.hardware.type.watch");
        this.assertWithUserMessage(!usesFeatureWatch.isEmpty(), "Watch face apps are working only on watches. The AndroidManifest.xml must contain a <uses-feature android:name=\"android.hardware.type.watch\" /> declaration.");
    }

    private void validateBaseContainsLayoutDefinitions(BundleModule baseModule) {
        boolean hasShapeDefinitions = baseModule.findEntries(entry -> Objects.equals(entry.getFileName().toString(), "watch_face_shapes.xml") && entry.toString().startsWith("res/xml")).findFirst().isPresent();
        if (!hasShapeDefinitions) {
            ZipPath requiredFilePath = ZipPath.create("/res/raw/watchface.xml");
            boolean fileExists = baseModule.findEntriesUnderPath(requiredFilePath).count() == 1L;
            this.assertWithUserMessage(fileExists, "Watch face must contain an xml watch_face_shapes resource or a default /res/raw/watchface.xml layout.");
        }
    }

    private void validateBaseHasNoExecutableComponents(BundleModule baseModule) {
        this.assertWithUserMessage(!baseModule.getAndroidManifest().hasComponents(), "Watch face base module cannot have any components and can only have resources.");
    }

    private Optional<Map.Entry<BundleModuleName, BundleModule>> getOptionalRuntime(AppBundle bundle) {
        ImmutableMap<BundleModuleName, BundleModule> modules = bundle.getModules();
        return modules.entrySet().stream().filter(entry -> !((BundleModule)entry.getValue()).isBaseModule()).findFirst();
    }

    private void validateRuntimeIsConditionallyInstalled(Map.Entry<BundleModuleName, BundleModule> runtimeModule) {
        BundleModule runtimeModuleValue = runtimeModule.getValue();
        this.assertWithUserMessage(runtimeModuleValue.getModuleType().isFeatureModule(), String.format("Module %s must be a feature module.", runtimeModule.getKey()));
        this.assertWithUserMessage(runtimeModuleValue.getDeliveryType().equals((Object)ModuleDeliveryType.CONDITIONAL_INITIAL_INSTALL), String.format("Module %s must be conditionally installed.", runtimeModule.getKey()));
        Optional runtimeDeliveryMaxSdk = runtimeModuleValue.getAndroidManifest().getManifestDeliveryElement().flatMap(it -> it.getModuleConditions().getMaxSdkVersion());
        int sdkLevelWithRuntime = 33;
        this.assertWithUserMessage(runtimeDeliveryMaxSdk.isPresent() && (Integer)runtimeDeliveryMaxSdk.get() < sdkLevelWithRuntime, String.format("Watch face with embedded runtime must not install the runtime on devices with API level >= %s.", sdkLevelWithRuntime));
    }

    private void validateMinSdkIsCorrect(BundleModule baseModule, boolean hasRuntime) {
        int baseMinSdk = baseModule.getAndroidManifest().getEffectiveMinSdkVersion();
        if (hasRuntime) {
            this.assertWithUserMessage(baseMinSdk == 30, "Watch face with embedded runtime must have minSdk 30.");
        } else {
            this.assertWithUserMessage(baseMinSdk >= 33, "Watch face without embedded runtime must have minSdk >= 33.");
        }
    }

    private void validateNoUnexpectedDexFiles(BundleModule baseModule, boolean hasRuntime) {
        ImmutableList dexFiles = baseModule.findEntriesUnderPath(BundleModule.DEX_DIRECTORY).collect(ImmutableList.toImmutableList());
        if (!hasRuntime) {
            this.assertWithUserMessage(dexFiles.isEmpty(), "Watch face with minSdk >= 33 cannot have dex files.");
        } else {
            this.assertWithUserMessage(dexFiles.size() == 1 && Objects.equals(((ModuleEntry)dexFiles.get(0)).getContentSha256Hash(), WEAR_3_COMPAT_DEX_SHA), "Watch face with embedded runtime must have a single, expected dex file in its base module.");
        }
    }

    private void validateBaseHasNoLibs(BundleModule baseModule) {
        boolean hasLibs = baseModule.findEntriesUnderPath(BundleModule.LIB_DIRECTORY).findFirst().isPresent();
        this.assertWithUserMessage(!hasLibs, "Watch face cannot have any external libraries.");
    }

    private void validateBaseHasNoRoot(BundleModule baseModule) {
        boolean hasRoot = baseModule.findEntriesUnderPath(BundleModule.ROOT_DIRECTORY).findFirst().isPresent();
        this.assertWithUserMessage(!hasRoot, "Watch face cannot have any files in the root of the package.");
    }

    private void assertWithUserMessage(boolean condition, String message2) {
        if (!condition) {
            throw InvalidBundleException.builder().withUserMessage(message2).build();
        }
    }
}

