// Code generated by go-swagger; DO NOT EDIT.

package consul_telemetry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-consul-telemetry-gateway/preview/2023-04-14/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// GetLabelValuesReader is a Reader for the GetLabelValues structure.
type GetLabelValuesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetLabelValuesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetLabelValuesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetLabelValuesDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetLabelValuesOK creates a GetLabelValuesOK with default headers values
func NewGetLabelValuesOK() *GetLabelValuesOK {
	return &GetLabelValuesOK{}
}

/*
GetLabelValuesOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetLabelValuesOK struct {
	Payload *models.HashicorpCloudConsulTelemetry20230414GetLabelValuesResponse
}

// IsSuccess returns true when this get label values o k response has a 2xx status code
func (o *GetLabelValuesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get label values o k response has a 3xx status code
func (o *GetLabelValuesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get label values o k response has a 4xx status code
func (o *GetLabelValuesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get label values o k response has a 5xx status code
func (o *GetLabelValuesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get label values o k response a status code equal to that given
func (o *GetLabelValuesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get label values o k response
func (o *GetLabelValuesOK) Code() int {
	return 200
}

func (o *GetLabelValuesOK) Error() string {
	return fmt.Sprintf("[POST /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/label/values][%d] getLabelValuesOK  %+v", 200, o.Payload)
}

func (o *GetLabelValuesOK) String() string {
	return fmt.Sprintf("[POST /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/label/values][%d] getLabelValuesOK  %+v", 200, o.Payload)
}

func (o *GetLabelValuesOK) GetPayload() *models.HashicorpCloudConsulTelemetry20230414GetLabelValuesResponse {
	return o.Payload
}

func (o *GetLabelValuesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudConsulTelemetry20230414GetLabelValuesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLabelValuesDefault creates a GetLabelValuesDefault with default headers values
func NewGetLabelValuesDefault(code int) *GetLabelValuesDefault {
	return &GetLabelValuesDefault{
		_statusCode: code,
	}
}

/*
GetLabelValuesDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetLabelValuesDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this get label values default response has a 2xx status code
func (o *GetLabelValuesDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get label values default response has a 3xx status code
func (o *GetLabelValuesDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get label values default response has a 4xx status code
func (o *GetLabelValuesDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get label values default response has a 5xx status code
func (o *GetLabelValuesDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get label values default response a status code equal to that given
func (o *GetLabelValuesDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get label values default response
func (o *GetLabelValuesDefault) Code() int {
	return o._statusCode
}

func (o *GetLabelValuesDefault) Error() string {
	return fmt.Sprintf("[POST /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/label/values][%d] GetLabelValues default  %+v", o._statusCode, o.Payload)
}

func (o *GetLabelValuesDefault) String() string {
	return fmt.Sprintf("[POST /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/label/values][%d] GetLabelValues default  %+v", o._statusCode, o.Payload)
}

func (o *GetLabelValuesDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *GetLabelValuesDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
GetLabelValuesBody GetLabelValuesRequest
swagger:model GetLabelValuesBody
*/
type GetLabelValuesBody struct {

	// cluster_internal_id is the internal UUID of the cluster. This is used, instead of the public id,
	// to separate metrics per cluster. There could be two clusters in the same organization with the same public id,
	// or a two clusters with the same name in the same project, one created after the other is deleted. In either
	// scenario, we do not want to show the other cluster's metrics.
	ClusterInternalID string `json:"cluster_internal_id,omitempty"`

	// end
	// Format: date-time
	End strfmt.DateTime `json:"end,omitempty"`

	// location
	Location *GetLabelValuesParamsBodyLocation `json:"location,omitempty"`

	// start
	// Format: date-time
	Start strfmt.DateTime `json:"start,omitempty"`

	// refs a metric that we allow frontend to query values for
	Type *models.HashicorpCloudConsulTelemetry20230414LVT `json:"type,omitempty"`
}

// Validate validates this get label values body
func (o *GetLabelValuesBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateEnd(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStart(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetLabelValuesBody) validateEnd(formats strfmt.Registry) error {
	if swag.IsZero(o.End) { // not required
		return nil
	}

	if err := validate.FormatOf("body"+"."+"end", "body", "date-time", o.End.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *GetLabelValuesBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *GetLabelValuesBody) validateStart(formats strfmt.Registry) error {
	if swag.IsZero(o.Start) { // not required
		return nil
	}

	if err := validate.FormatOf("body"+"."+"start", "body", "date-time", o.Start.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *GetLabelValuesBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	if o.Type != nil {
		if err := o.Type.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "type")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this get label values body based on the context it is used
func (o *GetLabelValuesBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetLabelValuesBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *GetLabelValuesBody) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if o.Type != nil {

		if swag.IsZero(o.Type) { // not required
			return nil
		}

		if err := o.Type.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "type")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GetLabelValuesBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GetLabelValuesBody) UnmarshalBinary(b []byte) error {
	var res GetLabelValuesBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
GetLabelValuesParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model GetLabelValuesParamsBodyLocation
*/
type GetLabelValuesParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *cloud.HashicorpCloudLocationRegion `json:"region,omitempty"`
}

// Validate validates this get label values params body location
func (o *GetLabelValuesParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetLabelValuesParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this get label values params body location based on the context it is used
func (o *GetLabelValuesParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetLabelValuesParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GetLabelValuesParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GetLabelValuesParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res GetLabelValuesParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
