/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.writer;

import java.io.IOException;
import java.io.Writer;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.AbstractPrerequisiteWriter;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterInterface;

public class PreVariableWriter
extends AbstractPrerequisiteWriter
implements PrerequisiteWriterInterface {
    @Override
    public String kindHandled() {
        return "var";
    }

    @Override
    public PrerequisiteOperator[] operatorsHandled() {
        return null;
    }

    @Override
    public void write(Writer writer, Prerequisite prereq) throws PersistenceLayerException {
        try {
            writer.write("PREVAR");
            writer.write(prereq.getOperator().toString().toUpperCase());
            writer.write(':' + (prereq.isOverrideQualify() ? "Q:" : ""));
            writer.write(prereq.getKey());
            writer.write(44);
            writer.write(prereq.getOperand());
        }
        catch (IOException e) {
            throw new PersistenceLayerException(e.getMessage());
        }
    }

    @Override
    public boolean specialCase(Writer writer, Prerequisite prereq) throws IOException {
        if (prereq.getKind() != null) {
            return false;
        }
        String handled = this.kindHandled();
        String count = prereq.getOperand();
        try {
            int i = Integer.parseInt(count);
            if (prereq.getPrerequisiteCount() != i) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        PrerequisiteOperator oper = null;
        for (Prerequisite p : prereq.getPrerequisites()) {
            if (!handled.equalsIgnoreCase(p.getKind())) {
                return false;
            }
            if (oper == null) {
                oper = p.getOperator();
                continue;
            }
            if (oper.equals((Object)p.getOperator())) continue;
            return false;
        }
        writer.write("PREVAR");
        if (prereq.getOperator() == PrerequisiteOperator.LT) {
            writer.write(oper.invert().toString().toUpperCase());
        } else {
            writer.write(oper.toString().toUpperCase());
        }
        writer.write(':' + (prereq.isOverrideQualify() ? "Q:" : ""));
        boolean first = true;
        for (Prerequisite p : prereq.getPrerequisites()) {
            if (!first) {
                writer.write(44);
            }
            writer.write(p.getKey());
            writer.write(44);
            writer.write(p.getOperand());
            first = false;
        }
        return true;
    }
}

