/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import pcgen.cdom.base.CDOMObject;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractDisplayPrereqTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;

public class PreAgeSetTester
extends AbstractDisplayPrereqTest
implements PrerequisiteTest {
    @Override
    public int passes(Prerequisite prereq, CharacterDisplay display, CDOMObject source) throws PrerequisiteException {
        int anInt;
        int ageset = display.getAgeSetIndex();
        int runningTotal = -1;
        try {
            anInt = Integer.parseInt(prereq.getKey());
        }
        catch (NumberFormatException exc) {
            anInt = display.getBioSet().getAgeSetNamed(prereq.getKey());
        }
        catch (Exception e) {
            throw new PrerequisiteException(LanguageBundle.getFormattedString("PreAgeSet.error.badly_formed_attribute", prereq.getOperand()));
        }
        if (anInt == -1) {
            throw new PrerequisiteException(LanguageBundle.getFormattedString("PreAgeSet.error.badly_formed_attribute", prereq.getOperand()));
        }
        runningTotal = prereq.getOperator().compare(ageset, anInt);
        return this.countedTotal(prereq, runningTotal);
    }

    @Override
    public String kindHandled() {
        return "AGESET";
    }
}

