/*
 * Decompiled with CFR 0.152.
 */
package plugin.overland.util;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdom.Element;

public class Localized {
    private static final boolean NEED_RESTART = true;
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ELEMENT_LOC = "loc";
    private static final String ATTRIBUTE_LANGUAGE = "language";
    private static Map<String, Integer> unnamedCount = new HashMap<String, Integer>();
    private String defaultName;
    private Map<String, String> languageNames;
    private String defaultLocaleName;

    public Localized(Element element, String attribute) {
        this.defaultName = attribute == null ? element.getTextTrim() : element.getAttributeValue(attribute);
        this.update(element, attribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Localized(Element element) {
        this(element, ATTRIBUTE_NAME);
        if (this.defaultName == null) {
            String name = element.getName();
            Integer i = unnamedCount.get(name);
            Map<String, Integer> map = unnamedCount;
            synchronized (map) {
                i = i == null ? Integer.valueOf(1) : Integer.valueOf(i + 1);
                unnamedCount.put(name, i);
            }
            this.defaultName = element.getName() + i;
        }
    }

    private void addName(String lang, String name) {
        if (Locale.getDefault().getLanguage().equals(lang)) {
            this.defaultLocaleName = name;
        } else {
            if (this.languageNames == null) {
                this.languageNames = new HashMap<String, String>();
            }
            this.languageNames.put(lang, name);
        }
    }

    private String toString(Locale l) {
        String lang;
        if (this.languageNames != null && this.languageNames.containsKey(lang = l.getLanguage())) {
            return this.languageNames.get(lang);
        }
        return this.defaultName;
    }

    public String toString() {
        if (this.defaultLocaleName != null) {
            return this.defaultLocaleName;
        }
        return this.defaultName;
    }

    private void update(Element e, String attribute) {
        List children = e.getChildren(ELEMENT_LOC);
        for (Object object : children) {
            if (!(object instanceof Element)) continue;
            Element child = (Element)object;
            String lang = child.getAttributeValue(ATTRIBUTE_LANGUAGE);
            String name = attribute == null ? child.getTextTrim() : child.getAttributeValue(attribute);
            if (lang == null || lang.isEmpty()) continue;
            this.addName(lang, name);
        }
    }
}

