/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.spell;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Type;
import pcgen.core.spell.Spell;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class ItemToken
extends AbstractTokenWithSeparator<Spell>
implements CDOMPrimaryToken<Spell> {
    @Override
    public String getTokenName() {
        return "ITEM";
    }

    @Override
    protected char separator() {
        return ',';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, Spell spell, String value) {
        StringTokenizer aTok = new StringTokenizer(value, ",");
        while (aTok.hasMoreTokens()) {
            String tokString = aTok.nextToken();
            int bracketLoc = tokString.indexOf(91);
            if (bracketLoc == 0) {
                if (tokString.lastIndexOf(93) != tokString.length() - 1) {
                    return new ParseResult.Fail("Invalid " + this.getTokenName() + ": mismatched open Bracket: " + tokString + " in " + value, context);
                }
                String substring = tokString.substring(1, tokString.length() - 1);
                if (substring.length() == 0) {
                    return new ParseResult.Fail("Invalid " + this.getTokenName() + ": cannot be empty item in brackets []", context);
                }
                context.getObjectContext().addToList(spell, ListKey.PROHIBITED_ITEM, Type.getConstant(substring));
                continue;
            }
            if (tokString.lastIndexOf(93) != -1) {
                return new ParseResult.Fail("Invalid " + this.getTokenName() + ": mismatched close Bracket: " + tokString + " in " + value, context);
            }
            context.getObjectContext().addToList(spell, ListKey.ITEM, Type.getConstant(tokString));
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, Spell spell) {
        Changes<Type> changes = context.getObjectContext().getListChanges(spell, ListKey.ITEM);
        Changes<Type> proChanges = context.getObjectContext().getListChanges(spell, ListKey.PROHIBITED_ITEM);
        Collection<Type> changeAdded = changes.getAdded();
        Collection<Type> proAdded = proChanges.getAdded();
        StringBuilder sb = new StringBuilder();
        boolean needComma = false;
        if (changeAdded != null) {
            for (Type t : changeAdded) {
                if (needComma) {
                    sb.append(",");
                }
                sb.append(t.toString());
                needComma = true;
            }
        }
        if (proAdded != null) {
            for (Type t : proAdded) {
                if (needComma) {
                    sb.append(",");
                }
                sb.append('[').append(t.toString()).append(']');
                needComma = true;
            }
        }
        if (sb.length() == 0) {
            return null;
        }
        return new String[]{sb.toString()};
    }

    @Override
    public Class<Spell> getTokenClass() {
        return Spell.class;
    }
}

