/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass.level;

import pcgen.base.formula.Formula;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class SpecialtyknownToken
extends AbstractTokenWithSeparator<PCClassLevel>
implements CDOMPrimaryToken<PCClassLevel> {
    @Override
    public String getTokenName() {
        return "SPECIALTYKNOWN";
    }

    @Override
    protected char separator() {
        return ',';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClassLevel level, String value) {
        context.getObjectContext().removeList(level, ListKey.SPECIALTYKNOWN);
        ParsingSeparator sep = new ParsingSeparator(value, ',');
        while (sep.hasNext()) {
            String tok = sep.next();
            try {
                if (Integer.parseInt(tok) < 0) {
                    return new ParseResult.Fail("Invalid Spell Count: " + tok + " is less than zero", context);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            Formula formula = FormulaFactory.getFormulaFor(tok);
            if (!formula.isValid()) {
                return new ParseResult.Fail("Formula in " + this.getTokenName() + " was not valid: " + formula.toString(), context);
            }
            context.getObjectContext().addToList(level, ListKey.SPECIALTYKNOWN, formula);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, PCClassLevel level) {
        Changes<Formula> changes = context.getObjectContext().getListChanges(level, ListKey.SPECIALTYKNOWN);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        return new String[]{StringUtil.join(changes.getAdded(), (String)",")};
    }

    @Override
    public Class<PCClassLevel> getTokenClass() {
        return PCClassLevel.class;
    }
}

