/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.AbilityCategory;
import pcgen.core.EquipmentModifier;
import pcgen.core.PCClass;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.rules.context.Changes;
import pcgen.rules.context.ConsolidatedListCommitStrategy;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.RuntimeLoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class BonusLst
implements CDOMPrimaryToken<CDOMObject>,
DeferredToken<CDOMObject> {
    private static final Class<PCClass> PCCLASS_CLASS = PCClass.class;
    private static final Class<AbilityCategory> ABILITY_CATEGORY_CLASS = AbilityCategory.class;

    @Override
    public String getTokenName() {
        return "BONUS";
    }

    @Override
    public ParseResult parseToken(LoadContext context, CDOMObject obj, String value) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        if (value.indexOf("PREAPPLY:") != -1) {
            return new ParseResult.Fail("Use of PREAPPLY prohibited on a BONUS , please use TEMPBONUS with: " + value);
        }
        String v = value.replaceAll(Pattern.quote("<this>"), obj.getKeyName());
        BonusObj bon = Bonus.newBonus(context, v);
        if (bon == null) {
            return new ParseResult.Fail(this.getTokenName() + " was given invalid bonus: " + value, context);
        }
        bon.setTokenSource(this.getTokenName());
        context.getObjectContext().addToList(obj, ListKey.BONUS, bon);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        if (obj instanceof EquipmentModifier) {
            return null;
        }
        Changes<BonusObj> changes = context.getObjectContext().getListChanges(obj, ListKey.BONUS);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection<BonusObj> added = changes.getAdded();
        String tokenName = this.getTokenName();
        TreeSet<String> bonusSet = new TreeSet<String>();
        for (BonusObj bonus : added) {
            if (!tokenName.equals(bonus.getTokenSource())) continue;
            String bonusString = bonus.getLSTformat();
            bonusSet.add(bonusString);
        }
        if (bonusSet.isEmpty()) {
            return null;
        }
        return bonusSet.toArray(new String[bonusSet.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    @Override
    public boolean process(LoadContext context, CDOMObject obj) {
        List<BonusObj> bonusList = obj.getListFor(ListKey.BONUS);
        boolean returnValue = true;
        if (bonusList != null) {
            for (BonusObj bonus : bonusList) {
                String bonusName = bonus.getBonusName();
                if ("ABILITYPOOL".equalsIgnoreCase(bonusName)) {
                    for (Object o : bonus.getBonusInfoList()) {
                        if (context.getReferenceContext().silentlyGetConstructedCDOMObject(ABILITY_CATEGORY_CLASS, o.toString()) != null) continue;
                        RuntimeLoadContext dummyCtx = new RuntimeLoadContext(context.getReferenceContext(), new ConsolidatedListCommitStrategy());
                        dummyCtx.setSourceURI(obj.getSourceURI());
                        Logging.errorPrint("BONUS: " + bonus + " in " + obj.getClass().getSimpleName() + " " + obj.getKeyName() + " contained an invalid AbilityCategory " + o.toString(), dummyCtx);
                        returnValue = false;
                    }
                    continue;
                }
                if (!"UDAM".equals(bonusName)) continue;
                for (Object o : bonus.getBonusInfoList()) {
                    String classKey = o.toString();
                    PCClass aClass = context.getReferenceContext().silentlyGetConstructedCDOMObject(PCCLASS_CLASS, classKey);
                    if (aClass != null) continue;
                    Logging.errorPrint("Could not find class '" + classKey + "' for UDAM token", context);
                }
            }
        }
        try {
            obj.ownBonuses(obj);
        }
        catch (CloneNotSupportedException e) {
            Logging.errorPrint(e.getLocalizedMessage());
            return false;
        }
        return returnValue;
    }

    @Override
    public Class<CDOMObject> getDeferredTokenClass() {
        return CDOMObject.class;
    }
}

