/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.context;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Categorized;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.ClassIdentity;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.UnconstructedValidator;
import pcgen.rules.context.AbstractReferenceContext;
import pcgen.rules.context.LoadValidator;
import pcgen.rules.persistence.TokenLibrary;
import pcgen.util.Logging;
import pcgen.util.StringPClassUtil;

public final class ReferenceContextUtilities {
    private ReferenceContextUtilities() {
    }

    public static void validateAssociations(AbstractReferenceContext refContext, LoadValidator validator) {
        for (ReferenceManufacturer<?> rm : refContext.getAllManufacturers()) {
            for (CDOMSingleRef<?> singleRef : rm.getReferenced()) {
                ReferenceManufacturer<?> mfg;
                Class<?> cl;
                String choice = singleRef.getChoice();
                if (choice == null) continue;
                CDOMObject cdo = (CDOMObject)singleRef.resolvesTo();
                ChooseInformation<?> ci = cdo.get(ObjectKey.CHOOSE_INFO);
                if (ci == null) {
                    Logging.errorPrint("Found " + rm.getReferenceDescription() + " " + cdo.getKeyName() + " " + " that had association: " + choice + " but was not an object with CHOOSE");
                    rm.fireUnconstuctedEvent(singleRef);
                    continue;
                }
                ClassIdentity<?> clIdentity = ci.getClassIdentity();
                if (choice.indexOf("%") > -1 || !Loadable.class.isAssignableFrom(cl = clIdentity.getChoiceClass()) || (mfg = refContext.getManufacturer(clIdentity)).containsObject(choice) || TokenLibrary.getPrimitive(cl, choice) != null || ReferenceContextUtilities.report(validator, clIdentity.getChoiceClass(), choice)) continue;
                Logging.errorPrint("Found " + rm.getReferenceDescription() + " " + cdo.getKeyName() + " " + " that had association: " + choice + " but no such " + mfg.getReferenceDescription() + " was ever defined");
                rm.fireUnconstuctedEvent(singleRef);
            }
        }
    }

    private static boolean report(UnconstructedValidator validator, Class<?> cl, String key) {
        return validator != null && validator.allow(cl, key);
    }

    public static <T extends Categorized<T>> ReferenceManufacturer<? extends Loadable> getManufacturer(AbstractReferenceContext refContext, String firstToken) {
        ReferenceManufacturer<? extends Loadable> rm;
        String categoryName;
        String className;
        int equalLoc = firstToken.indexOf(61);
        if (equalLoc != firstToken.lastIndexOf(61)) {
            Logging.log(Logging.LST_ERROR, "  Error encountered: Found second = in ObjectType=Category");
            Logging.log(Logging.LST_ERROR, "  Format is: ObjectType[=Category]|Key[|Key] value was: " + firstToken);
            Logging.log(Logging.LST_ERROR, "  Valid ObjectTypes are: " + StringPClassUtil.getValidStrings());
            return null;
        }
        if ("FEAT".equals(firstToken)) {
            className = "ABILITY";
            categoryName = "FEAT";
        } else if (equalLoc == -1) {
            className = firstToken;
            categoryName = null;
        } else {
            className = firstToken.substring(0, equalLoc);
            categoryName = firstToken.substring(equalLoc + 1);
        }
        Class<? extends Loadable> c = StringPClassUtil.getClassFor(className);
        if (c == null) {
            Logging.log(Logging.LST_ERROR, "Unrecognized ObjectType: " + className);
            return null;
        }
        if (Categorized.class.isAssignableFrom(c)) {
            Class<? extends Category<?>> catClass = StringPClassUtil.getCategoryClassFor(className);
            if (categoryName == null) {
                Logging.log(Logging.LST_ERROR, "  Error encountered: Found Categorized Type without =Category");
                Logging.log(Logging.LST_ERROR, "  Format is: ObjectType[=Category]|Key[|Key] value was: " + firstToken);
                Logging.log(Logging.LST_ERROR, "  Valid ObjectTypes are: " + StringPClassUtil.getValidStrings());
                return null;
            }
            rm = refContext.getManufacturer(c, catClass, categoryName);
            if (rm == null) {
                Logging.log(Logging.LST_ERROR, "  Error encountered: " + className + " Category: " + categoryName + " not found");
                return null;
            }
        } else {
            if (categoryName != null) {
                Logging.log(Logging.LST_ERROR, "  Error encountered: Found Non-Categorized Type with =Category");
                Logging.log(Logging.LST_ERROR, "  Format is: ObjectType[=Category]|Key[|Key] value was: " + firstToken);
                Logging.log(Logging.LST_ERROR, "  Valid ObjectTypes are: " + StringPClassUtil.getValidStrings());
                return null;
            }
            rm = refContext.getManufacturer(c);
        }
        return rm;
    }
}

