/*
 * Decompiled with CFR 0.152.
 */
package pcgen.facade.util;

import java.util.AbstractList;
import java.util.Iterator;
import javax.swing.event.EventListenerList;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;

public abstract class AbstractListFacade<E>
implements ListFacade<E> {
    protected EventListenerList listenerList = new EventListenerList();
    private Iterable<E> iteratorWrapper = null;

    @Override
    public void addListListener(ListListener<? super E> listener) {
        this.listenerList.add(ListListener.class, listener);
    }

    @Override
    public void removeListListener(ListListener<? super E> listener) {
        this.listenerList.remove(ListListener.class, listener);
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public boolean containsElement(E element) {
        for (E object : this) {
            if (!object.equals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.iteratorWrapper == null) {
            this.iteratorWrapper = new AbstractList<E>(){

                @Override
                public E get(int index) {
                    return AbstractListFacade.this.getElementAt(index);
                }

                @Override
                public int size() {
                    return AbstractListFacade.this.getSize();
                }
            };
        }
        return this.iteratorWrapper.iterator();
    }

    protected void fireElementAdded(Object source, E element, int index) {
        Object[] listeners = this.listenerList.getListenerList();
        ListEvent<E> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListListener.class) continue;
            if (e == null) {
                e = new ListEvent<E>(source, 0, element, index);
            }
            ((ListListener)listeners[i + 1]).elementAdded(e);
        }
    }

    protected void fireElementRemoved(Object source, E element, int index) {
        Object[] listeners = this.listenerList.getListenerList();
        ListEvent<E> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListListener.class) continue;
            if (e == null) {
                e = new ListEvent<E>(source, 1, element, index);
            }
            ((ListListener)listeners[i + 1]).elementRemoved(e);
        }
    }

    protected void fireElementsChanged(Object source) {
        Object[] listeners = this.listenerList.getListenerList();
        ListEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListListener.class) continue;
            if (e == null) {
                e = new ListEvent(source);
            }
            ((ListListener)listeners[i + 1]).elementsChanged(e);
        }
    }

    protected void fireElementModified(Object source, E element, int index) {
        Object[] listeners = this.listenerList.getListenerList();
        ListEvent<E> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListListener.class) continue;
            if (e == null) {
                e = new ListEvent<E>(source, 3, element, index);
            }
            ((ListListener)listeners[i + 1]).elementModified(e);
        }
    }
}

