/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpellProhibitor;
import pcgen.core.SubClass;
import pcgen.core.chooser.CDOMChooserFacadeImpl;
import pcgen.core.prereq.PrereqHandler;
import pcgen.facade.core.ChooserFacade;
import pcgen.gui2.facade.Gui2InfoFactory;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.enumeration.ProhibitedSpellType;

public class SubClassApplication {
    public static void checkForSubClass(PlayerCharacter aPC, PCClass cl) {
        List selectedSubClasses;
        List<SubClass> subClassList = cl.getListFor(ListKey.SUB_CLASS);
        if (subClassList == null || subClassList.isEmpty()) {
            return;
        }
        ArrayList<PCClass> availableList = new ArrayList<PCClass>();
        String subClassKey = aPC.getSubClassName(cl);
        boolean subClassSelected = subClassKey != null && !subClassKey.equals("None") && !subClassKey.equals("");
        for (SubClass sc : subClassList) {
            if (!PrereqHandler.passesAll(sc.getPrerequisiteList(), aPC, cl) || subClassSelected && !sc.getKeyName().equals(aPC.getSubClassName(cl))) continue;
            availableList.add(sc);
        }
        if (cl.getSafe(ObjectKey.ALLOWBASECLASS).booleanValue() && (!subClassSelected || cl.getKeyName().equals(aPC.getSubClassName(cl)))) {
            availableList.add(0, cl);
        }
        CDOMChooserFacadeImpl chooserFacade = new CDOMChooserFacadeImpl(LanguageBundle.getString("in_schoolSpecChoice"), availableList, new ArrayList(), 1);
        chooserFacade.setDefaultView(ChooserFacade.ChooserTreeViewType.NAME);
        chooserFacade.setInfoFactory(new Gui2InfoFactory(aPC));
        if (availableList.size() == 1) {
            selectedSubClasses = availableList;
        } else {
            if (availableList.size() == 0) {
                if (Logging.isLoggable(Logging.WARNING)) {
                    Logging.log(Logging.WARNING, "No subclass choices avaialble for " + cl);
                }
                return;
            }
            ChooserFactory.getDelegate().showGeneralChooser(chooserFacade);
            selectedSubClasses = chooserFacade.getFinalSelected();
        }
        if (!cl.getSafe(ObjectKey.ALLOWBASECLASS).booleanValue()) {
            while (selectedSubClasses.size() == 0) {
                ChooserFactory.getDelegate().showGeneralChooser(chooserFacade);
                selectedSubClasses = chooserFacade.getFinalSelected();
            }
        }
        if (selectedSubClasses.size() == 0) {
            return;
        }
        PCClass subselected = (PCClass)selectedSubClasses.get(0);
        if (subselected instanceof SubClass) {
            aPC.removeProhibitedSchools(cl);
            aPC.removeAssoc(cl, AssociationKey.SPECIALTY);
            SubClass sc = (SubClass)subselected;
            availableList.clear();
            for (SubClass sub : subClassList) {
                int displayedCost;
                if (sub.equals(sc) || !PrereqHandler.passesAll(sub.getPrerequisiteList(), aPC, cl) || (displayedCost = sub.getProhibitCost()) == 0) continue;
                availableList.add(sub);
            }
            SubClassApplication.setSubClassKey(aPC, cl, sc.getKeyName());
            if (sc.get(ObjectKey.CHOICE) != null) {
                aPC.setAssoc(cl, AssociationKey.SPECIALTY, sc.getChoice());
            }
            if (sc.getSafe(IntegerKey.COST) != 0) {
                chooserFacade = new CDOMChooserFacadeImpl(LanguageBundle.getString("in_schoolProhibitChoice"), availableList, new ArrayList(), sc.getSafe(IntegerKey.COST));
                chooserFacade.setDefaultView(ChooserFacade.ChooserTreeViewType.NAME);
                chooserFacade.setInfoFactory(new Gui2InfoFactory(aPC));
                chooserFacade.setRequireCompleteSelection(true);
                ChooserFactory.getDelegate().showGeneralChooser(chooserFacade);
                selectedSubClasses = chooserFacade.getFinalSelected();
                for (PCClass choice : chooserFacade.getFinalSelected()) {
                    sc = (SubClass)choice;
                    SpellProhibitor prohibSchool = new SpellProhibitor();
                    prohibSchool.setType(ProhibitedSpellType.SCHOOL);
                    prohibSchool.addValue(sc.getChoice());
                    SpellProhibitor prohibSubSchool = new SpellProhibitor();
                    prohibSubSchool.setType(ProhibitedSpellType.SUBSCHOOL);
                    prohibSubSchool.addValue(sc.getChoice());
                    aPC.addProhibitedSchool(prohibSchool, cl);
                    aPC.addProhibitedSchool(prohibSubSchool, cl);
                }
            }
        }
    }

    public static void setSubClassKey(PlayerCharacter pc, PCClass cl, String aKey) {
        SubClass a;
        if (aKey == null || cl == null) {
            return;
        }
        pc.setSubClassName(cl, aKey);
        if (!aKey.equals(cl.getKeyName()) && (a = cl.getSubClassKeyed(aKey)) != null) {
            cl.inheritAttributesFrom(a);
            pc.reInheritClassLevels(cl);
        }
    }
}

