/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.ability;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.AspectName;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.helper.Aspect;
import pcgen.core.Ability;
import pcgen.core.prereq.Prerequisite;
import pcgen.io.EntityEncoder;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.MapChanges;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class AspectToken
extends AbstractNonEmptyToken<Ability>
implements CDOMPrimaryToken<Ability> {
    public String getTokenName() {
        return "ASPECT";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, Ability ability, String value) {
        int pipeLoc = value.indexOf("|");
        if (pipeLoc == -1) {
            return new ParseResult.Fail(this.getTokenName() + " expecting '|', format is: " + "AspectName|Aspect value|Variable|... was: " + value, context);
        }
        String key = value.substring(0, pipeLoc);
        if (key.length() == 0) {
            return new ParseResult.Fail(this.getTokenName() + " expecting non-empty type, " + "format is: AspectName|Aspect value|Variable|... was: " + value, context);
        }
        String val = value.substring(pipeLoc + 1);
        if (val.length() == 0) {
            return new ParseResult.Fail(this.getTokenName() + " expecting non-empty value, " + "format is: AspectName|Aspect value|Variable|... was: " + value, context);
        }
        if (val.startsWith("|")) {
            return new ParseResult.Fail(this.getTokenName() + " expecting non-empty value, " + "format is: AspectName|Aspect value|Variable|... was: " + value, context);
        }
        Aspect a = this.parseAspect(key, val);
        MapChanges mc = context.getObjectContext().getMapChanges((CDOMObject)ability, MapKey.ASPECT);
        Map fullMap = mc.getAdded();
        ArrayList<Aspect> aspects = (ArrayList<Aspect>)fullMap.get(a.getKey());
        if (aspects == null) {
            aspects = new ArrayList<Aspect>();
        }
        aspects.add(a);
        context.getObjectContext().put((CDOMObject)ability, MapKey.ASPECT, (Object)a.getKey(), aspects);
        return ParseResult.SUCCESS;
    }

    public Aspect parseAspect(String name, String aspectDef) {
        StringTokenizer tok = new StringTokenizer(aspectDef, "|");
        String firstToken = tok.nextToken();
        Aspect aspect = new Aspect(name, EntityEncoder.decode((String)firstToken));
        boolean isPre = false;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (PreParserFactory.isPreReqString((String)token)) {
                Prerequisite prereq = this.getPrerequisite(token);
                if (prereq == null) {
                    Logging.errorPrint((String)(this.getTokenName() + " had invalid prerequisite : " + token));
                    return null;
                }
                aspect.addPrerequisite(prereq);
                isPre = true;
                continue;
            }
            if (isPre) {
                Logging.errorPrint((String)("Invalid " + this.getTokenName() + ": " + name));
                Logging.errorPrint((String)"  PRExxx must be at the END of the Token");
                return null;
            }
            aspect.addVariable(token);
        }
        return aspect;
    }

    public String[] unparse(LoadContext context, Ability ability) {
        MapChanges changes = context.getObjectContext().getMapChanges((CDOMObject)ability, MapKey.ASPECT);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        Set keys = changes.getAdded().keySet();
        for (AspectName an : keys) {
            List aspects = (List)changes.getAdded().get(an);
            for (int i = 0; i < aspects.size(); ++i) {
                Aspect q = (Aspect)aspects.get(i);
                set.add(q.getName() + "|" + q.getPCCText());
            }
        }
        return set.toArray(new String[set.size()]);
    }

    public Class<Ability> getTokenClass() {
        return Ability.class;
    }
}

